/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.ws.axis.handlers.UniversalHandler;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.RelatesTo;

public class AddressingToJMSHandler
extends UniversalHandler {
    @Override
    public void handleClientRequest(MessageContext mc) throws AxisFault {
        this.debug("AddressingToJMSHandler:handleClientRequest" + mc.hashCode());
    }

    @Override
    public void handleClientResponse(MessageContext mc) throws AxisFault {
        this.debug("AddressingToJMSHandler:handleClientResponse" + mc.hashCode());
        if (this.suppressWSA(mc)) {
            return;
        }
        try {
            AddressingHeaders ah = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
            String corr = this.evaluateRelatesToMessageExchangeCorrelator(mc, ah);
            if (corr != null) {
                mc.setProperty("COM_SONIC_WS_MESSAGEEXCHANGE_CORRELATOR", (Object)corr);
            }
            this.stripHeaders(mc.getResponseMessage());
        }
        catch (SOAPException se) {
            throw new AxisFault(se.toString());
        }
    }

    @Override
    public void handleServerRequest(MessageContext mc) throws AxisFault {
        this.debug("AddressingToJMSHandler:handleServerRequest" + mc.hashCode());
        if (this.suppressWSA(mc)) {
            return;
        }
        try {
            AddressingHeaders ah = (AddressingHeaders)mc.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
            String corr = this.evaluateRelatesToMessageExchangeCorrelator(mc, ah);
            if (corr == null) {
                corr = this.evaluateInitialMessageExchangeCorrelator(mc, ah);
            }
            if (corr != null) {
                mc.setProperty("COM_SONIC_WS_MESSAGEEXCHANGE_CORRELATOR", (Object)corr);
            }
            this.stripHeaders(mc.getRequestMessage());
        }
        catch (SOAPException se) {
            throw new AxisFault(se.toString());
        }
    }

    @Override
    public void handleServerResponse(MessageContext mc) throws AxisFault {
        this.debug("AddressingToJMSHandler:handleServerResponse" + mc.hashCode());
    }

    @Override
    public void onFault(MessageContext mc) {
        this.debug("AddressingToJMSHandler:onFault:" + mc.hashCode());
    }

    public void stripHeaders(Message m) throws AxisFault, SOAPException {
    }

    private String evaluateRelatesToMessageExchangeCorrelator(MessageContext mc, AddressingHeaders ah) {
        if (ah != null) {
            List r2l = ah.getRelatesTo();
            if (r2l == null) {
                return null;
            }
            Iterator r2li = r2l.iterator();
            if (r2li.hasNext()) {
                RelatesTo r2 = (RelatesTo)r2li.next();
                return r2.getURI().toString();
            }
        }
        return null;
    }

    private String evaluateInitialMessageExchangeCorrelator(MessageContext mc, AddressingHeaders ah) {
        if (ah != null) {
            if (ah.getRelatesTo() != null && ah.getRelatesTo().size() > 0) {
                return null;
            }
            MessageID mid = ah.getMessageID();
            if (mid == null) {
                return null;
            }
            return mid.toString();
        }
        return null;
    }

    private boolean suppressWSA(MessageContext mc) {
        String p = (String)mc.getProperty("COM_SONIC_WSA_SUPRESS");
        return p != null && p.equalsIgnoreCase("true");
    }
}

