/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.prAccessor;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.message.DetailEntry;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAP11Constants;

public class SequenceFault {
    private String code = null;
    private String subcode = null;
    private String reason = null;
    private String sequenceId = null;
    private AxisFault af = null;

    public AxisFault getAxisFault() {
        return this.af;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    public String getReason() {
        return this.reason;
    }

    public String getCode() {
        return this.code;
    }

    public String getSubode() {
        return this.subcode;
    }

    public static AxisFault makeSequenceTerminatedFault(Constants rmc, String id) {
        AxisFault terminateFault = new AxisFault();
        QName qn = new QName(rmc.getNSURI(), "Identifier", "wsrm");
        terminateFault.setFaultCode(new QName(prAccessor.getString("CODE_SENDER")));
        terminateFault.addFaultSubCode(new QName(rmc.getNSURI(), "SequenceTerminated", "wsrm"));
        terminateFault.clearFaultDetails();
        terminateFault.addFaultDetail(qn, id);
        terminateFault.setFaultReason(prAccessor.getString("REASON_TERMINATED"));
        return terminateFault;
    }

    public static AxisFault makeUnknownSequenceFault(Constants rmc, String id) {
        AxisFault terminateFault = new AxisFault();
        QName qn = new QName(rmc.getNSURI(), "Identifier", "wsrm");
        terminateFault.setFaultCode(new QName(prAccessor.getString("CODE_SENDER")));
        terminateFault.addFaultSubCode(new QName(rmc.getNSURI(), "UnknownSequence", "wsrm"));
        terminateFault.clearFaultDetails();
        terminateFault.addFaultDetail(qn, id);
        terminateFault.setFaultReason(prAccessor.getString("REASON_UNKNOWN_SEQUENCE"));
        return terminateFault;
    }

    public static AxisFault makeInvalidAcknowledgementFault(Constants rmc, String id) {
        AxisFault terminateFault = new AxisFault();
        QName qn = new QName(rmc.getNSURI(), "Identifier", "wsrm");
        terminateFault.setFaultCode(new QName(prAccessor.getString("CODE_SENDER")));
        terminateFault.addFaultSubCode(new QName(rmc.getNSURI(), "InvalidAcknowledgement", "wsrm"));
        terminateFault.clearFaultDetails();
        terminateFault.addFaultDetail(qn, id);
        terminateFault.setFaultReason(prAccessor.getString("REASON_INVALID_ACKNOWLEDGEMENT"));
        return terminateFault;
    }

    public static AxisFault makeMessageNumberRolloverFault(Constants rmc, String id) {
        AxisFault terminateFault = new AxisFault();
        QName qn = new QName(rmc.getNSURI(), "Identifier", "wsrm");
        terminateFault.setFaultCode(new QName(prAccessor.getString("CODE_SENDER")));
        terminateFault.addFaultSubCode(new QName(rmc.getNSURI(), "MessageNumberRollover", "wsrm"));
        terminateFault.clearFaultDetails();
        terminateFault.addFaultDetail(qn, id != null ? id : "");
        terminateFault.setFaultReason(prAccessor.getString("REASON_MESSAGE_NUMBER_ROLLOVER"));
        return terminateFault;
    }

    public static AxisFault makeLastMessageNumberExceededFault(Constants rmc, String id) {
        AxisFault terminateFault = new AxisFault();
        QName qn = new QName(rmc.getNSURI(), "Identifier", "wsrm");
        terminateFault.setFaultCode(new QName(prAccessor.getString("CODE_SENDER")));
        terminateFault.addFaultSubCode(new QName(rmc.getNSURI(), "LastMessageNumberExceeded", "wsrm"));
        terminateFault.clearFaultDetails();
        terminateFault.addFaultDetail(qn, id);
        terminateFault.setFaultReason(prAccessor.getString("REASON_LAST_MESSAGE_NUMBER_EXCEEDED"));
        return terminateFault;
    }

    public static SequenceFault fromSOAPEnvelope(SOAPEnvelope env) throws AxisFault, SOAPException {
        SOAPFault fault = (SOAPFault)env.getBody().getFault();
        if (fault == null) {
            return null;
        }
        String subcode = SequenceFault.getRMSubcode(env);
        if (subcode == null) {
            return null;
        }
        String ID = SequenceFault.getRMIdentifier(env);
        SequenceFault sf = new SequenceFault();
        sf.code = fault.getFaultCode();
        sf.subcode = subcode;
        sf.sequenceId = ID;
        sf.af = fault.getFault();
        sf.reason = sf.af.getFaultReason();
        return sf;
    }

    public static void toSequenceFaultHeader(Constants rmc, SOAPEnvelope env, String id, String fc) throws SOAPException {
        if (env.getSOAPConstants() instanceof SOAP11Constants) {
            Name n = env.createName("SequenceFault", "wsrm", rmc.getNSURI());
            SOAPHeader h = (SOAPHeader)env.getHeader();
            if (h == null) {
                h = (SOAPHeader)env.addHeader();
            }
            SOAPHeaderElement he = (SOAPHeaderElement)h.addHeaderElement(n);
            SOAPElement ide = he.addChildElement("Identifier", "wsrm", rmc.getNSURI());
            SOAPElement fce = he.addChildElement("FaultCode", "wsrm", rmc.getNSURI());
            ide.addTextNode(id);
            fce.addTextNode("wsrm:" + fc);
            AxisFault af = ((SOAPFault)env.getBody().getFault()).getFault();
            af.clearFaultDetails();
        }
    }

    private static String getRMSubcode(SOAPEnvelope env) {
        try {
            SOAPFault fault = (SOAPFault)env.getBody().getFault();
            AxisFault af = fault.getFault();
            if (env.getSOAPConstants() instanceof SOAP11Constants) {
                Iterator ir = env.getHeader().getChildElements();
                MessageElement chdr = null;
                while (ir.hasNext()) {
                    SOAPHeaderElement hdr = (SOAPHeaderElement)ir.next();
                    if (hdr.getLocalName().equalsIgnoreCase("SequenceFault") && hdr.getNamespaceURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2005/02/rm")) {
                        chdr = hdr.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "FaultCode"));
                        return chdr != null ? chdr.getValue() : null;
                    }
                    if (!hdr.getLocalName().equalsIgnoreCase("SequenceFault") || !hdr.getNamespaceURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2004/03/rm") || (chdr = hdr.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2004/03/rm", "FaultCode"))) != null) continue;
                    return chdr != null ? chdr.getValue() : null;
                }
            } else {
                QName[] qs = af.getFaultSubCodes();
                if (qs == null) {
                    return null;
                }
                for (int i = 0; i < qs.length; ++i) {
                    if (!qs[i].getNamespaceURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2005/02/rm")) continue;
                    return qs[i].toString();
                }
            }
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
        return null;
    }

    private static String getRMIdentifier(SOAPEnvelope env) {
        try {
            SOAPFault fault = (SOAPFault)env.getBody().getFault();
            AxisFault af = fault.getFault();
            if (env.getSOAPConstants() instanceof SOAP11Constants) {
                Iterator ir = env.getHeader().getChildElements();
                MessageElement chdr = null;
                while (ir.hasNext()) {
                    SOAPHeaderElement hdr = (SOAPHeaderElement)ir.next();
                    if (hdr.getLocalName().equalsIgnoreCase("SequenceFault") && hdr.getNamespaceURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2005/02/rm")) {
                        chdr = hdr.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Identifier"));
                        return chdr != null ? chdr.getValue() : null;
                    }
                    if (!hdr.getLocalName().equalsIgnoreCase("SequenceFault") || !hdr.getNamespaceURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2004/03/rm") || (chdr = hdr.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2004/03/rm", "Identifier"))) != null) continue;
                    return chdr != null ? chdr.getValue() : null;
                }
            } else if (fault.getDetail() != null) {
                Iterator ir = fault.getDetail().getDetailEntries();
                while (ir.hasNext()) {
                    DetailEntry de = (DetailEntry)ir.next();
                    MessageElement chdr = de.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm", "Identifier"));
                    if (chdr == null) {
                        chdr = de.getChildElement(new QName("http://schemas.xmlsoap.org/ws/2004/03/rm", "Identifier"));
                    }
                    if (chdr == null) continue;
                    return chdr.getAsString();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

