/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Enumeration;

public abstract class TokenManager {
    public static final String ENGINE_TYPE = "TokenManager";
    public static final String X509 = "X509";
    private static final String[] ALL_TYPES = new String[]{"X509"};
    private static final String X509_TM_SPI = "com.sonicsw.ws.security.X509TokenManager";
    protected String m_type = null;
    protected Provider m_provider = null;

    public static TokenManager getInstance(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objs = TokenManager.getImpl(type, provider);
        TokenManager tm = (TokenManager)objs[0];
        tm.m_type = type;
        tm.m_provider = (Provider)objs[1];
        return tm;
    }

    public static final String[] getTokenManagerTypes() {
        return Arrays.copyOf(ALL_TYPES, ALL_TYPES.length);
    }

    public abstract void init(Object var1);

    public final Provider getProvider() {
        return this.m_provider;
    }

    public final String getType() {
        return this.m_type;
    }

    public String toString() {
        return new String(this.m_type + " TokenManager from " + this.m_provider.getName());
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private static Object[] getImpl(String type, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + provider);
        }
        String key = "TokenManager." + type;
        String className = provider.getProperty(key);
        if (className == null) {
            Enumeration<Object> keys = provider.keys();
            while (keys.hasMoreElements() && className == null) {
                String matchKey = (String)keys.nextElement();
                if (!key.equalsIgnoreCase(matchKey)) continue;
                className = provider.getProperty(matchKey);
                break;
            }
        }
        if (className == null) {
            throw new NoSuchAlgorithmException(type + " TokenManager not available from provider " + provider);
        }
        try {
            ClassLoader cl = provider.getClass().getClassLoader();
            Class<?> implClass = Class.forName(className);
            String spiClassName = null;
            Class<?> spiClass = null;
            if (type.equalsIgnoreCase(X509)) {
                spiClassName = X509_TM_SPI;
            }
            spiClass = Class.forName(spiClassName);
            Class<?> subclass = implClass;
            while (!subclass.equals(spiClass)) {
                if ((subclass = subclass.getSuperclass()) != null) continue;
                throw new NoSuchAlgorithmException("class configured for " + type + " TokenManager: " + className + " does not implement " + spiClassName);
            }
            return new Object[]{implClass.newInstance(), provider};
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException("class configured for TokenManager(provider: " + provider + ")" + "cannot be found.\n" + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException("class " + className + " configured for TokenManager" + "(provider: " + provider + ") cannot be instantiated.\n" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException("class " + className + " configured for TokenManager" + "(provider: " + provider + ") cannot be accessed.\n" + e.getMessage());
        }
        catch (SecurityException e) {
            throw new NoSuchAlgorithmException("class " + className + " configured for TokenManager" + "(provider: " + provider + ") cannot be accessed.\n" + e.getMessage());
        }
    }
}

