/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.action.SupportingToken;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.SSPConstants;
import com.sonicsw.ws.security.policy.WSSEConstants;
import com.sonicsw.ws.security.policy.WSSPConstants;
import com.sonicsw.ws.security.policy.WSSPUtils;
import com.sonicsw.wsp.WSPUtils;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.xmlsoap.schemas.ws.x2002.x12.secext.SubjectNameType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.TokenTypeOpenEnum;
import org.xmlsoap.schemas.ws.x2002.x12.secext.UsePasswordType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.X509ExtensionType;
import org.xmlsoap.schemas.ws.x2002.x12.secext.impl.UsePasswordTypeImpl;

public class SecurityTokenAssertion
extends Assertion {
    private SupportingToken m_supportingToken = new SupportingToken();

    @Override
    public final int getType() {
        return SECURITY_TOKEN_ASSERTION;
    }

    @Override
    public Object getAction() {
        return this.m_supportingToken;
    }

    public QName getTokenType() {
        return this.m_supportingToken.getTokenType();
    }

    public final void setTokenType(QName tokenType) {
        this.m_supportingToken.setTokenType(tokenType);
    }

    public String getTokenIssuer() {
        return this.m_supportingToken.getTokenIssuer();
    }

    public final void setTokenIssuer(String tokenIssuer) {
        this.m_supportingToken.setTokenIssuer(tokenIssuer);
    }

    public QName getSubjectNameMatchType() {
        return this.m_supportingToken.getSubjectNameMatchType();
    }

    public void setSubjectNameMatchType(QName matchType) {
        this.m_supportingToken.setSubjectNameMatchType(matchType);
    }

    public String getSubjectName() {
        return this.m_supportingToken.getSubjectName();
    }

    public void setSubjectName(String subjectName) {
        this.m_supportingToken.setSubjectName(subjectName);
    }

    public QName getPasswordType() {
        return this.m_supportingToken.getPasswordType();
    }

    public void setPasswordType(QName type) {
        this.m_supportingToken.setPasswordType(type);
    }

    public String getPassword() {
        return this.m_supportingToken.getPassword();
    }

    public void setPassword(String password) {
        this.m_supportingToken.setPassword(password);
    }

    public QName getX509ExtensionMatchType() {
        return this.m_supportingToken.getX509ExtensionMatchType();
    }

    public void setX509ExtensionMatchType(QName matchType) {
        this.m_supportingToken.setX509ExtensionMatchType(matchType);
    }

    public String getX509ExtensionOID() {
        return this.m_supportingToken.getX509ExtensionOID();
    }

    public void setX509ExtensionOID(String oid) {
        this.m_supportingToken.setX509ExtensionOID(oid);
    }

    public boolean isX509ExtensionCritical() {
        return this.m_supportingToken.isX509ExtensionCritical();
    }

    public void setX509ExtensionCritical(boolean critical) {
        this.m_supportingToken.setX509ExtensionCritical(critical);
    }

    public String getX509Extension() {
        return this.m_supportingToken.getX509Extension();
    }

    public void setX509Extension(String value) {
        this.m_supportingToken.setX509Extension(value);
    }

    public QName getX509TokenRef() {
        return this.m_supportingToken.getX509TokenRef();
    }

    public final void setX509TokenRef(QName X509TokenRef) {
        this.m_supportingToken.setX509TokenRef(X509TokenRef);
    }

    public SecurityTokenAssertion() {
    }

    public SecurityTokenAssertion(XmlObject securityTokenBean) {
        Map namespaceMap = SecurityTokenAssertion.getInScopeNamespaces(securityTokenBean);
        this.initSecurityTokenAssertion(namespaceMap, securityTokenBean);
    }

    private void initSecurityTokenAssertion(Map namespaceMap, XmlObject securityTokenBean) {
        XmlObject[] claimsBeans;
        XmlObject[] tokenRefModelBeans;
        XmlObject[] tokenTypeBeans = securityTokenBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_TOKEN_TYPE));
        TokenTypeOpenEnum tokenTypeBean = (TokenTypeOpenEnum)tokenTypeBeans[0];
        this.setTokenType((QName)tokenTypeBean.getObjectValue());
        XmlObject[] tokenIssuerBeans = securityTokenBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_TOKEN_ISSUER));
        if (tokenIssuerBeans != null && tokenIssuerBeans.length > 0) {
            XmlString tokenIssuerBean = (XmlString)tokenIssuerBeans[0];
            this.setTokenIssuer(SecurityTokenAssertion.getTextContent((XmlObject)tokenIssuerBean));
        }
        if ((tokenRefModelBeans = securityTokenBean.selectPath(WSPUtils.childAttributeXPath(SSPConstants.QN_TOKEN_REF_MODEL))) != null && tokenRefModelBeans.length > 0) {
            XmlObject tokenRefModelBean = tokenRefModelBeans[0];
            String tokenRefModelQName = SecurityTokenAssertion.getTextContent(tokenRefModelBean);
            String nsPrefix = SecurityTokenAssertion.getNSPrefix(tokenRefModelQName);
            String localName = SecurityTokenAssertion.getLocalName(tokenRefModelQName);
            String ns = (String)namespaceMap.get(nsPrefix);
            this.setX509TokenRef(new QName(ns, localName, nsPrefix));
        }
        if ((claimsBeans = securityTokenBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_CLAIMS))) != null && claimsBeans.length > 0) {
            XmlObject[] x509ExtensionBeans;
            XmlObject claimsBean = claimsBeans[0];
            String xPathA = WSPUtils.childElementXPath(WSSPConstants.QN_SUBJECT_NAME);
            XmlObject[] subjectNameBeans = claimsBean.selectPath(xPathA);
            if (subjectNameBeans != null && subjectNameBeans.length > 0) {
                SubjectNameType subjectNameBean = (SubjectNameType)subjectNameBeans[0];
                this.setSubjectName(SecurityTokenAssertion.getTextContent((XmlObject)subjectNameBean));
                if (subjectNameBean.isSetMatchType()) {
                    this.setSubjectNameMatchType(subjectNameBean.getMatchType());
                } else {
                    XmlObject[] matchTypeBeans = subjectNameBean.selectPath(WSPUtils.childAttributeXPath(WSSPConstants.QN_MATCH_TYPE));
                    if (matchTypeBeans != null && matchTypeBeans.length > 0) {
                        XmlObject matchTypeBean = matchTypeBeans[0];
                        String matchTypeQName = SecurityTokenAssertion.getTextContent(matchTypeBean);
                        String nsPrefix = SecurityTokenAssertion.getNSPrefix(matchTypeQName);
                        String localName = SecurityTokenAssertion.getLocalName(matchTypeQName);
                        String ns = (String)namespaceMap.get(nsPrefix);
                        this.setSubjectNameMatchType(new QName(ns, localName, nsPrefix));
                    }
                }
            }
            if (this.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_USERNAME)) {
                DebugObjects.getPolicyDebug().debug("SecurityTokenAssertion: found token " + WSSPConstants.QN_TOKENTYPE_USERNAME);
                String xPathB = WSPUtils.childElementXPath(WSSPConstants.QN_USE_PASSWORD);
                XmlObject[] usePasswordBeans = claimsBean.selectPath(xPathB);
                if (usePasswordBeans != null && usePasswordBeans.length > 0) {
                    XmlAnyTypeImpl userPasswordBean;
                    String s;
                    XmlObject[] userPasswordBeans;
                    String xPathC;
                    UsePasswordType usePasswordBean = (UsePasswordType)usePasswordBeans[0];
                    if (usePasswordBean.isSetType()) {
                        this.setPasswordType(usePasswordBean.getType());
                        DebugObjects.getPolicyDebug().debug("SecurityTokenAssertion: getting password type from " + WSSPConstants.QN_USE_PASSWORD + ", Type = " + this.getPasswordType());
                    }
                    if (this.getPasswordType() == null) {
                        DebugObjects.getPolicyDebug().debug("SecurityTokenAssertion: password type not found in " + WSSPConstants.QN_USE_PASSWORD);
                        xPathC = WSPUtils.childElementXPath(WSSEConstants.QN_PASSWORD_TYPE);
                        XmlObject[] userPasswordTypeBeans = claimsBean.selectPath(xPathC);
                        if (userPasswordTypeBeans != null && userPasswordTypeBeans.length > 0) {
                            DebugObjects.getPolicyDebug().debug("SecurityTokenAssertion: trying to get password type from " + WSSEConstants.QN_PASSWORD_TYPE);
                            this.setPasswordType(new QName("PasswordText"));
                            DebugObjects.getPolicyDebug().debug("SecurityTokenAssertion: setting the default type " + this.getPasswordType());
                            UsePasswordTypeImpl userPasswordTypeBean = (UsePasswordTypeImpl)userPasswordTypeBeans[0];
                            XmlCursor c = userPasswordTypeBean.newCursor();
                            while (!c.toNextToken().isNone()) {
                                String s2;
                                QName name;
                                XmlCursor.TokenType t = c.currentTokenType();
                                if (t != XmlCursor.TokenType.ATTR || (name = c.getName()) == null || !(s2 = name.getLocalPart()).equals("Type")) continue;
                                String textValue = c.getTextValue();
                                DebugObjects.getPolicyDebug().debug("SecurityTokenAssertion: found passsword type = " + textValue);
                                if (textValue.endsWith("PasswordText")) {
                                    this.setPasswordType(new QName("PasswordText"));
                                    break;
                                }
                                if (!textValue.endsWith("PasswordDigest")) continue;
                                this.setPasswordType(new QName("PasswordDigest"));
                                break;
                            }
                            DebugObjects.getPolicyDebug().debug("SecurityTokenAssertion: getting password type from the bean for " + WSSEConstants.QN_PASSWORD_TYPE + ", Type = " + this.getPasswordType());
                            c.dispose();
                        }
                    }
                    if ((userPasswordBeans = claimsBean.selectPath(xPathC = WSPUtils.childElementXPath(SSPConstants.QN_PASSWORD))) != null && userPasswordBeans.length > 0 && (s = (userPasswordBean = (XmlAnyTypeImpl)userPasswordBeans[0]).getStringValue()) != null && s.trim().length() > 0) {
                        this.setPassword(s);
                    }
                }
            }
            if (this.getTokenType().equals(WSSPConstants.QN_TOKENTYPE_X509V3) && (x509ExtensionBeans = claimsBean.selectPath(WSPUtils.childElementXPath(WSSPConstants.QN_X509_EXTENSION))) != null && x509ExtensionBeans.length > 0) {
                X509ExtensionType x509ExtensionBean = (X509ExtensionType)x509ExtensionBeans[0];
                this.setX509Extension(SecurityTokenAssertion.getTextContent((XmlObject)x509ExtensionBean));
                if (x509ExtensionBean.isSetMatchType()) {
                    this.setX509ExtensionMatchType(x509ExtensionBean.getMatchType());
                }
                this.setX509ExtensionOID(x509ExtensionBean.getOID());
            }
        }
    }

    private static Map getInScopeNamespaces(XmlObject xobj) {
        XmlCursor c = xobj.newCursor();
        TreeMap m = new TreeMap();
        c.getAllNamespaces(m);
        c.dispose();
        return m;
    }

    public String toString() {
        String NEWLINE = "\n";
        StringBuffer buf = new StringBuffer();
        buf.append("-----------------------------------------------------------\n");
        buf.append("Assertion: SecurityToken").append("\n");
        buf.append("/SecurityToken/TokenType : ").append(this.getTokenType()).append("\n");
        buf.append("/SecurityToken/TokenIssuer : ").append(this.getTokenIssuer()).append("\n");
        buf.append("/SecurityToken/Claims/SubjectName : ").append(this.getSubjectName()).append("\n");
        buf.append("/SecurityToken/Claims/SubjectName/@MatchType : ").append(this.getSubjectNameMatchType()).append("\n");
        if (WSSPUtils.isUsernameTokenAssertion(this)) {
            buf.append("/SecurityToken/Claims/PasswordType: ").append(this.getPasswordType()).append("\n");
            DebugObjects.getPolicyDebug().debug("PasswordValue: " + this.getPassword());
        } else if (WSSPUtils.isX509v3TokenAssertion(this)) {
            buf.append("/SecurityToken/Claims/X509Extension : ").append(this.getX509Extension()).append("\n");
            buf.append("/SecurityToken/Claims/X509Extension/@MatchType : ").append(this.getX509ExtensionMatchType()).append("\n");
            buf.append("/SecurityToken/Claims/X509Extension/@OID : ").append(this.getX509ExtensionOID()).append("\n");
            buf.append("/SecurityToken/Claims/X509Extension/@Critical : ").append(this.isX509ExtensionCritical()).append("\n");
        }
        buf.append("-----------------------------------------------------------\n");
        buf.append("\n");
        return buf.toString();
    }

    private static String getNSPrefix(String qname) {
        return qname.substring(0, qname.lastIndexOf(58));
    }

    private static String getLocalName(String qname) {
        return qname.substring(qname.lastIndexOf(58) + 1);
    }

    private static String getTextContent(XmlObject xobj) {
        XmlCursor c = xobj.newCursor();
        c.toFirstChild();
        return c.getTextValue();
    }
}

