/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.provider;

import com.sonicsw.security.pass.broker.IAuthentication;
import com.sonicsw.security.pass.broker.UsernameToken;
import com.sonicsw.security.pass.client.IPasswordUser;
import com.sonicsw.ws.security.DomainTrustManager;
import com.sonicsw.ws.security.PasswordTrustManager;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.zclient.IUser;
import progress.message.zclient.ProgressPasswordUser;

public class DefaultTrustManager
extends PasswordTrustManager
implements DomainTrustManager {
    private static boolean doDebug = false;
    AccessController m_trustManager = AccessController.getController();

    @Override
    public Principal authenticate(String username, String password) {
        return this.m_trustManager.authenticate(username, password);
    }

    @Override
    public Principal authenticate(String username, String digest, String nonce, String createdTime) {
        return this.m_trustManager.authenticate(username, digest, nonce, createdTime);
    }

    @Override
    public Principal isTrusted(X509Certificate[] certs) {
        return null;
    }

    @Override
    public Principal isTrusted(X509Certificate cert) {
        return this.m_trustManager.isTrusted(cert);
    }

    private static String parseCN(String rdn) {
        if (rdn == null) {
            return null;
        }
        StringTokenizer tknizer = new StringTokenizer(rdn, ",", false);
        while (tknizer.hasMoreElements()) {
            String token = (String)tknizer.nextElement();
            if (!(token = token.trim()).startsWith("CN=")) continue;
            return token.substring(3, token.length());
        }
        return null;
    }

    public static class AccessController {
        private static Object _sync = new Object();
        private static AccessController s_controller = null;
        private boolean m_securityEnabled = Config.ENABLE_SECURITY;
        private boolean m_external = false;
        private IUser m_secdb = null;
        private IAuthentication m_externalProvider = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static AccessController getController() {
            if (s_controller == null) {
                Object object = _sync;
                synchronized (object) {
                    if (s_controller == null) {
                        s_controller = new AccessController();
                    }
                }
            }
            return s_controller;
        }

        private AccessController() {
            if (!this.m_securityEnabled) {
                return;
            }
            IAuthentication m_externalProvider = AgentRegistrar.getAuthenticationSPI();
            if (m_externalProvider != null) {
                this.m_external = true;
            } else {
                this.m_secdb = AgentRegistrar.getAgentRegistrar();
            }
        }

        public Principal authenticate(String name) {
            return this.authenticate(name, null, false);
        }

        public Principal authenticate(String name, String password) {
            return this.authenticate(name, password, true);
        }

        public Principal authenticate(String name, String password, boolean passwordRequired) {
            if (doDebug) {
                System.out.println("DefaultTrustManager: authenticating user " + name + ", password required = " + passwordRequired);
            }
            if (!this.m_securityEnabled) {
                return new ProgressPasswordUser(name, password);
            }
            if (this.m_external) {
                try {
                    return this.m_externalProvider.authenticate(name, password.getBytes(), null);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            if (name == null || passwordRequired && password == null) {
                return null;
            }
            ProgressPasswordUser user = this.m_secdb.getUser(name);
            if (!passwordRequired) {
                return user;
            }
            if (user == null) {
                return null;
            }
            return user.authenticate(password) ? user : null;
        }

        public Principal authenticate(String user, String digest, String nonce, String createdTime) {
            IPasswordUser authenticatedUser = null;
            if (this.m_external) {
                try {
                    byte[] credentials = new UsernameToken(user, digest, true, nonce, createdTime).toByteArray();
                    authenticatedUser = this.m_externalProvider.authenticate(user, credentials, null);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return authenticatedUser;
        }

        public Principal isTrusted(X509Certificate cert) {
            if (cert == null) {
                return null;
            }
            if (this.m_external) {
                try {
                    X509Certificate[] certs = new X509Certificate[]{cert};
                    return this.m_externalProvider.authenticate(null, null, certs);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return this.authenticate(DefaultTrustManager.parseCN(cert.getSubjectDN().getName()));
        }
    }
}

