/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.util.xml;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.trans.XPathException;

public class SonicNamespaceReducer
extends ProxyReceiver {
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, newstack, 0, this.depth);
            this.countStack = newstack;
        }
        if ((properties & 0x40) == 0) {
            this.namespace(this.getNamePool().allocateNamespaceCode(nameCode), 0);
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.isNeeded(namespaceCode)) {
            this.addToStack(namespaceCode);
            int n = this.depth - 1;
            this.countStack[n] = this.countStack[n] + 1;
            this.nextReceiver.namespace(namespaceCode, properties);
        }
    }

    private boolean isNeeded(int nscode) {
        if (nscode == 65537) {
            return false;
        }
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] == nscode) {
                return false;
            }
            if (this.namespaces[i] >> 16 != nscode >> 16) continue;
            return false;
        }
        return nscode != 0;
    }

    private void addToStack(int nscode) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] newlist = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, newlist, 0, this.namespacesSize);
            this.namespaces = newlist;
        }
        this.namespaces[this.namespacesSize++] = nscode;
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        int nscount = this.countStack[this.depth];
        this.namespacesSize -= nscount;
        this.nextReceiver.endElement();
    }
}

