/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.wsdl.extensions.wsp;

import java.io.PrintWriter;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DOMUtils {
    public static String getAttributeValue(Element el, String attrName) {
        String value = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            value = attr.getValue();
        }
        return value;
    }

    public static String getQualifiedValue(String namespaceURI, String localPart, Definition def) throws WSDLException {
        String prefix = null;
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            prefix = DOMUtils.getPrefix(namespaceURI, def);
        }
        return (prefix != null && !"".equals(prefix) ? prefix + ":" : "") + localPart;
    }

    public static String getPrefix(String namespaceURI, Definition def) throws WSDLException {
        String prefix = def.getPrefix(namespaceURI);
        if (prefix == null) {
            throw new WSDLException("OTHER_ERROR", "Can't find prefix for '" + namespaceURI + "'. Namespace prefixes must be set on the" + " Definition object using the " + "addNamespace(...) method.");
        }
        return prefix;
    }

    public static void printAttribute(String name, String value, PrintWriter pw) {
        if (value != null) {
            pw.print(' ' + name + "=\"" + DOMUtils.cleanString(value) + '\"');
        }
    }

    public static String cleanString(String orig) {
        if (orig == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        char[] chars = orig.toCharArray();
        boolean inCDATA = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!inCDATA) {
                switch (chars[i]) {
                    case '&': {
                        strBuf.append("&amp;");
                        break;
                    }
                    case '\"': {
                        strBuf.append("&quot;");
                        break;
                    }
                    case '\'': {
                        strBuf.append("&apos;");
                        break;
                    }
                    case '<': {
                        if (chars.length >= i + 9) {
                            String tempStr = new String(chars, i, 9);
                            if ("<![CDATA[".equals(tempStr)) {
                                strBuf.append(tempStr);
                                i += 8;
                                inCDATA = true;
                                break;
                            }
                            strBuf.append("&lt;");
                            break;
                        }
                        strBuf.append("&lt;");
                        break;
                    }
                    case '>': {
                        strBuf.append("&gt;");
                        break;
                    }
                    default: {
                        strBuf.append(chars[i]);
                        break;
                    }
                }
                continue;
            }
            strBuf.append(chars[i]);
            if (chars[i] != '>' || chars[i - 1] != ']' || chars[i - 2] != ']') continue;
            inCDATA = false;
        }
        return strBuf.toString();
    }
}

