/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.wsp;

import com.sonicsw.wsp.OperationContext;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IAgentQueue;
import progress.message.broker.ITempQueueDeleteListener;
import progress.message.broker.LogManager;
import progress.message.broker.OperationContextAddEvt;
import progress.message.broker.OperationContextRemoveEvt;
import progress.message.broker.SyncOperationContextEvt;
import progress.message.zclient.DebugObject;

public class OperationContextManager
extends DebugObject
implements ITempQueueDeleteListener {
    private Hashtable m_operations = new Hashtable();
    public static long BROKER_ID = AddrUtil.stringToClientId(Config.BROKER_NAME, "Broker");

    public OperationContextManager() {
        super("OperationContextManager");
    }

    public static OperationContextManager getOperationContextManager() {
        return AgentRegistrar.getAgentRegistrar().getOperationContextMgr();
    }

    public static String getBrokerIDAsString() {
        return Long.toString(BROKER_ID);
    }

    public void recoveryComplete() {
        Enumeration e = this.m_operations.elements();
        Map<String, IAgentQueue> aqpQueues = AgentRegistrar.getAgentRegistrar().getQueueProc().getQueues();
        Vector<String> deletes = new Vector<String>();
        while (e.hasMoreElements()) {
            OperationContext oc = (OperationContext)e.nextElement();
            if (aqpQueues.get(oc.getKey()) != null) continue;
            deletes.add(oc.getKey());
        }
        Enumeration e2 = deletes.elements();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            this.m_operations.remove(key);
        }
    }

    public void stop() {
    }

    public void start() {
        AgentRegistrar.getAgentRegistrar().getQueueProc().setTempQueueDeleteListener(this);
    }

    public void reset() {
        this.m_operations = new Hashtable();
    }

    public void setupAdminHandlers() throws IOException {
    }

    public OperationContext getOperationContext(String seq) {
        return (OperationContext)this.m_operations.get(seq);
    }

    public void addOperationContext(OperationContext oc, boolean log) {
        this.m_operations.put(oc.getKey(), oc);
        if (log) {
            try {
                this.logAdd(oc);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void removeOperationContext(OperationContext oc, boolean log) {
        this.m_operations.remove(oc.getKey());
        if (log) {
            this.logRemove(oc);
        }
    }

    public void redoSync(SyncOperationContextEvt oce) {
        this.redoAdd(oce);
    }

    public void redoRemove(OperationContextRemoveEvt oce) {
        this.m_operations.remove(oce.getId());
    }

    public void redoAdd(OperationContextAddEvt oce) {
        OperationContext oc = new OperationContext(oce.getId(), oce.getReplyPolicy(), oce.getKeyStoreAlias(), oce.getKeyPassword(), oce.getJMSCorrelationID());
        this.m_operations.put(oce.getId(), oc);
    }

    protected void logAdd(OperationContext oc) throws InterruptedException {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        OperationContextAddEvt be = new OperationContextAddEvt(oc);
        logMgr.addEvent(be, true);
        logMgr.waitForFlush(be);
    }

    protected void logRemove(OperationContext oc) {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        OperationContextRemoveEvt oce = new OperationContextRemoveEvt(oc);
        logMgr.addEvent(oce, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSyncRecords() {
        LogManager logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
        Hashtable hashtable = this.m_operations;
        synchronized (hashtable) {
            Enumeration it = this.m_operations.elements();
            while (it.hasMoreElements()) {
                OperationContext oc = (OperationContext)it.nextElement();
                SyncOperationContextEvt synce = new SyncOperationContextEvt(oc);
                logMgr.addEvent(synce, false);
            }
        }
    }

    @Override
    public void queueDeleted(String qn) {
        this.removeIfPresent(qn);
    }

    public void onFault(String id) {
        this.removeIfPresent(id);
    }

    public void onReply(String id) {
        this.removeIfPresent(id);
    }

    private void removeIfPresent(String id) {
        if (id == null) {
            return;
        }
        OperationContext oc = this.getOperationContext(id);
        if (oc != null) {
            this.removeOperationContext(oc, true);
        }
    }
}

