/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import progress.message.broker.AgentConnection;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.IAcceptor;
import progress.message.broker.prAccessor;
import progress.message.net.ESocketConfigException;
import progress.message.net.ISocketHandler;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.ProgressSocketFactory;
import progress.message.util.URLUtil;
import progress.message.zclient.BrokerURL;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;

public abstract class Acceptor
extends DebugObject
implements IAcceptor {
    public static String BIND_TO_SPECIFIED_IP_OR_HOST_ONLY = "#ONLY";
    private ISocketHandler m_sh;
    private int m_state = 0;
    protected ProgressServerSocket m_serverSocket;
    protected DebugThread m_acceptorThread = null;
    String m_url = null;
    String m_externalUrl = null;
    String m_protocol = null;
    String m_hostname = null;
    String m_name = null;
    String m_qualification = "";
    int m_port;
    int m_index;
    int m_backlog;
    Principal m_principal = null;
    Properties m_properties = null;
    ProgressInetAddress m_bindAddr = null;
    ProgressSocketFactory m_socketFactory = null;
    boolean m_bindToSpecifiedIpOrHostOnly = false;
    boolean m_isStartActive = true;
    private boolean m_isFTPeerAcceptor = false;
    private List<AgentConnection> m_connections = Collections.synchronizedList(new ArrayList());

    public void setStartActive(boolean b) {
        this.m_isStartActive = b;
    }

    public boolean isStartActive() {
        return this.m_isStartActive;
    }

    public void setFTPeerAcceptor(boolean b) {
        this.m_isFTPeerAcceptor = b;
    }

    public boolean isFTPeerAcceptor() {
        return this.m_isFTPeerAcceptor;
    }

    @Override
    public void addConnection(AgentConnection conn) {
        this.m_connections.add(conn);
    }

    @Override
    public void removeConnection(AgentConnection conn) {
        this.m_connections.remove(conn);
    }

    public List getConnections() {
        return this.m_connections;
    }

    public void start() {
        this.m_acceptorThread = new AcceptorThread(this.m_url);
        this.m_acceptorThread.start();
    }

    public void shutdown() {
        if (this.m_acceptorThread == null) {
            return;
        }
        this.m_acceptorThread.shutdown();
    }

    public void setName(String name) {
        if (this.m_acceptorThread == null) {
            return;
        }
        this.m_acceptorThread.setName(name);
    }

    public String getName() {
        if (this.m_acceptorThread == null) {
            return null;
        }
        return this.m_acceptorThread.getName();
    }

    public boolean isAlive() {
        if (this.m_acceptorThread == null) {
            return false;
        }
        return this.m_acceptorThread.isAlive();
    }

    public boolean isShuttingDown() {
        if (this.m_acceptorThread == null) {
            return false;
        }
        return this.m_acceptorThread.isShuttingDown();
    }

    public Acceptor(String name, String url, String externalUrl, String protocol, boolean dynHostBinding, String dynamicPrivateHost, String dynamicPublicHost, Properties properties) throws ESocketConfigException {
        super(url);
        this.debugName("Acceptor " + name);
        this.m_name = name;
        this.m_protocol = protocol;
        this.m_properties = this.m_properties == null && properties != null ? properties : new Properties();
        boolean result = false;
        String dynhost = dynamicPublicHost;
        if (dynhost == null || dynhost.length() == 0) {
            dynhost = dynamicPrivateHost;
        }
        try {
            this.setURLHostPort(url, dynHostBinding, dynhost);
        }
        catch (Exception e) {
            ESocketConfigException ex = new ESocketConfigException(prAccessor.getString("INVALID_URL") + url);
            ex.initCause(e);
            throw ex;
        }
        this.m_externalUrl = externalUrl;
        if (this.DEBUG || Config.DS_DEBUG) {
            System.out.println("Acceptor constructor, after resolution: m_name= " + this.m_name + " m_protocol= " + this.m_protocol + " m_url= " + this.m_url + " m_port= " + this.m_port + " m_externalUrl= " + this.m_externalUrl + " origUrl= " + url + " dynHostBinding= " + dynHostBinding + " dynamicPrivateHost= " + dynamicPrivateHost + " dynamicPublicHost= " + dynamicPublicHost);
        }
        this.m_qualification = "";
        this.setCallback();
    }

    private void setCallback() {
        if (this.CALLBACK) {
            this.callback("", 0, this);
        }
    }

    @Override
    public void setSocketHandler(ISocketHandler sh) {
        this.m_sh = sh;
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    @Override
    public void setPrincipal(Principal principal) {
        this.m_principal = principal;
    }

    @Override
    public void setSocketQueueLength(int socketQueueLengthInBytes) {
        this.m_backlog = socketQueueLengthInBytes;
    }

    @Override
    public Properties getProperties() {
        return this.m_properties;
    }

    abstract void createServerSocket() throws IOException;

    @Override
    public String getAcceptorName() {
        return this.m_name;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public synchronized int getAcceptorState() {
        return this.m_state;
    }

    @Override
    public synchronized void setAcceptorState(int state) {
        this.m_state = state;
        this.notifyAll();
    }

    @Override
    public String getURL() {
        if (this.m_hostname != null) {
            return this.m_url;
        }
        return null;
    }

    public String getExternalURL() {
        return this.m_externalUrl;
    }

    public void setBindToSpecifiedIpOrHostOnly(boolean b) throws ESocketConfigException {
        if (b) {
            if (!this.m_bindToSpecifiedIpOrHostOnly) {
                this.m_bindToSpecifiedIpOrHostOnly = true;
                try {
                    this.m_bindAddr = ProgressInetAddress.getByName(this.m_hostname);
                }
                catch (UnknownHostException ex) {
                    throw new ESocketConfigException(prAccessor.getString("BIND_ERROR_UNKNOWN_HOST") + this.m_hostname);
                }
            }
        } else {
            this.m_bindToSpecifiedIpOrHostOnly = false;
            this.m_bindAddr = null;
        }
    }

    private void setURLHostPort(String url, boolean dynHostBinding, String dynamicHost) throws IOException {
        boolean bindToSpecifiedIpOrHostOnly = url.endsWith(BIND_TO_SPECIFIED_IP_OR_HOST_ONLY);
        if (bindToSpecifiedIpOrHostOnly) {
            url = url.substring(0, url.lastIndexOf(BIND_TO_SPECIFIED_IP_OR_HOST_ONLY));
        }
        String newUrl = this.rebuildUrl(url, dynHostBinding, dynamicHost);
        this.m_bindToSpecifiedIpOrHostOnly = bindToSpecifiedIpOrHostOnly;
        BrokerURL brokerURL = new BrokerURL(newUrl, dynHostBinding);
        this.m_hostname = brokerURL.getBrokerHostName();
        this.m_port = brokerURL.getBrokerPort();
        this.m_url = brokerURL.getBrokerURL();
    }

    private String rebuildUrl(String url, boolean dynHostBinding, String dynHost) throws IOException {
        if (url == null) {
            return null;
        }
        BrokerURL brokerURL = new BrokerURL(url, dynHostBinding);
        String protocol = brokerURL.getBrokerProtocol();
        String newHost = brokerURL.getBrokerHostName();
        String returnedUrl = brokerURL.getBrokerURL();
        if (dynHost != null && dynHost.length() > 0 && !dynHost.equals(newHost)) {
            newHost = dynHost;
            returnedUrl = URLUtil.buildUrlString(protocol, newHost, brokerURL.getBrokerPort());
        }
        if (newHost.equals("localhost")) {
            newHost = ProgressInetAddress.getLocalHostName();
            returnedUrl = URLUtil.buildUrlString(protocol, newHost, brokerURL.getBrokerPort());
        }
        return returnedUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAcceptorNoWait() {
        if (this.getAcceptorState() == 1) {
            return;
        }
        if (this.CALLBACK) {
            super.callback("", 4, this.m_serverSocket);
        }
        Acceptor acceptor = this;
        synchronized (acceptor) {
            this.setAcceptorState(4);
            if (!this.isAlive()) {
                this.shutdown();
            }
        }
        if (this.getAcceptorState() == 1) {
            return;
        }
        try {
            Object[] obj;
            acceptor = this;
            synchronized (acceptor) {
                if (this.m_serverSocket != null) {
                    this.m_serverSocket.close();
                    this.m_serverSocket = null;
                }
            }
            if (this.m_index >= 0) {
                obj = new Object[]{this.m_name, this.m_qualification, this.m_protocol + "://" + this.m_hostname + ":" + this.m_port};
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("AcceptorStopped"), obj), 3);
            } else {
                obj = new Object[]{this.m_name, this.m_protocol + "://" + this.m_hostname + ":" + this.m_port};
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("AltAcceptorStopped"), obj), 3);
            }
            if (Config.DS_DEBUG) {
                System.out.println("Acceptor.stopAcceptor: m_name = " + this.m_name + ", state = " + this.getAcceptorState());
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format(prAccessor.getString("EXCEPTION_MSG"), "Acceptor");
            BrokerComponent.getComponentContext().logMessage(msg, (Throwable)e, 1);
            if (this.m_acceptorThread != null) {
                if (this.m_acceptorThread.isAlive()) {
                    this.m_acceptorThread.interrupt();
                } else if (Broker.exiting) {
                    this.m_acceptorThread.start();
                }
            }
            this.setAcceptorState(1);
        }
    }

    @Override
    public void stopAcceptor() {
        this.stopAcceptor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AgentConnection> stopAcceptor(boolean dropConnections) {
        Object object;
        ArrayList<AgentConnection> connectionsToDrop = null;
        if (this.getAcceptorState() == 3 || this.getAcceptorState() == 2) {
            this.stopAcceptorNoWait();
        }
        while (this.getAcceptorState() > 1) {
            object = this;
            synchronized (object) {
                try {
                    this.wait(100L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (dropConnections) {
            object = this.m_connections;
            synchronized (object) {
                connectionsToDrop = new ArrayList<AgentConnection>(this.m_connections);
                this.m_connections.clear();
            }
        }
        return connectionsToDrop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyAcceptor() {
        while (this.getAcceptorState() == 4) {
            Acceptor acceptor = this;
            synchronized (acceptor) {
                try {
                    this.wait(100L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            this.setAcceptorState(1);
        }
        catch (Exception e) {
            String msg = MessageFormat.format(prAccessor.getString("EXCEPTION_MSG"), "Acceptor");
            BrokerComponent.getComponentContext().logMessage(msg, (Throwable)e, 1);
        }
    }

    class AcceptorThread
    extends DebugThread {
        public AcceptorThread(String url) {
            super(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            try {
                block27: while (!Broker.exiting && !Thread.interrupted()) {
                    Object obj;
                    String msg;
                    block42: {
                        if (this.CALLBACK) {
                            super.callback(null, 1, null);
                        }
                        try {
                            ProgressInetAddress addr = ProgressInetAddress.getByName(Acceptor.this.m_hostname);
                            new ServerSocket(Acceptor.this.m_port, 0, addr == null ? null : addr.getDelegateInetAddress()).close();
                            if (!Acceptor.this.m_bindToSpecifiedIpOrHostOnly) break block42;
                            Acceptor.this.m_bindAddr = addr;
                        }
                        catch (UnknownHostException ex) {
                            msg = prAccessor.getString("BIND_ERROR_UNKNOWN_HOST") + Acceptor.this.m_hostname;
                            BrokerComponent.getComponentContext().logMessage(msg, (Throwable)ex, 1);
                            break;
                        }
                        catch (IOException ex) {
                            msg = prAccessor.getString("INVALID_URL") + Acceptor.this.m_url;
                            BrokerComponent.getComponentContext().logMessage(msg, (Throwable)ex, 1);
                            break;
                        }
                    }
                    try {
                        Acceptor ex = Acceptor.this;
                        synchronized (ex) {
                            if (Acceptor.this.getAcceptorState() == 4) {
                                break;
                            }
                            Acceptor.this.createServerSocket();
                        }
                    }
                    catch (IOException e) {
                        msg = MessageFormat.format(prAccessor.getString("IO_EXCEPTION_MSG"), "acceptor " + Acceptor.this.m_name);
                        BrokerComponent.getComponentContext().logMessage(msg, (Throwable)e, 1);
                        break;
                    }
                    if (this.CALLBACK) {
                        super.callback("", 2, Acceptor.this.m_serverSocket);
                    }
                    if (Acceptor.this.m_index >= 0) {
                        obj = new Object[]{this.m_name, Acceptor.this.m_qualification, Acceptor.this.m_protocol + "://" + Acceptor.this.m_hostname + ":" + Acceptor.this.m_port};
                        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("AcceptorReady"), obj), 3);
                    } else {
                        obj = new Object[]{this.m_name, Acceptor.this.m_protocol + "://" + Acceptor.this.m_hostname + ":" + Acceptor.this.m_port};
                        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("AltAcceptor"), obj), 3);
                    }
                    obj = Acceptor.this;
                    synchronized (obj) {
                        if (Acceptor.this.getAcceptorState() == 4) {
                            break;
                        }
                        Acceptor.this.setAcceptorState(3);
                    }
                    while (!this.isShuttingDown()) {
                        try {
                            ProgressSocket socket;
                            if (Acceptor.this.getAcceptorState() == 4) break;
                            try {
                                socket = Acceptor.this.m_serverSocket.accept();
                            }
                            catch (IOException ioe) {
                                Acceptor.this.m_serverSocket.close();
                                if (Acceptor.this.getAcceptorState() == 4) break;
                                BrokerComponent.getBrokerComponent();
                                BrokerComponent.logMessage(MessageFormat.format(prAccessor.getString("STR348"), this.m_name + " (" + Acceptor.this.m_url + ")"), ioe, BrokerComponent.getLevelWarning());
                                if (!(ioe instanceof ESocketConfigException)) continue block27;
                                break;
                            }
                            if (Acceptor.this.getAcceptorState() == 4) {
                                socket.close();
                                break;
                            }
                            socket.setAcceptor(Acceptor.this);
                            Acceptor.this.m_sh.handleSocket(socket, Acceptor.this);
                        }
                        catch (NullPointerException npe) {
                            break;
                        }
                        catch (SocketException se) {
                            if (Config.DS_DEBUG) {
                                System.out.println("Acceptor.threadMain: MF, java.net.SocketException caught in " + this.m_name + " loop...");
                            }
                            if (Acceptor.this.getAcceptorState() != 4) continue;
                            break;
                        }
                        catch (IOException e) {
                            if (Config.DS_DEBUG) {
                                System.out.println("Acceptor.threadMain: MF, Exception caught in " + this.m_name + " loop...");
                            }
                            if (Acceptor.this.getAcceptorState() == 4) break;
                            String mf66 = prAccessor.getString("STR348");
                            Object[] ob66 = new Object[]{this.m_name};
                            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf66, ob66), 2);
                            try {
                                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                PrintStream trace_os = new PrintStream(bos);
                                e.printStackTrace(trace_os);
                                String s_trace = new String(bos.toByteArray());
                                if (this.DEBUG) {
                                    BrokerComponent.getComponentContext().logMessage(s_trace, 2);
                                }
                                trace_os.close();
                            }
                            catch (Exception se) {
                                // empty catch block
                            }
                            BrokerComponent.getComponentContext().logMessage("", 3);
                            String mf69 = prAccessor.getString("STR349");
                            Object[] ob69 = new Object[]{this.m_name};
                            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf69, ob69), 3);
                            BrokerComponent.getComponentContext().logMessage("", 3);
                        }
                    }
                    if (System.getProperty("UMF_broker_prototype") != null) continue;
                }
                if (Config.DS_DEBUG) {
                    System.out.println("Acceptor.threadMain: m_name = " + this.m_name + ", m_serverSocket = " + Acceptor.this.m_serverSocket + ", exiting = " + Broker.exiting + ", state = " + Acceptor.this.getAcceptorState());
                }
                try {
                    Acceptor e = Acceptor.this;
                    synchronized (e) {
                        if (Acceptor.this.m_serverSocket != null) {
                            Acceptor.this.m_serverSocket.close();
                            Acceptor.this.m_serverSocket = null;
                        }
                    }
                }
                catch (IOException e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                if (Config.DS_DEBUG) {
                    System.out.println("Acceptor.threadMain: thread exiting...");
                }
            }
            finally {
                Acceptor.this.setAcceptorState(1);
            }
        }
    }
}

