/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.common.runtime.IConnectionData;
import com.sonicsw.mq.common.runtime.IDurableSubscriptionData;
import com.sonicsw.mq.common.runtime.ISubscriberData;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.mq.components.ExternalDomainAuthSPIConfig;
import com.sonicsw.net.http.HttpClientContextManager;
import com.sonicsw.net.http.ws.WSDLCache;
import com.sonicsw.security.pass.broker.IAuthentication;
import com.sonicsw.security.pass.broker.IBrokerSecurityCache;
import com.sonicsw.security.pcs.CipherSuiteInfo;
import com.sonicsw.security.pcs.IPluggableCipherSuite;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.util.WSAClusteringHelper;
import com.sonicsw.wsp.OperationContextManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentListener;
import progress.message.broker.AgentMessageProcessor;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentSender;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.Authorize;
import progress.message.broker.BaseClientContext;
import progress.message.broker.BaseClientContextWrapper;
import progress.message.broker.Broker;
import progress.message.broker.BrokerContext;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerSearchResults;
import progress.message.broker.BrokerSecurityContextDisplayInfoFactory;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.CWADSMessageHandler;
import progress.message.broker.ClientContextCreator;
import progress.message.broker.ClientContextFactory;
import progress.message.broker.ClientContextTracker;
import progress.message.broker.Config;
import progress.message.broker.ConnectEvt;
import progress.message.broker.CounterManager;
import progress.message.broker.DeleteMsgManager;
import progress.message.broker.DeleteSubscriptionManager;
import progress.message.broker.DisconnectTimerManager;
import progress.message.broker.DurableCCTracker;
import progress.message.broker.DurableManager;
import progress.message.broker.DurableSMOUpdateEvt;
import progress.message.broker.DurableSubscriptionUtil;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EConnectionNotResumable;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.EStartupFailure;
import progress.message.broker.ExpirationQueue;
import progress.message.broker.ExpiredMessageCleaner;
import progress.message.broker.ExpiredMsgContainer;
import progress.message.broker.FlowControlManager;
import progress.message.broker.FlowControlSender;
import progress.message.broker.GroupSubscription;
import progress.message.broker.GroupSubscriptions;
import progress.message.broker.IAcceptor;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.IClientContextTracker;
import progress.message.broker.IDRMgramHandler;
import progress.message.broker.IInterbrokerHook;
import progress.message.broker.IStateController;
import progress.message.broker.IStateListener;
import progress.message.broker.InitRestoreFlowController;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.IntervalPollingThread;
import progress.message.broker.LogEvent;
import progress.message.broker.LogFile;
import progress.message.broker.LogManager;
import progress.message.broker.MergedBrokerSubscription;
import progress.message.broker.MsgRestoreMgr;
import progress.message.broker.MsgRestorer;
import progress.message.broker.MsgSaver;
import progress.message.broker.PipeSocket;
import progress.message.broker.PostponedMsgSaver;
import progress.message.broker.ProvisionMonitor;
import progress.message.broker.PublishLimiter;
import progress.message.broker.QMsgStateMgr;
import progress.message.broker.QueueMsgSaver;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.Redirector;
import progress.message.broker.RemoteRestoreManager;
import progress.message.broker.RoutingConfiguration;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.broker.SlowSubscriberMonitor;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.SubscriptionData;
import progress.message.broker.SubscriptionExpirator;
import progress.message.broker.SubscriptionsTable;
import progress.message.broker.SyncpointLoc;
import progress.message.broker.TransactionMgr;
import progress.message.broker.UnfilteredEvt;
import progress.message.broker.UnregisterEvt;
import progress.message.broker.UnsubscribeAllEvt;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.WatchDogThread;
import progress.message.broker.fc.FlowControlMonitor;
import progress.message.broker.gs.GSManager;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.interceptor.InterceptorManager;
import progress.message.broker.loadbalancing.ILoadBalancer;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.broker.stats.LValueStatsObj;
import progress.message.client.Credentials;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EGeneralException;
import progress.message.client.EInauthenticClient;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidTTLException;
import progress.message.client.ENetworkFailure;
import progress.message.client.EPasswordExpired;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ESocketIdMismatch;
import progress.message.client.EUnauthorizedClient;
import progress.message.client.EUnknownPrincipal;
import progress.message.client.EUnusableConnection;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.EUserAlreadyConnectedPendingReconnect;
import progress.message.client.Username;
import progress.message.cwaq.ClusteredQueueManager;
import progress.message.db.EDatabaseException;
import progress.message.db.EInvalidConfiguration;
import progress.message.dd.NoDupDetectDb;
import progress.message.ft.ClientContextDescriptor;
import progress.message.ft.DurableSyncReplicationMgr;
import progress.message.ft.DynamicSyncManager;
import progress.message.ft.FTMgramFactory;
import progress.message.ft.FTReflectionOperation;
import progress.message.ft.IReplicationConnection;
import progress.message.ft.ReplicationConnection;
import progress.message.ft.ReplicationManager;
import progress.message.gr.RouterManager;
import progress.message.net.ISocket;
import progress.message.net.ISocketHandler;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ssl.CRLStore;
import progress.message.resources.prMessageFormat;
import progress.message.security.ENoAuthService;
import progress.message.security.EPrincipalConflict;
import progress.message.security.EPrincipalExists;
import progress.message.security.SecurityBean;
import progress.message.util.DebugState;
import progress.message.util.DraDestUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.LongHashTable;
import progress.message.util.server.LongHolder;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ConnectRequest;
import progress.message.zclient.CredentialsConnectRequest;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.IUser;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectSpace;
import progress.message.zclient.SubjectUtil;

public final class AgentRegistrar
extends DebugObject
implements ISocketHandler,
IUser,
IStateListener,
IStateController {
    private static final boolean DEBUG_SECURITY_QOPCACHE = false;
    private static volatile AgentRegistrar s_reg;
    private SecurityBean m_secBean;
    private long m_id;
    private LongHashTable m_regCl;
    private LongHashTable m_trackRegCl;
    public AgentSubjectSpace m_regSub;
    private LogManager m_logmgr;
    private long m_logTime;
    private BrokerDatabase m_db;
    private MsgSaver m_msgSaver;
    private InitRestoreFlowController m_initRestoreFC;
    private QueueMsgSaver m_qmsgSaver;
    private Hashtable m_dirtyClients;
    private StatsManager m_statsMgr;
    private AgentAdminConnection m_adminConn;
    private AgentConnection m_adminAgentConn;
    private TransactionMgr m_txnmgr;
    private RMManager m_rmmgr;
    private OperationContextManager m_ocmgr;
    private WSAClusteringHelper m_wsaclusterHelper;
    private IDRMgramHandler m_idrhandler;
    private int m_clientCount;
    private ExpiredMsgContainer m_expiredMsgs;
    private SubscriptionExpirator m_subExpirator;
    private ExpirationQueue m_expSubs;
    private ExpiredMessageCleaner m_expiredMessageCleaner;
    private SlowSubscriberMonitor m_slowSubscriberMonitor;
    private GroupSubscriptions m_groupSubs;
    private AgentMessageProcessor m_msgproc;
    private AgentQueueProcessor m_qproc;
    private ClusteredQueueManager m_cqm;
    private IInterbrokerHook m_iihook = null;
    private RoutingConfiguration m_routingConfig;
    private RouterManager m_routerMgr;
    private FlowControlManager m_flowControlManager;
    private ILoadBalancer m_loadBalancer;
    private QMsgStateMgr m_qMsgStateMgr;
    private GSManager m_gsManager;
    private CounterManager m_counterManager;
    private CWADSMessageHandler m_cwadsMsgHandler;
    private WatchDogThread m_watchdog = null;
    private ProvisionMonitor m_provisionMonitor = null;
    private IntervalPollingThread m_pollingThread = null;
    private FlowControlMonitor m_FCMonitor = null;
    private Object m_remoteRestoreManagerSyncObj = new Object();
    private volatile RemoteRestoreManager m_remoteRestoreManager = null;
    private ClientContextFactory[] m_clientContextFactories = null;
    private IClientContextTracker m_clientContextTracker = ClientContextTracker.getClientContextTracker();
    private boolean m_writingSubscriptions;
    private Hashtable m_contextLocks;
    private Object m_subscriptionMutex = new Object();
    private String m_collective = "";
    private int m_collectiveSCode = SubjectUtil.computeSCode(this.m_collective, 0, this.m_collective.length());
    private ReplicationManager m_replicationManager = null;
    private DurableSyncReplicationMgr m_durableSyncReplMgr = null;
    private static volatile DisconnectTimerManager m_disconnectTimerMgr;
    private boolean m_inRecovery = false;
    private boolean m_acceptConnection = true;
    private boolean m_recoveredFromLog;
    private long m_lastConnectionId = -1L;
    private Object m_connIdSync = new Object();
    private static volatile IAuthentication m_authenticationSPI;
    private static volatile ExternalDomainAuthSPIConfig m_externalDomainAuthSPIConfig;
    private static volatile IPluggableCipherSuite m_pluggableCipherSuite;
    private static boolean m_isBadCipherConfigured;
    private boolean m_isXAConfigured = false;
    private Object m_dsmSyncObject = new Object();
    private DurableManager m_dsm;
    private Object m_postponedMsgSaverSyncObject = new Object();
    private PostponedMsgSaver m_postponedMsgSaver;
    private Object m_deleteSubscriptionMgrSyncObject = new Object();
    private DeleteSubscriptionManager m_deleteSubscriptionMgr;
    private Object m_deleteMsgManagerSyncObject = new Object();
    private DeleteMsgManager m_deleteMsgManager;
    private Object m_msgRestoreMgrSyncObject = new Object();
    private MsgRestoreMgr m_msgRestoreMgr;
    private RecoveryThread m_recoveryThread = null;
    private HashMap m_recoveredSubscriptions = new HashMap();
    private LValueStatsObj m_clientCounter;
    private boolean m_debugSystemStatsEnabled = false;
    private Subject m_getGroupNamesSub = new Subject("$ISYS.secdb.getGroupNames");
    private final boolean DEBUG_UNEXPECTED = this.checkDebugFlags(8192);
    private boolean m_isActive = false;

    public boolean recoveredFromLog() {
        return this.m_recoveredFromLog;
    }

    public static void halt() {
        Runtime.getRuntime().halt(0);
    }

    public static void runDBCleaner(Object param) {
        AgentRegistrar.getAgentRegistrar().getBrokerDatabase().runCleaner();
    }

    public static void doSyncpoint(Object param) {
        try {
            AgentRegistrar.getAgentRegistrar().getLogManager().forceSyncpoint(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ExpirationQueue getExpirationQueue() {
        return this.m_expSubs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastConnectionId() {
        Object object = this.m_connIdSync;
        synchronized (object) {
            return this.m_lastConnectionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastConnectionId(long id) {
        Object object = this.m_connIdSync;
        synchronized (object) {
            if (id > this.m_lastConnectionId) {
                this.m_lastConnectionId = id;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLastConnectionId() throws IOException {
        Object object = this.m_connIdSync;
        synchronized (object) {
            this.m_db.setLastConnectionID(this.m_lastConnectionId);
        }
    }

    private void initConnectionId(long lastConnId) {
        long currentBlock = lastConnId / (long)Config.CONNECTION_ID_BLOCK_SIZE;
        this.m_lastConnectionId = currentBlock == Integer.MAX_VALUE / (long)Config.CONNECTION_ID_BLOCK_SIZE ? 0L : ++currentBlock * (long)Config.CONNECTION_ID_BLOCK_SIZE - 1L;
        if (this.DEBUG) {
            this.debug("starts next conn id from: " + (this.m_lastConnectionId + 1L));
        }
    }

    boolean isAcceptConnection() {
        return this.m_acceptConnection;
    }

    void setAcceptConnection(boolean accept) {
        this.m_acceptConnection = accept;
    }

    void shutdown() {
        if (this.m_provisionMonitor != null) {
            this.m_provisionMonitor.shutdown();
        }
        if (this.m_loadBalancer != null) {
            this.m_loadBalancer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killAllConnections() {
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            Enumeration enu = this.m_regCl.elements();
            while (enu.hasMoreElements()) {
                IClientContext cc = (IClientContext)enu.nextElement();
                if (ReplicationManager.isReplicationConnection(cc) || cc.isGroupSubscription() || Config.REPLICATED && cc.getConnection() == this.m_adminAgentConn) continue;
                if (this.DEBUG) {
                    this.debug("Killing " + cc);
                }
                cc.killAgentConnection();
                if (!cc.isConnected() || cc.isXOnce() || !cc.isDurable()) continue;
                cc.setLastConnectedTime(System.currentTimeMillis());
                if (cc.isDirty()) continue;
                Long id = new Long(cc.getId());
                this.m_dirtyClients.put(id, id);
            }
        }
    }

    void closeLogFiles() {
        try {
            LogFile logFile;
            LogManager logMgr = this.getLogManager();
            if (logMgr != null && (logFile = logMgr.getLogFile()) != null) {
                logFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void killAllThreads() {
        FlowControlSender flowControlSender;
        if (this.checkDebugFlags(32)) {
            this.debug("AgentReg.killAllThreads starting");
        }
        if (Config.ENABLE_INTERBROKER && this.m_iihook != null) {
            this.m_iihook.stopInterbroker();
        }
        if ((flowControlSender = PublishLimiter.getFlowControlSender()) != null) {
            flowControlSender.shutdown();
        }
        try {
            if (this.getAdminConnection() != null) {
                this.getAdminConnection().disconnect(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getStatsManager() != null) {
            this.getStatsManager().shutdown();
        }
        if (this.getTransactionMgr() != null) {
            this.getTransactionMgr().shutdown();
        }
        if (this.getRouterManager() != null) {
            this.getRouterManager().stopThreads();
            if (this.getRouterManager().getRouteForwarder() != null) {
                this.getRouterManager().getRouteForwarder().stopRouteSaver();
            }
        }
        if (this.getQueueProc() != null) {
            this.getQueueProc().stopQueues();
            this.getQueueProc().shutdown();
        }
        if (this.getSubscriptionExpirator() != null) {
            this.getSubscriptionExpirator().shutdown();
        }
        if (this.getSlowSubscriberMonitor() != null) {
            this.getSlowSubscriberMonitor().shutdown();
        }
        if (this.getWatchDogThread() != null) {
            this.getWatchDogThread().shutdown();
        }
        if (this.getPollingThread() != null) {
            this.getPollingThread().shutdown();
        }
        if (this.getFCMonitor() != null) {
            this.getFCMonitor().shutdown();
        }
        if (this.getAgentConnection() != null) {
            this.getAgentConnection().close();
            if (this.getAgentConnection().getAgentSender() != null && this.getAgentConnection().getAgentSender().isAlive()) {
                this.getAgentConnection().getAgentSender().interrupt();
            }
        }
        if (this.getGSManager() != null) {
            this.getGSManager().shutdown();
        }
        if (this.getDurableManager() != null) {
            this.getDurableManager().shutdown();
        }
        if (HttpClientContextManager.getInstance() != null) {
            HttpClientContextManager.getInstance().shutdown();
        }
        if (this.checkDebugFlags(32)) {
            this.debug("AgentReg.killAllThreads (14)");
        }
        this.killAllAcceptors();
    }

    private void killAllAcceptors() {
        Enumeration acceptorTables = AcceptorHolder.getAcceptorHolder().getAcceptors();
        if (acceptorTables != null) {
            while (acceptorTables.hasMoreElements()) {
                Hashtable acceptorsTable = (Hashtable)acceptorTables.nextElement();
                Enumeration acceptors = acceptorsTable.elements();
                while (acceptors.hasMoreElements()) {
                    Acceptor acceptor = (Acceptor)acceptors.nextElement();
                    acceptor.stopAcceptor();
                }
            }
        }
        CRLStore.shutdown();
    }

    LongHashTable getClientReg() {
        return this.m_regCl;
    }

    ArrayList getClientContexts() {
        ArrayList contexts = new ArrayList();
        try {
            Enumeration elements = this.getClientReg().elements();
            while (elements.hasMoreElements()) {
                contexts.add(elements.nextElement());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return contexts;
    }

    public void publishQop(long SenderId, byte attr, ISubject subject) {
        try {
            IClientContext pubcc = this.getClient(SenderId);
            Message m = new Message(SessionConfig.getDirectedSubject(pubcc.getUid(), pubcc.getAppid(), this.m_collective, Config.BROKER_UID, "QopCache"));
            m.writeByte(attr);
            m.writeShort(subject.getMatchVector().length);
            m.write(subject.getMatchVector());
            m.writeUTF(subject.getSubjectString());
            Envelope env = new Envelope(m);
            Session l_Session = this.m_adminConn.getDefaultSession();
            Label newLabel = (Label)env.getLabel().clone();
            newLabel.setPriority((byte)10);
            env.setLabel(newLabel);
            l_Session.publishInternal(env, 0, false, true);
        }
        catch (EClientNotRegistered cnr) {
        }
        catch (ENetworkFailure enf) {
            if (!Broker.isInShutdown()) {
                throw new EAssertFailure("internal error: in client qop cache publisher.", enf);
            }
        }
        catch (EGeneralException g) {
            throw new EAssertFailure("internal error: in client qop cache publisher.", g);
        }
        catch (IOException i) {
            throw new EAssertFailure("internal error: in client qop cache publisher.", i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DurableManager getDurableManager() {
        Object syncObject = this.m_dsmSyncObject;
        if (this.m_dsm == null) {
            Object object = syncObject;
            synchronized (object) {
                if (this.m_dsm == null) {
                    this.m_dsm = new DurableManager();
                    this.m_dsmSyncObject = null;
                    return this.m_dsm;
                }
            }
        }
        return this.m_dsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostponedMsgSaver getPostponedMsgSaver() {
        Object syncObject = this.m_postponedMsgSaverSyncObject;
        if (this.m_postponedMsgSaver == null) {
            Object object = syncObject;
            synchronized (object) {
                if (this.m_postponedMsgSaver == null) {
                    this.m_postponedMsgSaver = new PostponedMsgSaver(this.getMsgSaver());
                    this.m_postponedMsgSaverSyncObject = null;
                    return this.m_postponedMsgSaver;
                }
            }
        }
        return this.m_postponedMsgSaver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteSubscriptionManager getDeleteSubscriptionManager() {
        Object syncObject = this.m_deleteSubscriptionMgrSyncObject;
        if (this.m_deleteSubscriptionMgr == null) {
            Object object = syncObject;
            synchronized (object) {
                if (this.m_deleteSubscriptionMgr == null) {
                    this.m_deleteSubscriptionMgr = new DeleteSubscriptionManager();
                    this.m_deleteSubscriptionMgrSyncObject = null;
                }
            }
        }
        return this.m_deleteSubscriptionMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteMsgManager getDeleteMsgManager() {
        Object syncObject = this.m_deleteMsgManagerSyncObject;
        if (this.m_deleteMsgManager == null) {
            Object object = syncObject;
            synchronized (object) {
                if (this.m_deleteMsgManager == null) {
                    this.m_deleteMsgManager = new DeleteMsgManager();
                    this.m_deleteMsgManagerSyncObject = null;
                }
            }
        }
        return this.m_deleteMsgManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsgRestoreMgr getMsgRestoreMgr() {
        Object syncObject = this.m_msgRestoreMgrSyncObject;
        if (this.m_msgRestoreMgr == null) {
            Object object = syncObject;
            synchronized (object) {
                if (this.m_msgRestoreMgr == null) {
                    this.m_msgRestoreMgr = new MsgRestoreMgr();
                    this.m_msgRestoreMgrSyncObject = null;
                }
            }
        }
        return this.m_msgRestoreMgr;
    }

    public static AgentRegistrar getAgentRegistrar() {
        return s_reg;
    }

    public static void initAgentRegistrar() {
        s_reg = new AgentRegistrar();
    }

    public static final void setCipherSuite(IPluggableCipherSuite cipherSuite) {
        m_pluggableCipherSuite = cipherSuite;
    }

    public static final IPluggableCipherSuite getCipherSuite() {
        return m_pluggableCipherSuite;
    }

    public static final void setBadCipherConfiguration(boolean flag) {
        m_isBadCipherConfigured = true;
    }

    public static final boolean isBadCipherConfiguration() {
        return m_isBadCipherConfigured;
    }

    public static final IClientContextTracker getClientContextTracker() {
        if (AgentRegistrar.getAgentRegistrar().m_clientContextTracker == null) {
            AgentRegistrar.getAgentRegistrar().m_clientContextTracker = ClientContextTracker.getClientContextTracker();
        }
        return AgentRegistrar.getAgentRegistrar().m_clientContextTracker;
    }

    public static final IAuthentication getAuthenticationSPI() {
        return m_authenticationSPI;
    }

    public static final void setExternalDomainAuthSPIConfig(ExternalDomainAuthSPIConfig externalDomainAuthSPIConfig) {
        m_externalDomainAuthSPIConfig = externalDomainAuthSPIConfig;
    }

    public static final ExternalDomainAuthSPIConfig getExternalDomainAuthSPIConfig() {
        return m_externalDomainAuthSPIConfig;
    }

    public static final void initAuthenticationSPI() {
        if (m_externalDomainAuthSPIConfig != null) {
            m_authenticationSPI = m_externalDomainAuthSPIConfig.getNewInstance();
        }
    }

    private AgentRegistrar() {
        super(DebugState.GLOBAL_DEBUG_ON ? "AgentRegistrar" : null);
        if (this.DEBUG_UNEXPECTED) {
            BrokerComponent.getBrokerComponent();
            BrokerComponent.logMessage("DEBUG_UNEXPECTED enabled for AgentRegistrar", BrokerComponent.getLevelTrace());
        }
    }

    private void ARStartup() throws Exception {
        this.m_statsMgr = new StatsManager(this);
        m_disconnectTimerMgr = new DisconnectTimerManager(this);
        boolean bl = this.m_debugSystemStatsEnabled = (this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(1);
        if (this.m_debugSystemStatsEnabled) {
            this.m_clientCounter = new LValueStatsObj(1, 259, 2);
            this.m_statsMgr.registerStat(this.m_clientCounter);
        }
        ClientSecurityContext.setDisplayInfoFactory(new BrokerSecurityContextDisplayInfoFactory());
        Vector<ClientContextFactory> factoryVec = new Vector<ClientContextFactory>();
        if (Broker.getBroker().isMFComponent()) {
            String factoryName = "com.sonicsw.net.http.HttpClientContextFactory";
            boolean failed = false;
            String errmsg = null;
            try {
                Class<?> c = Class.forName(factoryName);
                ClientContextFactory factory = (ClientContextFactory)c.newInstance();
                factoryVec.addElement(factory);
                if (this.DEBUG) {
                    this.debug("Context factory " + factoryName + " loaded.");
                }
            }
            catch (ClassNotFoundException e) {
                failed = true;
                errmsg = prAccessor.getString("CTXFAC_CLSNOTFOUND");
            }
            catch (NoClassDefFoundError e) {
                failed = true;
                errmsg = prAccessor.getString("CTXFAC_CLSNOTFOUND");
            }
            catch (InstantiationException e) {
                failed = true;
                errmsg = prAccessor.getString("CTXFAC_ABSTRACT");
            }
            catch (IllegalAccessException e) {
                failed = true;
                errmsg = prAccessor.getString("CTXFAC_ACCESS");
            }
            catch (ClassCastException e) {
                failed = true;
                errmsg = prAccessor.getString("CTXFAC_CAST");
            }
            if (failed) {
                Object[] param = new Object[]{factoryName};
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("CTXFAC_LOADERROR"), 2);
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(errmsg, param), 2);
            }
        } else if (Config.CLIENT_CONTEXT_FACTORY != null) {
            for (int i = 0; i < Config.CLIENT_CONTEXT_FACTORY.length; ++i) {
                String factoryName = Config.CLIENT_CONTEXT_FACTORY[i];
                if (factoryName == null) continue;
                factoryName = factoryName.trim();
                boolean failed = false;
                String errmsg = null;
                try {
                    Class<?> c = Class.forName(factoryName);
                    ClientContextFactory factory = (ClientContextFactory)c.newInstance();
                    factoryVec.addElement(factory);
                    if (this.DEBUG) {
                        this.debug("Context factory " + factoryName + " loaded.");
                    }
                }
                catch (ClassNotFoundException e) {
                    failed = true;
                    errmsg = prAccessor.getString("CTXFAC_CLSNOTFOUND");
                }
                catch (NoClassDefFoundError e) {
                    failed = true;
                    errmsg = prAccessor.getString("CTXFAC_CLSNOTFOUND");
                }
                catch (InstantiationException e) {
                    failed = true;
                    errmsg = prAccessor.getString("CTXFAC_ABSTRACT");
                }
                catch (IllegalAccessException e) {
                    failed = true;
                    errmsg = prAccessor.getString("CTXFAC_ACCESS");
                }
                catch (ClassCastException e) {
                    failed = true;
                    errmsg = prAccessor.getString("CTXFAC_CAST");
                }
                if (!failed) continue;
                Object[] param = new Object[]{factoryName};
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("CTXFAC_LOADERROR"), 2);
                BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(errmsg, param), 2);
            }
        }
        this.m_clientContextFactories = new ClientContextFactory[factoryVec.size()];
        factoryVec.copyInto(this.m_clientContextFactories);
        if (this.DEBUG) {
            this.debug("constructing BrokerDatabase");
        }
        try {
            this.m_db = new BrokerDatabase();
        }
        catch (EGeneralException e) {
            throw new EStartupFailure(prAccessor.getString("STR021") + e, e);
        }
        if (!AgentRegistrar.isBadCipherConfiguration() && this.isBrokerQoPCipherChanged()) {
            String errorMsg = prAccessor.getString("STR355");
            BrokerComponent.getComponentContext().logMessage(errorMsg, 2);
            throw new EStartupFailure(errorMsg);
        }
        if (this.DEBUG) {
            this.debug("constructing core components");
        }
        this.m_id = AddrUtil.stringToClientId(Config.BROKER_UID, "Broker");
        this.m_regCl = new LongHashTable();
        this.m_regSub = new AgentSubjectSpace();
        this.m_expSubs = new ExpirationQueue();
        this.m_groupSubs = new GroupSubscriptions(this);
        this.m_logmgr = new LogManager(this);
        try {
            this.m_logTime = this.m_db.getLogTime();
            Vector routes = Broker.getBroker().getRoutesVector();
            this.m_routingConfig = new RoutingConfiguration(this, routes);
        }
        catch (EDatabaseException e) {
            throw new EStartupFailure(prAccessor.getString("STR218") + e, e);
        }
        this.m_flowControlManager = new FlowControlManager();
        this.m_msgSaver = new MsgSaver(this);
        this.m_qmsgSaver = new QueueMsgSaver(this);
        this.m_gsManager = new GSManager(this);
        this.m_counterManager = new CounterManager(this);
        this.m_clientCount = -1;
        this.m_initRestoreFC = new InitRestoreFlowController();
        this.m_dirtyClients = new Hashtable();
        this.m_expiredMsgs = new ExpiredMsgContainer();
        this.m_contextLocks = new Hashtable();
        if (this.DEBUG) {
            this.debug("constructing admin connection");
        }
        try {
            PipeSocket socket = new PipeSocket();
            PipeSocket adminSessionSoc = new PipeSocket(socket);
            this.m_adminAgentConn = new AgentConnection(socket, ProgressSecureRandom.theSecureRandom().nextLong());
            Credentials agentCreds = new Credentials(Config.BROKER_UID, Config.BROKER_PWD);
            this.m_adminConn = new AgentAdminConnection(this, adminSessionSoc, agentCreds);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("STR022") + e);
        }
        if (this.DEBUG) {
            this.debug("constructing transaction manager");
        }
        this.m_txnmgr = new TransactionMgr(this);
        this.m_rmmgr = new RMManager();
        this.m_ocmgr = new OperationContextManager();
        if (Config.ENABLE_INTERBROKER) {
            this.m_wsaclusterHelper = new WSAClusteringHelper();
        }
        this.m_idrhandler = new IDRMgramHandler(this);
        int pollingInterval = Config.getIntProperty("WATCHDOG_THREAD_POLLING_INTERVAL", 60000);
        this.m_watchdog = new WatchDogThread(pollingInterval);
        this.m_pollingThread = new IntervalPollingThread();
        try {
            if (this.DEBUG) {
                this.debug("constructing router manager");
            }
            this.m_routerMgr = new RouterManager(this, this.getLogManager(), this.getAdminConnection());
        }
        catch (EDatabaseException e) {
            throw new EStartupFailure(prAccessor.getString("RTMGR_INIT_ERROR"), e);
        }
        if (this.DEBUG) {
            this.debug("constructing clustered queue manager");
        }
        this.m_cqm = new ClusteredQueueManager(this);
        if (this.DEBUG) {
            this.debug("constructing queue processor");
        }
        this.m_qproc = new AgentQueueProcessor(this);
        if (this.DEBUG) {
            this.debug("constructing message processor");
        }
        this.m_msgproc = new AgentMessageProcessor(this);
        this.m_qMsgStateMgr = new QMsgStateMgr(this);
        BaseClientContextWrapper.initClass(this);
        BaseClientContext.initClass(this);
        MsgRestorer.initClass(this);
        AgentGuarMsgTracker.initClass(this);
        AgentQueueMsgTracker.initClass(this);
        try {
            AgentListener.initClass(this);
        }
        catch (IOException e) {
            throw new EStartupFailure(prAccessor.getString("STR023") + e, e);
        }
        try {
            NoDupDetectDb.init(Config.getProperties(), this.getBrokerDatabase().getDatabase());
        }
        catch (EInvalidConfiguration e) {
            throw new EStartupFailure(e.getMessage(), e);
        }
        this.m_FCMonitor = new FlowControlMonitor();
        try {
            this.m_FCMonitor.init();
        }
        catch (EGeneralException ex) {
            Object[] obj = new Object[]{ex.toString()};
            throw new EStartupFailure(prMessageFormat.format(prAccessor.getString("FCMONITOR_INIIT_FAILED"), obj), ex);
        }
        if (Config.ENABLE_INTERBROKER) {
            try {
                if (this.DEBUG) {
                    this.debug("constructing Interbroker");
                }
                this.m_iihook = InterbrokerHook.initialize(this);
            }
            catch (NoClassDefFoundError e) {
                throw new EStartupFailure(prAccessor.getString("STR024"), e);
            }
            this.m_routerMgr.getRouteForwarder().processNeighborRoutes();
        }
        this.m_watchdog.start();
        this.m_pollingThread.startThread();
        if (Config.ENABLE_SECURITY) {
            if (this.DEBUG) {
                this.debug("initializing security components");
            }
            Authorize.setSubjectSpace(this.m_regSub);
            this.m_secBean = Config.ENABLE_INTERBROKER ? InterbrokerHook.getSecurityBean() : SecurityBean.createLocalBean(this.m_adminConn);
            this.m_regSub.loadPolicies();
            this.m_secBean.addSecurityListener(this.m_regSub);
        }
        try {
            Class.forName("javax.transaction.xa.Xid");
            this.m_isXAConfigured = true;
        }
        catch (ClassNotFoundException e) {
            this.m_isXAConfigured = false;
        }
        if (Config.ENABLE_INTERBROKER) {
            InterbrokerHook.startConfigEventDelivery();
        }
        try {
            if (this.DEBUG) {
                this.debug("connecting admin client");
            }
            this.m_adminAgentConn.startListener();
            this.m_adminConn.stopDelivery();
            this.m_adminConn.connect("");
            IClientContext admincc = this.getClient(this.m_adminConn.getClientId());
            this.m_gsManager.setupAdminHandlers();
            this.m_rmmgr.setupAdminHandlers();
            this.m_ocmgr.setupAdminHandlers();
            if (this.m_wsaclusterHelper != null) {
                this.m_wsaclusterHelper.setUpAdminHandlers();
            }
            admincc.startDelivery(null);
            admincc.waitForStart();
            if (this.DEBUG) {
                this.debug("subscribing admin handler");
            }
            this.m_adminConn.subscribeAdminHandler();
            if (this.DEBUG) {
                this.debug("admin client initialized");
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("STR028") + e);
        }
        if (Config.REPLICATED) {
            this.m_replicationManager = ReplicationManager.getReplicationManager();
            this.m_durableSyncReplMgr = new DurableSyncReplicationMgr();
            try {
                if (this.DEBUG) {
                    this.debug("starting replication manager");
                }
                this.m_replicationManager.start();
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                throw new EStartupFailure(prAccessor.getString("FT_RM_START_ERROR") + e);
            }
        }
        BrokerStateManager.getBrokerStateManager().registerListener(this.m_qproc);
        BrokerStateManager.getBrokerStateManager().registerListener(this.m_gsManager);
    }

    private void ARRecovery() throws Exception {
        try {
            try {
                this.m_logmgr.initLog(false);
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    throw new EStartupFailure(prAccessor.getString("STR215"));
                }
                if (e instanceof EStartupFailure) {
                    throw (EStartupFailure)e;
                }
                throw new EStartupFailure(prAccessor.getString("STR216") + e);
            }
            this.m_logmgr.verifyTimestamps();
            this.initRecovery();
            if (this.DEBUG) {
                this.debug("starting recovery mananger");
            }
            RecoveryMgr rm = new RecoveryMgr(this, 0);
            long nextSeqNo = this.readLog(rm);
            if (this.DEBUG) {
                this.debug("starting log manager");
            }
            this.m_logmgr.startup(nextSeqNo);
            this.completeRecovery(rm);
            rm.clearMetaState();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("STR026") + e);
        }
    }

    private void ARStandbySync() throws Exception {
        this.resetRegistry();
        this.m_txnmgr.reset();
        this.m_ocmgr.reset();
        this.m_rmmgr.reset();
        this.initRecovery();
        if (this.DEBUG) {
            this.debug("starting recovery mananger");
        }
        RecoveryMgr rm = new RecoveryMgr(this, 1);
        try {
            BrokerStateManager.getBrokerStateManager().waitForStatusChange(this.m_replicationManager.getReplicationDemultiplexer());
        }
        catch (Throwable t) {
            if (!Broker.exiting) {
                BrokerComponent.getComponentContext().logMessage(t, 2);
            }
            throw new EStartupFailure(t.getMessage());
        }
        LogManager lm = this.getLogManager();
        try {
            lm.initLog(true);
        }
        catch (IOException e) {
            throw new EStartupFailure(e.getMessage(), e);
        }
        if (this.DEBUG) {
            this.debug("starting log manager");
        }
        lm.startup(0L);
        if (this.m_recoveryThread != null) {
            try {
                this.m_recoveryThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (this.DEBUG) {
            this.debug("starting recovery thread");
        }
        this.m_recoveryThread = new RecoveryThread(rm);
        this.m_recoveryThread.start();
    }

    private void ARWaiting() {
        if (Config.REPLICATED) {
            block9: {
                try {
                    BrokerStateManager.getBrokerStateManager().waitForStatusChange(this.m_replicationManager.getReplicationDemultiplexer());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Throwable t) {
                    if (Broker.exiting) break block9;
                    BrokerComponent.getComponentContext().logMessage(t, 2);
                }
            }
            if (this.m_recoveryThread != null) {
                try {
                    this.m_recoveryThread.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            this.resetRegistry();
            this.m_txnmgr.reset();
            this.m_ocmgr.reset();
            this.m_rmmgr.reset();
            try {
                this.m_logmgr.uninitLog();
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    private void initRecovery() {
        if (!this.m_msgSaver.isAlive()) {
            this.m_msgSaver.setDaemon(true);
            this.m_msgSaver.start();
        }
        if (!this.m_qmsgSaver.isAlive()) {
            this.m_qmsgSaver.setDaemon(true);
            this.m_qmsgSaver.start();
        }
    }

    private void resetRegistry() {
        if (this.m_trackRegCl == null) {
            this.m_trackRegCl = new LongHashTable();
        }
        if (!this.m_trackRegCl.isEmpty()) {
            ReplicationConnection replicationConn = this.m_replicationManager.getReplicationConnection();
            LongHashTable copy = (LongHashTable)this.m_trackRegCl.clone();
            if (replicationConn != null) {
                copy.remove(replicationConn.getClientId(0));
            }
            Enumeration enu = copy.elements();
            while (enu.hasMoreElements()) {
                IClientContext cc = (IClientContext)enu.nextElement();
                this.unregister(cc);
            }
        }
        this.m_dirtyClients.clear();
        this.m_recoveredSubscriptions.clear();
    }

    public void clearCCTracking() {
        this.m_trackRegCl = null;
    }

    private long readLog(RecoveryMgr rm) throws EStartupFailure {
        this.m_inRecovery = true;
        long nextSeqNo = rm.getEventProcessor().processEvents();
        this.m_inRecovery = false;
        return nextSeqNo;
    }

    private void completeRecovery(RecoveryMgr rm) throws EStartupFailure, EDatabaseException, InterruptedException {
        this.m_recoveredFromLog = rm.getEventProcessor().recoveredFromLog();
        this.m_routerMgr.loadRegisteredRemoterBrokersFromDataStore();
        this.m_routerMgr.getRouteForwarder().loadSavedRouteTableFromDatastore();
        this.clearCCTracking();
        this.redeliverSubscriptions();
        rm.recoverDurableStats();
        Vector v = this.getCCSizeTrackersToRestore();
        this.getDurableManager().initialize();
        this.getDurableManager().startCCSizeRestore(v);
        long lastIdFromLog = rm.getLastConnectionId();
        long lastIdFromDB = this.m_db.getLastConnectionID();
        if (this.DEBUG) {
            this.debug("conn id from log = " + lastIdFromLog + ", from db = " + lastIdFromDB);
        }
        this.initConnectionId(Math.max(lastIdFromLog, lastIdFromDB));
        this.m_counterManager.recoveryComplete();
        if (this.DEBUG) {
            this.debug("starting message processor");
        }
        this.m_msgproc.start();
        this.m_ocmgr.recoveryComplete();
        if (this.DEBUG) {
            this.debug("starting queue processor");
        }
        try {
            this.m_qproc.start();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("STR272") + e);
        }
        if (this.DEBUG) {
            this.debug("redelivering recovered messages");
        }
        try {
            rm.redeliverMsgs();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("ERROR_REDELIVERY") + e);
        }
        if (this.DEBUG) {
            this.debug("flushing message saver");
        }
        this.m_msgSaver.flush();
        if (this.DEBUG) {
            this.debug("flushing queue message saver");
        }
        this.m_qmsgSaver.flush();
        if (this.DEBUG) {
            this.debug("restoring delete subscription operations");
        }
        this.getDeleteSubscriptionManager().recoverDeleteSubscriptions();
        if (this.DEBUG) {
            this.debug("Updating redelivery state");
        }
        this.getMsgRestoreMgr().recoverRedeliveries(this.m_recoveredFromLog);
        this.m_msgSaver.flush();
        if (this.DEBUG) {
            this.debug("starting syncpoint thread");
        }
        this.m_logmgr.startSyncThread();
        try {
            this.forceSyncpoint(true);
        }
        catch (InterruptedException e) {
            throw new EStartupFailure(prAccessor.getString("CANNOT_COMPLETE_SYNCPOINT") + e);
        }
        this.m_logmgr.setStartupSeqNo();
        try {
            if (this.DEBUG) {
                this.debug("redelivering postponed messages");
            }
            rm.redeliverPostponedMsgs();
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("ERROR_POSTPONED_REDELIVERY") + e);
        }
        if (this.DEBUG) {
            this.debug("starting transaction manager");
        }
        this.m_txnmgr.startup();
        this.m_txnmgr.flush();
        this.m_qmsgSaver.flush();
        this.m_msgSaver.flush();
        if (this.m_recoveredFromLog) {
            this.m_db.deleteNonDurableUndelMsgs(this.m_logmgr.getStartupSeqNo());
        }
        if (Config.ENABLE_SECURITY) {
            try {
                if (this.DEBUG) {
                    this.debug("starting security server");
                }
                this.m_secBean.startServer();
            }
            catch (EGeneralException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        rm.clearMetaState();
        try {
            this.m_qproc.startQueues(rm.getRecoveredQueueSet());
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("STR334") + e);
        }
        try {
            if (this.DEBUG) {
                this.debug("starting routing manager");
            }
            this.m_routerMgr.start();
        }
        catch (EUnusableConnection e) {
            if (Broker.exiting) {
                return;
            }
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("RTMGR_STARTUP_ERROR") + e);
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("RTMGR_STARTUP_ERROR") + e);
        }
        Enumeration clients = ((LongHashTable)this.m_regCl.clone()).elements();
        while (clients.hasMoreElements()) {
            IClientContext cc = (IClientContext)clients.nextElement();
            cc.recoveryComplete();
        }
        this.m_groupSubs.recoveryComplete();
        if (Config.LG_ENABLE) {
            InterceptorManager.initAgentAdvisors();
        }
        if (InterbrokerHook.isSet()) {
            if (this.DEBUG) {
                this.debug("starting interbroker");
            }
            InterbrokerHook.start();
        }
        this.m_statsMgr.setDaemon(true);
        this.m_statsMgr.start();
        this.m_gsManager.start();
        if (Config.ENABLE_LOAD_BALANCING) {
            Class<?> lbclass;
            String lbname = Config.getProperty("LOAD_BALANCER", "ConnectionCountLoadBalancer");
            boolean loaded = false;
            try {
                lbclass = Class.forName("progress.message.broker." + lbname);
                this.m_loadBalancer = (ILoadBalancer)lbclass.newInstance();
                if ("ConnectionCountLoadBalancer".equals(lbname)) {
                    lbclass = Class.forName("progress.message.broker.RoundRobin");
                    ILoadBalancer delegate = (ILoadBalancer)lbclass.newInstance();
                    this.m_loadBalancer.setNext(delegate);
                }
                loaded = true;
            }
            catch (Exception e) {
                try {
                    lbclass = Class.forName(lbname);
                    this.m_loadBalancer = (ILoadBalancer)lbclass.newInstance();
                    loaded = true;
                }
                catch (Exception e1) {
                    Object[] obj = new Object[]{lbname};
                    BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(prAccessor.getString("UNABLE_LOAD_LB"), obj), (Throwable)e1, 2);
                }
            }
            if (loaded) {
                try {
                    BrokerContext context = new BrokerContext();
                    for (ILoadBalancer loadBalancer = this.m_loadBalancer; loadBalancer != null; loadBalancer = loadBalancer.getNext()) {
                        loadBalancer.initialize(context);
                    }
                }
                catch (Exception e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
        }
        if (this.DEBUG) {
            this.debug("startup complete");
        }
    }

    private boolean isBrokerQoPCipherChanged() throws EDatabaseException {
        CipherSuiteInfo configuredCipherSuiteInfo = AgentRegistrar.getCipherSuite().getCipherSuiteInfo();
        CipherSuiteInfo storedCipherSuiteInfo = this.m_db.getCipherSuiteInfo();
        if (storedCipherSuiteInfo == null && configuredCipherSuiteInfo != null) {
            this.m_db.setCipherSuiteInfo(configuredCipherSuiteInfo);
            return false;
        }
        if (configuredCipherSuiteInfo != null) {
            String[] configCipherDetail = configuredCipherSuiteInfo.getTransformation(0);
            String[] configDigestDetail = configuredCipherSuiteInfo.getDigest(0);
            String[] storedCipherDetail = storedCipherSuiteInfo.getTransformation(0);
            String[] storedDigestDetail = storedCipherSuiteInfo.getDigest(0);
            if (configCipherDetail[2] != null && storedCipherDetail[2] != null && configCipherDetail[2].equalsIgnoreCase(storedCipherDetail[2]) && configDigestDetail[2] != null && storedDigestDetail[2] != null && configDigestDetail[2].equalsIgnoreCase(storedDigestDetail[2])) {
                String error;
                Object[] obj;
                if (configCipherDetail[0] != null && storedCipherDetail[0] != null && !configCipherDetail[0].equalsIgnoreCase(storedCipherDetail[0]) && configCipherDetail[1] != null && storedCipherDetail[1] != null && !configCipherDetail[1].equalsIgnoreCase(storedCipherDetail[1])) {
                    obj = new Object[]{storedCipherDetail[0], storedCipherDetail[1], configCipherDetail[0], configCipherDetail[1]};
                    error = prMessageFormat.format(prAccessor.getString("STR356"), obj);
                    BrokerComponent.getComponentContext().logMessage(error, 2);
                }
                if (configDigestDetail[0] != null && storedDigestDetail[0] != null && !configDigestDetail[0].equalsIgnoreCase(storedDigestDetail[0]) && configDigestDetail[1] != null && storedDigestDetail[1] != null && !configDigestDetail[1].equalsIgnoreCase(storedDigestDetail[1])) {
                    obj = new Object[]{storedDigestDetail[0], storedDigestDetail[1], configDigestDetail[0], configDigestDetail[1]};
                    error = prMessageFormat.format(prAccessor.getString("STR357"), obj);
                    BrokerComponent.getComponentContext().logMessage(error, 2);
                }
                return false;
            }
            Object[] obj = new Object[]{storedCipherDetail[0], storedCipherDetail[2], configCipherDetail[0], configCipherDetail[2]};
            String error = prMessageFormat.format(prAccessor.getString("STR357"), obj);
            BrokerComponent.getComponentContext().logMessage(error, 2);
            return true;
        }
        return false;
    }

    @Override
    public void stateChangeComplete(int status) {
        switch (status) {
            case 7: {
                if (Config.REPLICATED) {
                    BrokerStateManager.getBrokerStateManager().setStateWaiting(this);
                    break;
                }
                BrokerStateManager.getBrokerStateManager().setStateRecovery(this);
                break;
            }
            case 8: {
                BrokerStateManager.getBrokerStateManager().setStateRecoveryComplete(this);
                break;
            }
            case 4: {
                if (!Config.FT_START_ACTIVE) break;
                this.getReplicationManager().startActive();
                break;
            }
            case 9: {
                BrokerStateManager.getBrokerStateManager().setStateStandalone(this);
                try {
                    if (!Config.ENABLE_SECURITY || AgentRegistrar.getAuthenticationSPI() == null) break;
                    AgentRegistrar.getAuthenticationSPI().setSecurityCache((IBrokerSecurityCache)Broker.getBroker().getSecurityCache().getSecurityCacheDelegate());
                    break;
                }
                catch (Throwable e) {
                    try {
                        BrokerComponent.getComponentContext().logMessage(e.getMessage(), 2);
                        break;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ARActive() throws Exception {
        if (this.m_isActive) {
            return;
        }
        this.m_isActive = true;
        if (Config.REPLICATED) {
            try {
                BrokerStateManager.getBrokerStateManager().waitForStatusChange(this.m_replicationManager.getReplicationDemultiplexer());
            }
            catch (Throwable t) {
                if (!Broker.exiting) {
                    BrokerComponent.getComponentContext().logMessage(t, 2);
                }
                throw new EStartupFailure(t.getMessage());
            }
            if (this.m_recoveryThread != null) {
                try {
                    this.m_recoveryThread.join();
                    if (this.m_recoveryThread.failed()) {
                        throw this.m_recoveryThread.m_failedException;
                    }
                }
                finally {
                    this.m_recoveryThread = null;
                }
            }
        }
        if (this.DEBUG) {
            this.debug("starting subscription expirator");
        }
        this.m_subExpirator = new SubscriptionExpirator(this, this.m_expSubs, Config.DURABLE_SUBSCRIBER_EXPIRATION_POLL_INTERVAL * 1000);
        this.m_subExpirator.startSubscriptionExpirator();
        this.m_subExpirator.expireNow();
        if (ExpiredMessageCleaner.isEnabled()) {
            if (this.DEBUG) {
                this.debug("starting ExpiredMessageCleaner");
            }
            this.m_expiredMessageCleaner = new ExpiredMessageCleaner(this.m_db, Config.EXP_MSG_CLEAN_POLL_INTERVAL);
        }
        if (SlowSubscriberMonitor.isEnabled()) {
            if (this.DEBUG) {
                this.debug("starting SlowSubscriber monitor");
            }
            this.m_slowSubscriberMonitor = new SlowSubscriberMonitor(this, Config.SLOW_SUBSCRIBER_MONITOR_POLL_INTERVAL, Config.SLOW_SUBSCRIBER_NOTIFY_THRESHOLD);
            this.m_slowSubscriberMonitor.start();
        }
        this.m_qproc.startThreads();
        this.m_routerMgr.startThreads();
        this.m_db.startCleaner();
        if (NoDupDetectDb.isEnabled()) {
            NoDupDetectDb.startCleaner();
        }
        this.m_provisionMonitor.activate();
    }

    public void setProvisionMonitor(ProvisionMonitor pMonitor) {
        this.m_provisionMonitor = pMonitor;
    }

    public ProvisionMonitor getProvisionMonitor() {
        return this.m_provisionMonitor;
    }

    public long getId() {
        return this.m_id;
    }

    public AgentAdminConnection getAdminConnection() {
        return this.m_adminConn;
    }

    public AgentAdminSession getAdminSession() {
        if (this.m_adminConn == null) {
            return null;
        }
        return (AgentAdminSession)this.m_adminConn.getDefaultSession();
    }

    public String getCollective() {
        return this.m_collective;
    }

    public int getCollectiveSCode() {
        return this.m_collectiveSCode;
    }

    public LogManager getLogManager() {
        return this.m_logmgr;
    }

    public ILoadBalancer getLoadBalancer() {
        return this.m_loadBalancer;
    }

    public BrokerDatabase getBrokerDatabase() {
        return this.m_db;
    }

    public long getLogTime() {
        return this.m_logTime;
    }

    public ExpiredMsgContainer getExpiredMsgs() {
        return this.m_expiredMsgs;
    }

    public MsgSaver getMsgSaver() {
        return this.m_msgSaver;
    }

    public InitRestoreFlowController getInitRestoreFC() {
        return this.m_initRestoreFC;
    }

    public QueueMsgSaver getQueueMsgSaver() {
        return this.m_qmsgSaver;
    }

    public StatsManager getStatsManager() {
        return this.m_statsMgr;
    }

    public SecurityBean getSecurityBean() {
        return this.m_secBean;
    }

    public QMsgStateMgr getQMsgStateMgr() {
        return this.m_qMsgStateMgr;
    }

    public void setCollective(String c) {
        this.m_collective = c;
        this.m_collectiveSCode = SubjectUtil.computeSCode(c, 0, c.length());
    }

    public ClusteredQueueManager getClusteredQueueManager() {
        return this.m_cqm;
    }

    public AgentMessageProcessor getMsgProc() {
        return this.m_msgproc;
    }

    public RoutingConfiguration getRoutingConfig() {
        return this.m_routingConfig;
    }

    public RouterManager getRouterManager() {
        return this.m_routerMgr;
    }

    public FlowControlManager getFlowControlManager() {
        return this.m_flowControlManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteRestoreManager getRemoteRestoreManager() {
        if (this.m_remoteRestoreManager == null) {
            Object object = this.m_remoteRestoreManagerSyncObj;
            synchronized (object) {
                if (this.m_remoteRestoreManager == null) {
                    this.m_remoteRestoreManager = new RemoteRestoreManager();
                }
            }
            this.m_remoteRestoreManagerSyncObj = null;
            return this.m_remoteRestoreManager;
        }
        return this.m_remoteRestoreManager;
    }

    public GroupSubscriptions getGroupSubscriptions() {
        return this.m_groupSubs;
    }

    public GSManager getGSManager() {
        return this.m_gsManager;
    }

    public CounterManager getCounterManager() {
        return this.m_counterManager;
    }

    public IDRMgramHandler getIDRMgramHandler() {
        return this.m_idrhandler;
    }

    public TransactionMgr getTransactionMgr() {
        return this.m_txnmgr;
    }

    public RMManager getReliableSequenceMgr() {
        return this.m_rmmgr;
    }

    public OperationContextManager getOperationContextMgr() {
        return this.m_ocmgr;
    }

    public WSAClusteringHelper getWSAClusteringHelper() {
        return this.m_wsaclusterHelper;
    }

    public AgentConnection getAgentConnection() {
        return this.m_adminAgentConn;
    }

    public WatchDogThread getWatchDogThread() {
        return this.m_watchdog;
    }

    public IntervalPollingThread getPollingThread() {
        return this.m_pollingThread;
    }

    public FlowControlMonitor getFCMonitor() {
        return this.m_FCMonitor;
    }

    public ReplicationManager getReplicationManager() {
        return this.m_replicationManager;
    }

    public DurableSyncReplicationMgr getDurableSyncReplicationMgr() {
        return this.m_durableSyncReplMgr;
    }

    public IReplicationConnection getReplicationConnection() {
        return this.m_replicationManager;
    }

    public DisconnectTimerManager getDisconnectTimerManager() {
        return m_disconnectTimerMgr;
    }

    synchronized int getClientCount() {
        return this.m_clientCount;
    }

    synchronized void incClientCount() {
        ++this.m_clientCount;
        if (this.m_debugSystemStatsEnabled) {
            this.m_clientCounter.update(this.m_clientCount);
        }
    }

    synchronized void decClientCount() {
        --this.m_clientCount;
        if (this.m_debugSystemStatsEnabled) {
            this.m_clientCounter.update(this.m_clientCount);
        }
    }

    public AgentQueueProcessor getQueueProc() {
        return this.m_qproc;
    }

    public SubscriptionExpirator getSubscriptionExpirator() {
        return this.m_subExpirator;
    }

    public SlowSubscriberMonitor getSlowSubscriberMonitor() {
        return this.m_slowSubscriberMonitor;
    }

    public CWADSMessageHandler getCWADSMsgHandler() {
        return this.m_cwadsMsgHandler;
    }

    public void setCWADSMsgHandler(CWADSMessageHandler msgHandler) {
        this.m_cwadsMsgHandler = msgHandler;
    }

    public IClientContext registerAndLock(long id, ClientSecurityContext csc, AgentConnection connection) {
        return this.lockContext(id, true, csc, connection);
    }

    public void redoConnect(long id, ClientSecurityContext csc, boolean ib) {
        this.redoConnect(id, csc, ib, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoConnect(long id, ClientSecurityContext csc, boolean ib, long lastConnectedTime) {
        this.redoConnectInternal(id, csc, ib);
        IClientContext cc = this.registerAndLock(id, csc, null);
        try {
            cc.setInterbroker(ib);
            this.refreshRegisteredCSC(cc, csc);
            this.refreshRegisteredCCWrappers(cc, csc);
            this.registerCCWithParent(cc);
            if (csc.isFaultTolerant()) {
                cc.setState(1);
                cc.setLastConnectedTime(lastConnectedTime);
                this.redoCWADSImplicitSubscribe(cc);
            } else if (cc.isDurable()) {
                cc.setState(1);
                if (lastConnectedTime == -1L) {
                    cc.setLastConnectedTime(System.currentTimeMillis());
                } else {
                    cc.setLastConnectedTime(lastConnectedTime);
                }
            } else if (lastConnectedTime == -1L) {
                cc.setLastConnectedTime(System.currentTimeMillis());
            } else {
                cc.setLastConnectedTime(lastConnectedTime);
            }
        }
        finally {
            cc.unlock();
        }
    }

    private final void redoCWADSImplicitSubscribe(IClientContext cc) {
        if (cc.isDurable() && Config.ENABLE_INTERBROKER) {
            BrokerSubscription rbs = this.getRecoveredDurableBrokerSubscription(cc.getId());
            if (rbs != null) {
                if (rbs.getDurableStrictMessageOrder()) {
                    try {
                        if (rbs.getRestoreToBrokerCID() != -1L) {
                            IClientContext restoringCC = null;
                            restoringCC = this.getClient(rbs.getRestoreToBrokerCID());
                            if (this.DEBUG) {
                                this.debug("SETTING restoring broker for " + cc + " to recoverd sub value: " + restoringCC);
                            }
                            cc.setCWADSRestoringBroker(restoringCC);
                            IClientContext previousCC = this.getClient(rbs.getPreviousBrokerCID());
                            cc.setCWADSPreviousBroker(previousCC);
                        } else if (rbs.getPreviousBrokerCID() != -1L && rbs.getPreviousBrokerCID() != cc.getId()) {
                            IClientContext previousCC = this.getClient(rbs.getPreviousBrokerCID());
                            if (this.DEBUG) {
                                this.debug("SETTING restoring broker to previous for " + cc + " prev: " + previousCC);
                            }
                            cc.setCWADSRestoringBroker(previousCC);
                            rbs.setRestoreToBrokerCID(previousCC.getId());
                            cc.setCWADSPreviousBroker(cc);
                            rbs.setPreviousBrokerCID(cc.getId());
                        }
                    }
                    catch (EClientNotRegistered ex1) {
                        cc.setCWADSRestoringBroker(null);
                        rbs.setRestoreToBrokerCID(-1L);
                        cc.setCWADSPreviousBroker(cc);
                        rbs.setRestoreToBrokerCID(cc.getId());
                    }
                } else {
                    if (this.DEBUG) {
                        System.out.println("CLEARING restoring broker for " + cc + " because not SMO");
                    }
                    cc.setCWADSRestoringBroker(null);
                    rbs.setRestoreToBrokerCID(-1L);
                    cc.setCWADSPreviousBroker(cc);
                    rbs.setPreviousBrokerCID(cc.getId());
                }
            } else if (this.DEBUG) {
                this.debug("NO RBS found for " + cc + " from redo implicit subscribe");
            }
        }
    }

    void cancelDisconnectTimer(IClientContext cc) {
        long timerid = cc.getTimerId();
        boolean lastManOut = m_disconnectTimerMgr.unregister(timerid, cc.getId());
        if (!lastManOut) {
            return;
        }
        if (!m_disconnectTimerMgr.cancel(timerid)) {
            try {
                m_disconnectTimerMgr.waitForTimerExec(timerid);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        } else {
            m_disconnectTimerMgr.clear(timerid);
        }
    }

    private FTReflectionOperation performBeginPubSubTran() throws EDatabaseException {
        FTReflectionOperation op = null;
        this.m_db.beginPubSubDBTran();
        if (Config.REPLICATED) {
            op = FTMgramFactory.createReflectionOperation();
            op.addMethod(6, "beginPubSubDBTran", null, null);
        }
        return op;
    }

    private void performDelMsgs(long id, FTReflectionOperation op) throws EDatabaseException {
        this.m_db.delMsgs(id);
        if (op != null) {
            op.addMethod(6, "delMsgs", BrokerDatabase.getDelMsgsParams(), new Object[]{new Long(id)});
        }
    }

    private void performCommitPubSubTran(FTReflectionOperation op) throws EDatabaseException {
        this.m_db.commitPubSubTran();
        if (op != null) {
            op.addMethod(6, "commitPubSubTran", null, null);
        }
    }

    private void performReleasePubSubTran(FTReflectionOperation op) {
        this.m_db.releasePubSubDBTran();
        if (op != null) {
            op.addMethod(6, "releasePubSubDBTran", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redoConnectInternal(long id, ClientSecurityContext csc, boolean ib) {
        this.createExternalUser(csc);
        int uid = AddrUtil.clientIdToUid(id);
        int appid = AddrUtil.clientIdToAppid(id);
        if (!((!ib || Config.ENABLE_INTERBROKER && InterbrokerHook.isNeighbor(id)) && (appid != Config.BROKER_CONFIG_APPID_SCODE || Config.ENABLE_INTERBROKER && InterbrokerHook.configConnectionOk(uid)))) {
            boolean needRelease = false;
            FTReflectionOperation op = null;
            try {
                op = this.performBeginPubSubTran();
                needRelease = true;
                this.performDelMsgs(id, op);
                this.performCommitPubSubTran(op);
            }
            catch (Exception e) {
                if (!Thread.currentThread().isInterrupted()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            finally {
                if (needRelease) {
                    this.performReleasePubSubTran(op);
                }
                if (op != null) {
                    this.getReplicationManager().replicateFTRelectionOp(op);
                }
            }
            return;
        }
        if (Config.ENABLE_SECURITY) {
            csc.setPrincipal(this.m_secBean.getUser(csc.getUid()));
            if (csc.getPrincipal() == null) {
                boolean needRelease = false;
                FTReflectionOperation op = null;
                try {
                    op = this.performBeginPubSubTran();
                    needRelease = true;
                    this.performDelMsgs(csc.getClientId(), op);
                    this.performCommitPubSubTran(op);
                }
                catch (Exception ee) {
                    if (!Thread.currentThread().isInterrupted()) {
                        BrokerComponent.getComponentContext().logMessage((Throwable)ee, 2);
                    }
                }
                finally {
                    if (needRelease) {
                        this.performReleasePubSubTran(op);
                    }
                    if (op != null) {
                        this.getReplicationManager().replicateFTRelectionOp(op);
                    }
                }
                return;
            }
        }
        if (this.DEBUG) {
            this.debug("CWADS_DEBUG: connect setting Directed Addr: " + SessionConfig.getDirectedSubject(csc.getUid(), csc.getAppid(), this.getCollective(), csc.getUid(), "reply"));
        }
        csc.setDirectedAddr(AddrUtil.directedAddr(id, 0, null));
        csc.setDirectedAddrString(SessionConfig.getDirectedSubject(csc.getUid(), csc.getAppid(), this.getCollective(), Config.BROKER_UID, "reply"));
    }

    public void redoDurableDisconnect(long id, long disconectTime, boolean inDoubt) {
        try {
            IClientContext prevProxy;
            if (this.DEBUG) {
                this.debug("Redoing durable disconnect.");
            }
            IClientContext cc = this.getClient(id);
            cc.setState(0);
            cc.setLastConnectedTime(disconectTime);
            if (!inDoubt && (prevProxy = cc.getCWADSPreviousBroker()) != null && prevProxy.getProxyHandle() != null) {
                cc.getProxyingHandle().notifyProxyDoubtResolved(prevProxy);
            }
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
    }

    public void redoDurableSMOUpdate(long id, long previousBrokerId, long restoringBrokerId) {
        try {
            BrokerSubscription bs;
            block13: {
                IClientContext cc;
                if (this.DEBUG) {
                    this.debug("Redoing durable SMO update. id: " + id + " previousBrokerId:" + previousBrokerId + " restoringBrokerId: " + restoringBrokerId);
                }
                if ((bs = this.getRecoveredDurableBrokerSubscription((cc = this.getClient(id)).getId())) == null) {
                    if (this.DEBUG) {
                        this.debug("Subscription not found for " + cc);
                    }
                    return;
                }
                try {
                    if (previousBrokerId != -1L) {
                        IClientContext previousCC = this.getClient(previousBrokerId);
                        cc.setCWADSPreviousBroker(previousCC);
                        bs.setPreviousBrokerCID(previousCC.getId());
                        if (this.DEBUG) {
                            this.debug("set cc.getCWADSPreviousBroker(): " + cc.getCWADSPreviousBroker());
                        }
                    }
                    if (restoringBrokerId != -1L) {
                        IClientContext restoringCC = this.getClient(restoringBrokerId);
                        cc.setCWADSRestoringBroker(restoringCC);
                        bs.setRestoreToBrokerCID(restoringCC.getId());
                        if (this.DEBUG) {
                            this.debug(" set cc.getCWADSRestoringBroker(): " + cc.getCWADSRestoringBroker());
                        }
                    } else {
                        cc.setCWADSRestoringBroker(null);
                        bs.setRestoreToBrokerCID(-1L);
                    }
                }
                catch (EClientNotRegistered e) {
                    cc.setCWADSPreviousBroker(null);
                    cc.setCWADSRestoringBroker(null);
                    bs.setPreviousBrokerCID(-1L);
                    bs.setRestoreToBrokerCID(-1L);
                    if (this.DEBUG) {
                        this.debug("cc.getCWADSPreviousBroker(): " + cc.getCWADSPreviousBroker(), e);
                    }
                    if (!this.DEBUG) break block13;
                    this.debug("cc.getCWADSRestoringBroker(): " + cc.getCWADSRestoringBroker(), e);
                }
            }
            bs.setDurableStrictMessageOrder(true);
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoUnregister(long id) {
        IClientContext cc = s_reg.lockContext(id);
        if (cc != null) {
            try {
                cc.setState(-1);
                this.m_txnmgr.cleanupCompletedTxns(id);
                s_reg.unregister(cc);
                this.unregisterCCFromParent(cc);
            }
            finally {
                cc.unlock();
            }
        }
    }

    public void redoCounter(short category, long id) {
        this.m_counterManager.redoCounter(category, id);
    }

    public IClientContext createContext(long clientId, ClientSecurityContext csc, AgentConnection connection) {
        return this.createContext(clientId, csc, connection, false);
    }

    public IClientContext createContext(long clientId, ClientSecurityContext csc, AgentConnection connection, boolean replicated) {
        if (this.m_clientContextFactories != null) {
            for (int i = 0; i < this.m_clientContextFactories.length; ++i) {
                IClientContext ctx;
                if (this.m_clientContextFactories[i] == null || (ctx = this.m_clientContextFactories[i].createContext(clientId, csc, connection)) == null) continue;
                if (this.DEBUG) {
                    this.debug("Factory " + this.m_clientContextFactories[i].getClass().getName() + " created context for UID:" + csc.getUid() + ", AID:" + csc.getAppid());
                }
                return ctx;
            }
        }
        if (this.DEBUG) {
            this.debug("Created default context for UID:" + csc.getUid() + ", AID:" + csc.getAppid());
        }
        IClientContext cc = ClientContextCreator.createCC(clientId, csc, connection, replicated);
        return cc;
    }

    public IClientContext lockContext(long id) {
        return this.lockContext(id, false, null, null, false);
    }

    public IClientContext lockContext(long id, boolean register, ClientSecurityContext csc, AgentConnection connection) {
        return this.lockContext(id, register, csc, connection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClientContext lockContext(long id, boolean register, ClientSecurityContext csc, AgentConnection connection, boolean replicated) {
        if (this.DEBUG) {
            this.debug("lockContext(" + id + ", " + (register ? "true" : "false") + ") called");
        }
        IClientContext c = null;
        boolean newcc = false;
        while (true) {
            newcc = false;
            LongHashTable longHashTable = this.m_regCl;
            synchronized (longHashTable) {
                c = (IClientContext)this.m_regCl.get(id);
                if (c == null) {
                    if (register) {
                        if (this.DEBUG) {
                            this.debug("registering client " + id + " replicated: " + replicated);
                        }
                        c = this.createContext(id, csc, connection, replicated);
                        newcc = true;
                    } else {
                        if (this.DEBUG) {
                            this.debug("NOT REGISTERING Already registered client " + id + " replicated: " + replicated);
                        }
                        break;
                    }
                }
            }
            c.lock();
            longHashTable = this.m_regCl;
            synchronized (longHashTable) {
                IClientContext ccInReg = (IClientContext)this.m_regCl.get(id);
                if (newcc) {
                    if (ccInReg == null) {
                        this.m_regCl.put(id, c);
                        if (this.m_trackRegCl != null) {
                            this.m_trackRegCl.put(id, c);
                        }
                        c.setRegistered();
                        break;
                    }
                } else if (ccInReg == c) {
                    break;
                }
            }
            c.unlock();
        }
        if (this.DEBUG) {
            this.debug("context " + id + " locked");
        }
        return c;
    }

    public void refreshRegisteredCSC(IClientContext regcc, ClientSecurityContext newcsc) {
        regcc.setCSC(newcsc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClientContext refreshRegisteredCCWrappers(IClientContext registeredCC, ClientSecurityContext csc) {
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            IClientContext updatedCC = ClientContextCreator.refreshWrappers(registeredCC, csc);
            if (updatedCC != registeredCC) {
                if (this.DEBUG) {
                    this.debug("Refreshed registry entry with new wrapper tree updated: " + updatedCC);
                }
                this.m_regCl.put(updatedCC.getId(), updatedCC);
            }
            return updatedCC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(IClientContext cc) {
        if (this.DEBUG) {
            this.debug("unregistering client " + cc.getId());
        }
        cc.setUnregistered();
        boolean removedFromDirty = false;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            this.m_regCl.remove(cc.getId());
            if (this.m_trackRegCl != null) {
                this.m_trackRegCl.remove(cc.getId());
            }
            Long lid = new Long(cc.getId());
            if (!this.m_db.isClientInDb(cc.getId())) {
                this.m_dirtyClients.remove(lid);
                removedFromDirty = true;
            } else {
                this.m_dirtyClients.put(lid, lid);
            }
        }
        if (removedFromDirty) {
            cc.setDirty(false);
        } else {
            cc.setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkUnregister(IClientContext cc) {
        boolean logUnregister = false;
        boolean unregistered = false;
        Object object = cc.getSyncObj();
        synchronized (object) {
            boolean hasRecoveredSubs;
            Long id = new Long(cc.getId());
            boolean bl = hasRecoveredSubs = this.m_recoveredSubscriptions != null && this.m_recoveredSubscriptions.get(id) != null;
            if (!hasRecoveredSubs && cc.okToUnregister()) {
                this.unregister(cc);
                unregistered = true;
                if (!(cc.getCSC().isAnonymous() || cc.isGroupSubscription() || this.m_inRecovery)) {
                    logUnregister = true;
                }
            }
        }
        if (logUnregister) {
            this.getLogManager().addEvent(new UnregisterEvt(cc.getId()), false);
        }
        return unregistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean prepareConnect(IClientContext cc, long rootClientId) throws InterruptedException, EUserAlreadyConnected {
        boolean locked = true;
        try {
            if (cc.isDisconnecting()) {
                Object object = cc.getSyncObj();
                synchronized (object) {
                    cc.unlock();
                    locked = false;
                    cc.getSyncObj().wait();
                    return false;
                }
            }
            if (cc.isConnected()) {
                try {
                    AgentRegistrar.attemptToPreempt(cc, rootClientId);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    locked = false;
                }
            }
            if (!cc.isPendingReconnect()) return true;
            long timerid = cc.getTimerId();
            boolean lastManOut = m_disconnectTimerMgr.unregister(timerid, cc.getId());
            if (!lastManOut) {
                return true;
            }
            if (!m_disconnectTimerMgr.cancel(timerid)) {
                cc.unlock();
                locked = false;
                m_disconnectTimerMgr.waitForTimerExec(timerid);
                return false;
            }
            m_disconnectTimerMgr.clear(timerid);
            return true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (!locked) throw ie;
            cc.unlock();
            throw ie;
        }
    }

    public static final void attemptToPreempt(IClientContext cc, long rootClientId) throws InterruptedException, EUserAlreadyConnected {
        if (cc.isActivelyConnected()) {
            cc.unlock();
            cc.pingIfIdle(rootClientId);
            cc.lock();
            if (!cc.isActivelyConnected()) {
                cc.unlock();
                return;
            }
            cc.unlock();
            throw new EUserAlreadyConnected("" + cc.getUid() + "/" + cc.getAppid());
        }
        long aboutToPreemptsRoot = -1L;
        try {
            aboutToPreemptsRoot = cc.getRootId();
        }
        catch (EClientNotRegistered ecnr) {
            // empty catch block
        }
        if (aboutToPreemptsRoot != -1L && rootClientId != aboutToPreemptsRoot && !AgentRegistrar.getAgentRegistrar().isInternalAppid(aboutToPreemptsRoot) && !m_disconnectTimerMgr.outOfTime(cc.getTimerId())) {
            cc.unlock();
            throw new EUserAlreadyConnectedPendingReconnect("" + cc.getUid() + "/" + cc.getAppid());
        }
        long timerid = cc.getTimerId();
        if (cc.isDurable() && !Config.ENABLE_INTERBROKER) {
            cc.resumePreempted();
            cc.unlock();
            return;
        }
        if (!m_disconnectTimerMgr.cancel(timerid)) {
            cc.unlock();
            m_disconnectTimerMgr.waitForTimerExec(timerid);
            return;
        }
        cc.unlock();
        m_disconnectTimerMgr.disconnect(timerid);
    }

    public RoutingConnectionInfo routingNodeReverseLookup(String destination) {
        destination = DraDestUtil.httpUrlToRoutingSubject(destination, true);
        BrokerSearchResults results = new BrokerSearchResults();
        this.getSubjectSpace().get(new Subject(destination), results);
        return results.getRoutingNode();
    }

    public boolean isInternalAppid(long cid) {
        try {
            IClientContext cc = this.getClient(cid);
            String appid = cc.getAppid();
            return appid != null && appid.startsWith("SonicMQ/mf/");
        }
        catch (EClientNotRegistered ecnr) {
            return false;
        }
    }

    public long connect(long clientId, AgentConnection connection, boolean isInterbroker) throws EUserAlreadyConnected, EConnectionLimitExceeded, EConnectFailure, InterruptedException {
        short ackMode = isInterbroker ? (short)1 : -1;
        return this.connect(clientId, connection, null, isInterbroker, ackMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long connect(long clientId, AgentConnection connection, ClientSecurityContext csc, boolean isInterbroker, short ackMode) throws EUserAlreadyConnected, EConnectionLimitExceeded, EConnectFailure, InterruptedException {
        long parentId;
        IClientContext clctx;
        if (csc == null) {
            if (connection != null) {
                csc = connection.getSecurityContextFromId(clientId);
            } else {
                throw new EAssertFailure("connect() with csc and connection both null");
            }
        }
        if (this.DEBUG) {
            this.debug("connecting client " + csc.getUid() + ", " + csc.getAppid() + ": " + clientId);
        }
        long loopCount = 0L;
        do {
            if (++loopCount >= 100L) {
                if (loopCount % 100L == 0L) {
                    Object[] obj = new Object[]{csc.getUid(), csc.getAppid(), Long.toString(clientId), Long.toString(loopCount)};
                    String error = prMessageFormat.format(prAccessor.getString("UNEXPECTED_CONNECT_LOOP"), obj);
                    BrokerComponent.getComponentContext().logMessage(error, 1);
                }
                Thread.sleep(30000L);
            }
            clctx = this.registerAndLock(clientId, csc, connection);
            parentId = -1L;
            if (connection == null) continue;
            ClientSecurityContext parentCSC = connection.getSecurityContext(0);
            if (parentCSC == null) {
                clctx.unlock();
                throw new EConnectFailure(-1, "The parent connection is not established.");
            }
            parentId = parentCSC.getClientId();
        } while (clctx.waitForRegistryUpdate() || !this.prepareConnect(clctx, parentId) || !clctx.beginRegistryUpdate());
        if (this.DEBUG) {
            this.debug("context locked");
        }
        boolean needsUnlock = true;
        try {
            IClientContext activeBrokerCC;
            if (this.DEBUG) {
                this.debug("CWADS_DEBUG: checking activeBrokerId for " + clctx.getAppid() + "\n before connect active = " + clctx.getCWADSActiveBroker() + "\n isconnected = " + clctx.isConnected());
            }
            if ((activeBrokerCC = clctx.getCWADSActiveBroker()) != null && clctx != activeBrokerCC) {
                throw new EUserAlreadyConnected("Cannot create subscription.  The durable subscription is already active on another member of the cluster.");
            }
            if (clctx.isActivelyConnected() || clctx.isDurable() && this.m_txnmgr.isParticipantOfTxn(clientId)) {
                throw new EUserAlreadyConnected("" + clientId);
            }
            if (clctx.isDurable() && csc.getAppid().indexOf("$DURABLE$") < 0) {
                throw new EUserAlreadyConnected("ClientID of new client conflicts with existing durable subscription");
            }
            long parentId2 = csc.getParentId();
            if (parentId2 != -1L && connection != null) {
                try {
                    IClientContext parent = this.getClient(parentId2);
                    AgentConnection parentConnection = parent.getConnection();
                    if (parentConnection == null) {
                        throw new EConnectFailure(-1, "The parent connection is not established.");
                    }
                    long parentSocketId = parentConnection.getSocketId();
                    if (connection.getSocketId() != parentSocketId) {
                        throw new ESocketIdMismatch(prAccessor.getString("STR269"));
                    }
                }
                catch (EClientNotRegistered e) {
                    throw new EConnectFailure(-1, "The parent connection cannot be found.", e);
                }
            }
            needsUnlock = false;
            long l = this.preparedConnect(connection, csc, clctx, isInterbroker, ackMode, false, parentId2).getId();
            return l;
        }
        finally {
            clctx.endRegistryUpdate();
            if (needsUnlock) {
                clctx.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IClientContext preparedConnect(AgentConnection connection, ClientSecurityContext csc, IClientContext clctx, boolean isInterbroker, short ackMode, boolean isCWADS, long rootId) throws EConnectFailure, InterruptedException {
        BrokerSubscription dbs;
        ConnectEvt ce;
        boolean waitForFlush;
        String uid;
        String appid;
        long clientId;
        block25: {
            clientId = clctx.getId();
            appid = clctx.getAppid();
            uid = clctx.getUid();
            boolean success = false;
            waitForFlush = false;
            ce = null;
            try {
                if (isCWADS) {
                    csc.setFaultTolerant(false);
                }
                clctx = this.refreshRegisteredCCWrappers(clctx, csc);
                if (!isCWADS && !isInterbroker && InterbrokerHook.isSet()) {
                    InterbrokerHook.clientConnect(clientId, connection);
                }
                if (Config.REPLICATED && this.m_replicationManager != null) {
                    if (appid.equals("FailoverBroker connect")) {
                        this.m_replicationManager.onConnect(clientId, connection);
                    } else if (!clctx.isGroupSubscription()) {
                        this.m_replicationManager.connectionReceived();
                    }
                }
                clctx.connect(connection, isInterbroker, ackMode);
                this.incClientCount();
                this.registerCCWithParent(clctx);
                if (!csc.isAnonymous() && !clctx.isGroupSubscription()) {
                    ce = new ConnectEvt(clientId, csc, isInterbroker);
                    if (clctx.isXOnce()) {
                        this.getLogManager().addEvent(ce, true);
                        waitForFlush = true;
                    } else {
                        this.getLogManager().addEvent(ce, false);
                    }
                    if (!clctx.isDirty()) {
                        Long ID = new Long(clientId);
                        this.m_dirtyClients.put(ID, ID);
                        clctx.setDirty(true);
                    }
                }
                if (!isCWADS) {
                    boolean subscribeToAcceptorChanges = rootId == -1L && connection != null && connection.getFaultTolerant();
                    this.subscribeToImplicits(clientId, uid, appid, subscribeToAcceptorChanges, connection == null ? null : connection.getAcceptorName());
                }
                if (success = true) break block25;
                this.checkUnregister(clctx);
            }
            catch (Throwable throwable) {
                if (!success) {
                    this.checkUnregister(clctx);
                }
                clctx.unlock();
                if (waitForFlush) {
                    this.getLogManager().waitForFlush(ce);
                }
                throw throwable;
            }
        }
        clctx.unlock();
        if (waitForFlush) {
            this.getLogManager().waitForFlush(ce);
        }
        if (!isCWADS && !uid.equals(Config.BROKER_UID)) {
            BrokerManagementNotificationsHelper.sendConnectionConnectNotification(Config.BROKER_NAME, uid, appid, connection == null ? "<unknown>" : connection.getHostIpAddrStr(), connection == null ? "<unknown>" : connection.getAcceptorUrl());
        }
        if (this.DEBUG) {
            this.debug("client " + clientId + " connect complete");
        }
        if (!(isCWADS || !clctx.isDurable() || (dbs = clctx.getDurableBrokerSubscription()) == null || SessionConfig.isSystemSubject(dbs.getSubject()) || dbs.getSubject().isSonicMQSubject() || dbs.getSubject().isTemporary())) {
            boolean isProxySubscription = false;
            if (dbs.getSubscribeEvt() != null && dbs.getSubscribeEvt().getSuppressCWADSPropagation()) {
                isProxySubscription = true;
            }
            if (!isProxySubscription) {
                String subscriptionName;
                String clientID;
                String connectID = DurableSubscriptionUtil.getConnectID(appid, clctx);
                if (connectID == null) {
                    connectID = "";
                }
                if ((clientID = DurableSubscriptionUtil.getJMSClientID(appid)) == null) {
                    clientID = "";
                }
                if ((subscriptionName = DurableSubscriptionUtil.getSubscriptionName(appid)) == null) {
                    subscriptionName = "";
                }
                String topicName = dbs.getSubject().getLookupName();
                BrokerManagementNotificationsHelper.sendBrokerSubscriberResumeNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, uid, clientID, connectID, topicName, subscriptionName);
                if (this.DEBUG) {
                    System.out.println("AR.connect: userID = " + uid + ", clientID = " + clientID + ", connectID = " + connectID + ", subscriptionName = " + subscriptionName + ", topicName = " + topicName);
                }
            }
        }
        return clctx;
    }

    long resume(long clientId, AgentConnection connection, boolean isInterbroker) throws EUserAlreadyConnected, EConnectionLimitExceeded, EConnectFailure, InterruptedException {
        short ackMode = isInterbroker ? (short)1 : -1;
        return this.resume(clientId, connection, isInterbroker, ackMode);
    }

    long resume(long clientId, AgentConnection connection, boolean isInterbroker, short ackMode) throws EUserAlreadyConnected, EConnectionLimitExceeded, EConnectFailure, InterruptedException {
        IClientContext clctx;
        String appid;
        String uid;
        block17: {
            long timerid;
            ClientSecurityContext csc = connection.getSecurityContextFromId(clientId);
            uid = csc.getUid();
            appid = csc.getAppid();
            if (this.DEBUG) {
                this.debug("resuming client " + uid + ", " + appid + ": " + clientId);
            }
            clctx = null;
            while (true) {
                boolean lastManOut;
                if ((clctx = this.lockContext(clientId)) == null) {
                    throw new EConnectionNotResumable("Client context for " + appid + " is not available to resume.");
                }
                if (connection.getChannel(clientId) == 0) {
                    if (!clctx.goodResumeCredentials(connection.getClientConnectParms())) {
                        boolean connected = clctx.isConnected();
                        clctx.unlock();
                        if (connected) {
                            throw new EUserAlreadyConnected("" + clientId);
                        }
                        throw new EConnectionNotResumable("Resume connect for " + appid + " does not appear valid to resume.");
                    }
                    clctx.unlock();
                    this.throwOutStaleConnection(clctx, connection);
                    clctx.lock();
                }
                if (!(lastManOut = m_disconnectTimerMgr.unregister(timerid = clctx.getTimerId(), clientId))) break block17;
                if (m_disconnectTimerMgr.cancel(timerid)) break;
                clctx.unlock();
                m_disconnectTimerMgr.waitForTimerExec(timerid);
            }
            m_disconnectTimerMgr.clear(timerid);
        }
        boolean success = false;
        try {
            if (!isInterbroker && InterbrokerHook.isSet()) {
                InterbrokerHook.clientConnect(clientId, connection);
            }
            clctx.resume(connection, isInterbroker, ackMode);
            this.registerCCWithParent(clctx);
            success = true;
            boolean subscribeToAcceptorChanges = connection != null && connection.getChannel(clientId) == 0;
            this.subscribeToImplicits(clientId, uid, appid, subscribeToAcceptorChanges, connection == null ? null : connection.getAcceptorName());
            if (Config.REPLICATED && this.m_replicationManager != null && clctx.isJMSConnection()) {
                this.m_replicationManager.connectionReceived();
            }
            if (!uid.equals(Config.BROKER_UID)) {
                BrokerManagementNotificationsHelper.sendConnectionReconnectNotification(Config.BROKER_NAME, uid, appid, connection == null ? "<unknown>" : connection.getHostIpAddrStr());
            }
        }
        catch (EConnectionNotResumable ecnr) {
            throw ecnr;
        }
        catch (EGeneralException g) {
            throw new EConnectionNotResumable(g.toString(), g);
        }
        finally {
            if (!success) {
                this.checkUnregister(clctx);
            }
            clctx.unlock();
        }
        if (this.DEBUG) {
            this.debug("client " + clientId + " resumed");
        }
        return clientId;
    }

    private void throwOutStaleConnection(IClientContext clctx, AgentConnection connection) throws InterruptedException {
        AgentConnection staleConnection = clctx.getConnection();
        if (clctx.getChannel() == 0 && staleConnection != null) {
            AgentSender staleSender = staleConnection.getAgentSender();
            AgentListener staleListener = staleConnection.getAgentListener();
            if (staleSender != null && staleSender.isAlive() || staleListener != null && staleListener.isAlive()) {
                ISocket socket;
                if (this.DEBUG) {
                    this.debug("Throwing out stale connection!:" + staleSender);
                }
                if ((socket = staleConnection.getSocket()) != null) {
                    staleConnection.close();
                    if (staleSender != null) {
                        staleSender.setAbort();
                        staleSender.notifySender();
                        if (staleSender.isAlive()) {
                            staleSender.join();
                        }
                    }
                    if (staleListener != null) {
                        staleListener.shutdown(false);
                        if (staleListener.isAlive()) {
                            staleListener.join();
                        }
                    }
                }
            }
        }
    }

    private final void subscribeToImplicits(long clientId, String uid, String appid, boolean subscribeToAcceptorChangeSubject, String acceptorName) {
        try {
            if (SessionConfig.isGroupSubscriptionAppid(appid)) {
                return;
            }
            Label lab = new Label();
            lab.setNonStop(true);
            lab.setRouteLimit(1);
            lab.setPersistent(false);
            SubscribeEvt evt = new SubscribeEvt(null, clientId, new Subject(SessionConfig.getDirectedSubject(uid, appid, "*", "#", "*")), lab);
            this.subscribe(evt);
            if (!subscribeToAcceptorChangeSubject) {
                return;
            }
            evt = new SubscribeEvt(null, clientId, new Subject("$ISYS.acceptor." + acceptorName.trim()), lab);
            this.subscribe(evt);
        }
        catch (EInvalidSubjectSyntax e) {
            String mf975 = prAccessor.getString("STR030");
            Object[] ob975 = new Object[]{appid, uid};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf975, ob975), (Throwable)e, 2);
        }
        catch (EClientNotRegistered e) {
            throw new EAssertFailure("Could not subscribe client " + clientId + "to its internal subscriptions: " + e, e);
        }
        catch (EOldVirtualClockException eovce) {
        }
        catch (ESecurityPolicyViolation e) {
            EAssertFailure t = new EAssertFailure("Error: could not subscribe client " + uid + "/" + appid + " to its internal subscriptions: " + e, e);
            BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
        }
        catch (ParseException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (TokenMgrError e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConnect(long id, int channel) {
        IClientContext cc = null;
        AgentConnection conn = null;
        try {
            cc = this.lockContext(id);
            if (cc == null) {
                Error err = new Error(prAccessor.getString("STR031") + id + prAccessor.getString("STR032"));
                BrokerComponent.getComponentContext().logMessage((Throwable)err, 2);
                return;
            }
            conn = cc.getConnection();
            AgentSender sender = conn.getAgentSender();
            sender.connect(cc, channel);
            if (!sender.isStarted() && channel == 0) {
                sender.startIfNotStartedOrShutdown();
            }
        }
        finally {
            if (cc != null) {
                cc.unlock();
            }
        }
        if (conn != null) {
            conn.initMetricsOnConnect(id);
        }
        this.m_txnmgr.sendInDoubtReqs(id);
    }

    public void disconnect(long id, boolean sync) {
        this.disconnect(id, sync, false, null);
    }

    public void disconnect(long id, boolean sync, boolean checkConnectionIntegrity, AgentConnection c) {
        this.disconnect(id, sync, checkConnectionIntegrity, c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(long id, boolean sync, boolean checkConnectionIntegrity, AgentConnection c, boolean proxyDisconnect) {
        BrokerSubscription dbs;
        IClientContext clctx;
        if (this.DEBUG) {
            this.debug("disconnect(" + id + ") called in thread " + Thread.currentThread());
        }
        if ((clctx = this.lockContext(id)) == null) {
            if (Config.REPLICATED && this.m_replicationManager != null) {
                this.m_replicationManager.onDisconnect(id);
            }
            return;
        }
        boolean ccLocked = true;
        String appID = null;
        String connectID = null;
        Vector unsubscribeEvts = null;
        try {
            appID = clctx.getAppid();
            if (clctx.isDurable()) {
                connectID = DurableSubscriptionUtil.getConnectID(appID, clctx);
            }
            if (this.DEBUG) {
                this.debug("uid = " + clctx.getUid() + " appID = " + clctx.getAppid());
            }
            if (checkConnectionIntegrity && clctx.getConnection() != c) {
                clctx.unlock();
                ccLocked = false;
                return;
            }
            long reconnectTimeout = -1L;
            boolean ft = clctx.isXOnce();
            if (ft) {
                reconnectTimeout = AgentRegistrar.deriveReconnectTimeoutForReporting(clctx);
            }
            if (clctx.isDisconnecting()) {
                int reason = clctx.getDisconnectReason();
                if (this.DEBUG) {
                    this.debug("disconnect reason = " + reason);
                }
                if (reason != 4 && reason != 5) {
                    BrokerManagementNotificationsHelper.sendConnectionDisconnectNotification(Config.BROKER_NAME, clctx.getUid(), clctx.getAppid(), clctx.getConnection() == null ? "<unknown>" : clctx.getConnection().getHostIpAddrStr(), c == null ? "<unknown>" : c.getAcceptorUrl());
                }
            } else {
                if (!clctx.isPendingReconnect() && clctx.postponeDisconnect()) {
                    if (this.DEBUG) {
                        this.debug("connection drop postponed");
                    }
                    if (!clctx.isXOnce()) {
                        BrokerManagementNotificationsHelper.sendConnectionDropNotification(Config.BROKER_NAME, clctx.getUid(), clctx.getAppid(), clctx.getConnection() == null ? "<unknown>" : clctx.getConnection().getHostIpAddrStr(), ft, reconnectTimeout);
                    }
                    clctx.unlock();
                    ccLocked = false;
                    return;
                }
                if (this.DEBUG) {
                    this.debug("connection dropped");
                }
                BrokerManagementNotificationsHelper.sendConnectionDropNotification(Config.BROKER_NAME, clctx.getUid(), clctx.getAppid(), clctx.getConnection() == null ? "<unknown>" : clctx.getConnection().getHostIpAddrStr(), ft, reconnectTimeout);
            }
            clctx.setDisconnecting(true);
            unsubscribeEvts = this.unsubscribeTransient(clctx);
        }
        finally {
            if (ccLocked) {
                clctx.unlock();
            }
        }
        if (clctx.isDurable()) {
            this.registerSubscriptionsForExpiration(clctx);
        }
        try {
            this.m_txnmgr.abortTxns(id);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        IClientContext proxy = null;
        if (clctx.getProxyingHandle() != null && InterbrokerHook.isSet()) {
            proxy = clctx.getProxyingHandle().preDisconnect(proxyDisconnect);
        }
        clctx.lock();
        try {
            if (this.DEBUG) {
                this.debug("Cleaning up sender queue");
            }
            clctx.disconnect(sync);
            if (this.DEBUG) {
                this.debug("Done cleaning up sender queue");
            }
            this.decClientCount();
            this.unregisterCCFromParent(clctx);
            if (InterbrokerHook.isSet()) {
                InterbrokerHook.disconnect(id);
            }
            if (Config.REPLICATED && this.m_replicationManager != null) {
                this.m_replicationManager.onDisconnect(id);
            }
            clctx.setDisconnecting(false);
            clctx.setDisconnectReason(-1);
            this.checkUnregister(clctx);
            Object object = clctx.getSyncObj();
            synchronized (object) {
                clctx.getSyncObj().notifyAll();
            }
        }
        finally {
            clctx.unlock();
            if (this.DEBUG) {
                this.debug("disconnect() exiting");
            }
            if (clctx.getProxyingHandle() != null && InterbrokerHook.isSet()) {
                clctx.getProxyingHandle().postDisconnect(proxyDisconnect, proxy);
            }
            LogEvent evt = null;
            boolean submitDbDelete = false;
            if (unsubscribeEvts != null) {
                evt = (LogEvent)unsubscribeEvts.remove(0);
                this.getDeleteSubscriptionManager().registerIdForDeletion(clctx, clctx.getId(), evt.getSeqNo(), evt.isReplicateOnly());
                if (this.DEBUG_UNEXPECTED && unsubscribeEvts.size() != 0) {
                    try {
                        BrokerComponent.logMessage(new EAssertFailure("AR.disconnect: unsubscribeEvts.size= " + unsubscribeEvts.size() + " expected 0; " + clctx.getUid() + "/" + clctx.getAppid()), BrokerComponent.getLevelWarning());
                    }
                    catch (Throwable ex) {}
                }
            }
            if (SessionConfig.isNonDurableSubscriber(clctx.getAppid()) && clctx.hasMsgsInDb()) {
                long maxMessageId = -1L;
                boolean persistent = false;
                boolean replicateOnly = false;
                if (clctx.isXOnce() && clctx.getClientSessionVer() >= 28) {
                    submitDbDelete = true;
                    persistent = true;
                    replicateOnly = true;
                } else if (SessionConfig.isFlowToDiskSupported(clctx.getAppid())) {
                    submitDbDelete = true;
                    persistent = false;
                    replicateOnly = false;
                }
                if (submitDbDelete) {
                    maxMessageId = evt != null ? evt.getSeqNo() : this.getLogManager().getSeqNo();
                    try {
                        this.deleteSubscriberMessages(clctx.getId(), clctx, maxMessageId, persistent, replicateOnly);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (evt != null && !submitDbDelete) {
                this.getDeleteSubscriptionManager().endDeleteSubscription(clctx.getId(), evt.getSeqNo(), evt.isReplicateOnly());
            }
        }
        if (clctx.isDurable() && (dbs = clctx.getDurableBrokerSubscription()) != null && !SessionConfig.isSystemSubject(dbs.getSubject()) && !dbs.getSubject().isSonicMQSubject() && !dbs.getSubject().isTemporary()) {
            boolean isProxySubscription = false;
            if (dbs.getSubscribeEvt() != null && dbs.getSubscribeEvt().getSuppressCWADSPropagation()) {
                isProxySubscription = true;
            }
            if (!isProxySubscription) {
                String subscriptionName;
                String clientID;
                String userID = clctx.getUid();
                if (userID == null) {
                    userID = "";
                }
                if ((clientID = DurableSubscriptionUtil.getJMSClientID(appID)) == null) {
                    clientID = "";
                }
                if ((subscriptionName = DurableSubscriptionUtil.getSubscriptionName(appID)) == null) {
                    subscriptionName = "";
                }
                String topicName = dbs.getSubject().getLookupName();
                BrokerManagementNotificationsHelper.sendBrokerSubscriberPauseNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, userID, clientID, connectID, topicName, subscriptionName);
                if (this.DEBUG) {
                    System.out.println("AR.disconnect: userID = " + userID + ", clientID = " + clientID + ", connectID = " + connectID + ", subscriptionName = " + subscriptionName + ", topicName = " + topicName);
                }
            }
        }
    }

    public void prepareDisconnect(long id) throws EClientNotRegistered {
        this.prepareDisconnect(id, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDisconnect(long id, int reason) throws EClientNotRegistered {
        IClientContext cc = this.lockContext(id);
        if (cc == null) {
            throw new EClientNotRegistered(id);
        }
        try {
            if (cc.isConnected()) {
                cc.prepareDisconnect(reason);
            }
        }
        finally {
            cc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClientContext getClient(long id) throws EClientNotRegistered {
        IClientContext cc;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            cc = (IClientContext)this.m_regCl.get(id);
        }
        if (cc == null) {
            throw new EClientNotRegistered(id);
        }
        return cc;
    }

    public void setProxyDoubtStatus(IClientContext cc, HashSet inDoubtProxies) {
        this.setProxyDoubtStatusInternal(cc, inDoubtProxies);
    }

    private void setProxyDoubtStatusInternal(IClientContext cc, HashSet inDoubtProxies) {
        BrokerSubscription bs;
        HashSet inDoubt = (HashSet)inDoubtProxies.clone();
        IClientContext proxy = cc.getCWADSActiveBroker();
        if (proxy != null && proxy.getId() != cc.getId()) {
            inDoubt.add(new Long(proxy.getId()));
        }
        if ((bs = cc.getDurableBrokerSubscription()) != null) {
            bs.setInDoubtProxies(inDoubt);
            if (!cc.isDirty()) {
                cc.setDirty(true);
                Long ID = new Long(cc.getId());
                this.m_dirtyClients.put(ID, ID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUnfilteredStatus(IClientContext cc, boolean unfiltered, boolean needsLog) {
        cc.lock();
        try {
            BrokerSubscription bs = cc.getSelectorSubscription();
            if (bs == null) {
                return;
            }
            bs.setUnfiltered(unfiltered);
            if (needsLog) {
                UnfilteredEvt evt = new UnfilteredEvt(cc.getId(), unfiltered);
                this.getLogManager().addEvent(evt, false);
            }
            if (!cc.isDirty()) {
                cc.setDirty(true);
                Long ID = new Long(cc.getId());
                this.m_dirtyClients.put(ID, ID);
            }
        }
        finally {
            cc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean trySetUnfilteredStatus(IClientContext cc, boolean unfiltered, boolean needsLog) {
        boolean result = false;
        boolean locked = false;
        try {
            locked = cc.tryLock();
            if (locked) {
                BrokerSubscription bs = cc.getSelectorSubscription();
                if (bs == null) {
                    boolean bl = true;
                    return bl;
                }
                bs.setUnfiltered(unfiltered);
                if (needsLog) {
                    UnfilteredEvt evt = new UnfilteredEvt(cc.getId(), unfiltered);
                    this.getLogManager().addEvent(evt, false);
                }
                if (!cc.isDirty()) {
                    cc.setDirty(true);
                    Long ID = new Long(cc.getId());
                    this.m_dirtyClients.put(ID, ID);
                }
                result = true;
            }
        }
        finally {
            if (locked) {
                cc.unlock();
            }
        }
        return result;
    }

    private static long deriveReconnectTimeoutForReporting(IClientContext cc) {
        ClientSecurityContext csc = cc.getCSC();
        long configuredBrokerLimit = Config.CLIENT_RECONNECT_TIMEOUT;
        boolean brokerLimitInfinite = false;
        boolean clientLimitInfinite = false;
        if (csc == null) {
            return configuredBrokerLimit;
        }
        long presentedMs = csc.getFaultTolerantReconnectTimeout();
        if (presentedMs <= 0L) {
            clientLimitInfinite = true;
        }
        if (clientLimitInfinite) {
            return configuredBrokerLimit;
        }
        if (configuredBrokerLimit <= 0L) {
            brokerLimitInfinite = true;
        }
        long presentedSecs = presentedMs / 1000L;
        if (brokerLimitInfinite) {
            return presentedSecs;
        }
        if (configuredBrokerLimit < presentedSecs) {
            return configuredBrokerLimit;
        }
        return presentedSecs;
    }

    public void subscribeAndWaitForFlush(SubscribeEvt evt) throws EInvalidSubjectSyntax, EClientNotRegistered, ESecurityPolicyViolation, ParseException, TokenMgrError, EOldVirtualClockException, InterruptedException {
        try {
            this.subscribeAndWaitForFlush(evt, false, false, null, false);
        }
        catch (EInvalidTTLException ittle) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ittle, 2);
        }
    }

    public void subscribeAndWaitForFlush(SubscribeEvt evt, boolean checkTTL, boolean skipSecurityChecks, Boolean unfiltered) throws EInvalidSubjectSyntax, EClientNotRegistered, ESecurityPolicyViolation, EInvalidTTLException, ParseException, TokenMgrError, EOldVirtualClockException, InterruptedException {
        this.subscribeAndWaitForFlush(evt, checkTTL, skipSecurityChecks, unfiltered, false);
    }

    public void subscribeAndWaitForFlush(SubscribeEvt evt, boolean checkTTL, boolean skipSecurityChecks, Boolean unfiltered, boolean propagate_for_cwads) throws EInvalidSubjectSyntax, EClientNotRegistered, ESecurityPolicyViolation, EInvalidTTLException, ParseException, TokenMgrError, EOldVirtualClockException, InterruptedException {
        this.subscribeInternal(evt, checkTTL, skipSecurityChecks, unfiltered, propagate_for_cwads);
        this.getLogManager().waitForFlush(evt);
    }

    public void subscribe(SubscribeEvt evt) throws EInvalidSubjectSyntax, EClientNotRegistered, ESecurityPolicyViolation, ParseException, TokenMgrError, EOldVirtualClockException {
        try {
            this.subscribe(evt, false, false, null);
        }
        catch (EInvalidTTLException ittle) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ittle, 2);
        }
    }

    public void subscribe(SubscribeEvt evt, boolean checkTTL) throws EInvalidTTLException, EInvalidSubjectSyntax, EClientNotRegistered, ESecurityPolicyViolation, ParseException, TokenMgrError, EOldVirtualClockException {
        this.subscribe(evt, checkTTL, false, null);
    }

    public void subscribe(SubscribeEvt evt, boolean checkTTL, boolean skipSecurityChecks, Boolean unfiltered) throws EInvalidSubjectSyntax, EClientNotRegistered, ESecurityPolicyViolation, EInvalidTTLException, ParseException, TokenMgrError, EOldVirtualClockException {
        this.subscribeInternal(evt, checkTTL, skipSecurityChecks, unfiltered, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeInternal(SubscribeEvt evt, boolean checkTTL, boolean skipSecurityChecks, Boolean unfiltered, boolean propagate_for_cwads) throws EInvalidSubjectSyntax, EClientNotRegistered, ESecurityPolicyViolation, EInvalidTTLException, ParseException, TokenMgrError, EOldVirtualClockException {
        block60: {
            boolean newSubscription = true;
            long id = evt.getClientId();
            boolean logged = evt.isLogged();
            SubscriptionInfo si = new SubscriptionInfo();
            si.m_subject = evt.getSubject();
            si.m_label = evt.getLabel();
            si.m_persistent = si.m_label.isPersistent();
            si.m_needsLog = si.m_persistent && !logged;
            si.m_remoteSubscription = false;
            si.m_gsExpirableSubject = !evt.getSubject().isMultiSubject() && evt.getSubject().getSubjectString().equals("$ISYS.GSA.expirableSubject");
            String remoteNodeName = null;
            String remoteBrokerName = null;
            String remoteUserID = null;
            IClientContext cc = this.lockContext(id);
            if (cc == null) {
                throw new EClientNotRegistered(id);
            }
            if (this.DEBUG) {
                this.debug("Subscribing UID: " + cc.getUid() + " APPID: " + cc.getAppid() + " to " + si.m_subject);
            }
            boolean waitForStalePubDispatches = false;
            try {
                if (si.m_subject.hasSubjectTracking()) {
                    throw new EInvalidSubjectSyntax("Cannot subscribe with a tracked subject: " + si.m_subject);
                }
                if (checkTTL && si.m_persistent && si.m_label.getExpiration() != null && !BrokerSubscription.isValidTTL(si.m_label.getExpirationTime())) {
                    throw new EInvalidTTLException(si.m_label.getExpirationTime());
                }
                Object object = this.m_subscriptionMutex;
                synchronized (object) {
                    if (si.m_persistent || cc.isConnected()) {
                        if (!logged && !skipSecurityChecks) {
                            this.doSecurityCheck(si, cc, evt);
                        }
                        this.retrieveSubscriptionInfo(si, evt, cc);
                        boolean SMOtoNonSMODowngrade = this.setupBrokerSubscription(si, evt, cc);
                        si.m_needsReplicationOnly = si.m_bs.isReplicateOnly() && !logged;
                        this.setupRemoteSubscription(si, cc);
                        if (si.m_remoteSubscription) {
                            remoteNodeName = si.m_remoteNodeCC.getRemoteNode();
                            remoteBrokerName = RouterManager.getRemoteBrokerFromGSAppID(cc.getAppid());
                            Principal p = this.m_gsManager.getRemoteNodePrincipal(remoteNodeName);
                            if (p != null) {
                                remoteUserID = p.getName();
                            }
                        }
                        if (si.m_oldSub != null) {
                            GroupSubscription gs;
                            newSubscription = false;
                            if (this.DEBUG) {
                                this.debug("BrokerSubscription FOUND already existed bs =" + si.m_bs);
                            }
                            this.checkVirtualClock(si, evt);
                            if (si.m_persistent && si.m_bs.isExpirable() && si.m_bs.hasTTE()) {
                                this.m_expSubs.remove(si.m_bs);
                            }
                            if (si.m_subject.hasGroup() && (gs = this.m_groupSubs.getGroup(si.m_subject)) != null) {
                                gs.resetDupsOK();
                            }
                            this.performSubscriptionUpdate(si, evt, logged, cc);
                            if (Config.ENABLE_INTERBROKER && !si.m_remoteSubscription && !si.m_gsExpirableSubject && !cc.isDurable()) {
                                InterbrokerHook.labelUpdateEvent(si.m_bs, evt.getLabel());
                            }
                        } else {
                            if (this.DEBUG) {
                                this.debug("Created new BrokerSubscription. Could NOT find bs = " + si.m_bs);
                            }
                            si.loadInfoIntoBS(evt);
                            if (!si.m_subject.hasGroup()) {
                                if (si.m_remoteSubscription) {
                                    if (si.m_firstBrokerSubscription) {
                                        this.m_regSub.put(si.m_subject, (ISubjectMatchObject)si.m_mergedSub);
                                    }
                                } else {
                                    this.m_regSub.put(si.m_subject, (ISubjectMatchObject)si.m_bs);
                                }
                            } else {
                                this.m_groupSubs.addGroupSubscription(si.m_bs);
                            }
                            if (si.m_remoteSubscription && si.m_firstBrokerSubscription) {
                                si.m_remoteNodeCC.getSubscriptions().put(si.m_subject, si.m_mergedSub);
                            }
                            cc.getSubscriptions().put(si.m_subject, si.m_bs);
                            if (cc.isDurable() && si.m_bs.getLabel().isPersistent()) {
                                cc.setDurableBrokerSubscription(si.m_bs);
                            }
                            cc.checkSpecialGroupSubscription();
                            if (Config.ENABLE_INTERBROKER && !si.m_remoteSubscription && !si.m_gsExpirableSubject && !cc.isDurable()) {
                                InterbrokerHook.subscribeEvent(si.m_bs);
                            }
                        }
                        if ((logged || si.m_bs.hasTTE()) && si.m_persistent && si.m_bs.isExpirable()) {
                            if (this.DEBUG) {
                                this.debug("SubscribeEvt from log or db has subscription with Expiration.");
                            }
                            if (logged) {
                                si.m_bs.convertTTLtoExpirationDate();
                            }
                            this.m_expSubs.insert(si.m_bs);
                        }
                        if (si.m_isJMSDurable || cc.isDurable() && cc.getClientSessionVer() < 28) {
                            BrokerSubscription durbs = cc.getDurableBrokerSubscription();
                            this.setupCWADSInfo(si, cc, evt, durbs, si.m_gsExpirableSubject, propagate_for_cwads, SMOtoNonSMODowngrade);
                        }
                        this.setupGSInfo(si, evt, si.m_gsExpirableSubject);
                        if (si.m_isJMSDurable && this.DEBUG) {
                            this.debug("CWADS_DEBUG: subscribe processing \n type = " + evt.type() + "\n subject = " + si.m_bs.getSubject() + "\n appid = " + cc.getAppid() + "\n bs.getDurableStrictMessageOrder : " + si.m_bs.getDurableStrictMessageOrder());
                        }
                        if (((evt.getDurableModification() & 2) > 0 || si.m_bs.getUnfiltered()) && cc.isPendingReconnect()) {
                            waitForStalePubDispatches = true;
                        }
                        this.setUnfilteredFlag(si, unfiltered);
                        if (si.m_needsLog || si.m_needsReplicationOnly) {
                            if (si.m_needsReplicationOnly) {
                                evt.setReplicateOnly(true);
                            }
                            boolean CWADSFlush = false;
                            if (cc != null && InterbrokerHook.isSet() && cc.getProxyingHandle() != null) {
                                cc.getProxyingHandle().addSubscribeEvt(evt);
                                CWADSFlush = true;
                            }
                            this.getLogManager().addEvent(evt, evt.getRequest() != null || CWADSFlush || si.m_remoteSubscription || si.m_gsExpirableSubject);
                            if (this.DEBUG) {
                                this.debug("CWADS_DEBUG: subscribe processing LOGGING subcribe evt\n type = " + evt.type() + "\n subject = " + si.m_bs.getSubject() + "\n appid = " + cc.getAppid() + "\n bs.getDurableStrictMessageOrder : " + si.m_bs.getDurableStrictMessageOrder());
                            }
                        }
                    }
                }
                if ((si.m_persistent || si.m_needsLog) && !cc.isDirty()) {
                    cc.setDirty(true);
                    Long ID = new Long(id);
                    this.m_dirtyClients.put(ID, ID);
                }
            }
            finally {
                cc.unlock();
            }
            if (waitForStalePubDispatches) {
                this.m_msgproc.lockPubDispatch();
                try {
                    cc.waitForPubDispatches();
                }
                finally {
                    this.m_msgproc.unlockPubDispatch();
                }
            }
            if (!si.m_needsLog && !si.m_needsReplicationOnly) {
                evt.localSubscribeDone();
            }
            try {
                if (evt.getSubject().isTemporary() || !SessionConfig.isSystemSubject(evt.getSubject()) && !evt.getSubject().isSonicMQSubject() && !evt.getSuppressCWADSPropagation()) {
                    String userID = null;
                    if (remoteUserID == null) {
                        userID = this.getClient(id).getUid();
                    }
                    String appID = this.getClient(id).getAppid();
                    String connectID = null;
                    String clientID = null;
                    String subscriptionName = null;
                    String topicName = si.m_bs.getSubject().getLookupName();
                    if (!si.m_persistent) {
                        connectID = SessionConfig.getConnectIDFromSubscriberAppid(appID);
                    } else {
                        AgentConnection ac = cc.getConnection();
                        AgentListener al = null;
                        String chan0AppID = null;
                        if (ac != null) {
                            al = ac.getAgentListener();
                        }
                        if (al != null) {
                            chan0AppID = al.getChan0Appid();
                        }
                        if (chan0AppID != null) {
                            connectID = chan0AppID.substring(0, chan0AppID.indexOf("$CONNECTION$"));
                        }
                        clientID = DurableSubscriptionUtil.getJMSClientID(appID);
                        subscriptionName = DurableSubscriptionUtil.getSubscriptionName(appID);
                    }
                    if (!newSubscription) {
                        BrokerManagementNotificationsHelper.sendBrokerSubscriberResumeNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, userID, clientID, connectID, topicName, subscriptionName);
                    } else {
                        BrokerManagementNotificationsHelper.sendBrokerSubscribeNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, userID, clientID, connectID, topicName, subscriptionName, remoteNodeName, remoteBrokerName, remoteUserID);
                    }
                    if (this.DEBUG) {
                        System.out.println("AR.subscribeInternal: userID = " + userID + ", appID = " + appID + ", connectID = " + connectID + ", subscriptionName = " + subscriptionName + ", subject = " + si.m_subject);
                    }
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block60;
                this.debug("Exception while attempting to send open receiver notification...", e);
            }
        }
        if (this.DEBUG) {
            this.debug("subscribe done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void recoverSubscribe(SubscribeEvt evt, Boolean unfiltered, boolean onStandby) throws EClientNotRegistered, EOldVirtualClockException, EInvalidSubjectSyntax, ParseException {
        IClientContext cc;
        long id = evt.getClientId();
        SubscriptionInfo si = new SubscriptionInfo();
        si.m_subject = evt.getSubject();
        si.m_label = evt.getLabel();
        si.m_persistent = si.m_label.isPersistent();
        si.m_remoteSubscription = false;
        si.m_gsExpirableSubject = evt.getSubject().equals("$ISYS.GSA.expirableSubject");
        if (this.DEBUG) {
            this.debug("subscribing client " + id + " to " + si.m_subject);
        }
        if ((cc = this.lockContext(id)) == null) {
            throw new EClientNotRegistered(id);
        }
        try {
            Object object = this.m_subscriptionMutex;
            // MONITORENTER : object
            if (si.m_persistent || cc.isConnected() || onStandby && evt.isReplicateOnly() && cc.isXOnce() && !SessionConfig.isSystemSubject(si.m_subject)) {
                this.retrieveSubscriptionInfo(si, evt, cc);
                boolean SMOtoNonSMODowngrade = this.setupBrokerSubscription(si, evt, cc);
                this.setupRemoteSubscription(si, cc);
                if (si.m_oldSub != null) {
                    if (this.DEBUG) {
                        this.debug("BrokerSubscription FOUND already existed bs =" + si.m_bs);
                    }
                    try {
                        this.checkVirtualClock(si, evt);
                    }
                    catch (EOldVirtualClockException eovce) {
                        // MONITOREXIT : object
                        cc.unlock();
                        return;
                    }
                    if (si.m_persistent && si.m_bs.isExpirable() && si.m_bs.hasTTE()) {
                        this.m_expSubs.remove(si.m_bs);
                    }
                    this.performSubscriptionUpdate(si, evt, true, cc);
                } else {
                    if (this.DEBUG) {
                        this.debug("Created new BrokerSubscription. Could NOT find bs = " + si.m_bs);
                    }
                    si.loadInfoIntoBS(evt);
                    if (si.m_remoteSubscription && si.m_firstBrokerSubscription) {
                        this.addRecoveredSubscription(si.m_remoteNodeCC.getId(), si.m_mergedSub, false);
                    }
                    this.addRecoveredSubscription(cc.getId(), si.m_bs, Config.ENABLE_INTERBROKER && !si.m_remoteSubscription && !si.m_gsExpirableSubject);
                }
                if (si.m_persistent && si.m_bs.isExpirable()) {
                    if (this.DEBUG) {
                        this.debug("SubscribeEvt from log or db has subscription with Expiration.");
                    }
                    if (!onStandby || si.m_bs.hasTTE()) {
                        if (!onStandby) {
                            si.m_bs.convertTTLtoExpirationDate();
                        }
                        this.m_expSubs.insert(si.m_bs);
                    }
                }
                if (cc.isDurable()) {
                    BrokerSubscription durbs = this.getRecoveredDurableBrokerSubscription(cc.getId());
                    this.setupCWADSInfo(si, cc, evt, durbs, si.m_gsExpirableSubject, false, SMOtoNonSMODowngrade);
                }
                this.setupGSInfo(si, evt, si.m_gsExpirableSubject);
                if (si.m_isJMSDurable && this.DEBUG) {
                    this.debug("CWADS_DEBUG: subscribe processing \n type = " + evt.type() + "\n subject = " + si.m_bs.getSubject() + "\n appid = " + cc.getAppid() + "\n bs.getDurableStrictMessageOrder : " + si.m_bs.getDurableStrictMessageOrder());
                }
                this.setUnfilteredFlag(si, unfiltered);
            }
            // MONITOREXIT : object
            if (si.m_persistent && !cc.isDirty()) {
                cc.setDirty(true);
                Long ID = new Long(id);
                this.m_dirtyClients.put(ID, ID);
            }
        }
        finally {
            cc.unlock();
        }
        evt.localSubscribeDone();
        if (!this.DEBUG) return;
        this.debug("subscribe done");
    }

    private void setUnfilteredFlag(SubscriptionInfo si, Boolean unfiltered) {
        if (si.m_isJMSDurable) {
            if (unfiltered == null) {
                String selectorString = si.m_bs.getSelectorString();
                if (selectorString == null || selectorString.length() > 0 && !si.m_isSelectorAtBroker) {
                    si.m_bs.setUnfiltered(true);
                } else if (si.m_oldSub == null) {
                    si.m_bs.setUnfiltered(false);
                }
            } else {
                si.m_bs.setUnfiltered(unfiltered);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCWADSInfo(SubscriptionInfo si, IClientContext cc, SubscribeEvt evt, BrokerSubscription durbs, boolean gsExpirableSubject, boolean propagate_for_cwads, boolean SMOtoNonSMODowngrade) {
        if (Config.ENABLE_INTERBROKER && !si.m_remoteSubscription && !gsExpirableSubject) {
            if (this.DEBUG) {
                this.debug("CWADS_DEBUG: processing subscribe Update \n type = " + evt.type() + "\n subject = " + si.m_bs.getSubject() + "\n appid = " + cc.getAppid());
            }
            if (durbs != null) {
                durbs.setCreationTime(evt.getCreationTime());
            }
            if (propagate_for_cwads && !evt.getSuppressCWADSPropagation() && durbs != null && cc.isConnected()) {
                try {
                    cc.getProxyingHandle().lockProxy();
                    if (cc.getState() <= 2) {
                        cc.setCWADSActiveBroker(cc, SMOtoNonSMODowngrade);
                    } else if (this.DEBUG_UNEXPECTED) {
                        BrokerComponent.logMessage(new EAssertFailure("Skipping setCWADSActiveBroker for " + cc.getUid() + "/" + cc.getAppid() + " in state: " + cc.getState()), BrokerComponent.getLevelWarning());
                    }
                    IClientContext previousCC = cc.getCWADSPreviousBroker();
                    if (previousCC != null) {
                        evt.setPreviousBrokerCID(previousCC.getId());
                    } else {
                        evt.setPreviousBrokerCID(-1L);
                    }
                    IClientContext rbcc = cc.getCWADSRestoringBroker();
                    if (rbcc != null) {
                        evt.setRestoreToBrokerCID(rbcc.getId());
                    } else {
                        evt.setRestoreToBrokerCID(-1L);
                    }
                }
                finally {
                    cc.getProxyingHandle().unlockProxy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSubscriptionUpdate(SubscriptionInfo si, SubscribeEvt evt, boolean logged, IClientContext cc) throws ParseException, EInvalidSubjectSyntax {
        if (!si.m_bs.getLabel().equals(si.m_label)) {
            if (this.DEBUG) {
                this.debug("Label is different for bs = " + si.m_bs);
            }
            if (!si.m_persistent && si.m_bs.getLabel().isPersistent() && !logged) {
                si.m_needsLog = true;
            }
            si.m_bs.setLabel(si.m_label);
        }
        si.m_bs.setTTE(si.m_TTE);
        si.m_isOldSelectorAtBroker = si.m_oldSub.getSelectorAtBroker();
        if (si.m_isSelectorAtBroker && si.m_isOldSelectorAtBroker) {
            si.m_addedSelectors = new Vector(1);
            si.m_removedSelectors = new Vector(1);
        }
        si.m_bs.setMessageSelectors(si.m_selectors, si.m_addedSelectors, si.m_removedSelectors);
        if (si.m_isSelectorAtBroker && si.m_isOldSelectorAtBroker && si.m_selectors == null && si.m_removedSelectors.size() > 0) {
            si.m_addedSelectors.clear();
            si.m_addedSelectors.addElement("");
        }
        si.m_bs.setSelectorAtBroker(si.m_isSelectorAtBroker);
        si.m_bs.setVirtualClock(si.m_vc);
        si.m_bs.setCreationTime(evt.getCreationTime());
        if (evt.getDurableModification() != 0) {
            if (this.m_recoveredSubscriptions != null) {
                RecoveredSubscriptions subs = (RecoveredSubscriptions)this.m_recoveredSubscriptions.get(new Long(cc.getId()));
                subs.removeSubscription(si.m_oldSubject);
                si.m_bs.setSubject(evt.getSubject());
                subs.addSubscription(si.m_bs, false);
            } else {
                si.m_bs.setSubject(evt.getSubject());
                SubscriptionsTable subs = cc.getSubscriptions();
                Object object = subs;
                synchronized (object) {
                    ((Hashtable)subs).put(evt.getSubject(), si.m_bs);
                    subs.remove((Object)si.m_oldSubject);
                }
                if (cc.isDurable() && si.m_label.isPersistent()) {
                    cc.setDurableBrokerSubscription(si.m_bs);
                }
                if (si.m_oldSubject.hasGroup()) {
                    this.m_groupSubs.groupSubjectModified(si.m_oldSubject, si.m_bs, evt.getAddedSubject(), evt.getRemovedSubject());
                } else {
                    object = this.m_regSub;
                    synchronized (object) {
                        this.m_regSub.removeSubscription(si.m_oldSubject, cc);
                        this.m_regSub.put(evt.getSubject(), (ISubjectMatchObject)si.m_bs);
                    }
                }
            }
        }
    }

    private void checkVirtualClock(SubscriptionInfo si, SubscribeEvt evt) throws EOldVirtualClockException {
        GSVirtualClock currentVc = si.m_bs.getVirtualClock();
        if (si.m_vc != null && currentVc != null && si.m_vc.compareTo(currentVc) < 0) {
            evt.setErrorCode(-25);
            throw new EOldVirtualClockException("Virtual clock:" + si.m_vc + " staler than:" + currentVc);
        }
    }

    private void retrieveSubscriptionInfo(SubscriptionInfo si, SubscribeEvt evt, IClientContext cc) {
        if (evt instanceof GSSubscribeEvt) {
            si.m_remoteSubscription = true;
            GSSubscribeEvt sEvt = (GSSubscribeEvt)evt;
            si.m_selectors = sEvt.getMessageSelectors();
            si.m_isSelectorAtBroker = sEvt.getSelectorAtBroker();
            si.m_vc = sEvt.getVirtualClock();
        } else if (evt instanceof SubscribeEvtForSelector) {
            SubscribeEvtForSelector sEvt = (SubscribeEvtForSelector)evt;
            si.m_selectors = sEvt.getMessageSelectors();
            si.m_isSelectorAtBroker = sEvt.getSelectorAtBroker();
        }
        si.m_TTE = evt.getTTE();
        if (si.m_persistent && cc.isDurable()) {
            si.m_isJMSDurable = true;
        }
    }

    private boolean setupBrokerSubscription(SubscriptionInfo si, SubscribeEvt evt, IClientContext cc) {
        boolean SMOtoNonSMODowngrade = false;
        si.m_mergedSub = null;
        si.m_bs = this.m_recoveredSubscriptions != null ? (evt.getDurableModification() == 0 ? this.getRecoveredSubscription(cc.getId(), si.m_subject) : this.getRecoveredDurableBrokerSubscription(cc.getId())) : (evt.getDurableModification() == 0 ? (BrokerSubscription)cc.getSubscriptions().get(si.m_subject) : cc.getDurableBrokerSubscription());
        si.m_oldSub = si.m_bs;
        si.m_firstBrokerSubscription = false;
        if (si.m_oldSub != null) {
            si.m_oldSubject = si.m_oldSub.getSubject();
        }
        if (si.m_bs == null) {
            si.m_bs = new BrokerSubscription(cc, si.m_subject, si.m_label);
        }
        si.m_bs.setFlowToDisk(evt.getFlowToDisk());
        if (!SessionConfig.isSystemSubject(si.m_subject)) {
            cc.setFlowToDisk(evt.getFlowToDisk());
        }
        if (si.m_isJMSDurable) {
            if (si.m_oldSub != null && si.m_oldSub.getDurableStrictMessageOrder() && si.m_oldSub.getDurableStrictMessageOrder() != evt.getDurableStrictMessageOrder()) {
                SMOtoNonSMODowngrade = true;
            }
            if (this.DEBUG) {
                this.debug("setupBrokerSubscription bs.setDurableStrictMessageOrder evt.getDurableStrictMessageOrder(): " + evt.getDurableStrictMessageOrder());
            }
            si.m_bs.setDurableStrictMessageOrder(evt.getDurableStrictMessageOrder());
        }
        return SMOtoNonSMODowngrade;
    }

    private void doSecurityCheck(SubscriptionInfo si, IClientContext cc, SubscribeEvt evt) throws EUnauthorizedClient {
        ClientSecurityContext csc = cc.getCSC();
        if (Config.ENABLE_ACCESS_MEDIATION) {
            if (!Authorize.checkPermission(cc.getPrincipal(), si.m_subject, 2)) {
                if (cc.isQueueBrowser()) {
                    if (!Authorize.checkPermission(cc.getPrincipal(), si.m_subject, 8)) {
                        evt.setErrorCode(-7);
                        throw new EUnauthorizedClient();
                    }
                } else {
                    evt.setErrorCode(-7);
                    throw new EUnauthorizedClient();
                }
            }
            if (si.m_label.isGuaranteed() && SessionConfig.isSystemSubject(si.m_subject) && !Authorize.checkPermission(cc.getPrincipal(), si.m_subject, 4)) {
                evt.setErrorCode(-8);
                throw new EUnauthorizedClient();
            }
        } else if (si.m_label.isGuaranteed() && csc.isAnonymous() && SessionConfig.isSystemSubject(si.m_subject)) {
            evt.setErrorCode(-8);
            throw new EUnauthorizedClient();
        }
    }

    private void setupGSInfo(SubscriptionInfo si, SubscribeEvt evt, boolean gsExpirableSubject) {
        if (this.getGSManager() != null && !gsExpirableSubject) {
            if (si.m_oldSub == null) {
                if (si.m_isSelectorAtBroker) {
                    si.m_addedSelectors = null;
                } else {
                    si.m_addedSelectors = new Vector(1);
                    si.m_addedSelectors.addElement("");
                }
                si.m_removedSelectors = null;
            } else if (si.m_isSelectorAtBroker) {
                if (!si.m_isOldSelectorAtBroker) {
                    si.m_addedSelectors = null;
                    si.m_removedSelectors = new Vector(1);
                    si.m_removedSelectors.addElement("");
                }
            } else if (si.m_isOldSelectorAtBroker) {
                si.m_addedSelectors = new Vector(1);
                si.m_addedSelectors.addElement("");
                si.m_selectors = si.m_bs.getSelectorStrings();
                if (si.m_selectors != null) {
                    si.m_removedSelectors = new Vector(si.m_selectors.length);
                    for (int ii = 0; ii < si.m_selectors.length; ++ii) {
                        si.m_removedSelectors.addElement(si.m_selectors[ii]);
                    }
                } else {
                    si.m_removedSelectors = new Vector(1);
                    si.m_removedSelectors.addElement("");
                }
            } else {
                si.m_addedSelectors = new Vector(1);
                si.m_removedSelectors = null;
            }
            this.getGSManager().globalSubscribe(si.m_bs, si.m_oldSub == null, evt.getSuppressNotification(), si.m_addedSelectors, si.m_removedSelectors, evt.getAddedSubject(), evt.getRemovedSubject());
        }
    }

    private void setupRemoteSubscription(SubscriptionInfo si, IClientContext cc) {
        if (si.m_remoteSubscription) {
            try {
                si.m_remoteNodeCC = this.getClient(this.m_routerMgr.getRemoteNodeGSClientID(cc.getRemoteNode()));
            }
            catch (EClientNotRegistered ex) {
                // empty catch block
            }
            if (si.m_remoteNodeCC == null) {
                si.m_remoteNodeCC = this.getGSManager().createRemoteNodeCC(cc.getRemoteNode());
            }
            si.m_mergedSub = this.m_recoveredSubscriptions != null ? (MergedBrokerSubscription)this.getRecoveredSubscription(si.m_remoteNodeCC.getId(), si.m_subject) : (MergedBrokerSubscription)si.m_remoteNodeCC.getSubscriptions().get(si.m_subject);
            if (si.m_mergedSub == null) {
                Label mLab = (Label)si.m_label.clone();
                mLab.setGuaranteed(false);
                mLab.setPersistent(false);
                si.m_mergedSub = new MergedBrokerSubscription(si.m_remoteNodeCC, si.m_subject, mLab);
                si.m_mergedSub.setSelectorAtBroker(true);
                this.m_gsManager.allocateGSTracker(si.m_mergedSub);
            }
            si.m_firstBrokerSubscription = si.m_mergedSub.addSubscription(si.m_bs);
        }
    }

    public void redeliverSubscriptions() {
        if (!this.m_recoveredSubscriptions.isEmpty()) {
            for (RecoveredSubscriptions rsubs : this.m_recoveredSubscriptions.values()) {
                rsubs.redeliverSubscriptions();
            }
        }
        this.m_recoveredSubscriptions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCWADSContexts(String subject) {
        IClientContext cc = null;
        String appID = null;
        Enumeration enu = null;
        Vector<IClientContext> durablesubs = new Vector<IClientContext>();
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            enu = this.m_regCl.elements();
        }
        try {
            while (enu.hasMoreElements()) {
                cc = (IClientContext)enu.nextElement();
                appID = cc.getAppid();
                if (this.DEBUG) {
                    this.debug("CWADS_DEBUG: getCWADSContexts found DS \n appid = " + cc.getAppid() + "\n uid = " + cc.getCSC().getUid() + "\n active = " + cc.getCWADSActiveBroker());
                }
                if (!appID.startsWith("$DURABLE$")) continue;
                if (this.DEBUG) {
                    this.debug("CWADS_DEBUG: getCWADSContexts DS " + appID + " is CWADS available");
                }
                durablesubs.add(cc);
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            durablesubs.removeAllElements();
        }
        return durablesubs;
    }

    public AgentSubjectSpace getSubjectSpace() {
        return this.m_regSub;
    }

    public final boolean removeExternalUserFromSecBean(String uidToRemoveFromCache) {
        try {
            if (!Config.ENABLE_SECURITY || this.m_secBean == null || uidToRemoveFromCache == null || uidToRemoveFromCache.trim().length() == 0) {
                return false;
            }
            ProgressPasswordUser user = this.m_secBean.getUser(uidToRemoveFromCache);
            if (user == null) {
                return false;
            }
            if (user.isInternalPrincipal()) {
                return false;
            }
            if (user.isCreatedDueToACLEntry()) {
                return false;
            }
            Map groupMap = null;
            ExternalDomainAuthSPIConfig authConfig = AgentRegistrar.getExternalDomainAuthSPIConfig();
            if (authConfig != null) {
                groupMap = authConfig.getGroupMap();
            }
            ArrayList externalGroups = user.getExternalGroups();
            if (groupMap != null && groupMap.size() != 0 && externalGroups != null && externalGroups.isEmpty()) {
                ArrayList<String> internalGroupsToRemoveFrom = new ArrayList<String>();
                internalGroupsToRemoveFrom.add("PUBLIC");
                for (String internalGroupName : groupMap.keySet()) {
                    String values = (String)groupMap.get(internalGroupName);
                    if (values == null) continue;
                    StringTokenizer st = new StringTokenizer(values, ",", false);
                    String s = null;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s == null || !externalGroups.contains(s)) continue;
                        internalGroupsToRemoveFrom.add(internalGroupName);
                    }
                }
                for (String groupName : internalGroupsToRemoveFrom) {
                    ProgressGroup group = this.m_secBean.getGroup(groupName);
                    if (group == null) continue;
                    Enumeration enumeration = group.members();
                    while (enumeration.hasMoreElements()) {
                        ProgressPasswordUser groupMember;
                        Object element = enumeration.nextElement();
                        if (!(element instanceof ProgressPasswordUser) || (groupMember = (ProgressPasswordUser)element).isInternalPrincipal() || !groupMember.getName().equals(user.getName()) || groupMember.isCreatedDueToACLEntry()) continue;
                        group.removeMember(user);
                    }
                }
            }
            try {
                this.m_secBean.delUser(uidToRemoveFromCache);
                return true;
            }
            catch (IOException ioe) {
                Object[] obj = new Object[]{uidToRemoveFromCache};
                String s = prMessageFormat.format(prAccessor.getString("STR364"), obj) + " " + ioe.getMessage();
                BrokerComponent.getComponentContext().logMessage(s, 2);
            }
        }
        catch (Exception e) {
            Object[] obj = new Object[]{uidToRemoveFromCache};
            String s = prMessageFormat.format(prAccessor.getString("STR364"), obj);
            BrokerComponent.getComponentContext().logMessage(s, 2);
        }
        return false;
    }

    public final void unsubscribe(UnsubscribeEvt evt) throws EClientNotRegistered, EOldVirtualClockException, InterruptedException {
        try {
            this.unsubscribe(evt, false);
        }
        catch (EUserAlreadyConnected eUserAlreadyConnected) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void unsubscribe(UnsubscribeEvt evt, boolean checkCCConnected) throws EClientNotRegistered, EOldVirtualClockException, InterruptedException, EUserAlreadyConnected {
        block67: {
            block65: {
                id = evt.getClientId();
                subject = evt.getSubject();
                logged = evt.isLogged();
                vc = evt.getVirtualClock();
                needsLog = false;
                needsReplicationOnly = false;
                persistent = false;
                remoteSubscription = false;
                gsExpirableSubject = evt.getSubject().equals("$ISYS.GSA.expirableSubject");
                connectID = null;
                if (this.DEBUG) {
                    this.debug("unsubscribing client " + id + " from " + subject);
                }
                if ((cc = this.lockContext(id)) == null) {
                    throw new EClientNotRegistered(id);
                }
                if (checkCCConnected && cc.isConnected()) {
                    if (this.DEBUG) {
                        this.debug(new Date(System.currentTimeMillis()) + " cc is connected skipping unsubscribe for cc " + id + " from " + subject);
                    }
                    cc.unlock();
                    throw new EUserAlreadyConnected(cc.getAppid());
                }
                remoteNodeCC = null;
                remoteNodeName = null;
                remoteBrokerName = null;
                remoteUserID = null;
                mergedSub = null;
                freeGSTracker = false;
                bs = null;
                try {
                    var22_21 = this.m_subscriptionMutex;
                    synchronized (var22_21) {
                        if (vc != null) {
                            currentVc = null;
                            gbs = (BrokerSubscription)cc.getSubscriptions().get(subject);
                            if (gbs != null) {
                                currentVc = gbs.getVirtualClock();
                            }
                            if (vc != null && currentVc != null && vc.compareTo(currentVc) < 0) {
                                throw new EOldVirtualClockException("Virtual clock:" + vc + " staler than:" + currentVc);
                            }
                        }
                        if ((remoteNodeName = cc.getRemoteNode()) != null && !subject.getSubjectString().equals("$ISYS.GSA.expirableSubject")) {
                            remoteSubscription = true;
                            try {
                                remoteNodeCC = this.getClient(this.m_routerMgr.getRemoteNodeGSClientID(cc.getRemoteNode()));
                                if (remoteNodeCC != null) {
                                    p = this.m_gsManager.getRemoteNodePrincipal(remoteNodeName);
                                    if (p != null) {
                                        remoteUserID = p.getName();
                                    }
                                    remoteBrokerName = RouterManager.getRemoteBrokerFromGSAppID(cc.getAppid());
                                }
                            }
                            catch (EClientNotRegistered ex) {
                                // empty catch block
                            }
                        }
                        bs = cc.getSubscriptions().remove(subject);
                        cc.checkSpecialGroupSubscription();
                        if (bs != null) {
                            lastBrokerSubscription = false;
                            persistent = bs.getLabel().isPersistent();
                            needsLog = persistent != false && logged == false;
                            v0 = needsReplicationOnly = bs.isReplicateOnly() != false && logged == false;
                            if (persistent && bs.isExpirable() && bs.hasTTE()) {
                                this.m_expSubs.remove(bs);
                            }
                            if (persistent && cc.isDurable()) {
                                cc.setDurableBrokerSubscription(null);
                            }
                            if (remoteSubscription && (lastBrokerSubscription = (mergedSub = bs.getParent()).removeSubscription(bs))) {
                                freeGSTracker = true;
                                if (remoteNodeCC != null) {
                                    remoteNodeCC.getSubscriptions().remove(subject);
                                }
                            }
                            if (!bs.isGroupMember()) {
                                if (remoteSubscription) {
                                    if (lastBrokerSubscription && remoteNodeCC != null) {
                                        this.m_regSub.removeSubscription(subject, remoteNodeCC);
                                    }
                                } else {
                                    this.m_regSub.removeSubscription(subject, cc);
                                }
                            }
                            cc.releasePublishersBlockedOnDbSpace();
                            if (InterbrokerHook.isSet() && !remoteSubscription && !gsExpirableSubject) {
                                if (cc.getAppid().startsWith("$DURABLE$")) {
                                    if (this.DEBUG) {
                                        this.debug("CWADS_DEBUG: processing cwads unsubscribe evt  subject = " + bs.getSubject() + "\n appid = " + cc.getAppid() + "\n active broker = " + cc.getCWADSActiveBroker());
                                    }
                                    if (!evt.getSuppressCWADSPropagation() && !SessionConfig.isSystemSubject(bs.getSubject()) && bs.getLabel().isPersistent()) {
                                        InterbrokerHook.notifyCWADSEvent(102, cc, bs);
                                    }
                                    if (cc.getClientSessionVer() < 28) {
                                        try {
                                            if (cc.getProxyingHandle() == null) ** GOTO lbl93
                                            cc.getProxyingHandle().lockProxy();
                                            cc.setCWADSActiveBroker(null, true);
                                        }
                                        finally {
                                            if (cc.getProxyingHandle() != null) {
                                                cc.getProxyingHandle().unlockProxy();
                                            }
                                        }
                                    }
                                } else {
                                    InterbrokerHook.unsubscribeEvent(bs);
                                }
                            }
                        }
lbl93:
                        // 8 sources

                        if (needsLog || needsReplicationOnly) {
                            if (needsReplicationOnly) {
                                evt.setReplicateOnly(true);
                            }
                            cc.waitForPubDispatches();
                            seqno = this.getLogManager().getSeqNo();
                            this.getDeleteSubscriptionManager().registerIdForDeletion(cc, cc.getId(), seqno, evt.isReplicateOnly());
                            this.getLogManager().addEvent(evt, true);
                        }
                        if (this.getGSManager() != null && bs != null && !gsExpirableSubject) {
                            this.getGSManager().globalUnsubscribe(bs);
                        }
                        if (bs != null) {
                            this.checkUnregister(cc);
                        }
                    }
                    if (persistent && !cc.isDirty()) {
                        cc.setDirty(true);
                        ID = new Long(id);
                        this.m_dirtyClients.put(ID, ID);
                    }
                    if (bs == null || !bs.isGroupMember()) break block65;
                    ID = this.m_subscriptionMutex;
                    synchronized (ID) {
                        this.m_groupSubs.removeSubscription(bs);
                    }
                }
                finally {
                    cc.unlock();
                    if (needsLog || needsReplicationOnly) {
                        this.deleteSubscriberMessages(id, cc, evt.getSeqNo(), true, evt.isReplicateOnly());
                    }
                    if (!logged && (tracker = this.getDurableManager().getDurableTracker(cc.getId())) != null) {
                        tracker.reset();
                    }
                }
            }
            if (remoteNodeCC != null && mergedSub != null && freeGSTracker) {
                remoteNodeCC.lock();
                try {
                    if (remoteNodeCC.getSubscriptions().get(mergedSub.getSubject()) == null) {
                        this.m_gsManager.freeGSTracker(mergedSub);
                    }
                }
                finally {
                    remoteNodeCC.unlock();
                }
            }
            if (!needsLog && !needsReplicationOnly) {
                evt.localUnsubscribeDone();
            }
            try {
                if (subject.isTemporary() || !SessionConfig.isSystemSubject(subject) && !subject.isSonicMQSubject() && !evt.getSuppressCWADSPropagation()) {
                    userID = null;
                    if (remoteUserID == null) {
                        userID = cc.getUid();
                    }
                    if ((appID = cc.getAppid()) == null) {
                        appID = "";
                    }
                    clientID = null;
                    subscriptionName = null;
                    if (persistent && connectID == null) {
                        ac = cc.getConnection();
                        al = null;
                        chan0AppID = null;
                        if (ac != null) {
                            al = ac.getAgentListener();
                        }
                        if (al != null) {
                            chan0AppID = al.getChan0Appid();
                        }
                        if (chan0AppID != null) {
                            connectID = chan0AppID.substring(0, chan0AppID.indexOf("$CONNECTION$"));
                        }
                        clientID = DurableSubscriptionUtil.getJMSClientID(appID);
                        subscriptionName = DurableSubscriptionUtil.getSubscriptionName(appID);
                    } else {
                        connectID = SessionConfig.getConnectIDFromSubscriberAppid(appID);
                    }
                    BrokerManagementNotificationsHelper.sendBrokerUnsubscribeNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, userID, clientID, connectID, subject.getSubjectString(), subscriptionName, remoteNodeName, remoteBrokerName, remoteUserID);
                    if (this.DEBUG) {
                        System.out.println("AR.unsubscribeInternal: userID = " + userID + ", appID = " + appID + ", connectID = " + connectID + ", subscriptionName = " + subscriptionName + ", topicName = " + subject);
                    }
                }
            }
            catch (Exception e) {
                if (!this.DEBUG) break block67;
                this.debug("Exception while attempting to send unsubscribe notification, e = " + e.getMessage(), e);
            }
        }
        if (this.DEBUG) {
            this.debug("unsubscribe done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverUnsubscribe(UnsubscribeEvt evt) throws EClientNotRegistered, EOldVirtualClockException, InterruptedException {
        IClientContext cc;
        long id = evt.getClientId();
        ISubject subject = evt.getSubject();
        GSVirtualClock vc = evt.getVirtualClock();
        boolean persistent = false;
        boolean remoteSubscription = false;
        boolean gsExpirableSubject = evt.getSubject().equals("$ISYS.GSA.expirableSubject");
        if (this.DEBUG) {
            this.debug("unsubscribing client " + id + " from " + subject);
        }
        if ((cc = this.lockContext(id)) == null) {
            throw new EClientNotRegistered(id);
        }
        IClientContext remoteNodeCC = null;
        MergedBrokerSubscription mergedSub = null;
        boolean freeGSTracker = false;
        try {
            Object object = this.m_subscriptionMutex;
            synchronized (object) {
                BrokerSubscription bs;
                block32: {
                    if (vc == null) break block32;
                    GSVirtualClock currentVc = null;
                    BrokerSubscription bs2 = this.getRecoveredSubscription(cc.getId(), subject);
                    if (bs2 != null) {
                        currentVc = bs2.getVirtualClock();
                    }
                    if (vc == null || currentVc == null || vc.compareTo(currentVc) >= 0) break block32;
                    return;
                }
                if (cc.getRemoteNode() != null && !subject.equals("$ISYS.GSA.expirableSubject")) {
                    remoteSubscription = true;
                    try {
                        remoteNodeCC = this.getClient(this.m_routerMgr.getRemoteNodeGSClientID(cc.getRemoteNode()));
                    }
                    catch (EClientNotRegistered ex) {
                        // empty catch block
                    }
                }
                if ((bs = this.removeRecoveredSubscription(cc.getId(), subject)) != null) {
                    boolean lastBrokerSubscription = false;
                    persistent = bs.getLabel().isPersistent();
                    if (persistent && bs.isExpirable() && bs.hasTTE()) {
                        this.m_expSubs.remove(bs);
                    }
                    if (remoteSubscription) {
                        mergedSub = bs.getParent();
                        if (mergedSub == null) {
                            String assertion = "AgentRegistrar.recoverUnsubscribe(): merged subscription not set on a remote subscription, subject = " + subject + ", remote client = " + cc + ", remote node = " + cc.getRemoteNode() + ", remote node client = " + remoteNodeCC;
                            if (remoteNodeCC == null) {
                                throw new NullPointerException("remoteNodeCC is null at " + this.getClass().getName() + ".recoverUnsubscribe( UnsubscribeEvt evt )");
                            }
                            MergedBrokerSubscription mergedSubForRemoteNode = (MergedBrokerSubscription)this.getRecoveredSubscription(remoteNodeCC.getId(), subject);
                            if (mergedSubForRemoteNode != null) {
                                mergedSub = mergedSubForRemoteNode;
                            } else {
                                assertion = "AgentRegistrar.recoverUnsubscribe(): merged subscription not found for a remote subscription, subject = " + subject + ", remote client = " + cc + ", remote node = " + cc.getRemoteNode() + ", remote node client = " + remoteNodeCC;
                            }
                            BrokerComponent.getComponentContext().logMessage(assertion, 2);
                        }
                        if (mergedSub != null) {
                            lastBrokerSubscription = mergedSub.removeSubscription(bs);
                        }
                        if (lastBrokerSubscription) {
                            freeGSTracker = true;
                            if (remoteNodeCC != null) {
                                this.removeRecoveredSubscription(remoteNodeCC.getId(), subject);
                            }
                        }
                    }
                }
                if (this.getGSManager() != null && bs != null && !gsExpirableSubject) {
                    this.getGSManager().globalUnsubscribe(bs);
                }
                this.checkUnregister(cc);
            }
            if (persistent && !cc.isDirty()) {
                cc.setDirty(true);
                Long ID = new Long(id);
                this.m_dirtyClients.put(ID, ID);
            }
        }
        finally {
            cc.unlock();
        }
        if (remoteNodeCC != null && mergedSub != null && freeGSTracker) {
            remoteNodeCC.lock();
            try {
                if (remoteNodeCC.getSubscriptions().get(mergedSub.getSubject()) == null) {
                    this.m_gsManager.freeGSTracker(mergedSub);
                }
            }
            finally {
                remoteNodeCC.unlock();
            }
        }
        evt.localUnsubscribeDone();
        if (this.DEBUG) {
            this.debug("unsubscribe done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logDurableSubscriptionSMOUpdate(boolean waitForFlush, IClientContext cc, DurableSMOUpdateEvt evt) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("logDurableSubscriptionSMOUpdate waitForFlush= " + waitForFlush + " cc " + cc + " evt: " + evt);
        }
        Object object = cc.getSyncObj();
        synchronized (object) {
            if (this.DEBUG) {
                this.debug("logDurableSubscriptionSMOUpdate cc.getId(): " + cc.getId() + " client marked as dirty");
            }
            if (!cc.isDirty()) {
                cc.setDirty(true);
                Long ID = new Long(cc.getId());
                this.m_dirtyClients.put(ID, ID);
            }
        }
        this.m_logmgr.addEvent(evt, true);
        if (this.DEBUG) {
            this.debug("logDurableSubscriptionSMOUpdate cc.getId(): " + cc.getId() + " flushed event dispatcher");
        }
        if (waitForFlush) {
            if (this.DEBUG) {
                this.debug("logDurableSubscriptionSMOUpdate cc.getId(): " + cc.getId() + " waiting for event flush");
            }
            this.m_logmgr.waitForFlush(evt);
            if (this.DEBUG) {
                this.debug("logDurableSubscriptionSMOUpdate cc.getId(): " + cc.getId() + " event flushed");
            }
        }
    }

    private void deleteSubscriberMessages(long id, IClientContext cc, long maxMessageId, boolean persistent, boolean replicateOnly) throws InterruptedException {
        if (this.DEBUG) {
            this.debug("Deleting database messages for client id " + id);
        }
        this.getPostponedMsgSaver().cancel(id);
        if (cc.isGroupSubscriptionMember()) {
            if (!persistent) {
                return;
            }
            this.getDeleteSubscriptionManager().registerIdForDeletion(cc, cc.getId(), maxMessageId, replicateOnly);
            this.getDeleteSubscriptionManager().endDeleteSubscription(cc.getId(), maxMessageId, replicateOnly);
            return;
        }
        this.getDeleteSubscriptionManager().beginDeleteSubscription(cc, maxMessageId, persistent, replicateOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsubscribeAllExternal(long id, boolean waitForFlush, boolean skipSystem, Envelope request) throws EClientNotRegistered {
        UnsubscribeAllEvt evt = new UnsubscribeAllEvt(id, request);
        boolean needsLog = false;
        boolean needsReplication = false;
        IClientContext cc = this.lockContext(id);
        if (cc == null) {
            throw new EClientNotRegistered(id);
        }
        try {
            Object object = this.m_subscriptionMutex;
            synchronized (object) {
                if (this.DEBUG) {
                    this.debug("unsubscribing client " + cc.getId() + " from all subjects");
                }
                SubscriptionsTable subs = cc.getSubscriptions();
                Enumeration enu = ((Hashtable)subs.clone()).elements();
                while (enu.hasMoreElements()) {
                    BrokerSubscription bs = (BrokerSubscription)enu.nextElement();
                    if (skipSystem && bs.getSubject().isSystem()) continue;
                    if (bs.getLabel().isPersistent()) {
                        needsLog = true;
                        if (cc.isDurable()) {
                            cc.setDurableBrokerSubscription(null);
                        }
                    }
                    if (bs.isReplicateOnly()) {
                        needsReplication = true;
                    }
                    this.unsubscribeInternal(cc, bs);
                    SubscriptionsTable subscriptionsTable = subs;
                    synchronized (subscriptionsTable) {
                        subs.remove((Object)bs.getSubject());
                    }
                }
                if (cc.isGroupSubscription()) {
                    needsLog = true;
                }
                cc.releasePublishersBlockedOnDbSpace();
                cc.checkSpecialGroupSubscription();
                if (!cc.isDirty() && needsLog) {
                    cc.setDirty(true);
                    Long lid = new Long(cc.getId());
                    this.m_dirtyClients.put(lid, lid);
                }
            }
            if (needsLog || needsReplication) {
                if (!needsLog) {
                    evt.setReplicateOnly(true);
                }
                cc.waitForPubDispatches();
                this.getDeleteSubscriptionManager().registerIdForDeletion(cc, cc.getId(), this.getLogManager().getSeqNo(), evt.isReplicateOnly());
                this.getLogManager().addEvent(evt, true);
            }
            this.checkUnregister(cc);
        }
        finally {
            cc.unlock();
        }
        if (needsLog || needsReplication) {
            try {
                if (waitForFlush) {
                    this.getLogManager().waitForFlush(evt);
                }
                this.deleteSubscriberMessages(id, cc, evt.getSeqNo(), true, evt.isReplicateOnly());
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
            }
        }
        if (!needsLog && !needsReplication) {
            evt.localUnsubscribeDone();
        }
    }

    private final void unsubscribeInternal(IClientContext clctx, BrokerSubscription bs) {
        if (this.DEBUG) {
            this.debug("unsubscribing client " + clctx.getId() + " from bs: " + bs.getSubject());
        }
        if (bs.isGroupMember()) {
            this.m_groupSubs.removeSubscription(bs);
        } else {
            this.m_regSub.removeSubscription(bs.getSubject(), clctx);
        }
        if (bs.isExpirable() && bs.hasTTE()) {
            this.m_expSubs.remove(bs);
        }
        if (InterbrokerHook.isSet()) {
            if (clctx.getAppid().startsWith("$DURABLE$")) {
                if (this.DEBUG) {
                    this.debug("CWADS_DEBUG: unsubscribeInternal processing cwads unsubscribe evt  subject = " + bs.getSubject() + "\n appid = " + clctx.getAppid() + "\n active broker = " + clctx.getCWADSActiveBroker());
                }
                if (!SessionConfig.isSystemSubject(bs.getSubject()) && bs.getLabel().isPersistent()) {
                    InterbrokerHook.notifyCWADSEvent(102, clctx, bs);
                }
            } else {
                InterbrokerHook.unsubscribeEvent(bs);
            }
        }
        if (this.getGSManager() != null) {
            this.getGSManager().globalUnsubscribe(bs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverUnsubscribeAllInternal(IClientContext clctx) {
        Object object = this.m_subscriptionMutex;
        synchronized (object) {
            Long id;
            RecoveredSubscriptions rss;
            if (this.DEBUG) {
                this.debug("unsubscribing client " + clctx.getId() + " from all subjects");
            }
            boolean hasDurable = false;
            if (this.m_recoveredSubscriptions != null && (rss = (RecoveredSubscriptions)this.m_recoveredSubscriptions.get(id = new Long(clctx.getId()))) != null) {
                hasDurable = rss.clearSubscriptions();
                this.m_recoveredSubscriptions.remove(id);
            }
            if (!clctx.isDirty() && hasDurable) {
                clctx.setDirty(true);
                id = new Long(clctx.getId());
                this.m_dirtyClients.put(id, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector unsubscribeTransient(IClientContext cc) {
        Vector<UnsubscribeEvt> result = null;
        cc.lock();
        BrokerSubscription xonceSub = null;
        try {
            Object object = this.m_subscriptionMutex;
            synchronized (object) {
                FastVector v = new FastVector();
                Enumeration enu = cc.getSubscriptions().elements();
                while (enu.hasMoreElements()) {
                    BrokerSubscription bs = (BrokerSubscription)enu.nextElement();
                    if (bs.getLabel().isPersistent()) continue;
                    if (bs.isReplicateOnly()) {
                        if (InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(cc.getId())) continue;
                        xonceSub = bs;
                    }
                    if (bs.isGroupMember()) {
                        this.m_groupSubs.removeSubscription(bs);
                    } else {
                        this.m_regSub.removeSubscription(bs.getSubject(), cc);
                    }
                    this.m_expSubs.remove(bs);
                    v.addElement(bs);
                    if (InterbrokerHook.isSet()) {
                        InterbrokerHook.unsubscribeEvent(bs);
                    }
                    if (this.getGSManager() == null) continue;
                    this.getGSManager().globalUnsubscribe(bs);
                }
                for (int i = 0; i < v.m_count; ++i) {
                    cc.getSubscriptions().remove(((BrokerSubscription)v.m_data[i]).getSubject());
                    ISubject subject = ((BrokerSubscription)v.m_data[i]).getSubject();
                    try {
                        String appID;
                        String remoteNodeName;
                        String remoteBrokerName;
                        String remoteUserID;
                        String userID;
                        block23: {
                            if (!subject.isTemporary() && (SessionConfig.isSystemSubject(subject) || subject.isSonicMQSubject())) continue;
                            userID = null;
                            remoteUserID = null;
                            remoteBrokerName = null;
                            remoteNodeName = cc.getRemoteNode();
                            if (remoteNodeName != null && !subject.equals("$ISYS.GSA.expirableSubject")) {
                                try {
                                    IClientContext remoteNodeCC = this.getClient(this.m_routerMgr.getRemoteNodeGSClientID(remoteNodeName));
                                    if (remoteNodeCC != null) {
                                        remoteNodeName = remoteNodeCC.getRemoteNode();
                                        Principal p = this.m_gsManager.getRemoteNodePrincipal(remoteNodeName);
                                        if (p != null) {
                                            remoteUserID = p.getName();
                                        }
                                        remoteBrokerName = RouterManager.getRemoteBrokerFromGSAppID(cc.getAppid());
                                    }
                                }
                                catch (Exception e) {
                                    if (!this.DEBUG) break block23;
                                    this.debug("Unable to obtain remote node info...", e);
                                }
                            }
                        }
                        if (remoteUserID == null) {
                            userID = cc.getUid();
                        }
                        if ((appID = cc.getAppid()) == null) {
                            appID = "";
                        }
                        String clientID = null;
                        String subscriptionName = "";
                        String connectID = SessionConfig.getConnectIDFromSubscriberAppid(appID);
                        BrokerManagementNotificationsHelper.sendBrokerUnsubscribeNotification(Config.BROKER_NAME, Config.ROUTING_NODE_NAME, userID, clientID, connectID, subject.getSubjectString(), subscriptionName, remoteNodeName, remoteBrokerName, remoteUserID);
                        continue;
                    }
                    catch (Exception e) {
                        if (!this.DEBUG) continue;
                        this.debug("Exception while attempting to send unsubscribe notification, e = " + e.getMessage(), e);
                    }
                }
                cc.releasePublishersBlockedOnDbSpace();
                if (xonceSub != null) {
                    UnsubscribeEvt evt = new UnsubscribeEvt(null, cc.getId(), xonceSub.getSubject());
                    evt.setReplicateOnly(true);
                    this.getDeleteSubscriptionManager().registerIdForDeletion(cc, cc.getId(), this.getLogManager().getSeqNo(), evt.isReplicateOnly());
                    this.getLogManager().addEvent(evt, true);
                    if (result == null) {
                        result = new Vector<UnsubscribeEvt>();
                    }
                    result.addElement(evt);
                }
            }
            this.checkUnregister(cc);
        }
        finally {
            cc.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateClient(long id) {
        boolean interrupted;
        block23: {
            interrupted = false;
            IClientContext cc = this.lockContext(id);
            if (cc != null) {
                boolean locked = true;
                try {
                    if (this.checkDebugFlags(64)) {
                        this.debug("terminateClient starting: " + cc);
                    }
                    cc.closeAgentConnection();
                    try {
                        this.unsubscribeAllExternal(id, false, false, null);
                    }
                    catch (EClientNotRegistered e) {
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                    if (cc.isInterbroker() || cc.isGroupSubscription()) {
                        try {
                            this.prepareDisconnect(id);
                        }
                        catch (EClientNotRegistered e) {
                            // empty catch block
                        }
                        this.disconnect(id, false);
                    }
                    Object object = cc.getSyncObj();
                    synchronized (object) {
                        while (!cc.isUnregistered()) {
                            if (!cc.getSubscriptions().isEmpty()) {
                                try {
                                    this.unsubscribeAllExternal(id, false, false, null);
                                }
                                catch (EClientNotRegistered e) {
                                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                                }
                            }
                            if (cc.isUnregistered()) break;
                            cc.unlock();
                            locked = false;
                            try {
                                cc.getSyncObj().wait();
                            }
                            catch (InterruptedException e) {
                                interrupted = true;
                            }
                            cc.lock();
                            locked = true;
                        }
                        break block23;
                    }
                }
                finally {
                    if (locked) {
                        cc.unlock();
                    }
                }
            }
            if (this.checkDebugFlags(64)) {
                this.debug("terminating unregistered id " + id);
            }
            if (this.checkDebugFlags(64)) {
                this.debug("terminateClient: about to delete db messages for " + id);
            }
            this.getDeleteSubscriptionManager().beginDeleteSubscription(cc, id, this.getLogManager().getSeqNo(), true, false);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public void forceSyncpoint() {
        this.m_logmgr.forceSyncpoint();
    }

    public void forceSyncpoint(boolean wait) throws InterruptedException {
        this.m_logmgr.forceSyncpoint(wait);
    }

    public void forceSyncpoint(boolean waitForStart, boolean waitToComplete) throws InterruptedException {
        this.m_logmgr.forceSyncpoint(waitForStart, waitToComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDurableSubscriptions(String key) {
        ArrayList subscriptions = new ArrayList();
        boolean gettingGroupSubData = SubjectUtil.getSubjectGroupPrefix(key) != null;
        boolean gettingMTGroupSubData = false;
        if (!gettingGroupSubData && key.startsWith("[[") && key.indexOf("]]") > 0) {
            gettingMTGroupSubData = true;
            gettingGroupSubData = true;
        }
        String groupkey = null;
        boolean groupSubCountsAlreadyAdded = false;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            Vector<IClientContext> c = null;
            if (gettingGroupSubData) {
                groupkey = key.replace('$', '.');
                Subject tmpsubject = new Subject(groupkey, null, true);
                GroupSubscription group = null;
                group = gettingMTGroupSubData ? this.getGroupSubscriptions().getGroupByName(groupkey) : this.getGroupSubscriptions().getGroup(tmpsubject);
                if (group == null) {
                    return subscriptions;
                }
                if (group.hasDurables()) {
                    Vector<IClientContext> list = new Vector<IClientContext>();
                    Iterator iter = group.getGroupMemberIds();
                    while (iter.hasNext()) {
                        Long ccid = (Long)iter.next();
                        try {
                            IClientContext cc = this.getClient(ccid);
                            list.addElement(cc);
                        }
                        catch (EClientNotRegistered e) {}
                    }
                    c = list;
                }
            } else {
                c = this.getDurableManager().getDurableSubscriptions(key);
            }
            if (c == null) {
                return subscriptions;
            }
            subscriptions.addAll(c);
        }
        for (int i = subscriptions.size() - 1; i >= 0; --i) {
            DurableCCTracker tracker;
            IClientContext cc = null;
            Object subentry = subscriptions.remove(i);
            if (subentry instanceof IClientContext) {
                cc = (IClientContext)subentry;
            } else if (subentry instanceof GroupSubscription) {
                cc = ((GroupSubscription)subentry).getGroupCC();
            } else {
                throw new EAssertFailure("Invalid entry in subscriptions list");
            }
            if (cc == null) continue;
            String user = cc.getUid();
            String jmsClientID = null;
            String subscriptionName = null;
            ISubject subject = null;
            String selector = null;
            boolean selectorAtBroker = false;
            boolean isConnectionConsumer = false;
            long messageCount = 0L;
            long messageSize = 0L;
            long lastConnectionTime = cc.getLastConnectedTime();
            Enumeration allSubscriptions = cc.getSubscriptions().elements();
            while (allSubscriptions.hasMoreElements()) {
                Object elem = allSubscriptions.nextElement();
                BrokerSubscription bs = (BrokerSubscription)elem;
                Label label = bs.getLabel();
                if (label.isPersistent()) {
                    subject = bs.getSubject();
                    if (!bs.hasSelector()) break;
                    selector = bs.getSelectorString();
                    selectorAtBroker = bs.getSelectorAtBroker();
                    break;
                }
                if (!gettingGroupSubData || !cc.isGroupSubscriptionMember() || !bs.getSubject().getSubjectString().equalsIgnoreCase(groupkey)) continue;
                subject = bs.getSubject();
                selector = null;
                selectorAtBroker = false;
                break;
            }
            if (subject == null || (tracker = this.getDurableManager().lookupDurableCCTracker(cc.getId())) == null) continue;
            if (cc.isGroupSubscription()) {
                messageCount = tracker.getMessageCount();
                messageSize = tracker.getMessageSize();
                lastConnectionTime = cc.getLastConnectedTime();
                jmsClientID = "*";
                subscriptionName = "*";
            } else if (!cc.isDurable()) {
                if (!cc.isGroupSubscriptionMember()) continue;
                messageCount = 0L;
                messageSize = 0L;
                lastConnectionTime = -1L;
                jmsClientID = "";
                subscriptionName = "";
            } else {
                if (gettingGroupSubData && cc.isDurable() && groupSubCountsAlreadyAdded) {
                    messageCount = 0L;
                    messageSize = 0L;
                } else {
                    messageCount = tracker.getMessageCount();
                    messageSize = tracker.getMessageSize();
                    groupSubCountsAlreadyAdded = true;
                }
                lastConnectionTime = cc.getLastConnectedTime();
                String appID = cc.getAppid();
                jmsClientID = DurableSubscriptionUtil.getJMSClientID(appID);
                subscriptionName = DurableSubscriptionUtil.getSubscriptionName(appID);
                isConnectionConsumer = DurableSubscriptionUtil.isConnectionConsumer(appID);
            }
            IDurableSubscriptionData subscription = RuntimeDataFactory.createDurableSubscriptionData(user, jmsClientID, subscriptionName, subject.toByteArray(), selector, selectorAtBroker, isConnectionConsumer, messageCount, messageSize, lastConnectionTime);
            subscriptions.add(subscription);
        }
        return subscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message OLDgetDurableSubscriptions(String userId) throws IOException {
        Message rep = new Message();
        IClientContext cc = null;
        String appID = null;
        Vector ctxVec = new Vector();
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            Collection c = this.getDurableManager().getDurableSubscriptions(userId);
            if (c != null) {
                ctxVec.addAll(c);
            }
        }
        int sz = ctxVec.size();
        rep.writeBoolean(true);
        rep.writeInt(sz);
        rep.writeInt(4);
        try {
            String jmsClientID = null;
            String subNm = null;
            String topicNm = null;
            Enumeration subscriptions = null;
            BrokerSubscription bs = null;
            Label label = null;
            for (int i = 0; i < sz; ++i) {
                cc = (IClientContext)ctxVec.elementAt(i);
                subscriptions = cc.getSubscriptions().elements();
                while (subscriptions.hasMoreElements()) {
                    bs = (BrokerSubscription)subscriptions.nextElement();
                    label = bs.getLabel();
                    if (!label.isPersistent()) continue;
                    topicNm = bs.getSubject().getSubjectString();
                    break;
                }
                appID = cc.getAppid();
                jmsClientID = DurableSubscriptionUtil.getJMSClientID(appID);
                subNm = DurableSubscriptionUtil.getSubscriptionName(appID);
                if (this.DEBUG) {
                    this.debug("AgentRegistrar.getDurableSubscriptions: jmsClientID = " + jmsClientID);
                    this.debug("AgentRegistrar.getDurableSubscriptions: subscription name = " + subNm);
                    this.debug("AgentRegistrar.getDurableSubscriptions: topic name = " + topicNm);
                }
                rep.writeUTF(jmsClientID);
                rep.writeUTF(subNm);
                rep.writeUTF(topicNm);
                IClientContext activeBrokerCC = cc.getCWADSActiveBroker();
                if (activeBrokerCC != null) {
                    rep.writeUTF(activeBrokerCC.getUid());
                } else {
                    rep.writeUTF("$INACTIVE");
                }
                if (!this.DEBUG) continue;
                this.debug("CWADS_DEBUG AgentRegistrar.OLDgetDurableSubscriptions: jmsClientID = " + jmsClientID);
                this.debug("CWADS_DEBUG AgentRegistrar.OLDgetDurableSubscriptions: subscription name = " + subNm);
                this.debug("CWADS_DEBUG AgentRegistrar.OLDgetDurableSubscriptions: topic name = " + topicNm);
                if (activeBrokerCC != null) {
                    this.debug("CWADS_DEBUG AgentRegistrar.OLDgetDurableSubscriptions: activecc = " + activeBrokerCC.getAppid());
                    continue;
                }
                this.debug("CWADS_DEBUG AgentRegistrar.OLDgetDurableSubscriptions: activecc = $INACTIVE");
            }
            ctxVec.removeAllElements();
            ctxVec = null;
            subscriptions = null;
            bs = null;
            label = null;
            jmsClientID = null;
            subNm = null;
            topicNm = null;
        }
        catch (Exception e) {
            rep = new Message();
            try {
                rep.writeBoolean(false);
                rep.writeObject(e);
            }
            catch (Exception ee) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ee, 2);
            }
        }
        return rep;
    }

    public ArrayList getSubscriptions(long requestor, String pattern) throws EInvalidSubjectSyntax, EClientNotRegistered {
        ArrayList<SubscriptionData> subscriptions = new ArrayList<SubscriptionData>();
        Vector v = this.subscriptions(requestor, pattern);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            BrokerSubscription bs = (BrokerSubscription)v.elementAt(i);
            String[] selectors = bs.getSelectorStrings();
            boolean selAtBroker = selectors == null;
            SubscriptionData subscription = new SubscriptionData(bs.getClient().getAppid(), bs.getSubject().getSubjectString(), selectors, selAtBroker, 0L, 0L);
            subscriptions.add(subscription);
        }
        return subscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void deleteDurableSubscriptions(String user, ArrayList durableSubscriptions) throws Exception {
        ArrayList userSubscriptions = new ArrayList();
        LongHashTable longHashTable = this.m_regCl;
        // MONITORENTER : longHashTable
        Collection c = this.getDurableManager().getDurableSubscriptions(user);
        if (c != null) {
            userSubscriptions.addAll(c);
        }
        // MONITOREXIT : longHashTable
        if (durableSubscriptions != null) {
            block22: for (int i = userSubscriptions.size() - 1; i >= 0; --i) {
                IClientContext cc = (IClientContext)userSubscriptions.get(i);
                String appID = cc.getAppid();
                String jmsClientID = DurableSubscriptionUtil.getJMSClientID(appID);
                String subsciptionName = DurableSubscriptionUtil.getSubscriptionName(appID);
                for (IDurableSubscriptionData durableSubscriptionData : durableSubscriptions) {
                    if (!durableSubscriptionData.getClientID().equals(jmsClientID) || !durableSubscriptionData.getSubscriptionName().equals(subsciptionName)) continue;
                    continue block22;
                }
                userSubscriptions.remove(i);
            }
        }
        int failed = 0;
        Iterator iterator = userSubscriptions.iterator();
        while (true) {
            Object label;
            if (!iterator.hasNext()) {
                if (failed <= 0) return;
                Object[] obj = new Object[]{new Integer(failed)};
                throw new Exception(MessageFormat.format(prAccessor.getString("STR353"), obj));
            }
            IClientContext cc = (IClientContext)iterator.next();
            ISubject subject = null;
            Enumeration subscriptions = cc.getSubscriptions().elements();
            while (subscriptions.hasMoreElements()) {
                BrokerSubscription bs = (BrokerSubscription)subscriptions.nextElement();
                label = bs.getLabel();
                if (!((Label)label).isPersistent()) continue;
                subject = bs.getSubject();
                break;
            }
            do {
                cc.lock();
            } while (!cc.beginRegistryUpdate());
            boolean ccLocked = true;
            try {
                label = cc.getSyncObj();
                // MONITORENTER : label
                if (cc.isActivelyConnected() || cc.isDurable() && this.m_txnmgr.isParticipantOfTxn(cc.getId())) {
                    ++failed;
                    // MONITOREXIT : label
                    continue;
                }
                // MONITOREXIT : label
                if (cc.isPendingReconnect()) {
                    long timerid = cc.getTimerId();
                    if (!m_disconnectTimerMgr.cancel(timerid)) {
                        cc.unlock();
                        ccLocked = false;
                        try {
                            m_disconnectTimerMgr.waitForTimerExec(timerid);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            if (!ccLocked) {
                                cc.lock();
                            }
                            try {
                                cc.endRegistryUpdate();
                                return;
                            }
                            finally {
                                cc.unlock();
                            }
                        }
                    } else {
                        cc.unlock();
                        ccLocked = false;
                        m_disconnectTimerMgr.disconnect(timerid);
                    }
                } else {
                    cc.unlock();
                    ccLocked = false;
                    this.disconnect(cc.getId(), false);
                }
                UnsubscribeEvt event = new UnsubscribeEvt(null, cc.getId(), subject);
                this.unsubscribe(event);
                continue;
            }
            finally {
                if (!ccLocked) {
                    cc.lock();
                }
                try {
                    cc.endRegistryUpdate();
                    continue;
                }
                finally {
                    cc.unlock();
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message delDurableSubscriptions(Message req) throws IOException {
        Message rep;
        block31: {
            rep = null;
            try {
                String userID = req.readUTF();
                if (this.DEBUG) {
                    this.debug("AgentRegistrar.delDurableSubscriptions: userID = " + userID);
                }
                int delCnt = req.readInt();
                if (this.DEBUG) {
                    this.debug("AgentRegistrar.delDurableSubscriptions: count of subscriptions to delete = " + delCnt);
                }
                rep = new Message();
                IClientContext cc = null;
                String appID = null;
                Vector ctxVec = new Vector();
                LongHashTable longHashTable = this.m_regCl;
                synchronized (longHashTable) {
                    Collection c = this.getDurableManager().getDurableSubscriptions(userID);
                    if (c != null) {
                        ctxVec.addAll(c);
                    }
                }
                if (this.DEBUG) {
                    this.debug("AgentRegistrar.delDurableSubscriptions: total number of durable subscriptions found = " + ctxVec.size());
                }
                ISubject subjectNm = null;
                Enumeration subscriptions = null;
                BrokerSubscription bs = null;
                Label label = null;
                UnsubscribeEvt uEvt = null;
                if (delCnt == 0) {
                    rep.writeBoolean(true);
                    rep.writeInt(0);
                    break block31;
                }
                if (delCnt == -1) {
                    int failed = 0;
                    int sz = ctxVec.size();
                    for (int i = 0; i < sz; ++i) {
                        cc = (IClientContext)ctxVec.elementAt(i);
                        subscriptions = cc.getSubscriptions().elements();
                        while (subscriptions.hasMoreElements()) {
                            bs = (BrokerSubscription)subscriptions.nextElement();
                            label = bs.getLabel();
                            if (!label.isPersistent()) continue;
                            subjectNm = bs.getSubject();
                            break;
                        }
                        Object object = cc.getSyncObj();
                        synchronized (object) {
                            if (cc.isConnected() || cc.isDurable() && this.m_txnmgr.isParticipantOfTxn(cc.getId())) {
                                ++failed;
                                continue;
                            }
                        }
                        this.disconnect(cc.getId(), false);
                        uEvt = new UnsubscribeEvt(null, cc.getId(), subjectNm);
                        this.unsubscribe(uEvt);
                    }
                    if (failed != 0) {
                        Object[] obj = new Object[]{new Integer(failed)};
                        String message = MessageFormat.format(prAccessor.getString("STR353"), obj);
                        rep.writeBoolean(false);
                        rep.writeObject(new EGeneralException(1, message));
                    } else {
                        rep.writeBoolean(true);
                        rep.writeInt(sz);
                    }
                    break block31;
                }
                int count = 0;
                int failed = 0;
                boolean fnd = false;
                String jmsClientID = null;
                String subNm = null;
                String id = null;
                String nm = null;
                for (int i = 0; i < delCnt; ++i) {
                    jmsClientID = req.readUTF();
                    subNm = req.readUTF();
                    if (this.DEBUG) {
                        this.debug("AgentRegistrar.delDurableSubscriptions: jmsClientID[" + i + "] = " + jmsClientID);
                        this.debug("AgentRegistrar.delDurableSubscriptions: subscription name[" + i + "] = " + subNm);
                    }
                    fnd = false;
                    for (int j = 0; j < ctxVec.size(); ++j) {
                        cc = (IClientContext)ctxVec.elementAt(j);
                        appID = cc.getAppid();
                        id = DurableSubscriptionUtil.getJMSClientID(appID);
                        nm = DurableSubscriptionUtil.getSubscriptionName(appID);
                        if (!id.equals(jmsClientID) || !nm.equals(subNm)) continue;
                        fnd = true;
                        ctxVec.removeElementAt(j);
                        break;
                    }
                    if (!fnd) continue;
                    subscriptions = cc.getSubscriptions().elements();
                    while (subscriptions.hasMoreElements()) {
                        bs = (BrokerSubscription)subscriptions.nextElement();
                        label = bs.getLabel();
                        if (!label.isPersistent()) continue;
                        subjectNm = bs.getSubject();
                        break;
                    }
                    Object j = cc.getSyncObj();
                    synchronized (j) {
                        if (cc.isConnected() || cc.isDurable() && this.m_txnmgr.isParticipantOfTxn(cc.getId())) {
                            ++failed;
                            continue;
                        }
                    }
                    this.disconnect(cc.getId(), false);
                    uEvt = new UnsubscribeEvt(null, cc.getId(), subjectNm);
                    this.unsubscribe(uEvt);
                    ++count;
                }
                if (failed != 0) {
                    Object[] obj = new Object[]{new Integer(failed)};
                    String message = MessageFormat.format(prAccessor.getString("STR353"), obj);
                    rep.writeBoolean(false);
                    rep.writeObject(new EGeneralException(1, message));
                } else {
                    rep.writeBoolean(true);
                    rep.writeInt(count);
                }
            }
            catch (Exception e) {
                rep = new Message();
                try {
                    rep.writeBoolean(false);
                    rep.writeObject(e);
                }
                catch (Exception ee) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ee, 2);
                }
            }
        }
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getUsersWithDurableSubscriptions(String prefix) {
        ArrayList<String> users = new ArrayList<String>();
        boolean useFilter = prefix != null && prefix.length() > 0;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            Collection c = this.getDurableManager().getDurableUids();
            for (String user : c) {
                if (useFilter && !user.startsWith(prefix)) continue;
                users.add(user);
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDurableSubscriptionUserIds(Vector uids) throws IOException {
        if (uids == null) {
            return;
        }
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            uids.addAll(this.getDurableManager().getDurableUids());
        }
    }

    public Message getConnectionInfo(Envelope env) throws IOException, EInvalidAdminAddress, EClientNotRegistered {
        Message msg = new Message();
        msg.writeUTF(Config.BROKER_NAME);
        if (Config.ENABLE_SECURITY) {
            long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
            ClientSecurityContext csc = this.getClientSecurityContext(requestor);
            boolean ok = Authorize.checkPermission(csc.getPrincipal(), this.m_getGroupNamesSub, 1);
            msg.writeBoolean(ok);
        } else {
            msg.writeBoolean(true);
        }
        msg.writeBoolean(Config.ENABLE_SECURITY);
        msg.writeUTF(Config.ROUTING_NODE_NAME == null ? "" : Config.ROUTING_NODE_NAME);
        msg.writeBoolean(Config.ENABLE_INTERBROKER);
        msg.writeBoolean(false);
        msg.writeBoolean(Redirector.redirector != null);
        msg.writeUTF(ProgressInetAddress.getLocalHostName());
        msg.writeInt(Config.PORT);
        msg.writeBoolean(this.m_isXAConfigured);
        return msg;
    }

    public void resetStats() {
        this.m_logmgr.resetSyncCount();
        try {
            this.m_db.resetPeakMsgCount();
        }
        catch (EDatabaseException eDatabaseException) {
            // empty catch block
        }
        this.m_txnmgr.resetStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector subscriptions(long id, String pattern) throws EClientNotRegistered, EInvalidSubjectSyntax {
        IClientContext clctx;
        Dictionary dictionary = this.m_regCl;
        synchronized (dictionary) {
            clctx = (IClientContext)this.m_regCl.get(id);
        }
        if (clctx == null) {
            throw new EClientNotRegistered(id);
        }
        dictionary = clctx.getSubscriptions();
        synchronized (dictionary) {
            if ("#".equals(pattern)) {
                Vector matches = new Vector();
                Enumeration subs = clctx.getSubscriptions().elements();
                while (subs.hasMoreElements()) {
                    matches.addElement(subs.nextElement());
                }
                return matches;
            }
            Enumeration subs = clctx.getSubscriptions().elements();
            Vector<BrokerSubscription> matches = new Vector<BrokerSubscription>();
            int[] pvec = SubjectUtil.computeMatchVector(pattern, true);
            while (subs.hasMoreElements()) {
                BrokerSubscription bs = (BrokerSubscription)subs.nextElement();
                int[] tvec = SubjectUtil.computeMatchVector(bs.getSubject().getLookupName(), true);
                if (!SubjectUtil.isSubset(tvec, pvec)) continue;
                matches.addElement(bs);
            }
            return matches;
        }
    }

    public final void subscribers(ISubject s, BrokerSearchResults bsr) {
        this.m_regSub.get(s, bsr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void beginWriteSubscriptions() {
        boolean interrupted = false;
        while (this.m_writingSubscriptions) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        this.m_writingSubscriptions = true;
        long timeToWait = 60000L;
        int count = 1;
        while (!this.m_contextLocks.isEmpty()) {
            if (this.DEBUG_UNEXPECTED) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(60000L);
                    long waited = System.currentTimeMillis() - start;
                    if (waited >= timeToWait) {
                        this.debug("Waited for over " + 60000 * count / 1000 + "s to write syncpoint subscriptions. If this situation continues, please take a thread dump and send it to support along with this log. Lock holder dump follows:");
                        Hashtable table = null;
                        AgentRegistrar agentRegistrar = this;
                        synchronized (agentRegistrar) {
                            table = (Hashtable)this.m_contextLocks.clone();
                        }
                        for (Thread t : table.keySet()) {
                            LongHolder holder = (LongHolder)table.get(t);
                            this.debug("Subscription lock holder thread: " + t.toString() + "[" + holder.get() + "]");
                        }
                        ++count;
                        timeToWait = 60000L;
                        continue;
                    }
                    timeToWait -= waited;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                continue;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized void endWriteSubscriptions() {
        this.m_writingSubscriptions = false;
        this.notifyAll();
    }

    synchronized boolean tryLockContext() {
        LongHolder l = (LongHolder)this.m_contextLocks.get(Thread.currentThread());
        if (l != null) {
            l.set(l.get() + 1L);
            return true;
        }
        if (this.m_writingSubscriptions) {
            return false;
        }
        l = new LongHolder(1L);
        this.m_contextLocks.put(Thread.currentThread(), l);
        return true;
    }

    synchronized void lockContext() {
        boolean interrupted = false;
        while (!this.tryLockContext()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized void unlockContext() {
        LongHolder l = (LongHolder)this.m_contextLocks.get(Thread.currentThread());
        if (l != null) {
            if (l.get() > 1L) {
                l.set(l.get() - 1L);
            } else {
                this.m_contextLocks.remove(Thread.currentThread());
            }
        }
        if (this.m_contextLocks.isEmpty()) {
            this.notifyAll();
        }
    }

    public void writeSyncSubscriptions(SyncpointLoc syncPtLoc) throws IOException {
        IClientContext cc;
        long id;
        this.beginWriteSubscriptions();
        int adds = 0;
        int deletes = 0;
        Enumeration ids = null;
        this.m_db.beginRegDBTran();
        try {
            if (this.checkDebugFlags(64)) {
                this.debug("WriteSyncSubscriptions;  m_dirtyClients.size= " + this.m_dirtyClients.size() + " m_regCl.size= " + this.m_regCl.size() + " " + Thread.currentThread());
            }
            ids = this.m_dirtyClients.keys();
            while (ids.hasMoreElements()) {
                id = (Long)ids.nextElement();
                cc = (IClientContext)this.m_regCl.get(id);
                if (cc == null) {
                    this.m_db.delClient(id);
                    ++deletes;
                    continue;
                }
                if (cc.isGroupSubscription()) continue;
                this.m_db.saveClient(cc);
                ++adds;
            }
            this.m_db.writeSyncPtLoc(syncPtLoc);
            this.m_logmgr.newDbSyncpointLoc(syncPtLoc);
            this.m_db.commitRegTran();
        }
        catch (EDatabaseException ex) {
            try {
                this.m_db.rollbackRegTran();
            }
            catch (EDatabaseException exc) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            this.m_db.releaseRegDBTran();
        }
        ids = this.m_dirtyClients.keys();
        while (ids.hasMoreElements()) {
            id = (Long)ids.nextElement();
            cc = (IClientContext)this.m_regCl.get(id);
            if (cc == null) continue;
            cc.setDirty(false);
        }
        this.m_dirtyClients.clear();
        if (this.checkDebugFlags(64)) {
            this.debug("WriteSyncSubscriptions completed; adds= " + adds + " deletes= " + deletes);
        }
        this.endWriteSubscriptions();
    }

    public void writeSyncSubscriptionsStandby(SyncpointLoc syncPtLoc) throws IOException {
        this.beginWriteSubscriptions();
        int adds = 0;
        int deletes = 0;
        Enumeration ids = null;
        this.m_db.beginRegDBTran();
        try {
            if (this.checkDebugFlags(64)) {
                this.debug("WriteSyncSubscriptionsStandby;  m_dirtyClients.size= " + this.m_dirtyClients.size() + " m_regCl.size= " + this.m_regCl.size() + " " + Thread.currentThread());
            }
            ids = this.m_dirtyClients.keys();
            while (ids.hasMoreElements()) {
                RecoveredSubscriptions rss;
                Long lid = (Long)ids.nextElement();
                long id = lid;
                IClientContext cc = (IClientContext)this.m_regCl.get(id);
                LinkedList subList = null;
                if (this.m_recoveredSubscriptions != null && (rss = (RecoveredSubscriptions)this.m_recoveredSubscriptions.get(lid)) != null) {
                    subList = rss.getSubscriptions();
                }
                if (cc == null) {
                    this.m_db.delClient(id);
                    ++deletes;
                    continue;
                }
                if (cc.isGroupSubscription()) continue;
                this.m_db.saveClient(cc, subList);
                ++adds;
            }
            this.m_db.writeSyncPtLoc(syncPtLoc);
            this.m_logmgr.newDbSyncpointLoc(syncPtLoc);
            this.m_db.commitRegTran();
        }
        catch (EDatabaseException ex) {
            try {
                this.m_db.rollbackRegTran();
            }
            catch (EDatabaseException exc) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            this.m_db.releaseRegDBTran();
        }
        ids = this.m_dirtyClients.keys();
        while (ids.hasMoreElements()) {
            long id = (Long)ids.nextElement();
            IClientContext cc = (IClientContext)this.m_regCl.get(id);
            if (cc == null) continue;
            cc.setDirty(false);
        }
        this.m_dirtyClients.clear();
        if (this.checkDebugFlags(64)) {
            this.debug("WriteSyncSubscriptionsStandby completed; adds= " + adds + " deletes= " + deletes);
        }
        this.endWriteSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            return this.m_regCl.toString() + "\n" + this.m_regSub.toString() + "\n";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSecurityContext getClientSecurityContext(long id) throws EClientNotRegistered {
        IClientContext clctx;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            clctx = (IClientContext)this.m_regCl.get(id);
        }
        if (clctx == null) {
            throw new EClientNotRegistered(id);
        }
        return clctx.getCSC();
    }

    public SubjectSpace lockSubscriptionTable() {
        this.beginWriteSubscriptions();
        return this.m_regSub;
    }

    public void unlockSubscriptionTable() {
        this.endWriteSubscriptions();
    }

    public Enumeration getAllSubscriptions() {
        return this.m_regSub.getAllSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getConnections(String prefix) {
        ArrayList<IConnectionData> connectionsData = new ArrayList<IConnectionData>();
        boolean useFilter = false;
        String pref = prefix;
        if (prefix != null && prefix.length() > 0) {
            useFilter = true;
            if (pref.indexOf(".") != -1) {
                pref = pref.replace('.', '$');
            }
        }
        Enumeration enu = null;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            enu = ((LongHashTable)this.m_regCl.clone()).elements();
        }
        while (enu.hasMoreElements()) {
            IClientContext context = (IClientContext)enu.nextElement();
            if (!context.isConnected() || context.getChannel() != 0 && !context.isJMSConnection()) continue;
            String user = context.getUid();
            if (useFilter && !user.startsWith(pref)) continue;
            String appID = context.getAppid();
            if (context.isRemoteBroker()) {
                String node = RouterManager.getRemoteNodeFromGRAppID(appID);
                String broker = RouterManager.getRemoteBrokerFromAppID(appID);
                connectionsData.add(RuntimeDataFactory.createConnectionData(user, new String[]{node, broker}, this.getClientHost(context), 4, context.getId()));
                continue;
            }
            if (context.isInterbroker()) {
                String broker = user;
                connectionsData.add(RuntimeDataFactory.createConnectionData(user, new String[]{broker}, this.getClientHost(context), 2, context.getId()));
                continue;
            }
            int index = appID.indexOf("$CONNECTION$");
            if (index < 0) continue;
            String connectID = appID.substring(0, index);
            connectionsData.add(RuntimeDataFactory.createConnectionData(user, new String[]{connectID}, this.getClientHost(context), 1, context.getId()));
        }
        return connectionsData;
    }

    private String getClientHost(IClientContext context) {
        String clientHost = null;
        try {
            clientHost = context.getConnection().getSocket().getInetAddress().getHostName();
        }
        catch (Exception e) {
            clientHost = "n/a";
        }
        return clientHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAllConnectionClients(boolean includeBrokerConnections) {
        if (this.DEBUG) {
            this.debug("get all JMS connection clients");
        }
        HashSet<IClientContext> ret = new HashSet<IClientContext>();
        if (this.m_regCl == null) {
            return null;
        }
        Enumeration enu = null;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            enu = ((LongHashTable)this.m_regCl.clone()).elements();
        }
        while (enu.hasMoreElements()) {
            IClientContext cc = (IClientContext)enu.nextElement();
            if (this.DEBUG) {
                if (!cc.isConnected()) {
                    this.debug(" - not connected ");
                } else {
                    String uid = cc.getUid();
                    String appid = cc.getAppid();
                    int channel = cc.getChannel();
                    this.debug(" - found: " + uid + "/" + appid + "/" + channel);
                }
            }
            if (!cc.isJMSConnection() && (!includeBrokerConnections || cc.getChannel() != 0) || !cc.isConnected() || cc.getUid().equals(Config.BROKER_UID)) continue;
            if (this.DEBUG) {
                this.debug(" - adding: " + cc.getUid() + "/" + cc.getAppid() + "/" + cc.getChannel());
            }
            ret.add(cc);
        }
        return ret;
    }

    public void dropConnections(ArrayList connections) {
        Iterator iterator = connections.iterator();
        while (iterator.hasNext()) {
            Long memberRef;
            IClientContext context = null;
            Object connectionRef = iterator.next();
            if (connectionRef == null) continue;
            if (connectionRef instanceof IConnectionData && (memberRef = ((IConnectionData)connectionRef).getConnectionMemberRef()) != null) {
                connectionRef = memberRef;
            }
            if (connectionRef instanceof Long) {
                try {
                    context = this.getClient((Long)connectionRef);
                }
                catch (EClientNotRegistered e) {
                    continue;
                }
                if (context == null || context.getChannel() != 0 || !context.isJMSConnection() && !context.isRemoteBroker() && !context.isInterbroker()) {
                    continue;
                }
            } else if (connectionRef instanceof IConnectionData) {
                IConnectionData connectionData = (IConnectionData)connectionRef;
                String appID = null;
                if (connectionData.isApplicationConnection()) {
                    appID = connectionData.getConnectID() + "$CONNECTION$";
                } else if (connectionData.isRoutingConnection()) {
                    appID = RouterManager.getRouterAppID(connectionData.getNode(), connectionData.getBroker());
                } else if (connectionData.isClusterConnection()) continue;
                try {
                    context = this.getClient(AddrUtil.stringToClientId(connectionData.getUser(), appID));
                }
                catch (EClientNotRegistered e) {
                    continue;
                }
            }
            if (context == null) continue;
            if (context.isRemoteBroker() || context.isInterbroker()) {
                String peer;
                String type;
                if (context.isInterbroker()) {
                    type = "cluster";
                    peer = context.getUid();
                } else {
                    type = "routing";
                    String appid = context.getAppid();
                    peer = appid == null ? null : (RouterManager.isRouterAppID(appid) ? RouterManager.getRemoteNodeFromGRAppID(appid) + ":" + RouterManager.getRemoteBrokerFromAppID(appid) : (RouterManager.isRemoteNodeGSAppID(appid) ? RouterManager.getRemoteNodeFromGSAppID(appid) + ":" + RouterManager.getRemoteBrokerFromGSAppID(appid) : null));
                }
                Object[] obj = new Object[]{type, peer};
                String s = prMessageFormat.format(prAccessor.getString("INTERBROKER_CONNECTION_DROP_REQUEST"), obj);
                BrokerComponent.getComponentContext().logMessage(s, 3);
            }
            this.dropConnection(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConnection(IClientContext context) {
        context.lock();
        if (context.isActivelyConnected()) {
            try {
                AgentConnection connection = context.getConnection();
                connection.prepareDisconnect(6);
                ISocket socket = connection.getSocket();
                if (socket == null) {
                    return;
                }
                try {
                    socket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            finally {
                context.unlock();
            }
            return;
        }
        if (context.isPendingReconnect()) {
            long timerid = context.getTimerId();
            if (!m_disconnectTimerMgr.cancel(timerid)) {
                context.unlock();
                try {
                    m_disconnectTimerMgr.waitForTimerExec(timerid);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                return;
            }
            context.unlock();
            m_disconnectTimerMgr.disconnect(timerid);
            return;
        }
        context.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message getAllConnections() throws IOException {
        Message rep = new Message();
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            Enumeration enu = this.m_regCl.elements();
            while (enu.hasMoreElements()) {
                IClientContext cc = (IClientContext)enu.nextElement();
                String uid = cc.getUid();
                if (!cc.isConnected() || uid.equals(Config.BROKER_UID)) continue;
                rep.writeUTF(uid);
                rep.writeUTF(cc.getAppid());
            }
        }
        return rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicSyncManager.DynamicSyncClientInfo getAllInMemoryClientContexts() {
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            ArrayList<ClientContextDescriptor> clients = new ArrayList<ClientContextDescriptor>(this.m_regCl.size());
            ArrayList<SubscribeEvt> subscribes = new ArrayList<SubscribeEvt>(this.m_regCl.size());
            IClientContext cc = null;
            ClientContextDescriptor ccDesc = null;
            Enumeration enu = this.m_regCl.elements();
            while (enu.hasMoreElements()) {
                cc = (IClientContext)enu.nextElement();
                String appId = cc.getAppid();
                if (cc.getId() == this.getId() || appId.equals("BACKUP") || appId.equals("PRIMARY") || appId.equals("FailoverBroker connect") || appId.equals("$GROUPSUBSCRIPTION$")) continue;
                SubscriptionsTable subscriptionsTable = cc.getSubscriptions();
                synchronized (subscriptionsTable) {
                    Enumeration subs = cc.getSubscriptions().elements();
                    while (subs.hasMoreElements()) {
                        BrokerSubscription bs = (BrokerSubscription)subs.nextElement();
                        if (bs instanceof MergedBrokerSubscription) continue;
                        SubscribeEvt subscribeEvt = bs.getSubscribeEvt();
                        subscribes.add(subscribeEvt);
                    }
                }
                ccDesc = new ClientContextDescriptor();
                ccDesc.setClientId(cc.getId());
                ccDesc.setUserId(cc.getUid());
                ccDesc.setAppId(cc.getAppid());
                ccDesc.setLastConnectedTime(cc.getLastConnectedTime());
                ccDesc.setInterbroker(cc.isInterbroker() || cc.isRemoteBroker());
                ccDesc.setCSC((ClientSecurityContext)cc.getCSC().clone());
                clients.add(ccDesc);
            }
            DynamicSyncManager.DynamicSyncClientInfo dyncSyncClientInfo = new DynamicSyncManager.DynamicSyncClientInfo();
            DynamicSyncManager.DynamicSyncClientInfo.m_clients = clients;
            DynamicSyncManager.DynamicSyncClientInfo.m_subscribes = subscribes;
            return dyncSyncClientInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnregisterAll() {
        Enumeration enu = null;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            enu = ((LongHashTable)this.m_regCl.clone()).elements();
        }
        while (enu.hasMoreElements()) {
            IClientContext cc = (IClientContext)enu.nextElement();
            cc.lock();
            try {
                if (!this.checkUnregister(cc) && !cc.isDirty()) {
                    cc.setDirty(true);
                    Long id = new Long(cc.getId());
                    this.m_dirtyClients.put(id, id);
                }
                if (!this.DEBUG) continue;
                this.debug("checkUnregisterAll " + cc + "; m_regCl.size= " + this.m_regCl.size());
            }
            finally {
                cc.unlock();
            }
        }
    }

    void fixupClientsAfterRecovery() {
        this.checkUnregisterAll();
        this.registerAllCCsWithParents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pingReplyRcvd(long id) {
        IClientContext cc;
        if (this.DEBUG) {
            this.debug("got ping reply for client " + id);
        }
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            cc = (IClientContext)this.m_regCl.get(id);
        }
        if (cc != null) {
            cc.pingReplyRcvd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientName(long id) {
        IClientContext cc;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            cc = (IClientContext)this.m_regCl.get(id);
        }
        if (cc == null) {
            return Long.toString(id);
        }
        return cc.getUid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getClientFullName(long id) {
        IClientContext cc;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            cc = (IClientContext)this.m_regCl.get(id);
        }
        if (cc == null) {
            return Long.toString(id);
        }
        return this.getClientFullName(cc);
    }

    public final String getClientFullName(IClientContext cc) {
        if (cc != null) {
            String name = cc.getUid() + "/" + cc.getAppid();
            ClientSecurityContext csc = cc.getCSC();
            if (csc != null) {
                name = name + "/" + csc.getClientIPAddress();
            }
            return name;
        }
        return "n/a";
    }

    Principal authenticate(ConnectRequest cr) throws ENoAuthService, EInauthenticClient, EPasswordExpired {
        if (!Config.ENABLE_SECURITY) {
            return new Username(cr.getUid());
        }
        if (cr instanceof CredentialsConnectRequest) {
            CredentialsConnectRequest ccr = (CredentialsConnectRequest)cr;
            ProgressPasswordUser user = this.m_secBean.getUser(ccr.getUid());
            if (user != null && user.authenticate(ccr.getPassword())) {
                return user;
            }
            return null;
        }
        throw new ENoAuthService();
    }

    @Override
    public void handleSocket(ISocket socket, IAcceptor acceptor) throws IOException {
        if (this.DEBUG) {
            this.debug("New socket connection.");
        }
        AgentConnection connection = new AgentConnection(socket, ProgressSecureRandom.theSecureRandom().nextLong());
        connection.setAcceptorName(acceptor.getAcceptorName());
        connection.setAcceptorUrl(acceptor.getURL());
        Properties acceptorProps = acceptor.getProperties();
        if (acceptorProps != null) {
            Integer initialRcvIOBufSize;
            Integer initialSendIOBufSize;
            Integer minRcvIOBufSize;
            Integer minSendIOBufSize;
            Integer maxRcvIOBufSize;
            Integer maxSendIOBufSize = (Integer)acceptorProps.get("MAX_SEND_IO_BUFFER_SIZE");
            if (maxSendIOBufSize != null) {
                connection.setMaxSendBufferSize(maxSendIOBufSize);
            }
            if ((maxRcvIOBufSize = (Integer)acceptorProps.get("MAX_RCV_IO_BUFFER_SIZE")) != null) {
                connection.setMaxRcvBufferSize(maxRcvIOBufSize);
            }
            if ((minSendIOBufSize = (Integer)acceptorProps.get("MIN_SEND_IO_BUFFER_SIZE")) != null) {
                connection.setMinSendBufferSize(minSendIOBufSize);
            }
            if ((minRcvIOBufSize = (Integer)acceptorProps.get("MIN_RCV_IO_BUFFER_SIZE")) != null) {
                connection.setMinRcvBufferSize(minRcvIOBufSize);
            }
            if ((initialSendIOBufSize = (Integer)acceptorProps.get("INITIAL_SEND_IO_BUFFER_SIZE")) != null) {
                connection.setInitialSendBufferSize(initialSendIOBufSize);
            }
            if ((initialRcvIOBufSize = (Integer)acceptorProps.get("INITIAL_RCV_IO_BUFFER_SIZE")) != null) {
                connection.setInitialRcvBufferSize(initialRcvIOBufSize);
            }
        }
        connection.startListener();
    }

    @Override
    public ProgressPasswordUser getUser(String uid) {
        return this.m_secBean.getUser(uid);
    }

    private void registerSubscriptionsForExpiration(IClientContext cc) {
        if (this.DEBUG) {
            this.debug("registering subscriptions for expiration for cc.m_id = " + cc.getId());
        }
        BrokerSubscription bs = null;
        Enumeration enu = cc.getSubscriptions().elements();
        while (enu.hasMoreElements()) {
            bs = (BrokerSubscription)enu.nextElement();
            if (!bs.getLabel().isPersistent() || !bs.isExpirable()) continue;
            if (this.DEBUG) {
                this.debug("Found a  subscription that has an expiration for topic bs.getSubject() =" + bs.getSubject());
            }
            if (bs.hasTTE()) continue;
            bs.convertTTLtoExpirationDate();
            if (this.DEBUG) {
                this.debug("logging SubscribeEvt to persist the TTE");
            }
            try {
                SubscribeEvt evt = bs.getSubscribeEvt();
                evt.setSuppressCWADSPropagation(true);
                this.subscribe(evt, false, true, null);
                if (!this.DEBUG) continue;
                this.debug("added subscription bs = " + bs + " with expiration date = " + bs.getTTE() + "to expiration queue");
            }
            catch (ESecurityPolicyViolation espv) {
            }
            catch (EClientNotRegistered ecnr) {
            }
            catch (EOldVirtualClockException eovce) {
            }
            catch (EInvalidSubjectSyntax eiss) {
            }
            catch (EInvalidTTLException ittle) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ittle, 2);
            }
            catch (ParseException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            catch (TokenMgrError e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    @Override
    public void stateChanging(int newState) {
    }

    @Override
    public void stateChanged(int newState) throws Exception {
        switch (newState) {
            case 7: {
                this.ARStartup();
                break;
            }
            case 5: {
                this.ARStandbySync();
                break;
            }
            case 6: {
                this.m_db.startCleaner();
                break;
            }
            case 8: {
                this.ARRecovery();
                break;
            }
            case 1: {
                this.ARActive();
                break;
            }
            case 4: {
                this.ARWaiting();
            }
        }
    }

    @Override
    public void stateChangeFailed(Throwable t, int state) {
    }

    public final void processExternalUsersAndGroupMap(ProgressPasswordUser user) {
        if (!Config.ENABLE_SECURITY || user == null || user.isInternalPrincipal()) {
            return;
        }
        ArrayList usersNewExternalGroups = user.getExternalGroups();
        Map groupMap = AgentRegistrar.getExternalDomainAuthSPIConfig().getGroupMap();
        ArrayList<String> internalGroupsToAddTo = new ArrayList<String>();
        if (groupMap == null || groupMap.isEmpty()) {
            internalGroupsToAddTo.add("PUBLIC");
        } else {
            for (String internalGroupName : groupMap.keySet()) {
                ArrayList<String> externalGroupsMapped = new ArrayList<String>();
                String values = (String)groupMap.get(internalGroupName);
                if (values != null) {
                    StringTokenizer st = new StringTokenizer(values, ",", false);
                    String s = null;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        if (s == null || externalGroupsMapped.contains(s)) continue;
                        externalGroupsMapped.add(s);
                    }
                }
                for (int j = 0; j < externalGroupsMapped.size(); ++j) {
                    String extenalGroupName = (String)externalGroupsMapped.get(j);
                    if (!usersNewExternalGroups.contains(extenalGroupName) || internalGroupsToAddTo.contains(internalGroupName)) continue;
                    internalGroupsToAddTo.add(internalGroupName);
                }
            }
            Vector externalGroupNames = this.getSecurityBean().getExternalGroupNames();
            if (usersNewExternalGroups != null && !usersNewExternalGroups.isEmpty() && externalGroupNames != null && !externalGroupNames.isEmpty()) {
                for (int i = 0; i < externalGroupNames.size(); ++i) {
                    String s = (String)externalGroupNames.get(i);
                    if (!usersNewExternalGroups.contains(s)) continue;
                    internalGroupsToAddTo.add(s);
                }
            }
            if (!internalGroupsToAddTo.contains("PUBLIC")) {
                internalGroupsToAddTo.add("PUBLIC");
            }
        }
        try {
            this.m_secBean.setUser(user);
        }
        catch (EPrincipalExists e) {
            Broker.getBroker().getSecurityCache().addUser(user);
        }
        catch (EPrincipalConflict e) {
            Broker.getBroker().getSecurityCache().addUser(user);
        }
        catch (IOException e) {
            Broker.getBroker().getSecurityCache().addUser(user);
        }
        for (int i = 0; i < internalGroupsToAddTo.size(); ++i) {
            String s;
            Object[] obj;
            ProgressGroup group = this.getSecurityBean().getGroup((String)internalGroupsToAddTo.get(i));
            if (group == null) continue;
            try {
                this.getSecurityBean().addGroupMember(group.getName(), user.getName());
                continue;
            }
            catch (EUnknownPrincipal ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
                obj = new Object[]{user.getName()};
                s = prMessageFormat.format(prAccessor.getString("STR362"), obj);
                BrokerComponent.getComponentContext().logMessage(s, 2);
                continue;
            }
            catch (IOException ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
                obj = new Object[]{user.getName()};
                s = prMessageFormat.format(prAccessor.getString("STR362"), obj);
                BrokerComponent.getComponentContext().logMessage(s, 2);
            }
        }
    }

    private final void createExternalUser(ClientSecurityContext csc) {
        if (Config.ENABLE_SECURITY && csc != null) {
            Principal p = csc.getPrincipal();
            String principalName = null;
            principalName = p != null ? p.getName() : csc.getUid();
            ProgressPasswordUser ppu = this.getSecurityBean().getUser(principalName);
            if (ppu == null) {
                try {
                    String[] user = new String[]{principalName};
                    Broker.getBroker().getSecurityCache().updateExternalUsers(user);
                    ppu = this.getSecurityBean().getUser(principalName);
                }
                catch (Throwable e) {
                    if (principalName != null && SubjectUtil.getSubjectGroup(principalName) != null) {
                        return;
                    }
                    Object[] obj = new Object[]{principalName};
                    String s = prMessageFormat.format(prAccessor.getString("STR364"), obj);
                    BrokerComponent.getComponentContext().logMessage(s, 2);
                }
                if (ppu == null) {
                    if (principalName != null && SubjectUtil.getSubjectGroup(principalName) != null) {
                        return;
                    }
                    Object[] obj = new Object[]{principalName};
                    String s = prMessageFormat.format(prAccessor.getString("STR362"), obj);
                    BrokerComponent.getComponentContext().logMessage(s, 2);
                }
            }
        }
    }

    public BrokerSubscription getRecoveredDurableBrokerSubscription(long id) {
        if (this.m_recoveredSubscriptions != null) {
            RecoveredSubscriptions recoveredSubs = (RecoveredSubscriptions)this.m_recoveredSubscriptions.get(new Long(id));
            BrokerSubscription bs = null;
            if (recoveredSubs != null) {
                bs = recoveredSubs.getDurableSubscription();
            }
            return bs;
        }
        return null;
    }

    private BrokerSubscription getRecoveredSubscription(long id, ISubject subject) {
        RecoveredSubscriptions recoveredSubs = (RecoveredSubscriptions)this.m_recoveredSubscriptions.get(new Long(id));
        BrokerSubscription bs = null;
        if (recoveredSubs != null) {
            bs = recoveredSubs.getSubscription(subject);
        }
        return bs;
    }

    private BrokerSubscription removeRecoveredSubscription(long id, ISubject subject) {
        Long lid = new Long(id);
        RecoveredSubscriptions recoveredSubs = (RecoveredSubscriptions)this.m_recoveredSubscriptions.get(lid);
        BrokerSubscription result = null;
        if (recoveredSubs != null) {
            result = recoveredSubs.removeSubscription(subject);
            if (recoveredSubs.size() == 0) {
                this.m_recoveredSubscriptions.remove(lid);
            }
        }
        return result;
    }

    private void addRecoveredSubscription(long id, BrokerSubscription bs, boolean interbrokerPropagate) {
        Long lid = new Long(id);
        RecoveredSubscriptions recoveredSubs = (RecoveredSubscriptions)this.m_recoveredSubscriptions.get(lid);
        if (recoveredSubs == null) {
            recoveredSubs = new RecoveredSubscriptions(id);
            this.m_recoveredSubscriptions.put(lid, recoveredSubs);
        }
        recoveredSubs.addSubscription(bs, interbrokerPropagate);
    }

    public static WSDLCache getWSDLCache() {
        return WSDLCacheLazyHolder.WSDL_CACHE;
    }

    public ArrayList<ISubscriberData> getConnectedSubscribers(String connectId, String userId) {
        String conAppId = connectId + "$CONNECTION$";
        String user = userId;
        if (user == null) {
            user = "";
        }
        if (user.indexOf(".") != -1) {
            user = user.replace('.', '$');
        }
        return this.getConnectedSubscribers(AddrUtil.stringToClientId(user, conAppId));
    }

    public ArrayList<ISubscriberData> getConnectedSubscribers(long id) {
        ArrayList<ISubscriberData> subscriptions = new ArrayList<ISubscriberData>();
        IClientContext context = null;
        try {
            context = this.getClient(id);
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
        if (context == null || !context.isConnected()) {
            return subscriptions;
        }
        if (!context.isJMSConnection()) {
            return subscriptions;
        }
        AgentConnection ac = context.getConnection();
        if (ac == null) {
            return subscriptions;
        }
        AgentSender as = ac.getAgentSender();
        if (as == null) {
            return subscriptions;
        }
        Enumeration enu = as.getCCs();
        while (enu.hasMoreElements()) {
            ISubject subject;
            ICCSizeTracker trk;
            IClientContext cc = (IClientContext)enu.nextElement();
            if (cc == null || !cc.isConnected() || (trk = cc.getCCSizeTracker()) == null && !cc.isGroupSubscriptionMember()) continue;
            BrokerSubscription bs = cc.getSubscriptions().getUserSubscription();
            ISubject iSubject = subject = bs == null ? null : bs.getSubject();
            if (subject == null) {
                if (!this.checkDebugFlags(64)) continue;
                this.debug("getConnectedSubscriptions; no user subjects; skipping " + cc);
                continue;
            }
            String jmsClientId = null;
            String subscriptionName = null;
            boolean isCC = false;
            String appId = cc.getAppid();
            if (cc.isDurable()) {
                isCC = DurableSubscriptionUtil.isConnectionConsumer(appId);
                jmsClientId = DurableSubscriptionUtil.getJMSClientID(appId);
                subscriptionName = DurableSubscriptionUtil.getSubscriptionName(appId);
            } else {
                boolean bl = isCC = appId.indexOf("$CC$$TS$") >= 0;
            }
            if (jmsClientId == null) {
                jmsClientId = "";
            }
            if (subscriptionName == null) {
                subscriptionName = "";
            }
            if (trk == null) {
                throw new NullPointerException("Tracker is null.");
            }
            long[] sizeCount = trk.getMessageCountAndSize();
            long count = sizeCount[0];
            long size = sizeCount[1];
            if (cc.isGroupSubscriptionMember() && !cc.isDurable()) {
                trk = cc.getGroupSubscriptionCC().getCCSizeTracker();
                sizeCount = trk.getMessageCountAndSize();
                count += sizeCount[0];
                size += sizeCount[1];
            }
            ISubscriberData subscription = RuntimeDataFactory.createSubscriberData(jmsClientId, subscriptionName, subject.toByteArray(), cc.isDurable(), isCC, count, size, cc.getId());
            subscriptions.add(subscription);
        }
        return subscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getCCSizeTrackersToRestore() {
        Vector<ICCSizeTracker> v = new Vector<ICCSizeTracker>();
        Enumeration enu = null;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            enu = ((LongHashTable)this.m_regCl.clone()).elements();
        }
        long maxMessageId = AgentRegistrar.getAgentRegistrar().getBrokerDatabase().getMaxAddedMessageId();
        while (enu.hasMoreElements()) {
            IClientContext cc = (IClientContext)enu.nextElement();
            ICCSizeTracker strk = cc.getCCSizeTracker();
            if (strk == null || cc.isGroupSubscriptionMember()) continue;
            if (this.m_recoveredFromLog && SessionConfig.isNonDurableSubscriber(cc.getAppid()) && (SessionConfig.isFlowToDiskSupported(cc.getAppid()) || cc.isXOnce())) {
                if (this.checkDebugFlags(64)) {
                    this.debug("getCCSizeTrackersToRestore: skipping size restore for " + cc);
                }
                strk.reset();
                continue;
            }
            if (strk.isRecovered()) continue;
            v.add(strk);
            if (!this.checkDebugFlags(64)) continue;
            this.debug("getCCSizeTrackersToRestore: added " + cc + " DbCount= " + strk.getRestorableMessageCount() + " DbSize= " + strk.getRestorableMessageSize());
        }
        if (this.checkDebugFlags(64) && !v.isEmpty()) {
            this.debug("getCCSizeTrackersToRestore: numToRestore " + v.size());
        }
        return v;
    }

    private void registerCCWithParent(IClientContext clctx) {
        block6: {
            long parentId;
            long l = parentId = clctx.getCSC() != null ? clctx.getCSC().getParentId() : -1L;
            if (parentId == -1L) {
                return;
            }
            try {
                ClientSecurityContext parentCSC = this.getClientSecurityContext(parentId);
                if (parentCSC != null) {
                    parentCSC.addChildId(clctx.getId());
                }
            }
            catch (EClientNotRegistered e) {
                if (!this.DEBUG) break block6;
                String appid = "<unavailable>";
                try {
                    appid = clctx.getAppid();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.debug("EClientNotRegistered thrown in AR.registerCCWithParent() for CC " + clctx.getId() + " (" + appid + "), parent id: " + parentId, e);
            }
        }
    }

    private void unregisterCCFromParent(IClientContext clctx) {
        long parentId;
        long l = parentId = clctx.getCSC() != null ? clctx.getCSC().getParentId() : -1L;
        if (parentId == -1L) {
            return;
        }
        try {
            ClientSecurityContext parentCSC = this.getClientSecurityContext(parentId);
            if (parentCSC != null) {
                parentCSC.removeChildId(clctx.getId());
            }
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAllCCsWithParents() {
        if (this.DEBUG) {
            this.debug("AgentRegistrer.registerAllCCsWithParents() starting");
        }
        Enumeration enu = null;
        LongHashTable longHashTable = this.m_regCl;
        synchronized (longHashTable) {
            enu = ((LongHashTable)this.m_regCl.clone()).elements();
        }
        while (enu.hasMoreElements()) {
            IClientContext cc = (IClientContext)enu.nextElement();
            this.registerCCWithParent(cc);
        }
        if (this.DEBUG) {
            this.debug("AgentRegistrer.registerAllCCsWithParents() done");
        }
    }

    static {
        m_disconnectTimerMgr = null;
    }

    private static class WSDLCacheLazyHolder {
        private static final WSDLCache WSDL_CACHE = new WSDLCache();

        private WSDLCacheLazyHolder() {
        }
    }

    private class RecoveredSubscription {
        private ISubject m_subject;
        private BrokerSubscription m_bs;
        private boolean m_interbrokerPropagate;

        RecoveredSubscription(BrokerSubscription bs, boolean interbrokerPropagate) {
            this.m_bs = bs;
            this.m_interbrokerPropagate = interbrokerPropagate;
        }

        public boolean equals(Object obj) {
            if (obj != null && this.getClass() == obj.getClass()) {
                return this.m_bs.getSubject().equals(((RecoveredSubscription)obj).getSubject());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.m_bs.getSubject());
        }

        public BrokerSubscription getSubscription() {
            return this.m_bs;
        }

        public ISubject getSubject() {
            return this.m_subject;
        }

        public boolean interbrokerPropagate() {
            return this.m_interbrokerPropagate;
        }
    }

    private class RecoveredSubscriptions {
        private HashMap m_subscriptions = new HashMap();
        private BrokerSubscription m_durableSub = null;
        private long m_id;

        RecoveredSubscriptions(long id) {
            this.m_id = id;
        }

        BrokerSubscription getSubscription(ISubject subject) {
            RecoveredSubscription rs = (RecoveredSubscription)this.m_subscriptions.get(subject);
            if (rs != null) {
                return rs.getSubscription();
            }
            return null;
        }

        boolean interbrokerPropagate(ISubject subject) {
            RecoveredSubscription rs = (RecoveredSubscription)this.m_subscriptions.get(subject);
            if (rs != null) {
                return rs.interbrokerPropagate();
            }
            return false;
        }

        void addSubscription(BrokerSubscription sub, boolean interbrokerPropagate) {
            Label label = sub.getLabel();
            if (label.isPersistent()) {
                this.m_durableSub = sub;
            }
            RecoveredSubscription rs = new RecoveredSubscription(sub, interbrokerPropagate);
            this.m_subscriptions.put(sub.getSubject(), rs);
        }

        BrokerSubscription removeSubscription(ISubject subject) {
            RecoveredSubscription rs = (RecoveredSubscription)this.m_subscriptions.remove(subject);
            if (rs != null) {
                return rs.getSubscription();
            }
            return null;
        }

        int size() {
            return this.m_subscriptions.size();
        }

        BrokerSubscription getDurableSubscription() {
            return this.m_durableSub;
        }

        void redeliverSubscriptions() {
            if (!this.m_subscriptions.isEmpty()) {
                IClientContext cc = null;
                try {
                    cc = AgentRegistrar.this.getClient(this.m_id);
                }
                catch (EClientNotRegistered e) {
                    // empty catch block
                }
                if (cc != null) {
                    for (ISubject subject : this.m_subscriptions.keySet()) {
                        BrokerSubscription bs = this.getSubscription(subject);
                        boolean interbrokerPropagate = this.interbrokerPropagate(subject);
                        try {
                            if (AgentRegistrar.this.CALLBACK) {
                                AgentRegistrar.this.callback("Adding Subscription: " + subject.getLookupName(), 1, subject.getSubjectString());
                            }
                            if (!subject.hasGroup()) {
                                if (bs.getParent() == null || !(bs.getParent() instanceof MergedBrokerSubscription)) {
                                    AgentRegistrar.this.m_regSub.put(subject, (ISubjectMatchObject)bs);
                                }
                            } else {
                                AgentRegistrar.this.m_groupSubs.addGroupSubscription(bs);
                            }
                            cc.getSubscriptions().put(subject, bs);
                            if (cc.isDurable() && bs.getLabel().isPersistent()) {
                                cc.setDurableBrokerSubscription(bs);
                            }
                            cc.checkSpecialGroupSubscription();
                            if (!interbrokerPropagate || cc.isDurable()) continue;
                            InterbrokerHook.subscribeEvent(bs);
                        }
                        catch (EInvalidSubjectSyntax e) {
                            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR250") + subject.getSubjectString() + ": " + e.getMessage(), (Throwable)e, 2);
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                        catch (ParseException e) {
                            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR250") + subject.getSubjectString() + ": " + e.getMessage(), (Throwable)e, 2);
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                        catch (TokenMgrError e) {
                            BrokerComponent.getComponentContext().logMessage("RecoveryMgr: couldn't process selector string to subject " + subject.getSubjectString() + ": " + e.getMessage(), (Throwable)e, 2);
                            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                        }
                    }
                }
            }
        }

        LinkedList getSubscriptions() {
            LinkedList<BrokerSubscription> list = null;
            if (!this.m_subscriptions.isEmpty()) {
                list = new LinkedList<BrokerSubscription>();
                Iterator iter = this.m_subscriptions.values().iterator();
                while (iter.hasNext()) {
                    list.add(((RecoveredSubscription)iter.next()).getSubscription());
                }
            }
            return list;
        }

        boolean clearSubscriptions() {
            boolean hasDurable = false;
            if (!this.m_subscriptions.isEmpty()) {
                Iterator iter = this.m_subscriptions.values().iterator();
                while (iter.hasNext()) {
                    RecoveredSubscription rs = (RecoveredSubscription)iter.next();
                    BrokerSubscription bs = rs.getSubscription();
                    if (bs.isExpirable() && bs.hasTTE()) {
                        AgentRegistrar.this.m_expSubs.remove(bs);
                    }
                    if (!hasDurable) {
                        hasDurable = bs.getLabel().isPersistent();
                    }
                    if (AgentRegistrar.this.getGSManager() != null) {
                        AgentRegistrar.this.getGSManager().globalUnsubscribe(bs);
                    }
                    iter.remove();
                }
            }
            return hasDurable;
        }
    }

    private final class SubscriptionInfo {
        boolean m_remoteSubscription;
        String[] m_selectors;
        boolean m_isSelectorAtBroker;
        boolean m_isOldSelectorAtBroker;
        boolean m_isJMSDurable;
        GSVirtualClock m_vc;
        BrokerSubscription m_bs;
        BrokerSubscription m_oldSub;
        MergedBrokerSubscription m_mergedSub;
        boolean m_firstBrokerSubscription;
        IClientContext m_remoteNodeCC;
        boolean m_needsLog;
        boolean m_needsReplicationOnly;
        Vector m_addedSelectors;
        Vector m_removedSelectors;
        ISubject m_subject;
        Label m_label;
        long m_TTE = -1L;
        boolean m_persistent;
        boolean m_gsExpirableSubject;
        private ISubject m_oldSubject;

        private SubscriptionInfo() {
        }

        void loadInfoIntoBS(SubscribeEvt evt) throws ParseException {
            this.m_bs.setMessageSelectors(this.m_selectors, this.m_addedSelectors, this.m_removedSelectors);
            this.m_bs.setSelectorAtBroker(this.m_isSelectorAtBroker);
            this.m_bs.setVirtualClock(this.m_vc);
            this.m_bs.setCreationTime(evt.getCreationTime());
            this.m_bs.setTTE(this.m_TTE);
        }
    }

    class RecoveryThread
    extends DebugThread {
        private RecoveryMgr m_rm;
        private boolean m_failed;
        private Exception m_failedException;

        RecoveryThread(RecoveryMgr rm) {
            super("RecoveryThread");
            this.m_failed = false;
            this.m_failedException = null;
            this.m_rm = rm;
        }

        @Override
        public void threadMain() {
            try {
                AgentRegistrar.this.m_inRecovery = true;
                long nextSeqNo = this.m_rm.getEventProcessor().processEvents();
                AgentRegistrar.this.m_inRecovery = false;
                if (this.DEBUG) {
                    this.debug("Completed Processing Events.");
                }
                AgentRegistrar.this.m_logmgr.resetLastSyncAdded();
                if (nextSeqNo != -1L) {
                    AgentRegistrar.this.m_logmgr.setSeqNo(nextSeqNo);
                    AgentRegistrar.this.completeRecovery(this.m_rm);
                    this.m_rm.clearMetaState();
                }
            }
            catch (EDatabaseException e) {
                this.m_failed = true;
                this.m_failedException = e;
                try {
                    BrokerComponent.getBrokerComponent().abort(prAccessor.getString("READ_LOG_FAILURE"), e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
            catch (InterruptedException e) {
                this.m_failed = true;
                this.m_failedException = e;
                try {
                    BrokerComponent.getBrokerComponent().abort(prAccessor.getString("READ_LOG_FAILURE"), e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
            catch (EStartupFailure e) {
                this.m_failed = true;
                this.m_failedException = e;
                try {
                    BrokerComponent.getBrokerComponent().abort(prAccessor.getString("READ_LOG_FAILURE"), e, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
            catch (Throwable te) {
                EStartupFailure ex = new EStartupFailure(te.toString(), te);
                this.m_failed = true;
                this.m_failedException = ex;
                try {
                    BrokerComponent.getBrokerComponent().abort(prAccessor.getString("RECOVERY_FAILURE"), ex, 1);
                }
                catch (EBrokerAborted eba) {
                    return;
                }
            }
        }

        public boolean failed() {
            return this.m_failed;
        }
    }
}

