/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.security.Principal;
import java.util.Iterator;
import progress.message.broker.BrokerSearchResults;
import progress.message.broker.SubjectAclEntry;
import progress.message.security.EUnknownPermission;
import progress.message.util.EAssertFailure;
import progress.message.zclient.FastVector;
import progress.message.zclient.Group;
import progress.message.zclient.ISubject;
import progress.message.zclient.SubjectSpace;
import progress.message.zclient.SubjectUtil;

public final class Authorize {
    private static volatile SubjectSpace m_table;

    static final void setSubjectSpace(SubjectSpace table) {
        m_table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean checkPermission(Principal user, ISubject subject, int operation) {
        if (subject == null || !subject.isSubjectSet()) {
            return true;
        }
        if (SubjectUtil.getSubjectGroup(user.getName()) != null) {
            return true;
        }
        if (subject.isReply()) {
            return true;
        }
        if (subject.isTemporary() && (operation == 1 || operation == 2)) {
            return true;
        }
        BrokerSearchResults results = new BrokerSearchResults();
        Iterator<ISubject> subjects = subject.getSingleSubjects();
        while (subjects.hasNext()) {
            boolean ok;
            SubjectAclEntry entry;
            ISubject s = subjects.next();
            m_table.get(s, results);
            SubjectAclEntry merge = null;
            int userIndex = -1;
            int count = 0;
            FastVector fastVector = results.m_userAcls;
            synchronized (fastVector) {
                count = results.m_userAcls.m_count;
            }
            boolean groupPermsFound = false;
            for (int i = count - 1; i >= 0; --i) {
                entry = null;
                FastVector fastVector2 = results.m_userAcls;
                synchronized (fastVector2) {
                    entry = (SubjectAclEntry)results.m_userAcls.m_data[i];
                }
                if (!user.equals(entry.getPrincipal())) continue;
                if (entry.includesGroupPerms()) {
                    boolean ok2;
                    groupPermsFound = true;
                    try {
                        ok2 = entry.checkPermission((byte)operation);
                    }
                    catch (EUnknownPermission e) {
                        throw new EAssertFailure("Unknown permission: " + operation, e);
                    }
                    if (ok2) break;
                    return false;
                }
                userIndex = i;
                merge = entry.copyForPrincipal(user);
            }
            if (groupPermsFound) continue;
            FastVector i = results.m_groupAcls;
            synchronized (i) {
                count = results.m_groupAcls.m_count;
            }
            for (int i2 = count - 1; i2 >= 0; --i2) {
                entry = null;
                FastVector ok2 = results.m_groupAcls;
                synchronized (ok2) {
                    entry = (SubjectAclEntry)results.m_groupAcls.m_data[i2];
                }
                if (!((Group)((Object)entry.getPrincipal())).isMember(user)) continue;
                if (merge == null) {
                    merge = entry.copyPosPermissions(user);
                    continue;
                }
                try {
                    merge.addPosPermissions(entry.getPosPermissions());
                    continue;
                }
                catch (EUnknownPermission e) {
                    throw new EAssertFailure("Invalid positive permissions: " + entry.getPosPermissions(), e);
                }
            }
            if (merge == null) {
                return false;
            }
            merge.setIncludesGroupPerms(true);
            FastVector i2 = results.m_userAcls;
            synchronized (i2) {
                if (userIndex >= 0) {
                    results.m_userAcls.m_data[userIndex] = merge;
                } else {
                    results.m_userAcls.addElement(merge);
                }
            }
            try {
                ok = merge.checkPermission((byte)operation);
            }
            catch (EUnknownPermission e) {
                throw new EAssertFailure("Unknown permission: " + operation, e);
            }
            if (ok) continue;
            return false;
        }
        return true;
    }
}

