/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import progress.message.broker.EInvalidBufferOffset;
import progress.message.broker.RandomAccessBlockFile;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class BlockBuffer
extends DebugObject {
    private static int SIZE = RandomAccessBlockFile.getBlockSize();
    private static int DATASIZE = SIZE - 4;
    private byte[] m_buffer = new byte[2 * SIZE];

    public static int getBlockSize() {
        return SIZE;
    }

    public static int getDataSize() {
        return DATASIZE;
    }

    public byte[] getBuffer() {
        return this.m_buffer;
    }

    public BlockBuffer() {
        super(DebugState.GLOBAL_DEBUG_ON ? "BlockBuffer" : null);
    }

    public synchronized int read(int off) throws IOException {
        if (off < 0 || off >= DATASIZE) {
            throw new EInvalidBufferOffset(off);
        }
        return this.m_buffer[off] & 0xFF;
    }

    public synchronized int read(int bufoff, byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        byte x = b[off];
        x = b[off + len - 1];
        if (bufoff < 0 || bufoff >= DATASIZE) {
            throw new EInvalidBufferOffset(bufoff);
        }
        if (bufoff + len > DATASIZE) {
            len = DATASIZE - bufoff;
        }
        System.arraycopy(this.m_buffer, bufoff, b, off, len);
        return len;
    }

    public synchronized int read(int bufoff, byte[] b) throws IOException {
        return this.read(bufoff, b, 0, b.length);
    }

    public synchronized void write(int off, int b) throws IOException {
        if (this.DEBUG) {
            this.debug("writing offset " + off);
        }
        if (off < 0 || off >= DATASIZE) {
            throw new EInvalidBufferOffset(off);
        }
        this.m_buffer[off] = (byte)b;
    }

    public synchronized int write(int bufoff, byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        byte x = b[off];
        x = b[off + len - 1];
        if (bufoff < 0 || bufoff > DATASIZE) {
            throw new EInvalidBufferOffset(bufoff);
        }
        if (bufoff + len > DATASIZE) {
            len = DATASIZE - bufoff;
        }
        System.arraycopy(b, off, this.m_buffer, bufoff, len);
        return len;
    }

    public synchronized int write(int bufoff, byte[] b) throws IOException {
        return this.write(bufoff, b, 0, b.length);
    }

    public synchronized int readInt(int off) {
        return (this.m_buffer[off++] & 0xFF) << 24 | (this.m_buffer[off++] & 0xFF) << 16 | (this.m_buffer[off++] & 0xFF) << 8 | this.m_buffer[off] & 0xFF;
    }

    public synchronized void writeInt(int off, int i) {
        this.m_buffer[off++] = (byte)(i >>> 24 & 0xFF);
        this.m_buffer[off++] = (byte)(i >>> 16 & 0xFF);
        this.m_buffer[off++] = (byte)(i >>> 8 & 0xFF);
        this.m_buffer[off] = (byte)(i & 0xFF);
    }

    public synchronized void writeChecksum() {
        int cs = this.calcChecksum();
        this.writeInt(DATASIZE, cs);
    }

    public synchronized boolean checksumOk() {
        return this.calcChecksum() == this.readInt(DATASIZE);
    }

    private int calcChecksum() {
        int sum = 0;
        for (int off = 0; off <= DATASIZE - 4; off += 4) {
            sum += this.readInt(off);
        }
        return sum;
    }

    public synchronized void swap(BlockBuffer b) {
        byte[] temp = this.m_buffer;
        this.m_buffer = b.m_buffer;
        b.m_buffer = temp;
    }

    synchronized void mirror() {
        System.arraycopy(this.m_buffer, 0, this.m_buffer, SIZE, SIZE);
    }
}

