/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.license.LicenseMgr;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import progress.message.broker.Broker;
import progress.message.broker.BrokerProductDecoder;
import progress.message.broker.Config;
import progress.message.broker.EExpiredEvaluationLicenseKey;
import progress.message.broker.ELogFileException;
import progress.message.broker.EStartupFailure;
import progress.message.broker.LogFile;
import progress.message.broker.prAccessor;
import progress.message.net.ProgressInetAddress;
import progress.message.resources.prMessageFormat;

public final class BrokerLicenseMgr
extends LicenseMgr {
    private static final Object MAX_CONN_WARNING_MONITOR = new Object();
    private static final long MAX_CONN_WARNING_INTERVAL_MS_DEFAULT = 60000L;
    private static long m_maxConnLastWarning = 0L;
    private static String MAX_CONN_WARNING_INTERVAL_MS_PROPERTY_NAME = "MAX_CONN_WARNING_INTERVAL_MS";
    private final int m_maxConnections;
    private final int m_maxConnectionsWarning;
    private final boolean m_enableSecurity;
    private final boolean m_enableQoP;
    private final boolean m_enableInterbroker;
    private final boolean m_enableRouting;
    private final boolean m_enableFaultTolerance;
    private final boolean m_enableHTTPDirect;
    private final boolean m_enableEnterpriseMode;
    private final int m_maxIPAddresses;
    private final boolean m_hasExpiration;
    private final int m_expirationMonth;
    private final int m_expirationYear;
    private final Vector<String> m_ipAddresses = new Vector();
    private static volatile BrokerLicenseMgr s_lm = null;
    private static final Object s_lmMonitor = new Object();
    private static long s_maxConnWarningIntervalMs;

    private static void initializeMaxConnWarningIntervalMs() {
        String sInfoMsg = "";
        String sWarnIntervalPropValue = "";
        s_maxConnWarningIntervalMs = 60000L;
        try {
            sWarnIntervalPropValue = System.getProperty(MAX_CONN_WARNING_INTERVAL_MS_PROPERTY_NAME);
            if (sWarnIntervalPropValue == null) {
                return;
            }
            s_maxConnWarningIntervalMs = Long.parseLong(sWarnIntervalPropValue);
            sInfoMsg = "[ " + MAX_CONN_WARNING_INTERVAL_MS_PROPERTY_NAME + "=" + sWarnIntervalPropValue + " ]";
        }
        catch (Exception e) {
            sInfoMsg = " [ " + MAX_CONN_WARNING_INTERVAL_MS_PROPERTY_NAME + "=" + sWarnIntervalPropValue + "; is not Numeric ]; Defaults to 60000  ";
            s_maxConnWarningIntervalMs = 60000L;
        }
        if (s_maxConnWarningIntervalMs < 0L) {
            sInfoMsg = "[ " + MAX_CONN_WARNING_INTERVAL_MS_PROPERTY_NAME + "=" + sWarnIntervalPropValue + " ] < 0; Defaults to 60000  ";
            s_maxConnWarningIntervalMs = 60000L;
        } else if (s_maxConnWarningIntervalMs > 0L && s_maxConnWarningIntervalMs < 60000L) {
            sInfoMsg = "[ 0 < [ " + MAX_CONN_WARNING_INTERVAL_MS_PROPERTY_NAME + "=" + sWarnIntervalPropValue + " ]  < 60000 ; Defaults to 60000  ";
            s_maxConnWarningIntervalMs = 60000L;
        } else if (0L == s_maxConnWarningIntervalMs) {
            sInfoMsg = "[ " + MAX_CONN_WARNING_INTERVAL_MS_PROPERTY_NAME + "=" + sWarnIntervalPropValue + " ] == 0 ; No Warning Messages Displayed ";
        }
        BrokerComponent.getComponentContext().logMessage(sInfoMsg, 3);
    }

    private BrokerLicenseMgr(String controlCode) throws Exception {
        super(controlCode);
        this.init(controlCode);
        BrokerProductDecoder pd = new BrokerProductDecoder(Config.MAJOR_VERSION + "." + Config.MINOR_VERSION, controlCode);
        this.m_maxConnections = pd.getMaxConnections();
        this.m_maxConnectionsWarning = pd.getMaxConnectionsWarning();
        this.m_maxIPAddresses = pd.getMaxIPAddresses();
        this.m_enableInterbroker = pd.isInterbrokerAllowed();
        this.m_enableRouting = pd.isRoutingAllowed();
        this.m_enableHTTPDirect = pd.isHttpDirectAllowed();
        this.m_enableEnterpriseMode = pd.isEnterprise();
        this.m_enableSecurity = true;
        this.m_enableQoP = true;
        this.m_enableFaultTolerance = pd.isFaultToleranceAllowed();
        this.m_hasExpiration = pd.hasExpiration();
        if (this.m_hasExpiration) {
            this.m_expirationMonth = pd.getExpirationMonth();
            this.m_expirationYear = pd.getExpirationYear();
        } else {
            this.m_expirationMonth = -1;
            this.m_expirationYear = -1;
        }
        if (DEBUG) {
            System.out.println("Product= " + this.m_product + ", serial= " + this.m_serial);
            System.out.println("MaxConnections= " + this.m_maxConnections + ", m_enableSecurity= " + this.m_enableSecurity + ", m_enableQoP= " + this.m_enableQoP + ", m_enableInterbroker= " + this.m_enableInterbroker + ", m_enableRouting= " + this.m_enableRouting + ", m_enableHTTPDirect= " + this.m_enableHTTPDirect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerLicenseMgr createLicenseMgr(String controlCode) throws Exception {
        Object object = s_lmMonitor;
        synchronized (object) {
            BrokerLicenseMgr lm = new BrokerLicenseMgr(controlCode);
            if (s_lm == null) {
                s_lm = lm;
            }
            return lm;
        }
    }

    public static BrokerLicenseMgr getLicenseMgr() {
        return s_lm;
    }

    protected void init(String controlCode) throws Exception {
        BrokerProductDecoder pd = new BrokerProductDecoder(Config.MAJOR_VERSION + "." + Config.MINOR_VERSION, controlCode);
        this.m_controlNumber = controlCode;
        this.m_product = pd.getProductCode();
        this.m_productName = pd.getProductName();
        this.m_count = pd.getCount();
        this.m_serial = pd.getSerialNumber();
        this.m_eval = pd.isEvaluationMode();
        if (this.m_eval) {
            this.m_evalPeriod = pd.getEvaluationPeriod();
        }
        switch (this.m_product) {
            case 43: 
            case 2486: 
            case 3117: 
            case 7704: 
            case 9117: 
            case 9704: {
                break;
            }
            default: {
                throw new Exception(prAccessor.getString("STR293"));
            }
        }
    }

    public String getLicenseBanner() {
        StringBuffer licenseBanner = new StringBuffer();
        Object[] obj = null;
        obj = new Object[]{Config.BROKER_NAME, Config.ROUTING_NODE_NAME};
        licenseBanner.append('\t');
        licenseBanner.append(prMessageFormat.format(prAccessor.getString("BROKER_NAMES"), obj));
        licenseBanner.append(Broker.NEWLINE);
        if (this.m_eval) {
            obj = new Object[]{new Integer(this.m_count).toString()};
            licenseBanner.append('\t');
            licenseBanner.append(prMessageFormat.format(prAccessor.getString("EVAL_NOTIFICATION1"), obj));
            licenseBanner.append(Broker.NEWLINE);
            licenseBanner.append('\t');
            licenseBanner.append(prAccessor.getString("EVAL_NOTIFICATION2"));
            licenseBanner.append(Broker.NEWLINE);
            licenseBanner.append('\t');
            licenseBanner.append(prAccessor.getString("EVAL_NOTIFICATION3"));
            licenseBanner.append(Broker.NEWLINE);
        }
        if (this.m_hasExpiration) {
            Integer month = new Integer(this.m_expirationMonth);
            Integer year = new Integer(this.m_expirationYear);
            obj = new Object[]{month.toString(), year.toString()};
            licenseBanner.append('\t');
            licenseBanner.append(prMessageFormat.format(prAccessor.getString("LICENSE_KEY_EXPIRATION_DATE"), obj));
            licenseBanner.append(Broker.NEWLINE);
        }
        licenseBanner.append('\t');
        if (this.m_maxConnections == -1 && Config.MAX_CONNECTIONS == -1) {
            licenseBanner.append(prAccessor.getString("STR201"));
        } else if ((this.m_maxConnections == -1 ? Integer.MAX_VALUE : this.m_maxConnections) <= (Config.MAX_CONNECTIONS == -1 ? Integer.MAX_VALUE : Config.MAX_CONNECTIONS)) {
            obj = new Object[]{new Integer(this.m_maxConnections).toString()};
            licenseBanner.append(prMessageFormat.format(prAccessor.getString("STR292a"), obj));
        } else {
            obj = new Object[]{new Integer(Config.MAX_CONNECTIONS).toString()};
            licenseBanner.append(prMessageFormat.format(prAccessor.getString("STR292b"), obj));
        }
        licenseBanner.append(Broker.NEWLINE);
        boolean securityDisabled = !this.m_enableSecurity || !Config.ENABLE_SECURITY;
        boolean qopDisabled = !securityDisabled && (!this.m_enableQoP || !Config.ENABLE_QOPSECURITY);
        boolean interbrokerDisabled = !this.m_enableInterbroker || !Config.ENABLE_INTERBROKER;
        obj = new Object[]{securityDisabled ? prAccessor.getString("DISABLED") : prAccessor.getString("ENABLED"), qopDisabled ? prAccessor.getString("STR207") : "", interbrokerDisabled ? prAccessor.getString("DISABLED") : prAccessor.getString("ENABLED")};
        licenseBanner.append('\t');
        licenseBanner.append(prMessageFormat.format(prAccessor.getString("STR206"), obj));
        licenseBanner.append(Broker.NEWLINE);
        obj = new Object[]{Config.ENABLE_ROUTING ? prAccessor.getString("ENABLED") : prAccessor.getString("DISABLED"), Config.ENABLE_HTTP_DIRECT ? prAccessor.getString("ENABLED") : prAccessor.getString("DISABLED")};
        licenseBanner.append('\t');
        licenseBanner.append(prMessageFormat.format(prAccessor.getString("STR206a"), obj));
        licenseBanner.append(Broker.NEWLINE);
        if (this.m_maxIPAddresses > 0) {
            licenseBanner.append('\t');
            if (this.m_maxIPAddresses == 1) {
                licenseBanner.append(prAccessor.getString("IP_ADDRESS_LIMITONE"));
            } else {
                obj = new Object[]{new Integer(this.m_maxIPAddresses).toString()};
                licenseBanner.append(prMessageFormat.format(prAccessor.getString("IP_ADDRESS_LIMIT"), obj));
            }
            licenseBanner.append(Broker.NEWLINE);
        }
        obj = new Object[]{Config.USE_DYNAMIC_HOST_BINDING ? prAccessor.getString("ENABLED") : prAccessor.getString("DISABLED")};
        licenseBanner.append('\t');
        licenseBanner.append(prMessageFormat.format(prAccessor.getString("STR206b"), obj));
        licenseBanner.append(Broker.NEWLINE);
        return licenseBanner.toString();
    }

    private static boolean checkLicenseLimit(int connectionCount) {
        if (BrokerLicenseMgr.s_lm.m_maxConnections == -1) {
            return true;
        }
        return connectionCount <= BrokerLicenseMgr.s_lm.m_maxConnections;
    }

    private static boolean checkAdminLimit(int connectionCount) {
        if (Config.MAX_CONNECTIONS == -1) {
            return true;
        }
        return connectionCount <= Config.MAX_CONNECTIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkConnectionLimit(int num_connections, int numMFConnections) {
        if (BrokerLicenseMgr.checkLicenseLimit(num_connections)) {
            int maxConnWarning = BrokerLicenseMgr.s_lm.m_maxConnectionsWarning;
            if (maxConnWarning > 0 && num_connections >= maxConnWarning && s_maxConnWarningIntervalMs != 0L) {
                Object object = MAX_CONN_WARNING_MONITOR;
                synchronized (object) {
                    long now = System.currentTimeMillis();
                    if (Math.abs(now - m_maxConnLastWarning) > s_maxConnWarningIntervalMs) {
                        String msg = prAccessor.format("MAX_CONNECTIONS_WARNING", num_connections, BrokerLicenseMgr.s_lm.m_maxConnectionsWarning, BrokerLicenseMgr.s_lm.m_maxConnections);
                        BrokerComponent.getComponentContext().logMessage(msg, 2);
                        m_maxConnLastWarning = now;
                    }
                }
            }
            return BrokerLicenseMgr.checkAdminLimit(num_connections - numMFConnections);
        }
        return false;
    }

    public boolean isSecurityEnabled() {
        return this.m_enableSecurity;
    }

    public boolean isQoPEnabled() {
        return this.m_enableQoP;
    }

    public boolean isRoutingAllowed() {
        return this.m_enableRouting;
    }

    public boolean isInterbrokerAllowed() {
        return this.m_enableInterbroker;
    }

    public boolean isHTTPDirectAllowed() {
        return this.m_enableHTTPDirect;
    }

    public boolean isFaultToleranceAllowed() {
        return this.m_enableFaultTolerance;
    }

    public boolean isEnterpriseEdition() {
        return this.m_enableEnterpriseMode;
    }

    public boolean checkIPAddressLimit(String lookupIpAddress) {
        if (this.m_maxIPAddresses == -1) {
            return true;
        }
        String ipAddress = lookupIpAddress;
        try {
            ProgressInetAddress address = ProgressInetAddress.getByName(ipAddress);
            ipAddress = address.isLoopbackAddress() ? ProgressInetAddress.getLocalHost().getHostAddress(false) : address.getHostAddress(false);
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (this.m_ipAddresses.contains(ipAddress)) {
            return true;
        }
        int numIPSources = this.m_ipAddresses.size();
        if (numIPSources >= this.m_maxIPAddresses) {
            String msgFmt = prAccessor.getString("IP_ADDRESS_DISALLOW");
            Object[] mObj = new String[]{ipAddress};
            String msg = prMessageFormat.format(msgFmt, mObj);
            BrokerComponent.getComponentContext().logMessage(msg, 2);
            return false;
        }
        String msgFmt = prAccessor.getString("IP_ADDRESS_ALLOW");
        Object[] mObj = new String[]{ipAddress};
        String msg = prMessageFormat.format(msgFmt, mObj);
        BrokerComponent.getComponentContext().logMessage(msg, 3);
        this.m_ipAddresses.addElement(ipAddress);
        return true;
    }

    protected void evalExpiredCheck() throws Exception {
        if (!this.m_eval) {
            return;
        }
        boolean evalExpired = false;
        LogFile lf = null;
        try {
            lf = new LogFile();
            lf.open();
        }
        catch (FileNotFoundException fnfe) {
            throw new EStartupFailure(prAccessor.getString("STR215"));
        }
        catch (IOException ioe) {
            throw new EStartupFailure(prAccessor.getString("STR216") + ioe);
        }
        long timestamp = lf.getTimestamp();
        long trialPeriodInDays = this.m_evalPeriod;
        long evalPeriodInMilliSecs = trialPeriodInDays * 86400000L;
        long expTime = timestamp + evalPeriodInMilliSecs;
        if (expTime < System.currentTimeMillis()) {
            evalExpired = true;
        }
        try {
            lf.close();
        }
        catch (IOException ioe) {
            throw new ELogFileException(prAccessor.getString("LOG_FILE_CLOSE_ERROR") + ioe);
        }
        if (evalExpired) {
            Object[] obj = new Object[]{new Integer(this.m_count).toString()};
            throw new EExpiredEvaluationLicenseKey(MessageFormat.format(prAccessor.getString("EVAL_PERIOD_EXPIRED"), obj));
        }
    }

    protected void checkExpiration() throws EExpiredEvaluationLicenseKey {
        if (!this.m_hasExpiration) {
            return;
        }
        GregorianCalendar today = new GregorianCalendar();
        int year = this.m_expirationYear;
        int month = this.m_expirationMonth - 1;
        int day = 1;
        GregorianCalendar expirationDate = new GregorianCalendar(year, month, day);
        if (!today.before(expirationDate)) {
            Object[] obj = new Object[]{expirationDate.getTime().toString()};
            throw new EExpiredEvaluationLicenseKey(MessageFormat.format(prAccessor.getString("LICENSE_KEY_EXPIRED"), obj));
        }
    }

    public void registerIPAddressInUse(String ipAddress) {
        if (this.m_maxIPAddresses == -1) {
            return;
        }
        if (this.m_ipAddresses.contains(ipAddress)) {
            return;
        }
        this.m_ipAddresses.addElement(ipAddress);
    }

    static {
        BrokerLicenseMgr.initializeMaxConnWarningIntervalMs();
    }
}

