/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.license.LicenseDecoder;
import com.sonicsw.mf.common.license.ProductDecoder;

public final class BrokerProductDecoder
extends ProductDecoder {
    public static final int PDTCODE_PROFDEVELOPER = 3117;
    public static final int PDTCODE_FT_EVALUATION_EDITION = 7704;
    public static final int PDTCODE_FT = 2486;
    public static final int PDTCODE_ENTERPRISE = 43;
    public static final int PDTCODE_ENTERPRISE_PROFDEVELOPER = 9117;
    public static final int PDTCODE_ENTERPRISE_EVALUATION_EDITION = 9704;
    public static final int MAX_CONN_HARD_LIMIT = 1500;
    public static final int MAX_CONN_SOFT_LIMIT = 1200;
    private static final int[] PRODUCT_CODES = new int[]{3117, 7704, 2486, 43, 9117, 9704};
    private static final String[] PRODUCT_NAMES = new String[]{"SonicMQ 2015 Developer Edition", "SonicMQ 2015 Evaluation Edition", "SonicMQ 2015", "SonicMQ 2015 Enterprise Edition", "SonicMQ 2015 Enterprise Developer Edition", "SonicMQ 2015 Enterprise Evaluation Edition"};
    public static final String FEATURE_EVAL_MODE = "Evaluation Mode";
    public static final String FEATURE_EVAL_PERIOD = "Evaluation Period";
    public static final String FEATURE_EXPIRES = "Expires";
    public static final String FEATURE_EXPIRATION_MONTH = "Expiration Month";
    public static final String FEATURE_EXPIRATION_YEAR = "Expiration Year";
    public static final String FEATURE_INTERBROKER = "Enable Interbroker";
    public static final String FEATURE_DRA = "Enable Dynamic Routing";
    public static final String FEATURE_HTTP_DIRECT = "Enable HTTP Direct";
    public static final String FEATURE_MAX_CONNECTIONS = "Max Connections";
    public static final String FEATURE_MAX_CONNECTIONS_WARNING = "Max Connections Warning";
    public static final String FEATURE_MAX_IP_ADDRESSES = "Max IP Addresses";
    public static final String FEATURE_FT = "Enable Fault Tolerance";
    private static final String[] FEATURE_LIST = new String[]{"Evaluation Mode", "Evaluation Period", "Expires", "Expiration Month", "Expiration Year", "Enable Interbroker", "Enable Dynamic Routing", "Enable HTTP Direct", "Enable Fault Tolerance", "Max Connections", "Max Connections Warning", "Max IP Addresses"};
    protected int m_maxConnections = -1;
    protected int m_maxConnectionsWarning = -1;
    protected int m_maxIPAddresses = -1;
    protected boolean m_interbrokerAllowed = false;
    protected boolean m_routingAllowed = false;
    protected boolean m_httpDirectAllowed = false;
    protected boolean m_faultToleranceAllowed = false;
    protected boolean m_hasExpiration = false;
    protected int m_expirationMonth = -1;
    protected int m_expirationYear = -1;
    protected boolean m_isEnterprise = false;

    public BrokerProductDecoder(String version, String controlCode) throws Exception {
        super(version, controlCode);
        LicenseDecoder ld = new LicenseDecoder(version, controlCode);
        this.validate(ld);
    }

    protected void validate(LicenseDecoder ld) {
        int pdtCode = ld.getProduct();
        for (int i = 0; i < PRODUCT_CODES.length; ++i) {
            if (pdtCode != PRODUCT_CODES[i]) continue;
            this.m_productIndex = i;
            break;
        }
        this.m_productCode = pdtCode;
        this.m_count = ld.getCount();
        this.m_serial = ld.getSerial();
        switch (this.m_productCode) {
            case 7704: 
            case 9704: {
                this.m_eval = true;
                this.m_evalPeriod = this.m_count;
            }
            case 43: 
            case 2486: 
            case 3117: 
            case 9117: {
                this.m_interbrokerAllowed = true;
                this.m_routingAllowed = true;
                this.m_httpDirectAllowed = true;
                this.m_faultToleranceAllowed = true;
            }
        }
        switch (this.m_productCode) {
            case 43: 
            case 9117: 
            case 9704: {
                this.m_maxConnections = -1;
                this.m_maxConnectionsWarning = -1;
                this.m_isEnterprise = true;
                break;
            }
            default: {
                if (Boolean.getBoolean("SonicMQ.legacy.connection.limiting")) {
                    this.m_maxConnections = -1;
                    this.m_maxConnectionsWarning = -1;
                } else {
                    this.m_maxConnections = 1500;
                    this.m_maxConnectionsWarning = 1200;
                }
                this.m_isEnterprise = false;
            }
        }
    }

    public boolean isEnterprise() {
        return this.m_isEnterprise;
    }

    public final String getProductName() {
        if (this.m_productIndex < 0) {
            return null;
        }
        return PRODUCT_NAMES[this.m_productIndex];
    }

    public final boolean isEvaluationMode() {
        return this.m_eval;
    }

    public final boolean isInterbrokerAllowed() {
        return this.m_interbrokerAllowed;
    }

    public final boolean isRoutingAllowed() {
        return this.m_routingAllowed;
    }

    public final boolean isHttpDirectAllowed() {
        return this.m_httpDirectAllowed;
    }

    public final boolean isFaultToleranceAllowed() {
        return this.m_faultToleranceAllowed;
    }

    public final int getMaxConnections() {
        return this.m_maxConnections;
    }

    public final int getMaxConnectionsWarning() {
        return this.m_maxConnectionsWarning;
    }

    public final int getMaxIPAddresses() {
        return this.m_maxIPAddresses;
    }

    public final boolean hasExpiration() {
        return this.m_hasExpiration;
    }

    public final int getExpirationMonth() {
        return this.m_expirationMonth;
    }

    public final int getExpirationYear() {
        return this.m_expirationYear;
    }

    public final String[] getFeatureList() {
        return FEATURE_LIST;
    }

    public final String getFeatureValue(String feature) {
        if (FEATURE_EVAL_MODE.equals(feature)) {
            return String.valueOf(this.isEvaluationMode());
        }
        if (FEATURE_EVAL_PERIOD.equals(feature)) {
            return String.valueOf(this.getEvaluationPeriod());
        }
        if (FEATURE_EXPIRES.equals(feature)) {
            return String.valueOf(this.hasExpiration());
        }
        if (FEATURE_EXPIRATION_MONTH.equals(feature)) {
            return String.valueOf(this.getExpirationMonth());
        }
        if (FEATURE_EXPIRATION_YEAR.equals(feature)) {
            return String.valueOf(this.getExpirationYear());
        }
        if (FEATURE_INTERBROKER.equals(feature)) {
            return String.valueOf(this.isInterbrokerAllowed());
        }
        if (FEATURE_DRA.equals(feature)) {
            return String.valueOf(this.isRoutingAllowed());
        }
        if (FEATURE_HTTP_DIRECT.equals(feature)) {
            return String.valueOf(this.isHttpDirectAllowed());
        }
        if (FEATURE_MAX_CONNECTIONS.equals(feature)) {
            return String.valueOf(this.getMaxConnections());
        }
        if (FEATURE_MAX_CONNECTIONS_WARNING.equals(feature)) {
            return String.valueOf(this.getMaxConnectionsWarning());
        }
        if (FEATURE_MAX_IP_ADDRESSES.equals(feature)) {
            return String.valueOf(this.getMaxIPAddresses());
        }
        if (FEATURE_FT.equals(feature)) {
            return String.valueOf(this.isFaultToleranceAllowed());
        }
        return null;
    }
}

