/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStatus;
import progress.message.broker.Config;
import progress.message.broker.IStateController;
import progress.message.broker.IStateListener;
import progress.message.util.EAssertFailure;
import progress.message.util.PriorityQueue;
import progress.message.zclient.ConnectionFailoverStatus;
import progress.message.zclient.DebugThread;

public class BrokerStateManager
implements BrokerStatus {
    private static volatile BrokerStateManager m_brokerStateMgr = null;
    private volatile int m_brokerState = 0;
    private LinkedList m_eventListeners = new LinkedList();
    private IStateController[][] m_controllers = new IStateController[10][10];
    private LinkedList m_controllerList = new LinkedList();
    private Object m_continuerThreadSyncObject = new Object();
    private BrokerStateManagerThread m_bsmThread = null;
    private Thread m_currentStateContinuerThread = null;
    private boolean m_informingListeners = false;
    private volatile boolean m_kill = false;
    private PriorityQueue m_stateChangeQueue = new PriorityQueue(1);

    private BrokerStateManager() {
        this.m_bsmThread = new BrokerStateManagerThread();
        this.m_bsmThread.start();
    }

    public static void resetBrokerStateManager() {
        m_brokerStateMgr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BrokerStateManager getBrokerStateManager() {
        if (m_brokerStateMgr != null) return m_brokerStateMgr;
        Class<BrokerStateManager> clazz = BrokerStateManager.class;
        synchronized (BrokerStateManager.class) {
            if (m_brokerStateMgr != null) return m_brokerStateMgr;
            m_brokerStateMgr = new BrokerStateManager();
            try {
                m_brokerStateMgr.initializeBrokerComponents();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return m_brokerStateMgr;
        }
    }

    public ConnectionFailoverStatus getConnectionFailoverStatus(AgentConnection c) {
        Acceptor acc;
        Enumeration acceptors;
        String acceptorName = c.getAcceptorName();
        ArrayList<String> localUrlList = new ArrayList<String>();
        ArrayList<String> standbyUrlList = new ArrayList<String>();
        AcceptorHolder ah = AcceptorHolder.getAcceptorHolder();
        String localDefaultRouting = ah.getDefaultRoutingURL();
        if (acceptorName != null && (acceptors = ah.getAcceptors(acceptorName)) != null) {
            while (acceptors.hasMoreElements()) {
                acc = (Acceptor)acceptors.nextElement();
                String externalURL = acc.getExternalURL();
                if (externalURL == null) continue;
                localUrlList.add(externalURL);
            }
        }
        if (localUrlList.isEmpty()) {
            if (localDefaultRouting != null) {
                localUrlList.add(localDefaultRouting);
            } else if (acceptorName != null && (acceptors = ah.getAcceptors(acceptorName)) != null) {
                while (acceptors.hasMoreElements()) {
                    acc = (Acceptor)acceptors.nextElement();
                    localUrlList.add(acc.getURL());
                }
            }
        }
        if ((ah = Broker.getBroker().getFTPeerAcceptorHolder()) != null) {
            Acceptor acc2;
            Enumeration acceptors2;
            String standbyDefaultRouting = ah.getDefaultRoutingURL();
            if (acceptorName != null && (acceptors2 = ah.getAcceptors(acceptorName)) != null) {
                while (acceptors2.hasMoreElements()) {
                    acc2 = (Acceptor)acceptors2.nextElement();
                    String externalURL = acc2.getExternalURL();
                    if (externalURL == null) continue;
                    standbyUrlList.add(externalURL);
                }
            }
            if (standbyUrlList.isEmpty()) {
                if (standbyDefaultRouting != null) {
                    standbyUrlList.add(standbyDefaultRouting);
                } else if (acceptorName != null && (acceptors2 = ah.getAcceptors(acceptorName)) != null) {
                    while (acceptors2.hasMoreElements()) {
                        acc2 = (Acceptor)acceptors2.nextElement();
                        standbyUrlList.add(acc2.getURL());
                    }
                }
            }
        }
        String[] localurls = new String[localUrlList.size()];
        localUrlList.toArray(localurls);
        String[] standbyurls = new String[standbyUrlList.size()];
        standbyUrlList.toArray(standbyurls);
        return new ConnectionFailoverStatus(this.m_brokerState, null, localurls, standbyurls);
    }

    public void registerListener(IStateListener listener) throws Exception {
        this.m_eventListeners.add(listener);
        listener.stateChanged(this.m_brokerState);
    }

    public void registerController(IStateController controller, int previousState, int nextState) {
        this.m_controllers[previousState][nextState] = controller;
        if (!this.m_controllerList.contains(controller)) {
            this.m_controllerList.add(controller);
        }
    }

    public void registerStartupController(IStateController controller) {
        this.registerController(controller, 0, 7);
    }

    public void setStateStartup(IStateController controllerObject) {
        this.setState(7, controllerObject);
    }

    public void setStateActive(IStateController controllerObject) {
        this.setState(2, controllerObject);
    }

    public void setStateStandby(IStateController controllerObject) {
        this.setState(6, controllerObject);
    }

    public void setStateRecovery(IStateController controllerObject) {
        this.setState(8, controllerObject);
    }

    public void setStateRecoveryComplete(IStateController controllerObject) {
        this.setState(9, controllerObject);
    }

    public void setStateActiveSync(IStateController controllerObject) {
        this.setState(3, controllerObject);
    }

    public void setStateStandbySync(IStateController controllerObject) {
        this.setState(5, controllerObject);
    }

    public void setStateWaiting(IStateController controllerObject) {
        this.setState(4, controllerObject);
    }

    public void setStateStandalone(IStateController contollerObject) {
        this.setState(1, contollerObject);
    }

    public synchronized boolean setState(int status, IStateController controllerObject) {
        if (status == this.m_brokerState) {
            return false;
        }
        if (this.m_informingListeners) {
            throw new EAssertFailure("Cannot start a state transition to " + BrokerStatus.State.get(status) + " while the transition to " + BrokerStatus.State.get(this.m_brokerState) + " still in progress!");
        }
        if (controllerObject != this.m_controllers[this.m_brokerState][status]) {
            throw new EAssertFailure("Invalid controller performing state transition.");
        }
        if (Thread.currentThread() == this.m_currentStateContinuerThread) {
            throw new EAssertFailure("Cannot change state from within a Status Listener");
        }
        this.m_brokerState = status;
        this.m_stateChangeQueue.enqueue(new Integer(status), 0);
        return true;
    }

    private synchronized void informStatusControllers(int status) {
        Iterator iter = this.m_controllerList.iterator();
        while (iter.hasNext()) {
            ((IStateController)iter.next()).stateChangeComplete(status);
        }
    }

    private void informStatusControllersOfFailure(Throwable t, int status) {
        Iterator iter = this.m_controllerList.iterator();
        while (iter.hasNext()) {
            ((IStateController)iter.next()).stateChangeFailed(t, status);
        }
    }

    private void initializeBrokerComponents() throws Exception {
        this.registerListener(AgentRegistrar.getAgentRegistrar());
        this.registerController(AgentRegistrar.getAgentRegistrar(), 7, 4);
        this.registerController(AgentRegistrar.getAgentRegistrar(), 7, 8);
        this.registerController(AgentRegistrar.getAgentRegistrar(), 8, 9);
        this.registerController(AgentRegistrar.getAgentRegistrar(), 9, 1);
    }

    public boolean isActive() {
        return BrokerStateManager.isActive(this.m_brokerState);
    }

    public boolean isWaiting() {
        return this.m_brokerState == 4;
    }

    public int getState() {
        return this.m_brokerState;
    }

    public static boolean isActive(int state) {
        return state == 2 || state == 3 || state == 1 || state == 8 || state == 9;
    }

    public static boolean isFaultTolerant() {
        return Config.REPLICATED;
    }

    public void waitForStatusChange(IStateListener sl) throws Throwable {
        this.m_bsmThread.waitForStateChange(sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) throws InterruptedException {
        if (this.m_bsmThread != null) {
            this.m_bsmThread.shutdown();
            if (wait) {
                if (this.m_bsmThread != Thread.currentThread()) {
                    this.m_bsmThread.join();
                }
            } else {
                Object object = this.m_continuerThreadSyncObject;
                synchronized (object) {
                    this.m_kill = true;
                    Thread currentThread = this.m_currentStateContinuerThread;
                    if (currentThread != null) {
                        currentThread.interrupt();
                    }
                    this.m_bsmThread.interrupt();
                }
            }
        }
        this.m_bsmThread = null;
    }

    class BrokerStateManagerThread
    extends DebugThread {
        private Object m_stateChangeSyncObject;
        private LinkedList m_listenersChanged;
        private Throwable m_throwable;

        BrokerStateManagerThread() {
            super("BrokerStateManagerThread");
            this.m_stateChangeSyncObject = new Object();
            this.m_listenersChanged = new LinkedList();
            this.m_throwable = null;
        }

        @Override
        public void threadMain() {
            try {
                while (!this.isShuttingDown()) {
                    int newState = this.waitForStateChange();
                    this.changeState(newState);
                    if (this.m_throwable == null) {
                        BrokerStateManager.this.informStatusControllers(newState);
                        continue;
                    }
                    BrokerStateManager.this.informStatusControllersOfFailure(this.m_throwable, newState);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private int waitForStateChange() throws InterruptedException {
            return (Integer)BrokerStateManager.this.m_stateChangeQueue.dequeueWait();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void changeState(int newState) throws InterruptedException {
            BrokerStateManager.this.m_informingListeners = true;
            LinkedList listeners = (LinkedList)BrokerStateManager.this.m_eventListeners.clone();
            Iterator iter = listeners.iterator();
            this.setStateChanging(newState, iter);
            if (this.m_throwable != null) {
                return;
            }
            BrokerStateManager.this.m_informingListeners = false;
            listeners = (LinkedList)BrokerStateManager.this.m_eventListeners.clone();
            Object object = this.m_stateChangeSyncObject;
            synchronized (object) {
                BrokerStateContinuerThread stateContinuerThread = new BrokerStateContinuerThread(null, newState, this.m_stateChangeSyncObject, listeners, 0);
                Object object2 = BrokerStateManager.this.m_continuerThreadSyncObject;
                synchronized (object2) {
                    BrokerStateManager.this.m_currentStateContinuerThread = stateContinuerThread;
                }
                stateContinuerThread.start();
                this.m_stateChangeSyncObject.wait();
            }
            this.m_listenersChanged.clear();
            BrokerStateManager.this.m_currentStateContinuerThread = null;
        }

        private void setStateChanging(int state, Iterator iter) {
            try {
                while (iter.hasNext()) {
                    ((IStateListener)iter.next()).stateChanging(state);
                }
            }
            catch (Throwable t) {
                this.m_throwable = t;
            }
        }

        public void waitForStateChange(IStateListener sl) throws Throwable {
            ((BrokerStateContinuerThread)BrokerStateManager.this.m_currentStateContinuerThread).waitForStateChange(sl);
        }

        class BrokerStateContinuerThread
        extends DebugThread {
            private int m_state;
            private Object m_notifySyncObject;
            private Object m_waitSyncObject;
            private LinkedList m_listeners;
            private int m_index;
            private IStateListener m_stateListener;

            BrokerStateContinuerThread(IStateListener sl, int state, Object syncObject, LinkedList listeners, int index) {
                super("BrokerStateContinuerThread");
                this.m_stateListener = null;
                this.m_state = state;
                this.m_notifySyncObject = syncObject;
                this.m_waitSyncObject = new Object();
                this.m_listeners = listeners;
                this.m_index = index;
                this.m_stateListener = sl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadMain() {
                try {
                    int size = this.m_listeners.size();
                    while (this.m_index < size && !BrokerStateManager.this.m_kill) {
                        IStateListener sl = (IStateListener)this.m_listeners.get(this.m_index);
                        sl.stateChanged(this.m_state);
                        BrokerStateManagerThread.this.m_listenersChanged.add(sl);
                        if (sl == this.m_stateListener) {
                            Object object = this.m_notifySyncObject;
                            synchronized (object) {
                                this.m_notifySyncObject.notifyAll();
                            }
                            return;
                        }
                        ++this.m_index;
                    }
                    Object object = this.m_notifySyncObject;
                    synchronized (object) {
                        this.m_notifySyncObject.notifyAll();
                    }
                }
                catch (Throwable t) {
                    BrokerStateManagerThread.this.m_throwable = t;
                    Object object = this.m_notifySyncObject;
                    synchronized (object) {
                        this.m_notifySyncObject.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForStateChange(IStateListener sl) throws Throwable {
                if (Thread.currentThread() != this) {
                    throw new EAssertFailure("Cannot wait for state change outside of current status listener");
                }
                if (BrokerStateManagerThread.this.m_listenersChanged.contains(sl)) {
                    return;
                }
                BrokerStateContinuerThread t = new BrokerStateContinuerThread(sl, this.m_state, this.m_waitSyncObject, this.m_listeners, this.m_index + 1);
                Object object = BrokerStateManager.this.m_continuerThreadSyncObject;
                synchronized (object) {
                    BrokerStateManager.this.m_currentStateContinuerThread = t;
                }
                object = this.m_waitSyncObject;
                synchronized (object) {
                    t.start();
                    this.m_waitSyncObject.wait();
                    if (BrokerStateManagerThread.this.m_throwable != null) {
                        throw BrokerStateManagerThread.this.m_throwable;
                    }
                }
                this.m_index = t.getIndex();
                object = BrokerStateManager.this.m_continuerThreadSyncObject;
                synchronized (object) {
                    BrokerStateManager.this.m_currentStateContinuerThread = this;
                }
            }

            private int getIndex() {
                return this.m_index;
            }
        }
    }
}

