/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import progress.message.broker.Config;
import progress.message.broker.GroupSubscription;
import progress.message.broker.IBrokerSubscription;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.MergedBrokerSubscription;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.MessageSelector;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.Selector;
import progress.message.broker.parser.TokenMgrError;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.util.QueueUtil;
import progress.message.zclient.DebugObject;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.Label;
import progress.message.zclient.SearchResults;
import progress.message.zclient.SessionConfig;

public class BrokerSubscription
extends DebugObject
implements IBrokerSubscription,
ISubjectMatchObject {
    private static final long s_maxTTL = 315360000000L;
    private boolean m_enforceDurableStrictMessageOrder = false;
    private int m_flowToDisk = 0;
    private long m_creationTime = -1L;
    private long m_previousBrokerCID = -1L;
    private long m_restoreToBrokerCID = -1L;
    private HashSet m_inDoubtProxies = null;
    private ISubject m_subject;
    private boolean m_isGroup;
    private volatile GroupSubscription m_group;
    private Label m_label;
    private long m_TTE;
    private IClientContext m_client;
    private Label m_msgDeliveryLabel;
    private MergedBrokerSubscription m_parent;
    private long m_expQKey = -1L;
    private int m_expQIndex = -1;
    private boolean m_ibMark;
    private boolean m_isSelectorAtBroker = false;
    protected Hashtable m_selectors = null;
    protected boolean m_hasEmptySelector = false;
    private SelectorInfo m_singleSelector = null;
    protected String[] m_messageSelectorStrings = null;
    private boolean m_selectorsUnknown = false;
    private boolean m_unfiltered = false;
    private GSVirtualClock m_virtualClock = null;
    private boolean m_replicateOnly = false;

    public MergedBrokerSubscription getParent() {
        return this.m_parent;
    }

    public void setParent(MergedBrokerSubscription parentSub) {
        this.m_parent = parentSub;
    }

    public long getClientId() {
        return this.m_client.getId();
    }

    public IClientContext getClient() {
        return this.m_client;
    }

    public void setClient(IClientContext cc) {
        this.m_client = cc;
    }

    @Override
    public synchronized Label getLabel() {
        return this.m_label;
    }

    synchronized void setLabel(Label l) {
        Label oldLabel = this.m_label;
        this.m_label = l;
        if (!SessionConfig.isSystemSubject(this.m_subject) && InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(this.m_client.getId())) {
            if (this.m_label.isGuaranteed()) {
                this.m_msgDeliveryLabel = (Label)this.m_label.clone();
                this.m_msgDeliveryLabel.setGuaranteed(false);
            } else {
                this.m_msgDeliveryLabel = null;
            }
            if (this.checkDebugFlags(64)) {
                this.debug("*****BrokerSubscription.setLabel: oldLabel= " + oldLabel + " new label= " + this.m_label + " m_msgDeliveryLabel: " + this.m_msgDeliveryLabel + " subj= " + this.m_subject.getSubjectString() + " " + this.m_client + " " + Thread.currentThread());
            }
        }
    }

    public ISubject getSubject() {
        return this.m_subject;
    }

    void setSubject(ISubject subject) {
        this.m_subject = subject;
    }

    public String getTopic() {
        return this.m_subject.getLookupName();
    }

    public long getCreationTime() {
        return this.m_creationTime;
    }

    public long getPreviousBrokerCID() {
        return this.m_previousBrokerCID;
    }

    public long getRestoreToBrokerCID() {
        return this.m_restoreToBrokerCID;
    }

    void setCreationTime(long creationTime) {
        this.m_creationTime = creationTime;
    }

    void setPreviousBrokerCID(long previousBrokerCID) {
        this.m_previousBrokerCID = previousBrokerCID;
    }

    void setRestoreToBrokerCID(long restoreToBrokerCID) {
        this.m_restoreToBrokerCID = restoreToBrokerCID;
    }

    public void setInDoubtProxies(HashSet proxies) {
        this.m_inDoubtProxies = proxies;
    }

    public HashSet getInDoubtProxies() {
        return this.m_inDoubtProxies;
    }

    public boolean isGroupMember() {
        return this.m_isGroup;
    }

    public void setGroup(GroupSubscription group) {
        this.m_group = group;
    }

    public GroupSubscription getGroup() {
        return this.m_group;
    }

    boolean hasSelectors() {
        return this.m_selectors.size() > 0 && !this.m_hasEmptySelector;
    }

    final boolean hasSelector() {
        if (this.m_selectors.size() > 1) {
            throw new EAssertFailure("Not a single selector");
        }
        return this.m_singleSelector != null && this.m_singleSelector.m_messageSelector != null;
    }

    SubscribeEvt getSubscribeEvt() {
        SubscribeEvt evt = null;
        String[] selectorStrs = this.getSelectorStrings();
        if (this.m_virtualClock != null) {
            evt = new GSSubscribeEvt(null, this.m_client.getId(), this.m_subject, this.m_label, selectorStrs, this.m_isSelectorAtBroker, this.m_virtualClock);
        } else if (selectorStrs != null) {
            evt = new SubscribeEvtForSelector(null, this.m_client.getId(), this.m_subject, this.m_label, selectorStrs, this.m_isSelectorAtBroker);
            evt.setCreationTime(this.m_creationTime);
            evt.setPreviousBrokerCID(this.m_previousBrokerCID);
            evt.setRestoreToBrokerCID(this.m_restoreToBrokerCID);
        } else {
            evt = new SubscribeEvt(null, this.m_client.getId(), this.m_subject, this.m_label);
            evt.setCreationTime(this.m_creationTime);
            evt.setPreviousBrokerCID(this.m_previousBrokerCID);
            evt.setRestoreToBrokerCID(this.m_restoreToBrokerCID);
        }
        evt.setTTE(this.getTTE());
        evt.setReplicateOnly(this.m_replicateOnly);
        return evt;
    }

    public synchronized String[] getSelectorStrings() {
        if (this.m_messageSelectorStrings != null) {
            return this.m_messageSelectorStrings;
        }
        if (this.m_selectorsUnknown) {
            return null;
        }
        String[] selectorStrings = null;
        if (this.m_singleSelector != null) {
            selectorStrings = new String[]{this.m_singleSelector.m_messageSelectorString};
        } else if (!this.m_selectors.isEmpty()) {
            selectorStrings = new String[this.m_selectors.size()];
            Enumeration selectors = this.m_selectors.elements();
            int ii = 0;
            SelectorInfo selectorInfo = null;
            while (selectors.hasMoreElements()) {
                selectorInfo = (SelectorInfo)selectors.nextElement();
                selectorStrings[ii] = selectorInfo.m_messageSelectorString;
                ++ii;
            }
        } else {
            this.m_selectorsUnknown = true;
        }
        this.m_messageSelectorStrings = selectorStrings;
        return selectorStrings;
    }

    public String getSelectorString() {
        if (this.m_selectors.size() > 1) {
            throw new EAssertFailure("Not a single selector");
        }
        if (this.m_singleSelector != null) {
            return this.m_singleSelector.m_messageSelectorString;
        }
        return null;
    }

    boolean hasVirtualClock() {
        return this.m_virtualClock != null;
    }

    public GSVirtualClock getVirtualClock() {
        return this.m_virtualClock;
    }

    synchronized void setMessageSelectors(String[] selectorStrings, Vector addedSelectors, Vector removedSelectors) throws ParseException, TokenMgrError {
        SelectorInfo currentSelector = null;
        if (this.DEBUG) {
            this.debug("Entering setMessageSelectors for " + this.toString());
        }
        this.m_messageSelectorStrings = null;
        if (addedSelectors != null) {
            addedSelectors.clear();
        }
        if (removedSelectors != null) {
            removedSelectors.clear();
        }
        if (selectorStrings == null) {
            if (this.DEBUG) {
                this.debug("Selectors are unknown");
            }
            if (!this.m_selectors.isEmpty()) {
                Enumeration selectors = this.m_selectors.elements();
                while (selectors.hasMoreElements()) {
                    currentSelector = (SelectorInfo)selectors.nextElement();
                    if (this.m_parent != null) {
                        this.m_parent.removeSelector(currentSelector.m_messageSelectorString);
                    }
                    if (removedSelectors == null) continue;
                    removedSelectors.addElement(currentSelector.m_messageSelectorString);
                }
                this.m_selectors.clear();
            }
            this.setSelectorsFlags();
            return;
        }
        String selectorString = null;
        Hashtable deletedSelectors = (Hashtable)this.m_selectors.clone();
        boolean newSelector = false;
        for (int ii = 0; ii < selectorStrings.length; ++ii) {
            selectorString = selectorStrings[ii];
            if (selectorString == null) continue;
            currentSelector = (SelectorInfo)this.m_selectors.get(selectorString);
            if (currentSelector == null) {
                if (this.DEBUG) {
                    this.debug("New selector: " + selectorString);
                }
                currentSelector = new SelectorInfo();
                this.m_selectors.put(selectorString, currentSelector);
                if (addedSelectors != null) {
                    addedSelectors.addElement(selectorString);
                }
                newSelector = true;
            } else {
                if (this.DEBUG) {
                    this.debug("Found previous selector for: " + selectorString);
                }
                deletedSelectors.remove(selectorString);
                newSelector = false;
            }
            if (selectorString != null && selectorString.length() > 0) {
                if (currentSelector.m_messageSelector == null) {
                    StringReader fs = new StringReader(selectorString);
                    Selector parser = new Selector(fs);
                    try {
                        currentSelector.m_messageSelector = parser.MessageSelector();
                    }
                    catch (ParseException e) {
                        throw e;
                    }
                    catch (TokenMgrError e) {
                        throw e;
                    }
                    currentSelector.m_messageSelectorString = selectorString;
                    if (this.DEBUG) {
                        this.debug("Selector successfully parsed");
                    }
                }
            } else {
                if (this.DEBUG) {
                    this.debug("No selector or unknown");
                }
                currentSelector.m_messageSelectorString = selectorString;
                currentSelector.m_messageSelector = null;
            }
            if (!newSelector || this.m_parent == null) continue;
            this.m_parent.addSelector(currentSelector);
        }
        Enumeration selectors = deletedSelectors.elements();
        while (selectors.hasMoreElements()) {
            currentSelector = (SelectorInfo)selectors.nextElement();
            this.m_selectors.remove(currentSelector.m_messageSelectorString);
            if (this.m_parent != null) {
                this.m_parent.removeSelector(currentSelector.m_messageSelectorString);
            }
            if (removedSelectors != null) {
                removedSelectors.addElement(currentSelector.m_messageSelectorString);
            }
            if (!this.DEBUG) continue;
            this.debug("Removed selector: " + currentSelector.m_messageSelectorString);
        }
        this.setSelectorsFlags();
        if (this.m_parent != null) {
            this.m_parent.setSelectorsFlags();
        }
    }

    void setSelectorsFlags() {
        if (this.m_selectors.size() == 1) {
            Enumeration selectors = this.m_selectors.elements();
            this.m_singleSelector = (SelectorInfo)selectors.nextElement();
        } else {
            this.m_singleSelector = null;
        }
        this.m_hasEmptySelector = this.m_selectors.get("") != null;
        if (this.DEBUG) {
            this.debug("For: " + this.toString() + " single selector - " + (this.m_singleSelector == null ? null : this.m_singleSelector.m_messageSelectorString) + " , empty selector - " + this.m_hasEmptySelector);
        }
    }

    void setVirtualClock(GSVirtualClock virtualClock) {
        this.m_virtualClock = virtualClock;
    }

    public final boolean getSelectorAtBroker() {
        return this.m_isSelectorAtBroker;
    }

    void setSelectorAtBroker(boolean isSelectorAtBroker) {
        if (this.DEBUG) {
            this.debug("Setting selector at broker to " + isSelectorAtBroker + " for: " + this.toString());
        }
        this.m_isSelectorAtBroker = isSelectorAtBroker;
    }

    public void setDurableStrictMessageOrder(boolean enforceDurableStrictMessageOrder) {
        if (enforceDurableStrictMessageOrder && this.m_subject != null && this.m_subject.hasGroup()) {
            BrokerComponent.getComponentContext().logMessage(this.m_client.getAppid() + " requested a durable subscription to be both part of a group and to have Strict Message Order. " + "  These are not compatible and the Strict Message Order will be ignored. ", 2);
            return;
        }
        this.m_enforceDurableStrictMessageOrder = enforceDurableStrictMessageOrder;
    }

    public boolean getDurableStrictMessageOrder() {
        return this.m_enforceDurableStrictMessageOrder;
    }

    public void setFlowToDisk(int flowToDisk) {
        this.m_flowToDisk = flowToDisk;
    }

    public int getFlowToDisk() {
        return this.m_flowToDisk;
    }

    boolean getUnfiltered() {
        return this.m_unfiltered;
    }

    void setUnfiltered(boolean unfiltered) {
        this.m_unfiltered = unfiltered;
    }

    synchronized boolean isMessageForSubscription(IMgram message) {
        if (this.DEBUG) {
            this.debug("Entering isMessageForSubscription for: " + this.toString());
        }
        if (this.m_hasEmptySelector) {
            if (this.DEBUG) {
                this.debug("Empty selector - returning true");
            }
            return true;
        }
        Enumeration selectors = null;
        boolean match = true;
        SelectorInfo currentSelector = null;
        MessageSelector messageSelector = null;
        boolean more = true;
        if (this.m_singleSelector == null) {
            selectors = this.m_selectors.elements();
        } else {
            currentSelector = this.m_singleSelector;
            if (this.DEBUG) {
                this.debug("Evaluating a single selector");
            }
        }
        do {
            if (selectors != null) {
                more = selectors.hasMoreElements();
                if (!more) break;
                currentSelector = (SelectorInfo)selectors.nextElement();
            }
            try {
                match = true;
                if (currentSelector == null) {
                    throw new NullPointerException("SelectorInfo currentSelector is null at " + this.getClass().getName() + ".isMessageForSubscription( IMgram message )");
                }
                messageSelector = currentSelector.m_messageSelector;
                if (messageSelector == null) continue;
                if (this.DEBUG) {
                    this.debug("Evaluating selector: " + currentSelector.m_messageSelectorString);
                }
                match = messageSelector.match(message);
                if (!this.DEBUG) continue;
                this.debug("Selector evaluated to " + match);
            }
            catch (EvalException e) {
                match = false;
            }
        } while (!match && selectors != null);
        return match;
    }

    final boolean matchAndFilterSubject(IMgram m) {
        if (this.m_subject.isMultiSubject()) {
            ISubject complement;
            ISubject msgSubject = m.getSubject();
            ISubjectFilter filter = m.getBrokerHandle().getSubjectFilter(this.m_client.getSubjectFilterId());
            if (filter != null) {
                msgSubject = filter.filter(msgSubject);
            }
            ISubject matchSubject = this.m_subject;
            if (this.isGroupMember() && this.getGroup() != null) {
                matchSubject = this.getGroup().getSubject();
            }
            if ((complement = msgSubject.complement(matchSubject, true)) != null) {
                if (complement.equals(msgSubject)) {
                    if (m.isGuarenteed()) {
                        this.m_client.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
                    }
                    return false;
                }
                if (filter != null) {
                    Iterator<ISubject> comps = complement.getSingleSubjects();
                    while (comps.hasNext()) {
                        ISubject s = comps.next();
                        filter.removeTrackingNum(msgSubject, (short)s.getSubjectTracking());
                        if (filter.filterSize() == 0) {
                            m.getBrokerHandle().getSubjectFilters().remove(this.m_client.getSubjectFilterId());
                            if (m.isGuarenteed()) {
                                this.m_client.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
                            }
                            return false;
                        }
                        if (!m.isGuarenteed()) continue;
                        IMgram ack = MgramFactory.getMgramFactory().buildSplitDeliveryAck(m.getGuarenteedTrackingNum(), this.m_client.getId(), (short)0, false, -1L, false, -1, -1, (short)s.getSubjectTracking());
                        this.m_client.handleNormalAck(m.getGuarenteedTrackingNum(), false, ack, m);
                    }
                } else {
                    BrokerComponent.getComponentContext().logMessage(this.m_client.getAppid() + " missing subject filter", (Throwable)new EAssertFailure("Missing subject filter for: " + msgSubject), 2);
                }
            }
        }
        return true;
    }

    @Override
    public long getExpQKey() {
        return this.m_expQKey;
    }

    @Override
    public void setExpQKey(long key) {
        this.m_expQKey = key;
    }

    @Override
    public int getExpQIndex() {
        return this.m_expQIndex;
    }

    @Override
    public void setExpQIndex(int i) {
        this.m_expQIndex = i;
    }

    @Override
    public boolean hasIBMark() {
        return this.m_ibMark;
    }

    @Override
    public void setIBMark(boolean mark) {
        this.m_ibMark = mark;
    }

    BrokerSubscription(IClientContext client, ISubject subject, Label lbl) {
        super("BrokerSubscription");
        this.m_client = client;
        this.m_label = lbl;
        this.m_TTE = -1L;
        this.m_subject = subject;
        this.m_isGroup = subject.hasGroup();
        this.m_parent = null;
        this.m_selectors = new Hashtable(1);
        this.m_hasEmptySelector = false;
        boolean bl = this.m_replicateOnly = Config.REPLICATED && (this.m_client.isXOnce() && this.m_client.getClientSessionVer() >= 28 && SessionConfig.isNonDurableSubscriber(this.m_client.getAppid()) || this.m_label.isGuaranteed() && InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(this.m_client.getId())) && !SessionConfig.isSystemSubject(this.m_subject);
        if (this.m_label.isGuaranteed() && InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(this.m_client.getId()) && !SessionConfig.isSystemSubject(this.m_subject)) {
            this.m_msgDeliveryLabel = (Label)this.m_label.clone();
            this.m_msgDeliveryLabel.setGuaranteed(false);
            if (this.checkDebugFlags(64)) {
                this.debug("*****BrokerSubscription constructor created m_msgDeliveryLabel: " + this.m_msgDeliveryLabel + " subj= " + this.m_subject.getSubjectString() + " " + this.m_client + " " + Thread.currentThread());
            }
        }
        if (Config.REPLICATED && this.m_client != null && this.m_client.isXOnce() && this.m_client.isQueueReceiver() && this.m_subject != null && QueueUtil.isQueueMessageGroupSubject(this.m_subject.getJMSName())) {
            this.m_replicateOnly = true;
            if (this.checkDebugFlags(16384)) {
                this.debug("adjusting the replication flag to true for bs " + this.m_subject);
            }
        }
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "]" + " constructor for: " + this.toString());
        }
    }

    public synchronized Label getMsgDeliveryLabel(IMgram m) {
        Label lab = this.m_label;
        if (this.m_msgDeliveryLabel != null && !m.isNonPersistentReplicated()) {
            lab = this.m_msgDeliveryLabel;
        }
        return lab;
    }

    public static boolean isValidTTL(long time) {
        return time <= 315360000000L && time > 0L;
    }

    @Override
    public final String toString() {
        return "BrokerSubscription to " + this.m_subject + " for " + this.m_client.getUid() + "/" + this.m_client.getAppid();
    }

    public boolean isExpirable() {
        return this.m_label.getExpiration() != null;
    }

    public boolean isReplicateOnly() {
        return this.m_replicateOnly;
    }

    public boolean hasTTE() {
        return this.m_TTE != -1L;
    }

    @Override
    public long getTTE() {
        return this.m_TTE;
    }

    public void setTTE(long expiration) {
        this.m_TTE = expiration;
    }

    public void unsetTTE() {
        this.m_TTE = -1L;
    }

    public boolean hasTTL() {
        return this.m_label.getExpiration() != null && this.m_label.getExpiration().getTime() <= 315360000000L;
    }

    public boolean convertTTLtoExpirationDate() {
        if (this.m_label.getExpiration() != null) {
            long time = this.m_label.getExpiration().getTime();
            if (time <= 315360000000L) {
                this.m_TTE = System.currentTimeMillis() + time;
                if (this.DEBUG) {
                    this.debug("time = " + time + " converted to expiration date = " + this.m_label.getExpiration());
                }
                return true;
            }
            this.m_TTE = time;
            if (this.DEBUG) {
                this.debug("No conversion needed expiration date = " + this.m_label.getExpiration());
            }
        }
        return false;
    }

    @Override
    public final void prefixMatch(ISubject subject, SearchResults result) {
    }

    @Override
    public final boolean localEffect() {
        return true;
    }

    @Override
    public boolean isBatchable() {
        IClientContext activeCC;
        IClientContext cc = this.getClient();
        if (cc.getRemoteNode() != null || cc.isRemoteBroker() || cc.isInterbroker() || cc.isHTTPDirect()) {
            return false;
        }
        if (cc.isDurable() && (activeCC = cc.getCWADSActiveBroker()) != null && activeCC.isInterbroker()) {
            return false;
        }
        if (this.hasSelectors()) {
            return false;
        }
        short ackMode = cc.getAckMode();
        return ackMode != 1 && ackMode != -1 && ackMode != 0;
    }

    @Override
    public boolean isBatchAtomic(boolean batchAtomicIfNonDurable) {
        IClientContext cc = this.getClient();
        short ackMode = cc.getAckMode();
        if (cc.getCSC().isFaultTolerant()) {
            return false;
        }
        if (ackMode == 3) {
            return true;
        }
        if (ackMode == 1 || ackMode == -1 || ackMode == 0) {
            return false;
        }
        return !cc.isDurable() && (batchAtomicIfNonDurable || !cc.isXOnce() || cc.getClientSessionVer() < 28 || !SessionConfig.isNonDurableSubscriber(cc.getAppid())) && !cc.isQueueReceiver();
    }

    boolean prepareForResubscribe(SubscribeEvtForSelector evt) {
        ISubject currentSubject = this.getSubject();
        String currentSelector = this.getSelectorString();
        if (currentSelector != null && !currentSelector.equals(evt.getMessageSelector())) {
            return false;
        }
        if (currentSubject.isMultiSubject() != evt.getSubject().isMultiSubject()) {
            return false;
        }
        if (currentSubject.hasGroup() != evt.getSubject().hasGroup() || currentSubject.hasGroup() && !currentSubject.getGroupName().equals(evt.getSubject().getGroupName())) {
            return false;
        }
        if (!currentSubject.equals(evt.getSubject())) {
            ISubject added;
            if (!currentSubject.isMultiSubject()) {
                return false;
            }
            ISubject intersect = currentSubject.intersect(evt.getSubject(), false);
            if (intersect == null) {
                return false;
            }
            byte mod = 0;
            ISubject removed = currentSubject.complement(intersect, false);
            if (removed != null) {
                mod = (byte)(mod | 2);
                evt.setRemovedSubject(removed);
            }
            if ((added = evt.getSubject().complement(intersect, false)) != null) {
                mod = (byte)(mod | 1);
                evt.setAddedSubject(added);
            }
            evt.setDurableModification(mod);
            return true;
        }
        return true;
    }

    class SelectorInfo {
        protected String m_messageSelectorString = null;
        protected MessageSelector m_messageSelector = null;

        SelectorInfo() {
        }
    }
}

