/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.msg.IMgram;
import progress.message.util.StreamUtil;

public final class ClientAckEvt
extends LogEvent {
    private short m_eventType = (short)117;
    private long m_id;
    private long m_msgTracking;
    private IMgram m_ack;
    private boolean m_isProxy;
    private short m_subjectTracking = (short)-1;
    private boolean m_hasDelete;
    private boolean notifyDelete;
    private static final byte IS_PROXY_MASK = 1;
    private static final byte HAS_DELETE_MASK = 2;
    private static final byte HAS_SUBJECT_TRACKING_MASK = 4;

    public ClientAckEvt(long clientId, long msgTracking, IMgram ack, boolean isProxy, boolean hasDelete) {
        this.m_id = clientId;
        this.m_msgTracking = msgTracking;
        this.m_ack = ack;
        this.m_isProxy = isProxy;
        this.m_hasDelete = hasDelete;
        if (ack != null && ack.getAckHandle().isSubjectAck()) {
            this.m_subjectTracking = ack.getAckHandle().getSubjectTracking();
        }
    }

    public ClientAckEvt(long clientId, long msgTracking, IMgram ack, boolean hasDelete) {
        this(clientId, msgTracking, ack, false, hasDelete);
    }

    public ClientAckEvt(short version) {
        this.m_eventType = version;
    }

    ClientAckEvt() {
    }

    public void setNotifyDelete(boolean b) {
        this.notifyDelete = true;
    }

    public boolean isProxy() {
        return this.m_isProxy;
    }

    public long getClientId() {
        return this.m_id;
    }

    public long getTracking() {
        return this.m_msgTracking;
    }

    public short getSubjectTracking() {
        return this.m_subjectTracking;
    }

    public final boolean hasSubjectTracking() {
        return this.m_subjectTracking != -1;
    }

    public boolean hasDelete() {
        return this.m_hasDelete;
    }

    @Override
    protected void onFlush() {
        if (this.m_ack != null && this.m_ack.isGuarenteed() && !this.m_ack.hasTxn()) {
            try {
                AgentRegistrar.getAgentRegistrar().getClient(this.m_ack.getBrokerHandle().getSenderID()).sendAckAck(this.m_ack);
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
        }
        if (this.notifyDelete) {
            try {
                AgentRegistrar.getAgentRegistrar().getClient(this.m_id).msgDeleteDone(this.m_msgTracking);
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
        }
    }

    @Override
    public short type() {
        return 117;
    }

    @Override
    protected int memSizeBody() {
        return 29;
    }

    @Override
    public int serializedSizeBody() {
        return this.streamSizeBody();
    }

    @Override
    public int streamSizeBody() {
        return 17 + (this.hasSubjectTracking() ? 2 : 0);
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeLong(this.m_msgTracking, os);
        byte flags = 0;
        if (this.m_isProxy) {
            flags = (byte)(flags | 1);
        }
        if (this.m_hasDelete) {
            flags = (byte)(flags | 2);
        }
        if (this.hasSubjectTracking()) {
            flags = (byte)(flags | 4);
        }
        StreamUtil.writeByte(flags, os);
        if (this.hasSubjectTracking()) {
            StreamUtil.writeShort(this.m_subjectTracking, os);
        }
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        this.m_msgTracking = StreamUtil.readLong(in);
        if (this.m_eventType >= 117) {
            byte flags = StreamUtil.readByte(in);
            if ((flags & 1) > 0) {
                this.m_isProxy = true;
            }
            if ((flags & 2) > 0) {
                this.m_hasDelete = true;
            }
            if ((flags & 4) > 0) {
                this.m_subjectTracking = StreamUtil.readShort(in);
            }
        } else {
            if (this.m_eventType >= 68) {
                this.m_isProxy = StreamUtil.readBoolean(in);
            }
            if (this.m_eventType >= 105) {
                this.m_hasDelete = StreamUtil.readBoolean(in);
            }
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoClientAck(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Client " + this.m_id + " acknowledge of message " + this.m_msgTracking + (this.m_ack != null && this.m_ack.isGuarenteed() ? "(ack ack required)" : "");
    }
}

