/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentConnection;
import progress.message.broker.BaseClientContext;
import progress.message.broker.BaseClientContextWrapper;
import progress.message.broker.Config;
import progress.message.broker.DurableClientContext;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IClientContext;
import progress.message.broker.IClientContextWrapper;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.XOnceClientContextWrapper;
import progress.message.interbroker.NeighborClientContext;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.SessionConfig;

public class ClientContextCreator
extends DebugObject {
    private ClientContextCreator() {
        this.debugName("ClientContextCreator");
    }

    public static IClientContext createCC(long clientId, ClientSecurityContext csc, AgentConnection connection, boolean replicated) {
        BaseClientContextWrapper wrapper;
        BaseClientContext bcc;
        DebugObject result = null;
        if (connection != null && connection.getFaultTolerant()) {
            csc.setFaultTolerant(true);
            csc.setFaultTolerantReconnectTimeout(connection.getClientConnectParms().getFaultTolerantReconnectTimeout());
            csc.setClientIPAddress(connection.getHostIpAddrStr());
            bcc = new BaseClientContext(clientId, csc, connection, null);
            XOnceClientContextWrapper wrapper2 = new XOnceClientContextWrapper(bcc, null);
            result = wrapper2;
        } else if (csc.isFaultTolerant()) {
            bcc = new BaseClientContext(clientId, csc, connection, null);
            XOnceClientContextWrapper wrapper3 = new XOnceClientContextWrapper(bcc, null);
            result = wrapper3;
        }
        if (csc.getAppid().startsWith("$DURABLE$")) {
            if (result == null) {
                result = new BaseClientContext(clientId, csc, connection, null);
            }
            wrapper = new DurableClientContext((IClientContext)((Object)result), null);
            result = wrapper;
        } else if (SessionConfig.isGroupSubscriptionAppid(csc.getAppid())) {
            if (result == null) {
                result = new BaseClientContext(clientId, csc, connection, null);
            }
            wrapper = new GroupSubscriptionClientContext((IClientContext)((Object)result), null);
            result = wrapper;
        } else if (clientId != SessionConfig.stringToClientId(Config.BROKER_UID, "Broker") && InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(clientId)) {
            if (result == null) {
                result = new BaseClientContext(clientId, csc, connection, null);
            }
            wrapper = new NeighborClientContext((IClientContext)((Object)result), null);
            result = wrapper;
        }
        if (result != null) {
            return result;
        }
        return new BaseClientContext(clientId, csc, connection, null);
    }

    public static IClientContext refreshWrappers(IClientContext cc, ClientSecurityContext csc) {
        boolean isXOnce = csc.isFaultTolerant();
        IClientContext newTopLevelCC = cc;
        if (cc.getXOnceHandle() != null) {
            newTopLevelCC = ClientContextCreator.removeXOnceWrapper(cc);
        }
        if (isXOnce) {
            IClientContextWrapper root = null;
            if (newTopLevelCC instanceof IClientContextWrapper) {
                root = (IClientContextWrapper)cc;
            }
            IClientContext baseCC = cc;
            while (!(baseCC instanceof BaseClientContext)) {
                if (!(baseCC instanceof IClientContextWrapper)) {
                    throw new EAssertFailure("Error in cc delegation tree: no BaseClientContext: " + cc);
                }
                baseCC = ((IClientContextWrapper)baseCC).getDelegate();
            }
            if (root == null) {
                XOnceClientContextWrapper wrapper = new XOnceClientContextWrapper(baseCC, null);
                newTopLevelCC = wrapper;
                baseCC.setDelegator(wrapper);
                root = wrapper;
            } else {
                IClientContextWrapper parent = root.getParentDelegator(baseCC);
                parent.setDelegate(new XOnceClientContextWrapper(baseCC, root));
            }
        }
        return newTopLevelCC;
    }

    static IClientContext removeXOnceWrapper(IClientContext wrapper) {
        XOnceClientContextWrapper xoWrapper = null;
        while (wrapper instanceof IClientContextWrapper) {
            if (wrapper instanceof XOnceClientContextWrapper) {
                xoWrapper = (XOnceClientContextWrapper)wrapper;
                break;
            }
            wrapper = ((IClientContextWrapper)wrapper).getDelegate();
        }
        if (xoWrapper != null) {
            wrapper = xoWrapper.removeFromDelegationTree(wrapper.getDelegator());
        }
        return wrapper;
    }
}

