/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import progress.message.broker.FlowControlListener;
import progress.message.broker.FlowControlManager;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IFlowController;
import progress.message.msg.IMgram;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.ISubject;

public class FlowControllerP28
extends DebugObject
implements FlowControlListener,
IFlowController {
    private IClientContext m_cc = null;
    private HashMap m_registeredKeys = null;
    private HashSet m_blockedList = null;
    private HashMap m_resumedList = null;
    private FlowControlManager m_flowManager = null;
    private boolean m_disconnected = false;

    public FlowControllerP28(FlowControlManager flowmgr, IClientContext cc) {
        super(DebugState.GLOBAL_DEBUG_ON ? "FlowController (" + cc.getId() + ")" : null);
        if (cc == null) {
            throw new EAssertFailure("Parameter is null: ClientContext cc");
        }
        this.m_cc = cc;
        this.m_registeredKeys = new HashMap();
        this.m_blockedList = new HashSet();
        this.m_flowManager = flowmgr;
        this.m_resumedList = new HashMap();
        if (this.DEBUG) {
            this.debug("Constructed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        if (this.DEBUG) {
            this.debug("Disconnecting");
        }
        HashMap htBlocked = null;
        HashMap htResumed = null;
        FlowControllerP28 flowControllerP28 = this;
        synchronized (flowControllerP28) {
            if (this.m_disconnected) {
                return;
            }
            htBlocked = (HashMap)this.m_registeredKeys.clone();
            htResumed = (HashMap)this.m_resumedList.clone();
            this.m_disconnected = true;
            this.m_registeredKeys.clear();
            this.m_resumedList.clear();
        }
        for (BlockedKey key : htBlocked.keySet()) {
            String localDest = (String)htBlocked.get(key);
            this.m_flowManager.removeFlowControlListener(this, localDest, key);
            if (!this.DEBUG) continue;
            this.debug("Unregistered listener for " + key);
        }
        for (BlockedKey key : htResumed.keySet()) {
            ResumedDestination resumedDest = (ResumedDestination)htResumed.get(key);
            this.m_flowManager.queueResumeCancelled(resumedDest.m_localDest, resumedDest.m_size);
            if (!this.DEBUG) continue;
            this.debug("QueueResumeCancelled for size " + resumedDest.m_size + " dest= " + key + " localDest = " + resumedDest.m_localDest);
        }
    }

    @Override
    public synchronized boolean isDestinationLocalBlocked(IMgram m) {
        if (!m.isPubSub() && !m.isPTP() && m.getType() != 11) {
            throw new EAssertFailure("Mgram type not NORMAL or QUEUE_NORMAL or QUEUE_ACKFORWARD_TYPE");
        }
        ISubject subject = m.getSubject();
        if (subject == null || !subject.isSubjectSet()) {
            return false;
        }
        return this.isDestinationLocalBlocked(m, subject);
    }

    private final boolean isDestinationLocalBlocked(IMgram m, ISubject subject) {
        if (this.m_blockedList.isEmpty()) {
            return false;
        }
        if (subject.isMultiSubject()) {
            Iterator<ISubject> i = subject.getMultiSubjects();
            while (i.hasNext()) {
                if (!this.isDestinationLocalBlocked(m, i.next())) continue;
                return true;
            }
            return false;
        }
        BlockedKey key = new BlockedKey(m, subject);
        if (this.DEBUG) {
            this.debug("Checking blocked list for " + m.getGuarenteedTrackingNum() + ", dest = " + key);
        }
        if (this.m_blockedList.contains(key)) {
            if (this.DEBUG) {
                this.debug("Destination is blocked locally: " + key);
            }
            return true;
        }
        if (this.DEBUG) {
            this.debug("Destination not blocked locally: " + key);
        }
        return false;
    }

    @Override
    public synchronized void onResumeReply(IMgram m) throws EMgramFormatError {
        IPTPFlowControlHandle handle = m.getPTPFlowControlHandle();
        BlockedKey key = new BlockedKey(handle);
        if (this.DEBUG) {
            this.debug("Received Resume Reply: " + key);
        }
        handle.setSubType((byte)4);
        this.m_cc.sendThrough(m);
        if (this.DEBUG) {
            this.debug("Sent Resume Complete: " + key);
        }
        this.removeBlockedKey(key);
        if (this.DEBUG) {
            this.debug("Removed from blocked list: " + key);
        }
    }

    private final void removeBlockedKey(BlockedKey key) {
        if (key.m_subject.isMultiSubject()) {
            Iterator<ISubject> i = key.m_subject.getMultiSubjects();
            while (i.hasNext()) {
                ISubject s = i.next();
                BlockedKey subKey = new BlockedKey(key);
                subKey.m_subject = s;
                this.m_blockedList.remove(subKey);
            }
        } else {
            this.m_blockedList.remove(key);
        }
        this.m_registeredKeys.remove(key);
    }

    @Override
    public synchronized boolean onQueueResume(Object destKey, String localDestination, int size) {
        BlockedKey key = (BlockedKey)destKey;
        if (this.DEBUG) {
            this.debug("Resuming delivery on: " + key);
        }
        boolean result = false;
        if (!this.m_disconnected && this.m_registeredKeys.get(key) != null) {
            if (this.DEBUG) {
                this.debug("Sent Resume Begin for " + key + " to " + this.m_cc);
            }
            this.m_resumedList.put(key, new ResumedDestination(localDestination, size));
            IMgram mg = MgramFactory.getMgramFactory().buildPTPFlowControlMgram(this.m_cc.getChannel(), key.m_routing, key.m_subject, key.m_isPubSub, (byte)2);
            this.m_cc.sendThrough(mg);
            result = true;
            if (this.m_cc.isGroupSubscriptionMember()) {
                this.m_cc.getGroupSubscriptionCC().notifyGroupRestoreThreads();
            }
        } else if (this.DEBUG) {
            this.debug("WARNING: Not locally blocked, resume ignored: " + key);
        }
        return result;
    }

    @Override
    public void nack(IMgram m, IAgentQueue target) {
        this.nack(m, m.getEnqueuedSize(), target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nack(IMgram m, int size, IAgentQueue target, String[] blockedRoutes) {
        BlockedKey key;
        String localDest = target.getQueueAddress();
        if (m.isDiscardable()) {
            if (!this.m_disconnected && m.isGuarenteed() && m.getRouting() != null && !m.getRoutingHandle().isGSAPublication()) {
                this.m_cc.sendThrough(MgramFactory.getMgramFactory().buildAck(m.getGuarenteedTrackingNum(), (short)0, this.m_cc.getChannel()));
                if (this.DEBUG) {
                    this.debug("Sent ACK for discardable message, tracking " + m.getGuarenteedTrackingNum());
                }
            }
            return;
        }
        if (this.DEBUG) {
            key = new BlockedKey(m);
            this.debug("Nack: TK = " + m.getGuarenteedTrackingNum() + ", key = " + key + ", local = " + localDest);
        }
        key = null;
        FlowControllerP28 flowControllerP28 = this;
        synchronized (flowControllerP28) {
            if (this.m_disconnected) {
                return;
            }
            key = this.generateBlockedKey(m, localDest);
        }
        if (key != null) {
            this.sendBlock(key);
        }
        this.sendNack(m);
        if (key != null) {
            this.m_flowManager.addFlowControlListener(this, localDest, key, size, blockedRoutes);
            if (this.DEBUG) {
                this.debug("Added listener for " + size + " on " + localDest + ", dest = " + key);
            }
        }
    }

    @Override
    public void block(IMgram m, IAgentQueue target) {
        this.block(m, m.getEnqueuedSize(), target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block(IMgram m, int size, IAgentQueue target, String[] blockedRoutes) {
        BlockedKey key;
        if (m.isDiscardable()) {
            return;
        }
        boolean register = false;
        String localDest = target.getQueueAddress();
        if (this.DEBUG) {
            key = new BlockedKey(m);
            this.debug("TxnBlock: TK = " + m.getGuarenteedTrackingNum() + ", destination = " + key + ", local = " + localDest);
        }
        key = null;
        FlowControllerP28 flowControllerP28 = this;
        synchronized (flowControllerP28) {
            if (this.m_disconnected) {
                return;
            }
            key = this.generateBlockedKey(m, localDest);
        }
        if (key != null) {
            this.sendBlock(key);
            long targSz = target.getMaxQueueSizeInBytes();
            long regSz = Math.min(targSz, (long)size);
            int registerSize = (int)regSz;
            this.m_flowManager.addFlowControlListener(this, localDest, key, registerSize, blockedRoutes);
            if (this.DEBUG) {
                this.debug("Added listener for " + size + " on " + localDest + ", key = " + key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkGlobalBlocked(String localDestination, IMgram m) {
        FlowControllerP28 flowControllerP28 = this;
        synchronized (flowControllerP28) {
            BlockedKey key;
            if (!this.m_resumedList.isEmpty() && this.m_resumedList.get(key = new BlockedKey(m)) != null) {
                this.m_resumedList.remove(key);
                return true;
            }
        }
        return !this.m_flowManager.isDestinationGloballyBlocked(localDestination);
    }

    private final BlockedKey generateBlockedKey(IMgram m, String localDest) {
        BlockedKey key = null;
        if (m.getSubject().isMultiSubject()) {
            ISubject copy = m.getSubject().protectedClone();
            Iterator<ISubject> i = copy.getMultiSubjects();
            while (i.hasNext()) {
                BlockedKey subKey = new BlockedKey(m, i.next());
                if (this.m_blockedList.add(subKey)) continue;
                i.remove();
            }
            if (copy.getMultiSubjectCount() == 1) {
                Iterator<ISubject> ii = copy.getMultiSubjects();
                copy = ii.next();
            } else if (copy.getMultiSubjectCount() == 0) {
                copy = null;
            }
            if (copy != null) {
                key = new BlockedKey(m, copy);
            }
        } else {
            key = new BlockedKey(m);
            if (this.m_blockedList.add(key)) {
                if (this.DEBUG) {
                    this.debug("Added to local list: " + key);
                }
            } else {
                if (this.DEBUG) {
                    this.debug("Already on local list: " + key);
                }
                key = null;
            }
        }
        if (key != null) {
            this.m_registeredKeys.put(key, localDest);
        }
        return key;
    }

    private void sendBlock(BlockedKey key) {
        if (this.DEBUG) {
            this.debug("Sending BLOCK on " + key.m_subject.getSubjectString() + " to " + this.m_cc);
        }
        IMgram mg = MgramFactory.getMgramFactory().buildPTPFlowControlMgram(this.m_cc.getChannel(), key.m_routing, key.m_subject, key.m_isPubSub, (byte)1);
        this.m_cc.sendThrough(mg);
    }

    void sendNack(IMgram m) {
        if (this.m_disconnected) {
            return;
        }
        if (m.isGuarenteed()) {
            if (m.isPTP() || m.isPubSub() || m.getType() == 11) {
                this.m_cc.sendThrough(MgramFactory.getMgramFactory().buildNack(m.getGuarenteedTrackingNum(), this.m_cc.getChannel()));
                if (this.DEBUG) {
                    this.debug("Sent NACK for " + m.getGuarenteedTrackingNum());
                }
            } else {
                throw new EAssertFailure("Only QUEUE_NORMAL or QUEUE_ACKFORWARD_TYPE or NORMAL_TYPE may be nacked");
            }
        }
    }

    @Override
    public boolean isConnected() {
        return !this.m_disconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBlockedDestinationsAsString() {
        HashMap registeredKeysCopy = null;
        FlowControllerP28 flowControllerP28 = this;
        synchronized (flowControllerP28) {
            if (this.m_disconnected) {
                return null;
            }
            if (this.m_registeredKeys.isEmpty()) {
                return null;
            }
            registeredKeysCopy = (HashMap)this.m_registeredKeys.clone();
        }
        StringBuffer resultBuffer = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : registeredKeysCopy.entrySet()) {
            String mgramDest = ((BlockedKey)entry.getKey()).toString();
            String localDest = (String)entry.getValue();
            if (first) {
                first = false;
            } else {
                resultBuffer.append(", ");
            }
            resultBuffer.append(mgramDest);
            if (localDest.equals(mgramDest)) continue;
            resultBuffer.append(" (").append(localDest).append(")");
        }
        return resultBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlockingDestinations(ArrayList al) {
        FlowControllerP28 flowControllerP28 = this;
        synchronized (flowControllerP28) {
            if (this.m_registeredKeys.isEmpty()) {
                return;
            }
            for (Map.Entry entry : this.m_registeredKeys.entrySet()) {
                String mgramDest = ((BlockedKey)entry.getKey()).toShortString();
                String localDest = (String)entry.getValue();
                String destString = null;
                if (!localDest.equals(mgramDest)) {
                    StringBuilder sb = new StringBuilder(mgramDest);
                    sb.append(" (").append(localDest).append(")");
                    destString = sb.toString();
                } else {
                    destString = mgramDest;
                }
                al.add(destString);
            }
        }
    }

    @Override
    public String toString() {
        return "FlowCntrl(" + this.m_cc.getId() + ")";
    }

    private final class BlockedKey {
        private String m_routing = null;
        private ISubject m_subject = null;
        private boolean m_isPubSub = true;

        public BlockedKey(BlockedKey key) {
            this.m_isPubSub = key.m_isPubSub;
            this.m_routing = key.m_routing;
            this.m_subject = key.m_subject;
        }

        public BlockedKey(IMgram m) {
            if (!m.isPubSub()) {
                this.m_routing = m.getRouting();
                this.m_isPubSub = false;
            }
            this.m_subject = m.getSubject();
        }

        public BlockedKey(IMgram m, ISubject subject) {
            if (!m.isPubSub()) {
                this.m_routing = m.getRouting();
                this.m_isPubSub = false;
            }
            this.m_subject = subject;
        }

        public BlockedKey(IPTPFlowControlHandle handle) {
            if (!handle.isPubSub()) {
                this.m_routing = handle.getRouting();
                this.m_isPubSub = false;
            }
            this.m_subject = handle.getFlowSubject();
        }

        public final int hashCode() {
            int hash = this.m_routing != null ? this.m_routing.hashCode() : 0;
            return hash += this.m_subject.hashCode();
        }

        public final boolean equals(Object o) {
            if (o == null || !(o instanceof BlockedKey)) {
                return false;
            }
            BlockedKey d = (BlockedKey)o;
            if (!(d.m_routing == this.m_routing || this.m_routing != null && this.m_routing.equals(d.m_routing))) {
                return false;
            }
            return d.m_subject.equals(this.m_subject);
        }

        public String toString() {
            String ret = this.m_routing != null ? this.m_routing + "::" : "";
            ret = ret + this.m_subject.getSubjectString();
            return ret;
        }

        public String toShortString() {
            StringBuilder sb = new StringBuilder();
            if (this.m_routing != null) {
                sb.append(this.m_routing).append("::");
            } else {
                sb.append("");
            }
            this.m_subject.appendSubjectString(sb, 10);
            return sb.toString();
        }
    }

    private static class ResumedDestination {
        private String m_localDest = null;
        private int m_size = 0;

        ResumedDestination(String localDest, int size) {
            this.m_localDest = localDest;
            this.m_size = size;
        }

        public String toString() {
            return "(" + this.m_localDest + "," + this.m_size + ")";
        }
    }
}

