/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.ConnectionIdEvt;
import progress.message.client.EEnvelopeIsNotRequest;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.client.EParameterIsNull;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.ETransactionFailure;
import progress.message.db.EDatabaseException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

final class GetConnectionID
implements IMessageHandler {
    private AgentRegistrar m_reg;
    private static final long MAX_CONNID = Integer.MAX_VALUE;
    private static int BLOCK_SIZE = Config.CONNECTION_ID_BLOCK_SIZE;
    private long m_currentBlock = -1L;
    private long m_last = -1L;
    private long m_broker;
    private boolean initDone = false;

    GetConnectionID(AgentRegistrar reg) throws EDatabaseException {
        this.m_reg = reg;
        this.m_broker = Config.BROKER_NAME.hashCode();
    }

    private void init() {
        if (this.initDone) {
            return;
        }
        this.m_last = this.m_reg.getLastConnectionId();
        this.m_currentBlock = this.m_last / (long)BLOCK_SIZE;
        this.initDone = true;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message rep = new Message();
            rep.writeLong(this.m_broker);
            long next = this.getNextId();
            rep.writeLong(next);
            s.reply(rep, env);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (ESecurityPolicyViolation e) {
        }
        catch (EParameterIsNull e) {
        }
        catch (EEnvelopeIsNotRequest e) {
        }
        catch (ETransactionFailure e) {
        }
        catch (ENetworkFailure e) {
        }
        catch (EGeneralException eGeneralException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextId() throws InterruptedException {
        this.init();
        long id = -1L;
        boolean flush = false;
        GetConnectionID getConnectionID = this;
        synchronized (getConnectionID) {
            id = ++this.m_last;
            this.m_reg.setLastConnectionId(id);
            if (this.m_last > Integer.MAX_VALUE) {
                this.m_currentBlock = 0L;
                this.m_last = 0L;
            } else {
                long block = id / (long)BLOCK_SIZE;
                if (block != this.m_currentBlock) {
                    this.m_currentBlock = block;
                    flush = true;
                }
            }
        }
        ConnectionIdEvt evt = new ConnectionIdEvt(id);
        if (flush) {
            this.m_reg.getLogManager().addEvent(evt, true);
            this.m_reg.getLogManager().waitForFlush(evt);
        } else {
            this.m_reg.getLogManager().addEvent(evt, false);
        }
        return id;
    }
}

