/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseClientContext;
import progress.message.broker.BaseClientContextWrapper;
import progress.message.broker.Broker;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DurableCCTracker;
import progress.message.broker.DurableManager;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.FlowToDiskMemoryManager;
import progress.message.broker.GroupMsgAllocationEvt;
import progress.message.broker.GroupSubscription;
import progress.message.broker.GroupXOnceMsgAllocationTracker;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.IClientContextWrapper;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.MsgRestorerBase;
import progress.message.broker.MsgSaver;
import progress.message.broker.PublishLimiter;
import progress.message.broker.SubscriptionsTable;
import progress.message.broker.prAccessor;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.Lock;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.Label;
import progress.message.zclient.SecurityLogic;
import progress.message.zclient.xonce.MgramTrace;

public class GroupSubscriptionClientContext
extends BaseClientContextWrapper {
    private Lock m_freezeLock = new Lock();
    private int m_freezeCount = 0;
    private GroupSubscription m_group = null;
    private Object m_restoreSync = new Object();
    private boolean m_restoreNotified = false;
    private DurableCCTracker m_tracker;
    private DurableManager m_manager;
    private AgentRegistrar m_reg;
    private FastVector m_offloadingMsgDestVector = new FastVector();
    private LBSTrackingInfo m_lbsTrackingInfo = null;
    private static final String m_debugname = "GroupSubscriptionClientContext";
    private final Object m_inDoubtRecoveryMutex = new Object();
    private InDoubtMemberRecoveryTracker m_inDoubtMemberRecoveryTracker;
    private GroupXOnceMsgAllocationTracker m_xonceAllocationTracker;
    static final boolean s_limitClusterHops = Boolean.getBoolean("SonicMQ.LIMIT_GROUP_SUB_CLUSTER_HOPS");
    private final Object m_stateChangeMutex = new Object();
    private SubscriptionsTable m_junkSubscriptionsHashtable = new SubscriptionsTable();
    private boolean startFTDWarningLogged = false;

    public GroupSubscriptionClientContext(IClientContext delegate, IClientContextWrapper delegator) {
        super(delegate, delegator);
        this.debugName(m_debugname);
        if (Config.ENABLE_INTERBROKER) {
            this.m_xonceAllocationTracker = new GroupXOnceMsgAllocationTracker(this.m_delegator.getId());
        }
        this.m_reg = AgentRegistrar.getAgentRegistrar();
        this.m_delegator.setFlowToDisk(1);
        this.m_offloadingMsgDestVector.addElement(this.m_delegator);
    }

    public void setGroup(GroupSubscription group) {
        this.m_group = group;
        this.m_lbsTrackingInfo = new LBSTrackingInfo();
        this.m_lbsTrackingInfo.addTargetGroup(this.m_group.getGroupName());
        this.m_lbsTrackingInfo.addTransitHistory(AgentRegistrar.getAgentRegistrar().getId());
    }

    public GroupSubscription getGroup() {
        return this.m_group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyGroup() {
        try {
            this.checkState();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.notifyGroupRestoreThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyGroupRestoreThreads() {
        Object object = this.m_restoreSync;
        synchronized (object) {
            this.m_restoreNotified = true;
            this.m_restoreSync.notifyAll();
        }
    }

    @Override
    public boolean isGroupSubscriptionMember() {
        return false;
    }

    @Override
    public boolean isGroupSubscription() {
        return true;
    }

    @Override
    public DurableCCTracker getDurableCCTracker() {
        return this.m_tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startDelivery(Envelope req) {
        boolean ret = false;
        try {
            if (this.m_delegator.isStarted() || this.m_delegator.checkRestoringState() && !this.m_delegator.isMsgRestoreCancelled()) {
                boolean bl = true;
                return bl;
            }
            try {
                this.freezeGroupCC();
                ret = this.m_delegate.startDelivery(null);
                if (this.DEBUG) {
                    this.debug("delivery started for group " + this.m_group);
                }
                this.m_delegate.setLastConnectedTime(-1L);
            }
            finally {
                this.unfreezeGroupCC();
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            this.notifyGroupRestoreThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDelivery() {
        try {
            this.m_delegate.stopDelivery();
            this.m_delegate.setLastConnectedTime(System.currentTimeMillis());
        }
        finally {
            this.notifyGroupRestoreThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enqueueOffloaded(IMgram message, long msgSaverOpIndx) {
        Object object = this.m_delegate.getSyncObj();
        synchronized (object) {
            ++((BaseClientContext)this.m_delegate).m_msgsToBeAddedToOffloadedQueue;
        }
        return this.m_delegate.enqueueOffloaded(message, msgSaverOpIndx);
    }

    private final void setDBTracking(IMgram m) {
        ((BaseClientContext)this.m_delegate).setDbTracking(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelMsgRestore() {
        try {
            this.m_delegate.cancelMsgRestore();
            if (this.DEBUG) {
                this.debug("message restore cancelled for group " + this.m_group);
            }
        }
        finally {
            this.notifyGroupRestoreThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreComplete(MsgRestorePos pos) {
        if (this.DEBUG) {
            this.debug("group " + this.m_group + " restore complete: " + this.m_delegate.hasMsgsInDb() + "/" + this.m_delegate.getSavesInProgress());
        }
        boolean isRestoreThread = Thread.currentThread() instanceof MsgRestorerBase;
        try {
            this.freezeGroupCC(isRestoreThread);
        }
        catch (InterruptedException ex) {
            return;
        }
        try {
            this.m_delegate.restoreComplete(pos);
            if (!this.m_delegator.getOutQueue().getOffloadedPubSubQueue().isEmpty()) {
                ((BaseClientContext)this.m_delegate).startOffloadedMsgRestorer();
            }
            if (this.DEBUG) {
                this.debug("message restore completed for group " + this.m_group);
            }
        }
        finally {
            this.unfreezeGroupCC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNormalAck(long tracking, boolean txnCommit, IMgram ack, IMgram ackedMgram) {
        try {
            this.m_delegate.handleNormalAck(tracking, txnCommit, ack, ackedMgram);
        }
        finally {
            this.notifyGroupRestoreThreads();
        }
    }

    @Override
    public void msgDeleteDone(long tracking) {
        this.removeXOnceAllocation(tracking);
        this.m_delegate.msgDeleteDone(tracking);
    }

    public Label getGroupDeliveryLabel() {
        Label label = new Label();
        boolean hasDurables = this.m_group.hasDurables();
        label.setPersistent(hasDurables);
        label.setGuaranteed(hasDurables);
        label.setNonStop(false);
        return label;
    }

    @Override
    public void sendPriorityPush(IMgram m, int prio, int pushPrio) {
        BrokerComponent.getComponentContext().logMessage((Throwable)new Exception("sendPriorityPush() attempted for delivering a message to a group subscription"), 2);
    }

    @Override
    public int send(IMgram mg, Label opts) {
        return this.m_delegator.send(mg, opts, null);
    }

    @Override
    public int send(IMgram mg, Label opts, PublishLimiter pubLimiter) {
        this.m_delegator.notifySave(mg, false);
        return 1;
    }

    @Override
    public boolean recheckRestoredMgram(IMgram m) {
        if (!this.m_delegate.recheckRestoredMgram(m)) {
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " not interested in restored mgram, TTL or PASS check failed.");
            }
            return false;
        }
        if (!this.m_group.checkGroupInterestInMgram(m)) {
            if (m.isGuarenteed() || m.getBrokerHandle().isGuarFormatIncorrect()) {
                this.m_delegator.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
            }
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " not interested in restored mgram, Selector has changed.");
            }
            return false;
        }
        BrokerSubscription bs = this.m_group.getOneSubscription();
        if (bs == null) {
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " not interested in restored mgram, no more members in group.");
            }
            return false;
        }
        if (m.hasSubject() && !m.getSubject().isSystem() && !bs.matchAndFilterSubject(m)) {
            if (m.isGuarenteed() || m.getBrokerHandle().isGuarFormatIncorrect()) {
                this.m_delegator.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
            }
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " not interested in restored mgram, does not match multi-topic filter.");
            }
            return false;
        }
        return true;
    }

    private boolean checkDeliveredStatus(IMgram m) {
        if (m.isGuarenteed() && m.getType() != 27) {
            if (this.m_delegator.getOutQueue().isGroupSubGuarPending(m.getGuarenteedTrackingNum())) {
                return true;
            }
            if (this.m_delegator.getGuarDoubtManager().wasMessageAcknowledged(m.getGuarenteedTrackingNum())) {
                return true;
            }
            if (this.m_delegator.getGuarDoubtManager().isMessageInDoubt(m.getGuarenteedTrackingNum())) {
                return true;
            }
            if (this.m_delegator.getOutQueue().getPendingGuar(m.getGuarenteedTrackingNum()) != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRestoredMgram(IMgram m, boolean durableSMORestore, boolean fromRemoteBroker) throws EDuplicateKey, InterruptedException {
        if (this.DEBUG) {
            this.debug("group " + this.m_group + " restore message: " + MgramTrace.diagnosticString("", null, m));
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        if (Config.ENABLE_INTERBROKER && this.m_xonceAllocationTracker.isAllocated(m.getGuarenteedTrackingNum())) {
            Object object = this.m_delegate.getSyncObj();
            synchronized (object) {
                try {
                    this.m_delegate.getOutQueue().setGuarMsgPending(m);
                }
                catch (EDuplicateKey e) {
                    // empty catch block
                }
            }
            return true;
        }
        if (this.checkDeliveredStatus(m)) {
            return true;
        }
        if (this.m_group.hasDurables() && !m.getBrokerHandle().isFromDB()) {
            this.adjustDurableCCTracker(m, false);
        }
        if (m.isGuarenteed() && s_reg.getDeleteMsgManager().checkPubSubDelete(m.getGuarenteedTrackingNum(), this.m_delegator.getId())) {
            return true;
        }
        if (m.isSecure()) {
            try {
                if (SecurityLogic.isMKeyMacHeader(m.getSecurity()) && m.getBrokerHandle().isFromDB()) {
                    m.getBrokerHandle().macHeaderWithMessageKey(((BaseClientContext)this.m_delegate).getMessageProtection());
                }
            }
            catch (ESecurityGeneralException e) {
                throw new EAssertFailure("Caught ESecurityGeneralException while remac'ing the header", e);
            }
        }
        if (m.getType() == 27) {
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " restored batch message: " + MgramTrace.diagnosticString(m));
            }
            if (this.reallocateBatchMgramInternal(m, -1L, null, false, true, false, false)) {
                if (this.DEBUG) {
                    this.debug("group " + this.m_group + " restored batch message: " + MgramTrace.diagnosticString("", null, m));
                }
                return true;
            }
            return false;
        }
        if (this.restoreMgramToGroupMember(m, null)) {
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " restored message: " + MgramTrace.diagnosticString("", null, m));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean restoreMgramToGroupMember(IMgram m, PublishLimiter pubLimiter) throws InterruptedException {
        boolean ret = false;
        while (!ret && (this.m_delegator.getRestoringOffloaded() || this.m_delegator.checkRestoringState() && !this.m_delegator.isMsgRestoreCancelled())) {
            IClientContext dnrMember;
            if (!this.recheckRestoredMgram(m)) {
                return true;
            }
            if (m.isGuarenteed() && (dnrMember = this.m_delegator.getGuarDoubtManager().getRecoveredGroupMemberDNR(m.getGuarenteedTrackingNum())) != null && dnrMember.setRecoveredGroupDNRPending(m)) {
                return true;
            }
            if (this.checkDeliveredStatus(m)) {
                return true;
            }
            if (this.CALLBACK) {
                this.callback(m_debugname, 404, new Object[]{this.m_delegator, m, new Boolean(this.m_restoreNotified)});
            }
            if (ret = this.reallocateMgramInternal(m, -1L, pubLimiter, false, true)) continue;
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " reallocation failed for " + MgramTrace.diagnosticString("", null, m));
            }
            Object object = this.m_restoreSync;
            synchronized (object) {
                if (!this.m_restoreNotified && (this.m_delegator.getRestoringOffloaded() || this.m_delegator.checkRestoringState() && !this.m_delegator.isMsgRestoreCancelled())) {
                    try {
                        if (Config.ENABLE_INTERBROKER) {
                            this.m_restoreSync.wait(100L);
                        } else {
                            this.m_restoreSync.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        this.m_restoreNotified = false;
                        throw e;
                    }
                    if (!this.recheckRestoredMgram(m)) {
                        if (this.DEBUG) {
                            this.debug("group " + this.m_group + "offloaded restore found obselete message " + MgramTrace.diagnosticString("", null, m));
                        }
                        return true;
                    }
                }
                this.m_restoreNotified = false;
            }
        }
        return ret;
    }

    private boolean reallocateBatchMgramInternal(IMgram m, long ccThatFailed, PublishLimiter pubLimiter, boolean flowToDiskClientsOnly, boolean restoringMgram, boolean jms_redelivery, boolean indoubt) {
        if (this.DEBUG) {
            this.debug("Reallocating batch mgram " + MgramTrace.diagnosticString("", null, m) + " -- " + this.m_group.getGroupName() + " restoring: " + restoringMgram);
        }
        if (m.getBatchHandle().isAtomic()) {
            if (this.DEBUG_UNEXPECTED) {
                this.debug("Unexpected atomic batch detected " + MgramTrace.diagnosticString("", null, m) + " -- " + this.m_group.getGroupName());
            }
            if (m.isGuarenteed() || m.getBrokerHandle().isGuarFormatIncorrect()) {
                this.m_delegator.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
            }
        }
        Iterator subMgrams = m.getBatchHandle().getBatchIterator();
        while (subMgrams.hasNext()) {
            IMgram subMgram = (IMgram)subMgrams.next();
            boolean success = false;
            try {
                success = restoringMgram ? this.restoreMgramToGroupMember(subMgram, pubLimiter) : this.reallocateMgramInternal(subMgram, ccThatFailed, pubLimiter, flowToDiskClientsOnly, restoringMgram);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (success) continue;
            if (this.DEBUG) {
                this.debug("Reallocating batch mgram FAILED " + MgramTrace.diagnosticString("", null, subMgram) + " -- " + this.m_group.getGroupName() + " restoring: " + restoringMgram);
            }
            if (!restoringMgram) {
                while (subMgram != null) {
                    this.doGroupMessageSave(subMgram, pubLimiter, jms_redelivery, indoubt, true);
                    subMgram = null;
                    if (!subMgrams.hasNext()) continue;
                    subMgram = (IMgram)subMgrams.next();
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reallocateMgramInternal(IMgram mgram, long ccThatFailed, PublishLimiter pubLimiter, boolean flowToDiskClientsOnly, boolean restoringMgram) throws InterruptedException {
        IClientContext failedCC = null;
        try {
            if (ccThatFailed != -1L) {
                failedCC = this.m_reg.getClient(ccThatFailed);
            }
        }
        catch (EClientNotRegistered e) {
            failedCC = null;
        }
        if (this.CALLBACK) {
            this.callback(m_debugname, 400, new Object[]{this.m_delegator, failedCC, mgram, pubLimiter, new Boolean(flowToDiskClientsOnly), new Boolean(restoringMgram)});
        }
        if (this.checkDeliveredStatus(mgram)) {
            return true;
        }
        this.waitForGroupCCUnfreeze(true);
        try {
            IClientContext cc;
            int idx;
            FastVector members = new FastVector();
            Iterator iter = this.m_group.getGroupMemberIds();
            while (iter.hasNext()) {
                Long bs = (Long)iter.next();
                if (members.indexOf(bs, 0) >= 0) continue;
                members.addElement(bs);
            }
            if (members.m_count == 0) {
                this.cleanupReallocatedMgram(mgram, failedCC, true);
                boolean bs = true;
                return bs;
            }
            FastVector localMembers = new FastVector();
            for (idx = members.m_count - 1; idx >= 0; --idx) {
                long cid = (Long)members.m_data[idx];
                if (cid == ccThatFailed) {
                    members.removeElementAt(idx);
                    continue;
                }
                try {
                    boolean activeOnAnotherBroker;
                    cc = this.m_reg.getClient(cid);
                    if (cc == null) {
                        members.removeElementAt(idx);
                        continue;
                    }
                    IClientContext activecc = cc.getCWADSActiveBroker();
                    boolean bl = activeOnAnotherBroker = activecc != null && activecc.isInterbroker();
                    if (!activeOnAnotherBroker) {
                        if (cc.isInterbroker() && pubLimiter != null && pubLimiter.getPublisherCC() != null && pubLimiter.getPublisherCC().getId() == cc.getId()) {
                            members.removeElementAt(idx);
                            continue;
                        }
                        if (!cc.isStarted()) {
                            members.removeElementAt(idx);
                            continue;
                        }
                        if (!cc.isInterbroker()) {
                            localMembers.addElement(new Long(cid));
                        }
                        if (cc.getMinSendPriority(null) > mgram.getPriority()) {
                            members.removeElementAt(idx);
                            continue;
                        }
                        if (cc.hasRoomForMgram(mgram)) continue;
                        members.removeElementAt(idx);
                        continue;
                    }
                    if (pubLimiter != null && pubLimiter.getPublisherCC() != null && pubLimiter.getPublisherCC().getId() == activecc.getId()) {
                        members.removeElementAt(idx);
                        continue;
                    }
                    if (!activecc.isStarted()) {
                        members.removeElementAt(idx);
                        continue;
                    }
                    if (activecc.getMinSendPriority(null) > mgram.getPriority()) {
                        members.removeElementAt(idx);
                        continue;
                    }
                    if (activecc.hasRoomForMgram(mgram)) continue;
                    members.removeElementAt(idx);
                    continue;
                }
                catch (EClientNotRegistered e) {
                    members.removeElementAt(idx);
                }
            }
            if (s_limitClusterHops && localMembers.m_count > 0 && InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(mgram.getBrokerHandle().getSenderID())) {
                for (idx = members.m_count - 1; idx >= 0; --idx) {
                    Object obj = members.m_data[idx];
                    if (localMembers.indexOf(obj, 0) >= 0) continue;
                    members.removeElementAt(idx);
                }
            }
            if (members.m_count == 0) {
                idx = 0;
                return idx != 0;
            }
            boolean result = false;
            while (members.m_count > 0 && !Broker.exiting && Thread.currentThread().isAlive()) {
                IMgram sendmsg = mgram;
                BrokerSubscription bs = this.m_group.selectBrokerSubscription(mgram, null, members);
                if (bs == null) {
                    if (this.DEBUG) {
                        this.debug("Aborting reallocation because there are no suitable subscribers");
                    }
                    result = false;
                    break;
                }
                IClientContext sendCc = cc = bs.getClient();
                boolean remote = false;
                if (cc.isInterbroker()) {
                    remote = true;
                } else {
                    IClientContext activecc = cc.getCWADSActiveBroker();
                    if (activecc != null && activecc.isInterbroker()) {
                        remote = true;
                        sendCc = activecc;
                    }
                }
                if (this.CALLBACK) {
                    this.callback(m_debugname, 401, new Object[]{this.m_delegator, sendCc, sendmsg});
                }
                int sendresult = 1;
                if (remote) {
                    sendresult = this.reallocateToRemote(sendmsg, sendCc, bs, pubLimiter);
                } else {
                    int dispatchIncrement = 1;
                    if (sendmsg.getType() == 27 && !sendmsg.getBrokerHandle().isBatchedPublish()) {
                        dispatchIncrement = sendmsg.getBatchHandle().getBatchSize();
                    }
                    sendCc.notifyPubDispatch(dispatchIncrement);
                    sendresult = sendCc.send(sendmsg, bs.getLabel(), pubLimiter);
                }
                if (this.CALLBACK) {
                    this.callback(m_debugname, 402, new Object[]{this.m_delegator, sendCc, sendmsg, new Integer(sendresult)});
                }
                if (sendresult == 0) {
                    if (!(mgram.isGuarenteed() && (sendCc.isDurable() || sendCc.isInterbroker() || sendCc.isXOnce() && mgram.isGuarenteed()))) {
                        this.cleanupReallocatedMgram(mgram, failedCC, true);
                    }
                    result = true;
                    break;
                }
                if (sendresult == 2) {
                    this.cleanupReallocatedMgram(mgram, failedCC, true);
                    result = true;
                    break;
                }
                if (sendCc.isDurable()) {
                    this.adjustDurableCCTracker(mgram, false);
                }
                int idx2 = members.indexOf(new Long(cc.getId()), 0);
                members.removeElementAt(idx2);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlockGroupCC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int reallocateToRemote(IMgram m, IClientContext sendCc, BrokerSubscription bs, PublishLimiter pubLimiter) {
        ISubjectFilter sf;
        if (m.getType() != 2) {
            Config.logMessage("Attempt to reallocate non NORMAL mgram to remote: " + MgramTrace.diagnosticString(m), 2);
        }
        IMgram wrapper = this.wrapMgramWithLBSWrapper(m);
        if (m.getSubject().isMultiSubject() && (sf = m.getBrokerHandle().getSubjectFilter(this.m_delegator.getSubjectFilterId())) != null) {
            m.getBrokerHandle().addSubjectFilter(sendCc.getSubjectFilterId(), sf);
            wrapper.getBrokerHandle().addSubjectFilter(sendCc.getSubjectFilterId(), sf);
        }
        int result = 1;
        sendCc.notifyPubDispatch();
        if (m.isGuarenteed()) {
            GroupMsgAllocationEvt evt = new GroupMsgAllocationEvt(sendCc, this, m.getGuarenteedTrackingNum(), wrapper);
            result = sendCc.xOnceGroupSend(wrapper, pubLimiter, bs.getLabel(), evt);
            if (result == 0) {
                Object object = this.m_delegate.getSyncObj();
                synchronized (object) {
                    try {
                        this.m_delegate.getOutQueue().setFwdGuarMsgPending(m, null);
                    }
                    catch (EDuplicateKey e) {
                        // empty catch block
                    }
                }
                this.m_xonceAllocationTracker.addXOnceAllocation(evt.isReplicateOnly(), sendCc.getId(), m.getGuarenteedTrackingNum(), wrapper.getGuarenteedTrackingNum());
                AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(evt, true);
            }
        } else {
            if (this.DEBUG) {
                this.debug("Reallocating to remote " + sendCc.getAppid() + " - " + MgramTrace.diagnosticString(m));
            }
            result = sendCc.send(wrapper, bs.getLabel(), pubLimiter);
        }
        return result;
    }

    public void adjustDurableCCTracker(IMgram mg, boolean add) {
        DurableCCTracker tracker;
        if (mg == null) {
            return;
        }
        boolean fromDb = false;
        if (mg.getBrokerHandle() != null) {
            fromDb = mg.getBrokerHandle().isFromDB();
        }
        if (mg.isPubSub() && !mg.isDiscardable() && !fromDb && (tracker = this.m_delegator.getDurableCCTracker()) != null) {
            int size;
            int count;
            if (mg.getType() == 27) {
                count = mg.getBatchHandle().getBatchSize();
                size = mg.getBatchHandle().getDurableBatchSerializedLength();
            } else {
                count = 1;
                size = mg.getBrokerHandle().getTrackedSize();
            }
            if (add) {
                tracker.messageAdded(count, size);
            } else {
                tracker.messageRemoved(count, size);
            }
            if (this.CALLBACK) {
                this.callback(m_debugname, 403, new Object[]{this.m_delegator, mg, new Boolean(add), tracker});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGroupMemberMgram(IMgram msg, PublishLimiter pubLimiter, IClientContext cc, boolean jms_redelivery, boolean inDoubt, boolean setSuccessorBit) {
        if (msg == null) {
            return;
        }
        msg = MsgSaver.removeLBSWrapper(msg);
        if (cc.isDurable()) {
            this.adjustDurableCCTracker(msg, false);
        }
        if (cc.getId() != this.m_delegator.getId()) {
            if (setSuccessorBit) {
                msg.setSuccessor(true);
            }
            this.cleanupReallocatedMgram(msg, cc, false);
        }
        boolean inDoubtMembers = false;
        Object object = this.m_inDoubtRecoveryMutex;
        synchronized (object) {
            if (this.m_inDoubtMemberRecoveryTracker != null) {
                inDoubtMembers = true;
            }
        }
        if (!this.recheckRestoredMgram(msg)) {
            return;
        }
        if (!inDoubtMembers) {
            if (msg.getType() == 27) {
                this.reallocateBatchMgramInternal(msg, cc.getId(), pubLimiter, false, false, jms_redelivery, inDoubt);
            } else {
                try {
                    if (this.reallocateMgramInternal(msg, cc.getId(), pubLimiter, false, false)) {
                        return;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.doGroupMessageSave(msg, pubLimiter, jms_redelivery, inDoubt, true);
            }
        } else {
            this.doGroupMessageSave(msg, pubLimiter, jms_redelivery, inDoubt, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doGroupMessageSave(IMgram msg, PublishLimiter pubLimiter, boolean jms_redelivery, boolean inDoubt, boolean offloadOk) {
        long msgSaverOpIndx = -1L;
        try {
            this.freezeGroupCC();
            boolean offloading = offloadOk && this.m_delegator.okToOffloadMessages();
            boolean nonGuarsOk = false;
            if (!msg.getBrokerHandle().isFromDB()) {
                if (this.m_group.needsPersistence(msg)) {
                    nonGuarsOk = true;
                }
                if (!msg.isGuarenteed() && (msg.getType() != 27 || msg.getBatchHandle().isAtomic())) {
                    if (nonGuarsOk || offloading) {
                        this.setDBTracking(msg);
                    } else {
                        if (this.DEBUG) {
                            this.debug(MgramTrace.diagnosticString("Dropping non guarenteed group message ", null, msg));
                        }
                        return;
                    }
                }
                this.m_delegator.notifySave(msg, false);
                if (this.m_group.hasDurables()) {
                    this.adjustDurableCCTracker(msg, true);
                }
                AgentGuarMsgTracker tracker = null;
                try {
                    if (msg.isGuarenteed()) {
                        tracker = AgentGuarMsgTracker.getTracker(msg.getGuarenteedTrackingNum());
                    }
                }
                catch (ETrackingNumNotFound e) {
                    // empty catch block
                }
                msgSaverOpIndx = this.m_reg.getMsgSaver().save(msg, pubLimiter, this.m_offloadingMsgDestVector, null, null, tracker, jms_redelivery, inDoubt, offloading, nonGuarsOk);
            }
            if (offloading) {
                int memorySize = this.m_delegator.enqueueOffloaded(msg, msgSaverOpIndx);
                if (memorySize > 0) {
                    FlowToDiskMemoryManager.getFlowToDiskMemoryManager().updateMemorySize(memorySize, this.m_offloadingMsgDestVector, pubLimiter);
                }
            } else if (msg.getBrokerHandle().isFromDB()) {
                this.m_delegator.setMsgsInDb(true);
            }
        }
        finally {
            this.unfreezeGroupCC();
            this.notifyGroupRestoreThreads();
        }
    }

    public void cleanupReallocatedMgram(IMgram m, IClientContext cc, boolean deleteit) {
        if (this.CALLBACK) {
            this.callback(m_debugname, 405, new Object[]{this.m_delegator, cc, m, new Boolean(deleteit)});
        }
        if (m.isGuarenteed() || m.getBrokerHandle().isGuarFormatIncorrect()) {
            if (cc != null && cc.getId() != this.m_delegator.getId()) {
                cc.getGuarDoubtManager().removeMessageInDoubt(m.getGuarenteedTrackingNum());
                cc.removeMsgPendingAck(m.getGuarenteedTrackingNum());
                cc.getGuarDoubtManager().removePendingGroupTxnMessage(m.getGuarenteedTrackingNum());
                cc.getOutQueue().removeGroupSubGuarPending(m.getGuarenteedTrackingNum());
            }
            if (deleteit) {
                this.m_delegator.removeMsgPendingAck(m.getGuarenteedTrackingNum());
                this.m_delegator.handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
            }
        }
    }

    @Override
    public boolean okToOffloadMessages() {
        int state = this.m_delegate.getState();
        return state > 2;
    }

    private IMgram wrapMgramWithLBSWrapper(IMgram mgram) {
        IMgram ret = mgram;
        ret = LBSTrackingInfo.buildLBSTargetWrapper(mgram, this.m_lbsTrackingInfo);
        ret.getOperationHandle().setOperationType(14);
        ret.getBrokerHandle().setGroupSubscriptionCC(this.m_delegator.getId());
        if (mgram.isGuarenteed()) {
            ret.setGuarenteed(s_reg.getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL);
        }
        ret.setRouteLimit(2);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean sync) {
        try {
            this.freezeGroupCC();
            this.m_delegate.disconnect(sync);
            return;
        }
        finally {
            this.unfreezeGroupCC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnregistered() {
        try {
            this.freezeGroupCC();
            this.getDurableManager().unregister(this.getDelegator());
            this.m_delegate.setUnregistered();
        }
        finally {
            this.unfreezeGroupCC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRegistered() {
        try {
            this.freezeGroupCC();
            this.m_tracker = this.getDurableManager().register(this.getDelegator());
            this.m_delegate.setRegistered();
        }
        finally {
            this.unfreezeGroupCC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkState() throws InterruptedException {
        if (this.m_group == null) {
            return;
        }
        boolean groupIsStarted = false;
        boolean groupMemberIsStarted = false;
        Object object = this.m_stateChangeMutex;
        synchronized (object) {
            this.waitForGroupCCUnfreeze(false);
            try {
                Iterator subscribers = this.m_group.getGroupMemberIds();
                boolean bl = groupIsStarted = this.m_delegator.isStarted() || this.m_delegator.checkRestoringState() && !this.m_delegator.isMsgRestoreCancelled();
                while (subscribers.hasNext() && !groupMemberIsStarted) {
                    long clientid = (Long)subscribers.next();
                    IClientContext cc = null;
                    try {
                        cc = this.m_reg.getClient(clientid);
                    }
                    catch (EClientNotRegistered e) {
                        continue;
                    }
                    groupMemberIsStarted |= cc.isStarted();
                }
            }
            finally {
                this.unlockGroupCC();
            }
            if (groupMemberIsStarted && !groupIsStarted) {
                this.groupDeliveryRestart();
            }
            if (!groupMemberIsStarted && groupIsStarted) {
                this.groupDeliveryHalt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void groupDeliveryRestart() {
        if (this.m_group != null && this.m_group.getGroupCC() != null) {
            if (this.DEBUG) {
                this.debug("group " + this.m_group + " delivery restart db messages: " + this.m_delegate.hasMsgsInDb() + "/" + this.m_delegate.getSavesInProgress());
            }
            Object object = this.m_inDoubtRecoveryMutex;
            synchronized (object) {
                if (this.m_inDoubtMemberRecoveryTracker != null && this.m_inDoubtMemberRecoveryTracker.startRecoveryTimer()) {
                    return;
                }
            }
            this.m_delegator.stopDelivery();
            this.m_delegator.cancelMsgRestore();
            this.m_delegator.startDelivery(null);
        }
    }

    private void groupDeliveryHalt() {
        if (this.m_group != null && this.m_group.getGroupCC() != null) {
            this.m_delegator.stopDelivery();
        }
    }

    private DurableManager getDurableManager() {
        if (this.m_manager == null) {
            this.m_manager = AgentRegistrar.getAgentRegistrar().getDurableManager();
        }
        return this.m_manager;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        try {
            this.freezeGroupCC();
            if (!this.m_delegate.isConnected()) {
                boolean bl = false;
                return bl;
            }
            Iterator iter = this.m_group.getGroupMemberIds();
            while (iter.hasNext()) {
                Long ccid = (Long)iter.next();
                try {
                    IClientContext cc = this.m_reg.getClient(ccid);
                    if (!cc.isConnected()) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (EClientNotRegistered eClientNotRegistered) {}
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unfreezeGroupCC();
        }
    }

    @Override
    public boolean isDisconnected() {
        return !this.m_delegator.isConnected();
    }

    @Override
    public SubscriptionsTable getSubscriptions() {
        this.m_junkSubscriptionsHashtable.clear();
        return this.m_junkSubscriptionsHashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int msgSaveDone(IMgram message, boolean postponedSave) {
        int ret = -1;
        try {
            ret = this.m_delegate.msgSaveDone(message, postponedSave);
        }
        finally {
            this.notifyGroupRestoreThreads();
        }
        return ret;
    }

    public void lockGroupCC() {
        this.m_freezeLock.lock();
    }

    public void unlockGroupCC() {
        try {
            this.m_freezeLock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freezeGroupCC() {
        try {
            this.lockGroupCC();
            Lock lock = this.m_freezeLock;
            synchronized (lock) {
                ++this.m_freezeCount;
            }
        }
        finally {
            this.unlockGroupCC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freezeGroupCC(boolean interruptible) throws InterruptedException {
        boolean locked = false;
        try {
            this.m_freezeLock.lock(interruptible);
            locked = true;
            Lock lock = this.m_freezeLock;
            synchronized (lock) {
                ++this.m_freezeCount;
            }
        }
        finally {
            if (locked) {
                this.unlockGroupCC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unfreezeGroupCC() {
        try {
            this.lockGroupCC();
            Lock lock = this.m_freezeLock;
            synchronized (lock) {
                --this.m_freezeCount;
                if (this.m_freezeCount == 0) {
                    this.m_freezeLock.notifyAll();
                }
            }
            if (this.m_freezeCount < 0) {
                EAssertFailure t = new EAssertFailure("Negative group freeze count!");
                BrokerComponent.getComponentContext().logMessage((Throwable)t, 1);
            }
        }
        finally {
            this.unlockGroupCC();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForGroupCCUnfreeze(boolean interruptable) throws InterruptedException {
        this.m_freezeLock.lock(interruptable);
        boolean interrupted = false;
        while (this.m_freezeCount > 0) {
            this.m_freezeLock.unlock();
            Lock lock = this.m_freezeLock;
            synchronized (lock) {
                if (this.m_freezeCount > 0) {
                    try {
                        this.m_freezeLock.wait();
                    }
                    catch (InterruptedException ie) {
                        if (interruptable) {
                            throw new InterruptedException();
                        }
                        interrupted = true;
                    }
                }
            }
            this.m_freezeLock.lock(interruptable);
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public ICCSizeTracker getCCSizeTracker() {
        return this.m_tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMemberDoubtResolved(IClientContext member, List dnrs) {
        InDoubtMemberRecoveryTracker tracker = null;
        Object object = this.m_inDoubtRecoveryMutex;
        synchronized (object) {
            tracker = this.m_inDoubtMemberRecoveryTracker;
        }
        if (tracker != null) {
            if (dnrs != null && !dnrs.isEmpty() && tracker.isMemberInDoubt(member)) {
                this.m_delegator.getGuarDoubtManager().addRecoveredGroupMemberDNRs(member, dnrs);
            }
            tracker.removeMemberRecoveredInDoubt(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMemberDisconnect(IClientContext member, List oldDnrs) {
        Object object = this.m_inDoubtRecoveryMutex;
        synchronized (object) {
            if (this.m_inDoubtMemberRecoveryTracker != null) {
                this.m_inDoubtMemberRecoveryTracker.removeMemberRecoveredInDoubt(member);
            }
        }
        if (oldDnrs != null) {
            this.m_delegator.getGuarDoubtManager().clearRecoveredGroupMemberDNRs(oldDnrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasRecoveredInDoubtMembers() {
        Object object = this.m_inDoubtRecoveryMutex;
        synchronized (object) {
            if (this.m_inDoubtMemberRecoveryTracker != null) {
                return this.m_inDoubtMemberRecoveryTracker.hasRecoveredInDoubtMembers();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recoveryComplete() {
        for (BrokerSubscription bs : this.m_group.appendAllSubscriptions(new ArrayList<BrokerSubscription>())) {
            IClientContext cc = bs.getClient();
            if (cc == null || !cc.isXOnce() || !cc.isResumable()) continue;
            if (this.DEBUG) {
                this.debug(this.m_group.getGroupName() + " Adding in doubt member: " + AgentRegistrar.getAgentRegistrar().getClientFullName(cc.getId()) + "/" + cc.getId());
            }
            Object object = this.m_inDoubtRecoveryMutex;
            synchronized (object) {
                if (this.m_inDoubtMemberRecoveryTracker == null) {
                    this.m_inDoubtMemberRecoveryTracker = new InDoubtMemberRecoveryTracker();
                }
                this.m_inDoubtMemberRecoveryTracker.addMemberRecoveredInDoubt(cc);
            }
        }
        if (Config.ENABLE_INTERBROKER) {
            for (GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma : this.m_xonceAllocationTracker.getAllocations()) {
                try {
                    IClientContext cc = this.m_reg.getClient(gma.recipientId);
                    cc.addInDoubtXOGroupSend(gma, this);
                }
                catch (EClientNotRegistered ecnr) {
                    this.m_xonceAllocationTracker.removeXOnceAllocation(gma.msgTracking);
                }
            }
        }
    }

    public void setGroupAllocationTracker(GroupXOnceMsgAllocationTracker tracker) {
        if (Config.ENABLE_INTERBROKER) {
            this.m_xonceAllocationTracker = tracker;
        }
    }

    public final void removeXOnceAllocation(long msgTracking) {
        if (Config.ENABLE_INTERBROKER && this.m_xonceAllocationTracker.removeXOnceAllocation(msgTracking)) {
            this.m_delegate.removeMsgPendingAck(msgTracking);
        }
    }

    public void processXOnceGroupDeallocation(final IMgram m, final IClientContext recipient, final boolean inDoubt, boolean async) {
        if (m == null) {
            this.notifyGroup();
            return;
        }
        Runnable reallocateTask = new Runnable(){

            @Override
            public void run() {
                GroupSubscriptionClientContext.this.processGroupMemberMgram(m, null, recipient, inDoubt, inDoubt, inDoubt);
            }
        };
        if (async) {
            AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(reallocateTask, 0L);
        } else {
            reallocateTask.run();
        }
    }

    public void saveInDoubtXOGroupMessage(IMgram m, IClientContext recipient, boolean jmsRedelivery, boolean inDoubt) {
        m = MsgSaver.removeLBSWrapper(m);
        if (recipient.isDurable()) {
            this.adjustDurableCCTracker(m, false);
        }
        this.doGroupMessageSave(m, null, jmsRedelivery, inDoubt, false);
    }

    public void writeSyncRecords() throws ECannotFlushEvents {
        if (Config.ENABLE_INTERBROKER) {
            this.m_xonceAllocationTracker.writeSyncRecords();
        }
    }

    @Override
    public void checkFTDNotifyEventRequired(boolean starting) {
        if (Config.FLOW_TO_DISK_NOTIFY) {
            if (!starting) {
                Iterator<BrokerSubscription> subs = this.m_group.appendAllSubscriptions(new ArrayList<BrokerSubscription>()).iterator();
                while (subs != null && subs.hasNext()) {
                    BrokerSubscription bs = subs.next();
                    bs.getClient().checkFTDNotifyEventRequired(starting);
                }
            } else if (!this.startFTDWarningLogged) {
                this.startFTDWarningLogged = true;
                BrokerComponent.getComponentContext().logMessage((Throwable)new Exception(this.m_group.toString() + " - checkFTDNotifyEventRequired(true) not expected for group subscription."), 2);
            }
        }
    }

    private class InDoubtMemberRecoveryTracker
    implements Runnable {
        private static final long WARNING_INTERVAL = 30000L;
        private static final int UNSTARTED = 0;
        private static final int STARTED = 1;
        private static final int CANCELED = 2;
        private static final int TIMED_OUT = 3;
        private int m_trackerState = 0;
        private HashSet m_membersRecoveredInDoubt = new HashSet();
        private boolean m_warned = false;
        private long m_tte = -1L;

        private InDoubtMemberRecoveryTracker() {
        }

        private final void addMemberRecoveredInDoubt(IClientContext member) {
            this.m_membersRecoveredInDoubt.add(new Long(member.getId()));
        }

        public final boolean hasRecoveredInDoubtMembers() {
            return !this.m_membersRecoveredInDoubt.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isMemberInDoubt(IClientContext member) {
            Object object = GroupSubscriptionClientContext.this.m_inDoubtRecoveryMutex;
            synchronized (object) {
                return this.m_membersRecoveredInDoubt.contains(new Long(member.getId()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeMemberRecoveredInDoubt(IClientContext member) {
            Object object = GroupSubscriptionClientContext.this.m_inDoubtRecoveryMutex;
            synchronized (object) {
                if (this.m_membersRecoveredInDoubt.remove(new Long(member.getId())) && this.m_membersRecoveredInDoubt.isEmpty()) {
                    this.cancelRecoveryTimer();
                }
            }
        }

        public final boolean startRecoveryTimer() {
            if (this.m_trackerState == 0) {
                if (GroupSubscriptionClientContext.this.DEBUG) {
                    GroupSubscriptionClientContext.this.debug(GroupSubscriptionClientContext.this.m_group.getGroupName() + "Starting in doubt recovery timer because of in doubt group members: " + this.m_membersRecoveredInDoubt);
                }
                this.m_trackerState = 1;
                if (Config.SHARED_SUBS_RECOVERY_TIMEOUT < 0L) {
                    AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(this, 30000L);
                } else {
                    if (Config.SHARED_SUBS_RECOVERY_TIMEOUT > 30000L) {
                        if (GroupSubscriptionClientContext.this.DEBUG) {
                            GroupSubscriptionClientContext.this.debug(GroupSubscriptionClientContext.this.m_group.getGroupName() + "Adding in doubt recovery warning timer at " + new Date());
                        }
                        AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(this, 30000L);
                    }
                    this.m_tte = System.currentTimeMillis() + Config.SHARED_SUBS_RECOVERY_TIMEOUT;
                    AgentRegistrar.getAgentRegistrar().getWatchDogThread().addAbsoluteTimer(this, this.m_tte);
                }
            }
            return this.m_trackerState == 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean cancelRecoveryTimer() {
            Object object = GroupSubscriptionClientContext.this.m_inDoubtRecoveryMutex;
            synchronized (object) {
                switch (this.m_trackerState) {
                    case 0: 
                    case 1: {
                        this.m_trackerState = 2;
                        if (this.m_warned && this.m_membersRecoveredInDoubt.isEmpty()) {
                            Config.logMessage(prMessageFormat.format(prAccessor.getString("LBS_RECOVERY_RESOLVED"), new Object[]{GroupSubscriptionClientContext.this.m_group.getGroupName()}), 3);
                        }
                        GroupSubscriptionClientContext.this.m_inDoubtMemberRecoveryTracker = null;
                        this.scheduleNotify();
                        return true;
                    }
                }
                return false;
            }
        }

        private final void scheduleNotify() {
            AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(new Runnable(){

                @Override
                public void run() {
                    GroupSubscriptionClientContext.this.notifyGroup();
                }
            }, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = GroupSubscriptionClientContext.this.m_inDoubtRecoveryMutex;
            synchronized (object) {
                if (GroupSubscriptionClientContext.this.DEBUG) {
                    GroupSubscriptionClientContext.this.debug(GroupSubscriptionClientContext.this.m_group.getGroupName() + " timer fired in state: " + this.m_trackerState + " at " + new Date());
                }
                if (this.m_trackerState != 1) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (this.m_tte >= 0L && now >= this.m_tte && this.m_trackerState == 1) {
                    this.m_trackerState = 3;
                    Config.logMessage(prMessageFormat.format(prAccessor.getString("LBS_RECOVERY_TIMEOUT"), new Object[]{GroupSubscriptionClientContext.this.m_group.getGroupName(), Long.toString(Config.SHARED_SUBS_RECOVERY_TIMEOUT / 1000L), Integer.toString(this.m_membersRecoveredInDoubt.size())}), 2);
                    this.m_membersRecoveredInDoubt.clear();
                    GroupSubscriptionClientContext.this.m_inDoubtMemberRecoveryTracker = null;
                    this.scheduleNotify();
                    return;
                }
                if (!this.m_warned) {
                    int inDoubt = this.m_membersRecoveredInDoubt.size();
                    if (inDoubt > 0) {
                        this.m_warned = true;
                        if (this.m_tte < 0L) {
                            Config.logMessage(prMessageFormat.format(prAccessor.getString("LBS_RECOVERY_WARNING"), new Object[]{GroupSubscriptionClientContext.this.m_group.getGroupName(), Long.toString(30L), "unlimited", Integer.toString(inDoubt)}), 2);
                        } else {
                            Config.logMessage(prMessageFormat.format(prAccessor.getString("LBS_RECOVERY_WARNING"), new Object[]{GroupSubscriptionClientContext.this.m_group.getGroupName(), Long.toString(30L), Long.toString(Config.SHARED_SUBS_RECOVERY_TIMEOUT / 1000L), Integer.toString(inDoubt)}), 2);
                        }
                    } else {
                        this.cancelRecoveryTimer();
                    }
                }
            }
        }
    }
}

