/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpConfigManager;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import progress.message.broker.Acceptor;
import progress.message.broker.AcceptorHolder;
import progress.message.broker.Config;
import progress.message.broker.HTTPDirectInboundEntry;
import progress.message.broker.HTTPDirectInboundHolder;
import progress.message.broker.HTTPDirectInboundProtocolHolder;
import progress.message.broker.IAcceptor;
import progress.message.broker.prAccessor;
import progress.message.net.ESocketConfigException;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressSocketFactory;
import progress.message.net.http.server.HttpConnectionHandler;
import progress.message.net.http.server.HttpXProtocolHandlerFactory;

public class HTTPAcceptor
extends Acceptor
implements IAcceptor {
    HTTPDirectInboundHolder m_httpDirectInboundHolder;
    private Hashtable m_configManagers = new Hashtable();
    private String m_acceptorConfigID = null;
    private HttpConnectionHandler m_connectionHandler = null;
    static volatile String s_DEFAULT_HTTP_DEBUG = null;
    static volatile String s_DEFAULT_HTTP_MIN_THREADS = null;
    static volatile String s_DEFAULT_HTTP_MAX_THREADS = null;
    static volatile String s_DEFAULT_HTTP_THREAD_IDLE_TIMEOUT_IN_MILLISECS = null;
    static volatile String s_DEFAULT_HTTP_CONNECTION_CLEANUP_INTERVAL = null;
    static volatile String s_DEFAULT_HTTP_CLIENT_IDLE_TIMEOUT_IN_MILLISECS = null;
    static volatile String s_DEFAULT_HTTP_CLIENT_READ_TIMEOUT_IN_MILLISECS = null;
    static volatile String s_DEFAULT_HTTP_BROKER_READ_TIMEOUT_IN_MILLISECS = null;

    public HTTPAcceptor(String name, String url, String externalUrl, boolean dynHostBinding, String privateHost, String publicHost, Properties properties) throws ESocketConfigException {
        this(name, url, externalUrl, "http", dynHostBinding, privateHost, publicHost, properties);
    }

    public HTTPAcceptor(String name, String url, String externalUrl, String protocol, boolean dynHostBinding, String privateHost, String publicHost, Properties properties) throws ESocketConfigException {
        super(name, url, externalUrl, protocol, dynHostBinding, privateHost, publicHost, properties);
        this.m_name = name;
        if (this.m_bindAddr == null && this.m_hostname != null) {
            try {
                this.m_bindAddr = this.m_bindToSpecifiedIpOrHostOnly ? ProgressInetAddress.getByName(this.m_hostname) : ProgressInetAddress.getLocalAnyLocalAddress();
                ProgressInetAddress.showIPAddressDiagnostic("HTTPAcceptor " + this.m_name + " bindAddress = " + this.m_bindAddr + ", hostname = " + this.m_hostname, null);
            }
            catch (UnknownHostException e) {
                ProgressInetAddress.showIPAddressDiagnostic("HTTPAcceptor " + this.m_name + " unable to determine bindAddress for host " + this.m_hostname, e);
            }
        }
        this.m_properties.put("PROTOCOL", "HTTP");
        int socketType = ProgressSocketFactory.getType(this.m_protocol);
        this.m_socketFactory = ProgressSocketFactory.getFactory(socketType);
    }

    public static void setDefaultHTTPParams(Boolean httpDebug, Integer httpMinThreads, Integer httpMaxThreads, Long httpThreadIdleTimeout, Long httpConnectionCleanupInterval, Long httpClientIdleTimeout, Long httpClientReadTimeout, Long httpBrokerReadTimeout) {
        String val = httpDebug != null ? httpDebug.toString() : "false";
        s_DEFAULT_HTTP_DEBUG = new String(val);
        val = httpMinThreads != null ? httpMinThreads.toString() : String.valueOf(2);
        s_DEFAULT_HTTP_MIN_THREADS = new String(val);
        val = httpMaxThreads != null ? httpMaxThreads.toString() : String.valueOf(512);
        s_DEFAULT_HTTP_MAX_THREADS = new String(val);
        val = httpThreadIdleTimeout != null ? httpThreadIdleTimeout.toString() : "60000";
        s_DEFAULT_HTTP_THREAD_IDLE_TIMEOUT_IN_MILLISECS = new String(val);
        val = httpConnectionCleanupInterval != null ? httpConnectionCleanupInterval.toString() : "60000";
        s_DEFAULT_HTTP_CONNECTION_CLEANUP_INTERVAL = new String(val);
        val = httpClientIdleTimeout != null ? httpClientIdleTimeout.toString() : String.valueOf(10000L);
        s_DEFAULT_HTTP_CLIENT_IDLE_TIMEOUT_IN_MILLISECS = new String(val);
        val = httpClientReadTimeout != null ? httpClientReadTimeout.toString() : String.valueOf(50500L);
        s_DEFAULT_HTTP_CLIENT_READ_TIMEOUT_IN_MILLISECS = new String(val);
        val = httpBrokerReadTimeout != null ? httpBrokerReadTimeout.toString() : String.valueOf(20000L);
        s_DEFAULT_HTTP_BROKER_READ_TIMEOUT_IN_MILLISECS = new String(val);
    }

    public void setHTTPDirectInboundHolder(HTTPDirectInboundHolder holder) {
        this.m_httpDirectInboundHolder = holder;
        Enumeration enumeration = this.m_httpDirectInboundHolder.getHTTPDirectInboundProtocolHolders();
        while (enumeration.hasMoreElements()) {
            HTTPDirectInboundProtocolHolder protocolHolder = (HTTPDirectInboundProtocolHolder)enumeration.nextElement();
            Properties props = new Properties();
            props.put("HTTP_INBOUND_HOLDER", protocolHolder);
            if (AcceptorHolder.getAcceptorHolder().getAcceptor(this.m_acceptorConfigID) == null) continue;
            HttpConfigManager configMgr = new HttpConfigManager(props, "INBOUND", protocolHolder.getInboundProtocol());
            this.registerConfigManager(protocolHolder.getEntryName(), configMgr);
        }
    }

    public HTTPDirectInboundHolder getHTTPDirectInboundHolder() {
        return this.m_httpDirectInboundHolder;
    }

    @Override
    void createServerSocket() throws IOException {
        if (this.m_httpDirectInboundHolder != null) {
            this.m_properties.put("HTTP_DIRECT_INBOUND_HOLDER", this.m_httpDirectInboundHolder);
        }
        this.m_serverSocket = this.m_socketFactory.createProgressServerSocket(this.m_principal, this.m_port, this.m_backlog, this.m_bindAddr, this.m_properties);
    }

    private void PrintEnd() {
        this.setAcceptorState(0);
        String mf87 = prAccessor.getString("STR350");
        Object[] ob87 = new Object[]{this.m_name};
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf87, ob87), 3);
    }

    public void registerConfigManager(String entryName, HttpConfigManager mgr) {
        if (entryName == null || entryName.equals("")) {
            return;
        }
        if (Config.DS_DEBUG) {
            System.out.println("HttpAcceptor.registerConfigManager for protocol entry " + entryName + " accp_name = " + this.getAcceptorName() + " prot = " + this.getProtocol());
        }
        if (!this.m_configManagers.containsKey(entryName)) {
            this.m_configManagers.put(entryName, mgr);
        }
    }

    public void unregisterConfigManager(String entryName) {
        if (Config.DS_DEBUG) {
            System.out.println("HttpAcceptor.unregisterConfigManager for entry: " + entryName + " accp_name = " + this.getAcceptorName() + " prot = " + this.getProtocol());
        }
        if (this.m_configManagers.containsKey(entryName)) {
            this.m_configManagers.remove(entryName);
        }
    }

    public HttpConfigManager getConfigManager(String entryName) {
        if (entryName == null) {
            return null;
        }
        if (Config.DS_DEBUG) {
            System.out.println("HttpAcceptor.getConfigManager for entryName " + entryName + " accp_name = " + this.getAcceptorName() + " prot = " + this.getProtocol());
        }
        return (HttpConfigManager)this.m_configManagers.get(entryName);
    }

    public void setAcceptorConfigID(String acceptorConfigID) {
        this.m_acceptorConfigID = acceptorConfigID;
    }

    public String getAcceptorConfigID() {
        return this.m_acceptorConfigID;
    }

    public void addProtocolEntry(HTTPDirectInboundProtocolHolder protocolEntry) {
        String entryName;
        if (Config.DS_DEBUG) {
            System.out.println("HttpAcceptor.addProtocolEntry for type " + protocolEntry.getInboundProtocol() + " accp_name = " + this.getAcceptorName() + " accep.prot = " + this.getProtocol());
        }
        if (this.m_configManagers.containsKey(entryName = protocolEntry.getEntryName())) {
            return;
        }
        if (AcceptorHolder.getAcceptorHolder().getAcceptor(this.m_acceptorConfigID) != null) {
            Properties props = new Properties();
            props.put("HTTP_INBOUND_HOLDER", protocolEntry);
            HttpConfigManager configMgr = new HttpConfigManager(props, "INBOUND", protocolEntry.getInboundProtocol());
            this.registerConfigManager(protocolEntry.getEntryName(), configMgr);
        }
        if (this.getHTTPDirectInboundHolder() != null) {
            this.getHTTPDirectInboundHolder().addHTTPDirectInboundProtocolHolder(protocolEntry);
        }
        HttpXProtocolHandlerFactory factory = null;
        HttpConnectionHandler handler = this.getHttpConnectionHandler();
        if (handler != null) {
            factory = handler.loadHttpFactory(protocolEntry, null);
        }
        if (factory != null) {
            handler.insertProtocolFactory(factory, 0);
        }
    }

    public void removeProtocolEntry(String entryName) {
        HttpConfigManager configMgr;
        if (Config.DS_DEBUG) {
            System.out.println("HttpAcceptor.removeProtocolEntry for entry " + entryName);
        }
        if ((configMgr = this.getConfigManager(entryName)) != null) {
            configMgr.onDeleted();
        }
    }

    public void addURLEntry(HTTPDirectInboundEntry entry, String parentName) {
        HttpConfigManager configMgr;
        if (Config.DS_DEBUG) {
            System.out.println(" HttpAcceptor.addURLEntry for protocol entry: " + parentName + " accp_name = " + super.getAcceptorName() + " accep.prot = " + super.getProtocol());
        }
        if ((configMgr = this.getConfigManager(parentName)) != null) {
            configMgr.addInboundEntry(entry, null);
        }
        if (Config.DS_DEBUG) {
            System.out.println("in HttpAcceptor.addURLEntry for entry " + entry.toString());
        }
    }

    public void updateURLEntry(HTTPDirectInboundEntry entry, String parentName, String newURL) {
        HttpConfigManager configMgr;
        if (Config.DS_DEBUG) {
            System.out.println(" HttpAcceptor.updateURLEntry for protocol entry: " + parentName + " accp_name = " + super.getAcceptorName() + " accep.prot = " + super.getProtocol());
        }
        if ((configMgr = this.getConfigManager(parentName)) != null) {
            configMgr.updateInboundEntryURL(entry, newURL);
        }
        if (Config.DS_DEBUG) {
            System.out.println("in HttpAcceptor.updateURLEntry for entry " + entry.toString() + " new url = " + newURL);
        }
    }

    public void removeURLEntry(HTTPDirectInboundEntry entry, String name) {
        HttpConfigManager configMgr;
        if (Config.DS_DEBUG) {
            System.out.println("HttpAcceptor.removeURLEntry for name " + name + " accp_name = " + super.getAcceptorName() + " accep.prot = " + super.getProtocol());
        }
        if ((configMgr = this.getConfigManager(name)) != null) {
            configMgr.removeInboundEntry(entry);
        }
    }

    public void registerConnectionHandler(HttpConnectionHandler handler) {
        this.m_connectionHandler = handler;
    }

    public HttpConnectionHandler getHttpConnectionHandler() {
        return this.m_connectionHandler;
    }
}

