/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.AgentRegistrar;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.StringUtil;
import progress.message.zclient.FastVector;
import progress.message.zclient.SessionConfig;

public class LBSTrackingInfo {
    private static byte VERSION = 1;
    private FastVector transitHistory;
    private FastVector targetGroups;

    public synchronized void addTransitHistory(long brokerId) {
        if (this.transitHistory == null) {
            this.transitHistory = new FastVector();
        }
        this.transitHistory.addElement(new Long(brokerId));
    }

    public synchronized void copyTransitHistory(FastVector source) {
        if (source == null || source.m_count == 0) {
            this.transitHistory = null;
            return;
        }
        this.transitHistory = new FastVector();
        for (int i = 0; i < source.m_count; ++i) {
            this.transitHistory.addElement(source.m_data[i]);
        }
    }

    public synchronized boolean isInTransitHistory(long id) {
        if (this.transitHistory == null) {
            return false;
        }
        for (int i = 0; i < this.transitHistory.m_count; ++i) {
            long history = (Long)this.transitHistory.m_data[i];
            if (history != id) continue;
            return true;
        }
        return false;
    }

    public synchronized long[] getTransitHistoryArray() {
        if (this.transitHistory == null) {
            return new long[0];
        }
        long[] visited = new long[this.transitHistory.m_count];
        for (int i = 0; i < this.transitHistory.m_count; ++i) {
            long broker_id;
            visited[i] = broker_id = ((Long)this.transitHistory.m_data[i]).longValue();
        }
        return visited;
    }

    public synchronized int getHopCount() {
        if (this.transitHistory == null) {
            return 0;
        }
        return this.transitHistory.m_count;
    }

    public synchronized int getTargetSerializedLength() {
        int ret = 4;
        for (int i = 0; i < this.targetGroups.m_count; ++i) {
            ret += StringUtil.lengthUTF((String)this.targetGroups.m_data[i]);
        }
        return ret;
    }

    public synchronized int getTargetCount() {
        if (this.targetGroups == null) {
            return 0;
        }
        return this.targetGroups.m_count;
    }

    public synchronized FastVector getTransitHistory() {
        return this.transitHistory;
    }

    public synchronized void addTargetGroup(String group) {
        if (this.targetGroups == null) {
            this.targetGroups = new FastVector();
        }
        this.targetGroups.addElement(group);
    }

    public synchronized void setTargetGroups(FastVector groups) {
        this.targetGroups = groups;
    }

    public synchronized FastVector getTargetGroups() {
        return this.targetGroups;
    }

    public FastVector toTransitVector() {
        int i;
        FastVector ret = new FastVector();
        if (this.transitHistory != null) {
            ret.addElement(new Integer(this.transitHistory.m_count));
            for (i = 0; i < this.transitHistory.m_count; ++i) {
                ret.addElement(this.transitHistory.m_data[i]);
            }
        } else {
            ret.addElement(new Integer(0));
        }
        if (this.targetGroups != null) {
            for (i = 0; i < this.targetGroups.m_count; ++i) {
                ret.addElement(this.targetGroups.m_data[i]);
            }
        }
        return ret;
    }

    public synchronized boolean containsTarget(String groupName) {
        if (this.targetGroups == null) {
            return false;
        }
        for (int i = 0; i < this.targetGroups.m_count; ++i) {
            if (!groupName.equals((String)this.targetGroups.m_data[i])) continue;
            return true;
        }
        return false;
    }

    public synchronized void writeToStream(DataOutput out) throws IOException {
        out.writeByte(VERSION);
        if (this.transitHistory != null) {
            out.writeInt(this.transitHistory.m_count);
            for (int i = 0; i < this.transitHistory.m_count; ++i) {
                out.writeLong((Long)this.transitHistory.m_data[i]);
            }
        } else {
            out.writeInt(0);
        }
        this.writeTargetGroupsToStream(out);
    }

    public synchronized void readFromStream(DataInput in) throws IOException {
        in.readByte();
        int hops = in.readInt();
        if (hops > 0) {
            this.transitHistory = new FastVector(hops);
            for (int i = 0; i < hops; ++i) {
                this.transitHistory.addElement(new Long(in.readLong()));
            }
        }
        this.targetGroups = LBSTrackingInfo.readTargetGroupsFromStream(in);
    }

    public synchronized void writeTargetGroupsToStream(DataOutput out) throws IOException {
        if (this.targetGroups != null) {
            out.writeInt(this.targetGroups.m_count);
            for (int i = 0; i < this.targetGroups.m_count; ++i) {
                out.writeUTF((String)this.targetGroups.m_data[i]);
            }
        } else {
            out.writeInt(0);
        }
    }

    public static FastVector readTargetGroupsFromStream(DataInput in) throws IOException {
        FastVector ret = null;
        int targets = in.readInt();
        if (targets > 0) {
            ret = new FastVector(targets);
            for (int i = 0; i < targets; ++i) {
                ret.addElement(in.readUTF());
            }
        }
        return ret;
    }

    public synchronized String toString() {
        int k;
        StringBuffer sb = new StringBuffer();
        sb.append("LBS Tracking: Hops: [");
        sb.append(this.transitHistory == null ? 0 : this.transitHistory.m_count);
        sb.append("], Transit History: [");
        if (this.transitHistory != null) {
            for (k = 0; k < this.transitHistory.m_count; ++k) {
                try {
                    if (k > 0) {
                        sb.append("-->");
                    }
                    long id = (Long)this.transitHistory.m_data[k];
                    sb.append(AgentRegistrar.getAgentRegistrar().getClient(id).getUid());
                    continue;
                }
                catch (Exception e) {
                    sb.append(this.transitHistory.m_data[k]);
                }
            }
        }
        sb.append("], Groups: [");
        if (this.targetGroups != null) {
            for (k = 0; k < this.targetGroups.m_count; ++k) {
                if (k > 0) {
                    sb.append(", ");
                }
                sb.append(this.targetGroups.m_data[k]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static final IMgram buildLBSTargetWrapper(IMgram m, LBSTrackingInfo info) {
        IMgram wrapper = MgramFactory.getMgramFactory().buildLBSTargetMessage(m, info.getHopCount() <= 1);
        ObjectOutput out = wrapper.getPayloadOutputStreamHandle();
        try {
            info.writeToStream(out);
        }
        catch (IOException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            return null;
        }
        return wrapper;
    }

    public static final LBSTrackingInfo unmarshalLBTargetWrapper(IMgram m) {
        ObjectInput in = m.getPayloadInputStreamHandle();
        try {
            LBSTrackingInfo info = new LBSTrackingInfo();
            info.readFromStream(in);
            return info;
        }
        catch (IOException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
            return null;
        }
    }
}

