/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;
import progress.message.broker.Config;
import progress.message.broker.ECorruptLogEvent;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.ELogOutOfSequence;
import progress.message.broker.EOFEvent;
import progress.message.broker.EOLEvent;
import progress.message.broker.EProtectedBlockReached;
import progress.message.broker.EStartupFailure;
import progress.message.broker.EUnknownLogEventType;
import progress.message.broker.EventListener;
import progress.message.broker.LogEvent;
import progress.message.broker.LogInputStream;
import progress.message.broker.LogOutputStream;
import progress.message.broker.LogStreamFile;
import progress.message.broker.LogTrace;
import progress.message.broker.SyncEndEvt;
import progress.message.broker.SyncpointLoc;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.prAccessor;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.IStateEvent;

class LogFile
extends DebugObject {
    static final int OVERHEAD = 10;
    private static final int VERS_MOD = 32768;
    private LogStreamFile[] m_file;
    private String[] m_filePaths;
    private short[] m_version = new short[2];
    private long[] m_timestamp = new long[2];
    private LogStreamFile m_curfile;
    private int m_curfile_no;
    private LogInputStream m_logis;
    private LogOutputStream m_logos;
    private boolean m_inSync;
    private SyncpointLoc m_syncLoc;
    private SyncpointLoc m_syncLast;
    private SyncpointLoc m_syncLastInDb;
    private long m_syncLastSize;
    private static boolean s_nofilter = true;
    private static volatile PrintWriter s_pw = null;
    private static volatile Properties s_filters = null;
    private DebugObject DbgSP = new DebugObject("DebugSyncpoint");

    LogFile() throws IOException {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogFile" : null);
        if (this.DbgSP.getDebug()) {
            this.DbgSP.debug("Enabled");
        }
    }

    public void open() throws IOException {
        this.open(Config.LOG_FILE_1, Config.LOG_FILE_2);
    }

    public void open(String logFile1, String logFile2) throws IOException {
        this.open(logFile1, logFile2, Config.LOG_BLOCK_SIZE);
    }

    public void open(String logFile1, String logFile2, int blockSize) throws IOException {
        if (this.DEBUG) {
            this.debug("initializing");
        }
        File f1 = new File(logFile1);
        File f2 = new File(logFile2);
        if (!f1.exists()) {
            throw new FileNotFoundException(logFile1);
        }
        if (!f2.exists()) {
            throw new FileNotFoundException(logFile2);
        }
        this.m_file = new LogStreamFile[2];
        this.m_file[0] = new LogStreamFile(logFile1, blockSize, Config.LOG_BUFFERED_BLOCKS);
        this.m_file[1] = new LogStreamFile(logFile2, blockSize, Config.LOG_BUFFERED_BLOCKS);
        this.m_filePaths = new String[2];
        this.m_filePaths[0] = logFile1;
        this.m_filePaths[1] = logFile2;
        if (this.DEBUG) {
            this.debug("reading version numbers");
        }
        this.getvers(0);
        this.getvers(1);
        if (this.DEBUG) {
            this.debug("File 0 readseq= " + this.m_file[0].getCurrentReadSequenceNumber() + " writeseq= " + this.m_file[0].getCurrentWriteSequenceNumber());
        }
        if (this.DEBUG) {
            this.debug("File 1 readseq= " + this.m_file[1].getCurrentReadSequenceNumber() + " writeseq= " + this.m_file[1].getCurrentWriteSequenceNumber());
        }
        if (this.m_timestamp[0] != this.m_timestamp[1]) {
            throw new EStartupFailure(prAccessor.getString("STR209") + logFile1 + prAccessor.getString("STR210") + new Date(this.m_timestamp[0]) + ", " + logFile2 + " was initialized " + new Date(this.m_timestamp[1]));
        }
        if (this.DEBUG) {
            this.debug("init done");
        }
    }

    LogFile(long timestamp) throws IOException {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogFile" : null);
        if (this.DbgSP.getDebug()) {
            this.DbgSP.debug("Enabled");
        }
        this.m_file = new LogStreamFile[2];
        this.m_file[0] = new LogStreamFile(Config.LOG_FILE_1);
        this.m_file[1] = new LogStreamFile(Config.LOG_FILE_2);
        this.m_version[0] = 1;
        this.m_version[1] = -1;
        this.m_timestamp[0] = this.m_timestamp[1] = timestamp;
        this.setvers(this.m_file[0], this.m_version[0], this.m_timestamp[0]);
        this.setvers(this.m_file[1], this.m_version[1], this.m_timestamp[1]);
    }

    public void reset(long timestamp) throws IOException {
        if (this.m_file != null) {
            this.m_file[0].close();
            this.m_file[1].close();
        }
        File file = new File(Config.LOG_FILE_1);
        file.delete();
        file = new File(Config.LOG_FILE_2);
        file.delete();
        this.m_file = new LogStreamFile[2];
        this.m_file[0] = new LogStreamFile(Config.LOG_FILE_1);
        this.m_file[1] = new LogStreamFile(Config.LOG_FILE_2);
        this.m_filePaths = new String[2];
        this.m_filePaths[0] = Config.LOG_FILE_1;
        this.m_filePaths[1] = Config.LOG_FILE_2;
        this.m_version[0] = 1;
        this.m_version[1] = -1;
        this.m_timestamp[0] = this.m_timestamp[1] = timestamp;
        this.setvers(this.m_file[0], this.m_version[0], this.m_timestamp[0]);
        this.setvers(this.m_file[1], this.m_version[1], this.m_timestamp[1]);
    }

    void copy(String targetDirectory) throws IOException {
        File logFile1 = new File(this.m_filePaths[0]);
        File logFile2 = new File(this.m_filePaths[1]);
        File targetFile1 = new File(targetDirectory, logFile1.getName());
        File targetFile2 = new File(targetDirectory, logFile2.getName());
        this.copy(this.m_filePaths[0], targetFile1.getAbsolutePath(), 8192);
        this.copy(this.m_filePaths[1], targetFile2.getAbsolutePath(), 8192);
    }

    private void copy(String sourcePath, String targetPath, int blockSize) throws FileNotFoundException, IOException {
        if (this.DEBUG) {
            this.debug("copying " + sourcePath + " to " + targetPath);
        }
        LogStreamFile.copy(sourcePath, targetPath, blockSize);
    }

    public long readLog(LogInputStream logis, EventListener l) throws IOException {
        long nextseq;
        long lastloc;
        block20: {
            lastloc = 0L;
            nextseq = 1L;
            try {
                DataInputStream dis = new DataInputStream(logis);
                if (this.DEBUG) {
                    this.debug("Starting to read log; position= " + logis.getFilePointer());
                }
                while (true) {
                    lastloc = logis.getFilePointer();
                    LogEvent evt = LogEvent.readFromLog(dis);
                    if (this.DEBUG) {
                        this.debug("loc= " + lastloc + " read " + evt.toString());
                    }
                    if (evt instanceof EOFEvent) {
                        LogInputStream cont;
                        if (this.DEBUG) {
                            this.debug("Reached EOF " + logis + " " + lastloc);
                        }
                        if ((cont = this.continuation()) != null) {
                            logis = cont;
                            dis = new DataInputStream(logis);
                            if (!this.DEBUG) continue;
                            this.debug("Continuing " + logis);
                            continue;
                        }
                        break;
                    }
                    if (evt instanceof SyncEndEvt && this.m_inSync && this.DEBUG) {
                        this.debug("SyncEndEvt " + logis + " " + lastloc);
                    }
                    if (evt instanceof EOLEvent) {
                        if (this.DEBUG) {
                            this.debug("Reached EOL " + logis + " " + lastloc);
                        }
                        break;
                    }
                    nextseq = evt.getSeqNo() + (long)evt.getNumSeqNos();
                    l.onLogEventRead(evt, lastloc, nextseq);
                }
            }
            catch (EOFException e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (ECorruptLogEvent e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (EUnknownLogEventType e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (ELogOutOfSequence e) {
                if (this.DEBUG) {
                    this.debug("caught " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (EMgramFormatError e) {
                if (!this.DEBUG) break block20;
                this.debug("caught " + e);
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        if (this.DEBUG) {
            this.debug("Calling onEndLog " + lastloc);
        }
        l.onEndLog(lastloc);
        return nextseq;
    }

    public long LogicalSize(long physicalsize) {
        return this.m_file[0].LogicalSize(physicalsize);
    }

    private void getvers(int fileno) throws IOException {
        DataInputStream dis = new DataInputStream(this.m_file[fileno].getInputStream());
        this.m_version[fileno] = dis.readShort();
        this.m_timestamp[fileno] = dis.readLong();
    }

    private void setvers(LogStreamFile file, short version, long timestamp) throws IOException {
        LogOutputStream logos = file.getOutputStream();
        try {
            logos.seek(0L);
        }
        catch (EProtectedBlockReached e) {
            // empty catch block
        }
        DataOutputStream dos = new DataOutputStream(logos);
        dos.writeShort(version);
        dos.writeLong(timestamp);
        try {
            new EOLEvent().write2log(dos, 14L);
        }
        catch (ELogEventTooLong e) {
            throw new EAssertFailure(e.toString(), e);
        }
        dos.flush();
        logos.sync();
        if (this.DEBUG) {
            this.debug("setvers: flushed");
        }
    }

    private int versCompare(int v1, int v2) {
        if (v1 > v2 || v1 == 0 && v2 == Short.MAX_VALUE) {
            return 1;
        }
        if (v1 == v2) {
            return 0;
        }
        return -1;
    }

    long getTimestamp() {
        return this.m_timestamp[0];
    }

    boolean inSync() {
        return this.m_inSync;
    }

    LogInputStream beginRead(SyncpointLoc syncloc) throws IOException, EStartupFailure {
        this.m_logos = null;
        this.m_logis = null;
        if (syncloc != null) {
            try {
                if (syncloc.getFileNo() == -1 || syncloc.getFilePos() == -1L) {
                    throw new IOException(prAccessor.getString("STR211"));
                }
                this.currentFile(syncloc.getFileNo());
                this.m_logis = this.m_curfile.getInputStream();
                this.m_logis.seek(syncloc.getFilePos());
                this.m_syncLast = syncloc;
                this.m_syncLastInDb = syncloc;
                this.m_curfile.protectFilePos(this.m_syncLast.getFilePos());
            }
            catch (EStartupFailure e) {
                this.m_logis = null;
                throw e;
            }
            catch (IOException e) {
                this.m_logis = null;
            }
        } else {
            if (this.m_version[1] != -1 && this.versCompare(this.m_version[1], this.m_version[0]) == -1) {
                this.currentFile(1);
            } else {
                this.currentFile(0);
            }
            this.m_logis = this.m_curfile.getInputStream();
            this.m_logis.seek(10L);
        }
        if (this.DEBUG) {
            this.debug("Begin Read: m_logis is: " + this.m_logis + " pos is " + this.m_logis.getFilePointer());
        }
        return this.m_logis;
    }

    LogOutputStream beginWrite() throws IOException {
        long pos = this.m_logis == null ? 10L : this.m_logis.getFilePointer();
        this.m_logos = this.m_curfile.getOutputStream();
        if (this.DEBUG) {
            this.debug("beginWrite; currentFile= " + this.m_curfile_no + " pos= " + pos);
        }
        try {
            this.m_logos.seek(pos);
        }
        catch (EProtectedBlockReached eProtectedBlockReached) {
            // empty catch block
        }
        if (this.DbgSP.getDebug()) {
            this.DbgSP.debug("beginWrite; currentFile= " + this.m_curfile_no + " pos= " + pos);
            if (this.m_syncLast != null && this.m_curfile_no == this.m_syncLast.getFileNo() && this.m_syncLast.getFilePos() >= pos) {
                this.DbgSP.debug("***** Begin Write: writepos before last syncpoint m_syncLast= " + this.m_syncLast + " m_curfile_no= " + this.m_curfile_no + " pos= " + pos + " m_syncLastInDb= " + this.m_syncLastInDb);
            }
            if (this.m_syncLastInDb != null && this.m_curfile_no == this.m_syncLastInDb.getFileNo() && this.m_syncLastInDb.getFilePos() >= pos) {
                this.DbgSP.debug("***** Begin Write: writepos before last DB syncpoint m_syncLastInDb= " + this.m_syncLastInDb + " m_curfile_no= " + this.m_curfile_no + " pos= " + pos + " m_syncLast= " + this.m_syncLast);
            }
        }
        this.m_logis = null;
        return this.m_logos;
    }

    void seekWrite(long pos) throws IOException {
        this.m_logos.seek(pos);
    }

    private void currentFile(int fileno) {
        this.m_curfile_no = fileno;
        this.m_curfile = this.m_file[this.m_curfile_no];
    }

    synchronized void beginSyncpoint() throws IOException {
        this.m_inSync = true;
        this.m_syncLoc = new SyncpointLoc((short)this.m_curfile_no, this.m_logos.getFilePointer());
        this.m_curfile.incSequenceNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean checkSyncpointOverwrite(long pos, IStateEvent evt) throws IOException {
        boolean result = false;
        boolean dbOverWrite = false;
        if (this.DbgSP.getDebug()) {
            dbOverWrite = this.checkDbSyncpointOverwrite(pos, evt);
        }
        try {
            if (this.m_syncLast == null) {
                result = false;
                boolean bl = false;
                return bl;
            }
            if (this.m_syncLast.getFileNo() != this.m_curfile_no) {
                result = false;
                boolean bl = false;
                return bl;
            }
            long syncPos = this.m_syncLast.getFilePos();
            long posPlusEvtsize = pos + (long)evt.memsize();
            if (pos <= syncPos && posPlusEvtsize > syncPos) {
                if (this.DbgSP.getDebug()) {
                    this.DbgSP.debug("LogFile.checkSyncpointOverwrite returning true;  syncLast= " + this.m_syncLast + " fileno= " + " pos= " + pos + " posPlusEvtsize= " + posPlusEvtsize);
                }
                result = true;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (this.DbgSP.getDebug() && !result && dbOverWrite) {
                long posPlusEvtsize = pos + (long)evt.memsize();
                new EAssertFailure("***********************LogFile.checkSyncpointOverwrite returning FALSE;  checkDbSyncpointOverwrite returning TRUE;  syncLast= " + this.m_syncLast + " m_syncLastInDb= " + this.m_syncLastInDb + " currentLogPos= " + pos + " posPlusEvtsize= " + posPlusEvtsize).printStackTrace();
            }
        }
        return false;
    }

    synchronized boolean checkDbSyncpointOverwrite(long pos, IStateEvent evt) throws IOException {
        if (this.m_syncLastInDb == null) {
            return false;
        }
        if (this.m_syncLastInDb.getFileNo() != this.m_curfile_no) {
            return false;
        }
        long syncPos = this.m_syncLastInDb.getFilePos();
        long posPlusEvtsize = pos + (long)evt.memsize();
        return pos <= syncPos && posPlusEvtsize > syncPos;
    }

    synchronized SyncpointLoc getSyncpointLoc() {
        return this.m_syncLoc;
    }

    synchronized long getLastSyncpointSize() {
        return this.m_syncLastSize;
    }

    synchronized SyncpointLoc endSyncpoint() {
        this.m_inSync = false;
        if (this.m_syncLast != null) {
            LogStreamFile fileOfPreviousSyncpoint = this.m_file[this.m_syncLast.getFileNo()];
            fileOfPreviousSyncpoint.unprotect();
        }
        this.m_syncLast = this.m_syncLoc;
        short fileNoOfCurrentSyncpoint = this.m_syncLast.getFileNo();
        LogStreamFile fileOfCurrentSyncpoint = this.m_file[fileNoOfCurrentSyncpoint];
        fileOfCurrentSyncpoint.protectFilePos(this.m_syncLast.getFilePos());
        this.m_syncLastSize = 0L;
        if (this.m_curfile_no == fileNoOfCurrentSyncpoint) {
            try {
                long curfilepos = this.m_logos.getFilePointer();
                long syncpos = this.m_syncLast.getFilePos();
                if (syncpos < curfilepos) {
                    this.m_syncLastSize = curfilepos - syncpos;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.DEBUG) {
            try {
                this.debug("EndSyncpoint m_logos is: " + this.m_logos + " pos is " + this.m_logos.getFilePointer() + " syncsize= " + this.m_syncLastSize + " lastSPLoc= " + this.m_syncLast);
                this.debug("EndSyncpoint currentFile= " + this.m_curfile_no + " writeseq= " + this.m_curfile.getCurrentWriteSequenceNumber());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_syncLoc = null;
        return this.m_syncLast;
    }

    public void newDbSyncpointLoc(SyncpointLoc sp) {
        this.m_syncLastInDb = sp;
    }

    synchronized LogOutputStream startNewFile() throws IOException {
        if (this.DEBUG) {
            this.debug("startNewFile (1) oldFile= " + this.m_curfile_no + " newfile " + (1 - this.m_curfile_no));
        }
        int n = 1 - this.m_curfile_no;
        this.m_version[n] = (short)((this.m_version[1 - n] + 1) % 32768);
        this.setvers(this.m_file[n], this.m_version[n], this.m_timestamp[n]);
        long currentSequenceNumber = this.m_curfile.getCurrentWriteSequenceNumber();
        if (this.DEBUG) {
            this.debug("startNewFile (2) m_curfile_no= " + this.m_curfile_no + " seqno= " + currentSequenceNumber);
        }
        this.currentFile(n);
        this.m_curfile.setWriteSequenceNumber(currentSequenceNumber);
        this.m_logos = this.m_curfile.getOutputStream();
        this.m_logos.seek(10L);
        if (this.DEBUG) {
            this.debug("startNewFile (3) (after currentFile(n)); m_curfile_no= " + this.m_curfile_no + " seqno= " + this.m_curfile.getCurrentWriteSequenceNumber());
        }
        return this.m_logos;
    }

    LogInputStream continuation() throws IOException {
        long currentSequenceNumber = this.m_curfile.getCurrentReadSequenceNumber();
        long otherFileSeqNo = this.m_file[1 - this.m_curfile_no].getCurrentReadSequenceNumber();
        if (this.DEBUG) {
            this.debug("Continuation currentSequenceNumber= " + currentSequenceNumber + " otherFileSeqNo= " + otherFileSeqNo);
        }
        if (otherFileSeqNo < currentSequenceNumber) {
            return null;
        }
        this.currentFile(1 - this.m_curfile_no);
        this.m_curfile.setReadSequenceNumber(currentSequenceNumber);
        this.m_logis = this.m_curfile.getInputStream();
        this.m_logis.seek(10L);
        if (this.DEBUG) {
            this.debug("Continuation pos= " + this.m_logis.getFilePointer() + " " + this.m_logis);
        }
        return this.m_logis;
    }

    public long getSize() {
        return new File(this.m_curfile_no == 0 ? Config.LOG_FILE_1 : Config.LOG_FILE_2).length();
    }

    synchronized boolean checkSyncpointDone(long pos) {
        boolean result = false;
        if (this.m_syncLast != null && this.m_curfile_no == this.m_syncLast.getFileNo() && this.m_syncLast.getFilePos() < pos) {
            result = true;
        }
        if (this.DEBUG) {
            this.debug("checkSyncpointDone fileno " + this.m_curfile_no + " pos= " + pos + " result= " + result);
        }
        return result;
    }

    public void close() throws IOException {
        this.m_file[0].close();
        this.m_file[1].close();
        this.m_file = null;
    }

    public void syncSequenceNumbers() {
        long currentSequenceNumber = this.m_curfile.getCurrentReadSequenceNumber();
        this.m_curfile.setWriteSequenceNumber(currentSequenceNumber);
    }

    public void setSize(long size) throws IOException {
        if (size > 0L && this.m_file[0] != null) {
            this.m_file[0].setSize(size);
        }
        if (size > 0L && this.m_file[1] != null) {
            this.m_file[1].setSize(size);
        }
    }

    public static void main(String[] args) throws IOException {
        String base = "F:\\temp\\dump";
        if (args.length > 0) {
            base = args[0];
        }
        LogFile.dumpLogFile(base + File.separator + "recoverylog1.bin", base + File.separator + "recoverylog2.bin", (short)1, 10L, base + File.separator + "dump.txt", base + File.separator + "dump.filter");
    }

    private static void dumpLogFile(String logFile1, String logFile2, short fileno, long pos, String outputFile, String filterFile) throws IOException {
        s_filters = new Properties();
        Config.LOG_BLOCK_SIZE = 8192;
        LogFile lf = new LogFile();
        lf.open(logFile1, logFile2, 8192);
        SyncpointLoc sp = new SyncpointLoc(fileno, pos);
        if (new File(filterFile).exists()) {
            s_filters.load(new FileInputStream(filterFile));
            s_nofilter = false;
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        s_pw = new PrintWriter(fos);
        LogInputStream lis = lf.beginRead(sp);
        EventListener rlr = new EventListener(){

            @Override
            public void onEndLog(long lastloc) {
                s_pw.println("END: " + lastloc);
                s_pw.close();
                System.out.println("END: " + lastloc);
            }

            @Override
            public void onLogEventRead(LogEvent evt, long lastloc, long nextseq) {
                String s = LogTrace.typeToString(evt.type());
                if (s_nofilter || s_filters.getProperty(s, "false").equalsIgnoreCase("true")) {
                    String supplement = "";
                    if (evt.type() == 114) {
                        GSSubscribeEvt gse = (GSSubscribeEvt)evt;
                        GSVirtualClock gsv = gse.getVirtualClock();
                        long g = gsv.getVirtualClock();
                        Date dt = new Date(g);
                        supplement = " VC = " + dt.toString();
                    }
                    s_pw.println("READ: " + evt.toString() + supplement);
                    System.out.println("READ: " + evt.toString() + supplement);
                }
            }
        };
        lf.readLog(lis, rlr);
    }
}

