/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.MessageGroupTable;

final class MessageGroupExpirer
implements Runnable {
    static final int EXPIRER_RUN_INTERVAL = 60000;
    MessageGroupTable m_messageGroupTable;
    volatile boolean m_isRegistered = false;

    public MessageGroupExpirer(MessageGroupTable messageGroupTable) {
        this.m_messageGroupTable = messageGroupTable;
    }

    public void initIfNeeded() {
        if (!this.m_isRegistered && this.m_messageGroupTable.getGroupIdleTimeout() > 0 && BrokerStateManager.getBrokerStateManager().isActive()) {
            AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(this, 60000L);
            this.m_isRegistered = true;
            this.m_messageGroupTable.debug("expirer started for " + this.m_messageGroupTable.getQueueName());
        }
    }

    @Override
    public void run() {
        Thread expireThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MessageGroupExpirer.this.m_messageGroupTable.getGroupIdleTimeout() > 0) {
                    try {
                        MessageGroupExpirer.this.m_messageGroupTable.expireGroups();
                    }
                    catch (Throwable t) {
                        String err = "Error while expiring PTP message groups for queue " + MessageGroupExpirer.this.m_messageGroupTable.getQueueName();
                        BrokerComponent.getComponentContext().logMessage(err, t, 2);
                    }
                    finally {
                        AgentRegistrar.getAgentRegistrar().getWatchDogThread().addRelativeTimer(this, 60000L);
                    }
                } else {
                    MessageGroupExpirer.this.m_isRegistered = false;
                    MessageGroupExpirer.this.m_messageGroupTable.debug("expirer stopped for " + MessageGroupExpirer.this.m_messageGroupTable.getQueueName());
                }
            }
        };
        expireThread.setName("PTP Message Group Expiry - " + this.m_messageGroupTable.getQueueName());
        expireThread.start();
    }
}

