/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Vector;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EDuplicateKey;
import progress.message.util.IndexedList;
import progress.message.util.PriorityQueue;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.IExpirePrecheck;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.OutQueue;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.SenderQueue;

public class MgramSenderQueue
extends SenderQueue {
    IClientContext m_cc = null;
    private IExpirePrecheck m_precheck = null;

    public MgramSenderQueue(OutQueue oq, PrioQueueLimiter outLimiter, IndexedList pendingQmsgs, PrioQueueLimiter pendingQmsgsLimiter, String localNodeName, IClientContext cc) {
        super(cc, oq, outLimiter, pendingQmsgs, pendingQmsgsLimiter, localNodeName);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("MgramSenderQueue");
        }
        this.m_cc = cc;
    }

    void setCC(IClientContext cc) {
        this.m_cc = cc;
    }

    public void setExpirePrecheck(IExpirePrecheck precheck) {
        this.m_outQueue.setExpirePrecheck(precheck);
        this.m_precheck = precheck;
    }

    public synchronized void enqueuePriorityPush(IMgram mgram, int prio, int pushPrio) {
        this.m_outQueue.enqueuePriorityPush(mgram, prio, pushPrio, true);
        this.m_outLimiter.add(mgram.getLimiterSize(), prio);
    }

    @Override
    public synchronized void enqueue(IMgram obj, int prio) throws EMgramFormatError {
        IMgram m = obj;
        if (m.getBrokerHandle().getLocalQueueName() != null) {
            IPTPFlowControlHandler fc = this.m_cc.getPTPFlowControlHandler();
            if (fc == null || !fc.interceptBlocked(m)) {
                this.m_outQueue.enqueue(obj, m.getPriority(), true);
            } else if (m.isDiscardable()) {
                return;
            }
            int len = m.getLimiterSize();
            prio = m.getPriority();
            this.m_outLimiter.add(len, prio);
            if (m.isGuarenteed() && !m.isDiscardable()) {
                try {
                    this.m_pendingQmsgs.append(m.getGuarenteedTrackingNum(), m);
                    this.m_pendingQmsgsLimiter.add(len, prio);
                }
                catch (EDuplicateKey ex) {}
            }
        } else {
            this.m_outQueue.enqueue(obj, prio, true);
            this.m_outLimiter.add(m.getLimiterSize(), prio);
        }
        this.notifyAll();
    }

    @Override
    public synchronized Object dequeueAtOrAbove(int prio) {
        Object obj = this.m_outQueue.dequeueAtOrAbove(prio);
        if (obj == null) {
            return null;
        }
        int len = 0;
        IMgram m = (IMgram)obj;
        len = m.getLimiterSize();
        prio = m.getPriority();
        this.m_outLimiter.add(-len, prio);
        this.notifyAll();
        return obj;
    }

    @Override
    public synchronized Object dequeue(int prio) {
        Object obj = this.m_outQueue.dequeue(prio);
        if (obj == null) {
            return null;
        }
        int len = 0;
        IMgram m = (IMgram)obj;
        len = m.getLimiterSize();
        prio = m.getPriority();
        this.m_outLimiter.add(-len, prio);
        this.notifyAll();
        return obj;
    }

    @Override
    public Vector getExpiredMsgs() {
        Vector v = this.m_outQueue.getExpiredMsgs(this.m_outLimiter);
        IPTPFlowControlHandler fc = this.m_cc.getPTPFlowControlHandler();
        if (fc != null) {
            fc.removeExpired(this, v);
        }
        return v;
    }

    @Override
    public boolean isMsgExpired(Object obj) {
        long now;
        IMgram m = (IMgram)obj;
        if (m.getNoOutqueueExpire()) {
            return false;
        }
        if (this.m_precheck != null && this.m_precheck.precheck(m) != 0) {
            return true;
        }
        if (!m.isTTE()) {
            return false;
        }
        long expTm = m.getTTE();
        return expTm < (now = System.currentTimeMillis());
    }

    private String buildFullDestinationName(IMgram m) {
        if (m == null) {
            return null;
        }
        String subject = m.getSubject().getSubjectString();
        if (subject == null) {
            return null;
        }
        String dest = null;
        String node = m.getRoutingHandle().getRouting();
        dest = node != null && !m.isPubSub() ? (node.equals("") ? "::" + subject : node + "::" + subject) : subject;
        return dest;
    }

    @Override
    public PriorityQueue getOutputQueue() {
        return this.m_outQueue;
    }

    @Override
    public PrioQueueLimiter getOutputQueueLimiter() {
        return this.m_outLimiter;
    }

    @Override
    public IndexedList getQueueMsgPendingQueue() {
        return this.m_pendingQmsgs;
    }

    @Override
    public String getFlowControlName() {
        return "MgramSenderQueue on " + Config.BROKER_NAME + " for: " + this.m_cc;
    }
}

