/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.File;
import java.io.IOException;
import progress.message.broker.ILogRandomAccessFile;

public class NativeRandomAccessFile
implements ILogRandomAccessFile {
    private int m_fileHandle;

    public NativeRandomAccessFile(String path, String mode) throws IOException, IllegalArgumentException {
        boolean rw = mode.equals("rw");
        if (!mode.equals("r") && !rw) {
            throw new IllegalArgumentException("mode must be r or rw");
        }
        this.m_fileHandle = this.open(path, rw);
    }

    public NativeRandomAccessFile(File file, String mode) throws SecurityException, IOException, IllegalArgumentException {
        this(file.getPath(), mode);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.nativeSeek(this.m_fileHandle, pos);
    }

    @Override
    public long length() throws IOException {
        return this.nativeLength(this.m_fileHandle);
    }

    @Override
    public void close() throws IOException {
        this.nativeClose(this.m_fileHandle);
    }

    @Override
    public void sync() throws IOException {
    }

    @Override
    public int readRAF(byte[] b) throws IOException, NullPointerException {
        return this.readRAF(b, 0, b.length);
    }

    @Override
    public int readRAF(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        int readBytes = len;
        return this.nativeRead(this.m_fileHandle, readBytes, b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException, NullPointerException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (b == null) {
            throw new NullPointerException();
        }
        int writeBytes = len;
        this.nativeWrite(this.m_fileHandle, writeBytes, b, off, len);
    }

    @Override
    public void setLength(long length) {
    }

    private native int open(String var1, boolean var2) throws IOException;

    private native void nativeSeek(int var1, long var2) throws IOException;

    private native void nativeClose(int var1) throws IOException;

    private native int nativeRead(int var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    private native void nativeWrite(int var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    public native long nativeLength(int var1) throws IOException;

    static {
        System.loadLibrary("NativeRandomAccessFile");
    }
}

