/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.MsgSaver;
import progress.message.broker.OffloadedPubSubMessage;
import progress.message.msg.IMgram;
import progress.message.util.LongHashTable;
import progress.message.util.PriorityQueue;
import progress.message.zclient.DebugObject;

public class OffloadedPubSubQueue
extends DebugObject {
    private MsgSaver m_saver = null;
    private IClientContext m_cc = null;
    private PriorityQueue m_queue = null;
    private LongHashTable m_publisherCounts = null;
    private Vector m_recycledQElements = null;
    private long m_maxRecycledQElementCount = 100L;
    private long m_memoryLength = 0L;

    synchronized long getMemoryLength() {
        return this.m_memoryLength;
    }

    OffloadedPubSubQueue(IClientContext cc, MsgSaver saver) {
        this.m_cc = cc;
        this.m_saver = saver;
        this.m_queue = new PriorityQueue(13);
        this.m_publisherCounts = new LongHashTable();
        this.m_recycledQElements = new Vector();
    }

    void setCC(IClientContext cc) {
        this.m_cc = cc;
    }

    synchronized boolean isEmpty() {
        return this.m_queue.isEmpty() && this.m_publisherCounts.isEmpty();
    }

    synchronized boolean isEmpty(long publisher) {
        return this.m_publisherCounts.get(publisher) == null;
    }

    synchronized boolean isEmpty(byte priority, long publisher) {
        int[] priorityCounts = (int[])this.m_publisherCounts.get(publisher);
        if (priorityCounts != null) {
            return priorityCounts[priority] == 0;
        }
        return true;
    }

    synchronized int enqueue(IMgram message, long msgSaverOpIndx) {
        OffloadedPubSubMessage offloadedMsg = (OffloadedPubSubMessage)this.reuse();
        if (offloadedMsg != null) {
            offloadedMsg.repopulate(message, msgSaverOpIndx);
        } else {
            offloadedMsg = new OffloadedPubSubMessage(message, msgSaverOpIndx);
        }
        this.m_queue.enqueue(offloadedMsg, message.getPriority());
        int[] priorityCounts = (int[])this.m_publisherCounts.get(message.getBrokerHandle().getSenderID());
        if (priorityCounts == null) {
            priorityCounts = new int[14];
            this.m_publisherCounts.put(message.getBrokerHandle().getSenderID(), priorityCounts);
        }
        byte by = message.getPriority();
        priorityCounts[by] = priorityCounts[by] + 1;
        priorityCounts[13] = priorityCounts[13] + 1;
        int size = offloadedMsg.memoryLength() + PriorityQueue.getPriorityQueueElementSize();
        this.m_memoryLength += (long)size;
        return size;
    }

    synchronized OffloadedPubSubMessage dequeue() {
        OffloadedPubSubMessage offloadedMsg = (OffloadedPubSubMessage)this.m_queue.dequeue();
        if (offloadedMsg == null) {
            return null;
        }
        return offloadedMsg;
    }

    synchronized int completeMessageRestore(OffloadedPubSubMessage offloadedMsg) {
        int[] priorityCounts = (int[])this.m_publisherCounts.get(offloadedMsg.getSenderID());
        if (priorityCounts != null) {
            byte by = offloadedMsg.getPriority();
            priorityCounts[by] = priorityCounts[by] - 1;
            priorityCounts[13] = priorityCounts[13] - 1;
            if (priorityCounts[13] == 0) {
                this.m_publisherCounts.remove(offloadedMsg.getSenderID());
                IClientContext publisher = null;
                try {
                    publisher = AgentRegistrar.getAgentRegistrar().getClient(offloadedMsg.getSenderID());
                }
                catch (EClientNotRegistered e) {
                    // empty catch block
                }
                if (publisher != null) {
                    int state = this.m_cc.getState();
                    if (state == 8 || state == 5) {
                        this.m_cc.getOutQueue().dbSpaceReleaseBlockedPublisher(publisher.getPublishLimiter(), true);
                    }
                    this.m_cc.getOutQueue().flowToDiskReleaseBlockedPublisher(publisher.getPublishLimiter(), true);
                }
            }
        }
        int size = offloadedMsg.memoryLength() + PriorityQueue.getPriorityQueueElementSize();
        this.m_memoryLength -= (long)size;
        offloadedMsg.cleanup();
        this.recycle(offloadedMsg);
        return size;
    }

    synchronized void reset() {
        this.m_queue = new PriorityQueue(13);
        this.m_publisherCounts.clear();
        this.m_memoryLength = 0L;
    }

    private synchronized Object reuse() {
        Object obj = null;
        if (!this.m_recycledQElements.isEmpty()) {
            obj = this.m_recycledQElements.firstElement();
            this.m_recycledQElements.removeElement(obj);
        }
        return obj;
    }

    private synchronized void recycle(Object obj) {
        if ((long)this.m_recycledQElements.size() < this.m_maxRecycledQElementCount) {
            this.m_recycledQElements.add(obj);
        }
    }
}

