/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EAsyncOpNotSupported;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IQMsgStateListener;
import progress.message.broker.IReenqueuer;
import progress.message.broker.InDoubtQMsgReenqueueEvt;
import progress.message.broker.LogEvent;
import progress.message.broker.LogManager;
import progress.message.broker.QueueMsgMoveEvt;
import progress.message.broker.QueueMsgMoveToTopicEvt;
import progress.message.broker.QueueMsgSaver;
import progress.message.broker.SyncQueueMsgMoveEvt;
import progress.message.broker.SyncQueueMsgMoveToTopicEvt;
import progress.message.broker.prAccessor;
import progress.message.gr.RemoteBrokerHelper;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.util.EDuplicateKey;
import progress.message.util.IndexedList;
import progress.message.util.LinkedList;
import progress.message.util.LongHashTable;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;

public class QMsgStateMgr
extends DebugObject {
    private LogManager m_logmgr;
    private AgentRegistrar m_reg;
    private QueueMsgSaver m_qMsgSaver;
    IndexedList m_activeList;
    private LongHashTable m_inDoubtList;
    private long m_estimatedSyncSize;
    private long m_saveThreshold;
    private QSyncSizeThread m_saveThread;
    private Object m_syncObj = new Object();
    private Map m_movesInProgess = null;
    private Map m_pendingAckList = null;

    QMsgStateMgr(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "QMsgStateMgr" : null);
        this.m_reg = reg;
        this.m_logmgr = reg.getLogManager();
        this.m_qMsgSaver = reg.getQueueMsgSaver();
        this.m_activeList = new IndexedList();
        this.m_inDoubtList = new LongHashTable();
        this.m_movesInProgess = Collections.synchronizedMap(new HashMap());
        this.m_pendingAckList = Collections.synchronizedMap(new HashMap());
    }

    void initQSyncSizeThread() {
        this.m_saveThreshold = Config.MAX_LOG_FILE_SIZE / 4L;
        this.m_saveThread = new QSyncSizeThread();
        this.m_saveThread.setDaemon(true);
        if (Config.PTP_ENABLE_SYNCSIZE_MONITOR) {
            this.m_saveThread.start();
        }
    }

    void stopQSyncSizeThread() {
        if (this.m_saveThread != null && this.m_saveThread.isAlive() && !this.m_saveThread.isInterrupted()) {
            this.m_saveThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEstimatedSyncSize() {
        Object object = this.m_syncObj;
        synchronized (object) {
            return this.m_estimatedSyncSize;
        }
    }

    public AgentQueueMsgTracker getTracker(long tracking) throws ETrackingNumNotFound {
        Object tracker = this.m_activeList.get(tracking);
        if (tracker == null) {
            throw new ETrackingNumNotFound("" + tracking);
        }
        return (AgentQueueMsgTracker)tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeSyncEvents() throws ECannotFlushEvents {
        LinkedList enumList = new LinkedList();
        IndexedList indexedList = this.m_activeList;
        synchronized (indexedList) {
            Enumeration enu = this.m_activeList.elements();
            while (enu.hasMoreElements()) {
                enumList.append(enu.nextElement());
            }
        }
        if (this.CALLBACK) {
            this.callback("Writing Sync Events", 0, null);
        }
        Enumeration qmsgs = enumList.elements();
        int totcount = 0;
        long totsize = 0L;
        int txcount = 0;
        long txsize = 0L;
        while (qmsgs.hasMoreElements()) {
            AgentQueueMsgTracker trk = (AgentQueueMsgTracker)qmsgs.nextElement();
            long size = trk.writeSyncRecord();
            totsize += size;
            if ((this.debugFlags & 0x40) <= 0) continue;
            if (trk.isTransacted()) {
                txsize += size;
                ++txcount;
            }
            ++totcount;
        }
        if ((this.debugFlags & 0x40) > 0) {
            this.debug("Wrote queue sync Events, num= " + totcount + ", bytesize= " + totsize + ", txCount= " + txcount + ", txsize= " + txsize + " " + new Date());
        }
        Map map = this.m_movesInProgess;
        synchronized (map) {
            if (!this.m_movesInProgess.isEmpty()) {
                if ((this.debugFlags & 0x40) > 0) {
                    this.debug("QMsgStateMgr.writeSyncEvents: m_movesInProgess.size()= " + this.m_movesInProgess.size());
                }
                for (LogEvent evt : this.m_movesInProgess.values()) {
                    LogEvent newEvt;
                    LogEvent moveEvt;
                    if (evt instanceof QueueMsgMoveEvt) {
                        moveEvt = (QueueMsgMoveEvt)evt;
                        newEvt = new SyncQueueMsgMoveEvt(((QueueMsgMoveEvt)moveEvt).getNewQueueName(), ((QueueMsgMoveEvt)moveEvt).getMessage(), ((QueueMsgMoveEvt)moveEvt).getOldTracking(), ((QueueMsgMoveEvt)moveEvt).isNewTempQueue());
                    } else {
                        moveEvt = (QueueMsgMoveToTopicEvt)evt;
                        newEvt = new SyncQueueMsgMoveToTopicEvt(((QueueMsgMoveToTopicEvt)moveEvt).getNewGuarEvt(), ((QueueMsgMoveToTopicEvt)moveEvt).getOldTracking());
                    }
                    if ((this.debugFlags & 0x40) > 0) {
                        this.debug("QMsgStateMgr.writeSyncEvents: writing: " + newEvt);
                    }
                    this.m_reg.getLogManager().tryAddEvent(newEvt, false);
                    totsize += (long)newEvt.memsize();
                }
                this.m_movesInProgess.clear();
            }
        }
        return totsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInDoubtMsg(long tracking) {
        LongHashTable longHashTable = this.m_inDoubtList;
        synchronized (longHashTable) {
            this.m_inDoubtList.remove(tracking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInDoubtMsg(long tracking) {
        LongHashTable longHashTable = this.m_inDoubtList;
        synchronized (longHashTable) {
            this.m_inDoubtList.put(tracking, new Long(tracking));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMsgInDoubt(long tracking) {
        LongHashTable longHashTable = this.m_inDoubtList;
        synchronized (longHashTable) {
            return this.m_inDoubtList.containsKey(tracking);
        }
    }

    public void restoreXOnceMsgsToQueues(List toRestore, boolean sync, IReenqueuer reenqueuer) throws EAsyncOpNotSupported {
        HashMap<String, Vector<IMgram>> reenqueueTable = new HashMap<String, Vector<IMgram>>();
        InDoubtQMsgReenqueueEvt idmrEvt = null;
        for (int i = 0; i < toRestore.size(); ++i) {
            Vector<IMgram> msgs;
            IMgram qMsg = (IMgram)toRestore.get(i);
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(qMsg.getGuarenteedTrackingNum());
            if (tracker != null) {
                tracker.setReceiverId(0L);
            }
            if (qMsg.isJMSPersistent()) {
                if (idmrEvt == null) {
                    idmrEvt = new InDoubtQMsgReenqueueEvt();
                    idmrEvt.setReplOnlyEvt(new InDoubtQMsgReenqueueEvt());
                    ((LogEvent)idmrEvt.getReplOnlyEvt()).setReplicateOnly(true);
                }
                if (qMsg.isNonPersistentReplicated()) {
                    ((InDoubtQMsgReenqueueEvt)idmrEvt.getReplOnlyEvt()).addTracking(qMsg.getGuarenteedTrackingNum());
                } else {
                    idmrEvt.addTracking(qMsg.getGuarenteedTrackingNum());
                }
            }
            if ((msgs = (Vector<IMgram>)reenqueueTable.get(qMsg.getBrokerHandle().getLocalQueueName())) == null) {
                msgs = new Vector<IMgram>();
                reenqueueTable.put(qMsg.getBrokerHandle().getLocalQueueName(), msgs);
            }
            msgs.add(qMsg);
        }
        for (String qName : reenqueueTable.keySet()) {
            Vector qMsgs = (Vector)reenqueueTable.get(qName);
            IAgentQueue q = this.m_reg.getQueueProc().getAgentQueue(qName);
            if (q != null) {
                if (this.DEBUG) {
                    this.debug(this + " Restoring " + qMsgs.size() + " Queue Msgs to " + q.getQueueName() + " sync=" + sync);
                }
                if (reenqueuer != null) {
                    reenqueuer.notifyReenqueue(q, qMsgs, sync, idmrEvt);
                } else {
                    if (!sync) {
                        throw new EAsyncOpNotSupported("Async reenqueue to " + qName + " not supported with out reenqueuer thread.");
                    }
                    this.restoreXOnceMsgsToQueue(q, qMsgs, idmrEvt);
                }
            }
            idmrEvt = null;
        }
    }

    public void restoreXOnceMsgsToQueue(IAgentQueue q, Vector msgs, LogEvent idmrEvt) {
        if (idmrEvt != null) {
            AgentRegistrar.getAgentRegistrar().getLogManager().addEvent(idmrEvt, false);
        }
        if (q.getQueueName().equals("SonicMQ.routingQueue")) {
            RemoteBrokerHelper rbh = AgentRegistrar.getAgentRegistrar().getQueueProc().getRemoteBrokerHelper();
            rbh.rerouteUnacknowledged(msgs.elements());
        } else {
            q.restore(msgs.elements(), true, true);
        }
        msgs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveMsg(IMgram msg, boolean flush, String newQueueName, boolean delete, boolean isTempQueue) throws InterruptedException {
        if (msg.isJMSPersistent()) {
            long oldTracking = !delete ? 0L : msg.getGuarenteedTrackingNum();
            QueueMsgMoveEvt evt = new QueueMsgMoveEvt(newQueueName, msg, oldTracking, isTempQueue);
            this.m_movesInProgess.put(evt, evt);
            try {
                this.m_reg.getLogManager().addEvent(evt, true);
                long tracking = evt.getSeqNo() & 0xFFFFFFFFFFFFL;
                if (this.DEBUG) {
                    this.debug("In moveMsg for persistent msg oldTracking= " + oldTracking + " newTracking= " + tracking);
                }
                AgentQueueMsgTracker tracker = null;
                try {
                    tracker = new AgentQueueMsgTracker(tracking, msg, newQueueName, oldTracking);
                    tracker.setTemporary(isTempQueue);
                }
                catch (EDuplicateKey e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR010") + tracking, (Throwable)e, 2);
                }
                this.m_reg.getLogManager().waitForFlush(evt);
                if (!delete) return;
                AgentQueueMsgTracker oldTracker = null;
                try {
                    oldTracker = this.getTracker(oldTracking);
                    oldTracker.acknowledged(null, flush);
                    return;
                }
                catch (ETrackingNumNotFound ex) {
                    this.m_qMsgSaver.deleteMsg(oldTracking, true);
                }
                return;
            }
            finally {
                this.m_movesInProgess.remove(evt);
            }
        }
        if (!delete) return;
        long oldTracking = msg.getGuarenteedTrackingNum();
        if (this.DEBUG) {
            this.debug("In moveMsg for nonpersistent msg oldTracking= " + oldTracking);
        }
        this.m_qMsgSaver.deleteMsg(oldTracking, false);
        try {
            this.m_qMsgSaver.flush();
            return;
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveMsgToTopic(IMgram msg, GuarMsgEvt newGuarEvt, boolean flush, boolean delete) throws InterruptedException {
        QueueMsgMoveToTopicEvt evt = null;
        if (msg.isJMSPersistent()) {
            long oldTracking;
            long l = oldTracking = !delete ? 0L : msg.getGuarenteedTrackingNum();
            if (newGuarEvt != null) {
                evt = new QueueMsgMoveToTopicEvt(newGuarEvt, oldTracking);
                this.m_movesInProgess.put(evt, evt);
            }
            try {
                if (newGuarEvt != null) {
                    this.m_reg.getLogManager().addEvent(evt, true);
                    long tracking = evt.getSeqNo() & 0xFFFFFFFFFFFFL;
                    if (this.DEBUG) {
                        this.debug("In moveMsgToTopic for persistent msg oldTracking= " + oldTracking + " newTracking= " + tracking);
                    }
                    newGuarEvt.createTracker();
                    this.m_reg.getLogManager().waitForFlush(evt);
                }
                if (!delete) return;
                AgentQueueMsgTracker oldTracker = null;
                try {
                    oldTracker = this.getTracker(oldTracking);
                    oldTracker.acknowledged(null, flush);
                    return;
                }
                catch (ETrackingNumNotFound ex) {
                    this.m_qMsgSaver.deleteMsg(oldTracking, true);
                }
                return;
            }
            finally {
                if (newGuarEvt != null) {
                    this.m_movesInProgess.remove(evt);
                }
            }
        }
        if (!delete) return;
        long oldTracking = msg.getGuarenteedTrackingNum();
        if (this.DEBUG) {
            this.debug("In moveMsgToTopic for nonpersistent msg oldTracking= " + oldTracking);
        }
        this.m_qMsgSaver.deleteMsg(oldTracking, false);
        try {
            this.m_qMsgSaver.flush();
            return;
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public void addPendingAckedMsg(long tracking, IQMsgStateListener listener) {
        this.m_pendingAckList.put(new Long(tracking), listener);
    }

    public void msgAcknowledged(long tracking) {
        IQMsgStateListener listener = (IQMsgStateListener)this.m_pendingAckList.remove(new Long(tracking));
        if (listener != null) {
            listener.onMsgAcknowledged(tracking);
        }
    }

    class QSyncSizeThread
    extends DebugThread {
        private boolean m_startSave;
        private boolean m_saving;

        QSyncSizeThread() {
            super("QSyncSizeThread");
            this.m_startSave = false;
            this.m_saving = false;
        }

        synchronized void startSave() {
            if (!this.m_saving) {
                this.m_startSave = true;
                this.notifyAll();
            }
        }

        synchronized void waitForStart() throws InterruptedException {
            this.m_saving = false;
            while (!this.m_startSave) {
                this.wait();
            }
            this.m_startSave = false;
            this.m_saving = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() throws InterruptedException {
            if (this.DEBUG) {
                this.debug("Starting");
            }
            try {
                while (!Broker.exiting && !this.isInterrupted()) {
                    this.waitForStart();
                    if (this.DEBUG) {
                        this.debug("Before save; Estimated SyncSize= " + QMsgStateMgr.this.getEstimatedSyncSize());
                    }
                    QMsgStateMgr.this.m_reg.getQueueProc().forcedSave();
                    QMsgStateMgr.this.m_reg.getQueueMsgSaver().flush();
                    if (!this.DEBUG) continue;
                    this.debug("After save; Estimated SyncSize= " + QMsgStateMgr.this.getEstimatedSyncSize());
                }
            }
            catch (InterruptedException ie) {
                if (!Broker.exiting) {
                    throw ie;
                }
            }
            finally {
                if (this.DEBUG) {
                    this.debug("threadMain: thread exiting, broker exiting = " + Broker.exiting);
                }
            }
        }
    }
}

