/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.LBSTrackingInfo;
import progress.message.zclient.Label;

final class RecipientWrap {
    private IClientContext m_client = null;
    private long m_clientId = -1L;
    private String m_localQueueName;
    private String m_targetedNodeName;
    private long m_groupccid = -1L;
    private long m_subjectFilterId = -1L;
    Label m_label;
    LBSTrackingInfo m_groupSubscriptionList = null;

    private RecipientWrap(RecipientWrap rw) {
        this.m_client = rw.m_client;
        this.m_clientId = rw.m_clientId;
        this.m_label = rw.m_label;
        this.m_groupSubscriptionList = rw.m_groupSubscriptionList;
        this.m_targetedNodeName = rw.m_targetedNodeName;
        this.m_localQueueName = rw.m_localQueueName;
        this.setGroupCCID(rw.m_client);
    }

    RecipientWrap(IClientContext client, Label label) {
        this.m_client = client;
        if (client != null) {
            this.m_clientId = client.getId();
            this.setGroupCCID(client);
        }
        this.m_label = label;
    }

    public Object clone() {
        return new RecipientWrap(this);
    }

    public IClientContext getClient() {
        if (this.m_client == null) {
            try {
                this.m_client = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
            }
            catch (EClientNotRegistered e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this.m_client;
    }

    public void setClientContext(long id) {
        this.m_clientId = id;
    }

    public void setClientContext(IClientContext cc) {
        this.m_client = cc;
        this.m_clientId = cc.getId();
        this.setGroupCCID(cc);
    }

    public void setTargetedNodeName(String targetedNodeName) {
        this.m_targetedNodeName = targetedNodeName == null ? null : targetedNodeName.intern();
    }

    public void setLocalQueueName(String localQueueName) {
        this.m_localQueueName = localQueueName == null ? null : localQueueName.intern();
    }

    public boolean hasClientContext() {
        return this.m_clientId != -1L;
    }

    public String getTargetedNodeName() {
        return this.m_targetedNodeName;
    }

    public String getLocalQueueName() {
        return this.m_localQueueName;
    }

    public long getId() {
        return this.m_clientId;
    }

    public long getGroupCCId() {
        if (this.m_groupccid == -1L) {
            this.setGroupCCID(this.getClient());
        }
        return this.m_groupccid;
    }

    private void setGroupCCID(IClientContext cc) {
        this.m_groupccid = cc != null && cc.isGroupSubscriptionMember() ? cc.getGroupSubscriptionCC().getId() : -1L;
    }

    public void setSubjectFilterId(long sfID) {
        this.m_subjectFilterId = sfID;
    }

    public long getSubjectFilterId() {
        if (this.m_subjectFilterId == -1L && this.getClient() != null) {
            this.m_subjectFilterId = this.m_client.getSubjectFilterId();
        }
        return this.m_subjectFilterId;
    }
}

