/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.HashSet;
import java.util.LinkedList;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.IClientContext;
import progress.message.zclient.DebugObject;

public class RemoteRestoreManager
extends DebugObject
implements Runnable {
    protected LinkedList s_remoteRestoreQueue = new LinkedList();
    protected HashSet s_activeRemoteRestoreThreads = new HashSet();
    private Thread m_restoreStarterThread = null;
    private boolean m_isShutdown = false;
    private boolean m_isRunning = false;
    private final long IDLE_TIMEOUT = 300000L;
    private Object m_runningSyncObject = new Object();
    private IClientContext m_startingCC = null;

    public RemoteRestoreManager() {
        super("RemoteRestoreManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (this.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("RemoteRestoreManager thread started.", 3);
        }
        try {
            while (!Broker.exiting) {
                if (Thread.currentThread().isInterrupted()) return;
                Object object = this.m_runningSyncObject;
                // MONITORENTER : object
                if (this.m_isShutdown) {
                    // MONITOREXIT : object
                    return;
                }
                // MONITOREXIT : object
                object = this;
                // MONITORENTER : object
                Object cc = null;
                if (this.s_remoteRestoreQueue.size() == 0 || this.s_activeRemoteRestoreThreads.size() > Config.REMOTE_RESTORE_THREAD_CAP) {
                    int activeCount = this.s_activeRemoteRestoreThreads.size();
                    this.wait(300000L);
                    if (this.s_remoteRestoreQueue.isEmpty()) {
                        if (this.s_activeRemoteRestoreThreads.size() == 0 && activeCount == 0) {
                            // MONITOREXIT : object
                            return;
                        }
                        // MONITOREXIT : object
                        continue;
                    }
                }
                if (this.s_activeRemoteRestoreThreads.size() > Config.REMOTE_RESTORE_THREAD_CAP) {
                    // MONITOREXIT : object
                    continue;
                }
                cc = (IClientContext)this.s_remoteRestoreQueue.removeFirst();
                this.s_activeRemoteRestoreThreads.add(cc);
                this.m_startingCC = cc;
                // MONITOREXIT : object
                if (this.m_startingCC == null) continue;
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage(this + ": Starting delivery for: " + this.m_startingCC, 3);
                }
                this.m_startingCC.startDelivery(null);
                object = this;
                this.m_startingCC = null;
                this.notifyAll();
                // MONITOREXIT : object
            }
            return;
            catch (Throwable throwable) {
                RemoteRestoreManager remoteRestoreManager = this;
                // MONITORENTER : remoteRestoreManager
                this.m_startingCC = null;
                this.notifyAll();
                // MONITOREXIT : remoteRestoreManager
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            return;
        }
        finally {
            boolean doRestart = false;
            Object object = this.m_runningSyncObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.m_runningSyncObject;
        synchronized (object) {
            this.m_isShutdown = true;
            if (this.m_restoreStarterThread != null && this.m_isRunning && this.m_restoreStarterThread.isAlive()) {
                try {
                    this.m_restoreStarterThread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueRemoteRestore(IClientContext cc) {
        Object object = this.m_runningSyncObject;
        synchronized (object) {
            if (this.m_isShutdown || Broker.exiting) {
                return;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.s_activeRemoteRestoreThreads.contains(cc) && !this.s_remoteRestoreQueue.contains(cc)) {
                this.s_remoteRestoreQueue.addLast(cc);
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage(this + ": Enqueued remote restore for: " + cc, 3);
                }
            } else {
                return;
            }
            this.notifyAll();
        }
        this.checkStartRestoreStarterThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStartRestoreStarterThread() {
        boolean needStart = false;
        Object object = this;
        synchronized (object) {
            if (!this.s_remoteRestoreQueue.isEmpty()) {
                needStart = true;
            }
        }
        if (!needStart) {
            return;
        }
        object = this.m_runningSyncObject;
        synchronized (object) {
            if (!(this.m_isRunning || Broker.exiting || this.m_isShutdown)) {
                this.m_isRunning = true;
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage(this + ": Starting RemoteRestoreStarter", 3);
                }
                try {
                    this.m_restoreStarterThread = new Thread((Runnable)this, this.toString());
                    this.m_restoreStarterThread.start();
                }
                catch (Throwable thrown) {
                    BrokerComponent.getComponentContext().logMessage(thrown, 2);
                }
            }
        }
    }

    synchronized void cancelRemoteRestore(IClientContext cc) {
        if (this.s_remoteRestoreQueue.remove(cc)) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage(this + ": Cancelled remote restore for: " + cc, 3);
            }
        } else {
            this.remoteRestoreDone(cc);
            if (Thread.currentThread() != this.m_restoreStarterThread) {
                while (this.m_startingCC == cc) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    synchronized void remoteRestoreDone(IClientContext cc) {
        if (this.s_activeRemoteRestoreThreads.remove(cc)) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage(this + ": Remote restore finished for: " + cc, 3);
            }
            this.notifyAll();
        }
    }

    @Override
    public String toString() {
        return "RemoteRestoreManager";
    }
}

