/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Hashtable;
import progress.message.zclient.DebugObject;

public class RequestContext
extends DebugObject {
    private static Hashtable m_contexts = new Hashtable();
    private int m_requestId;
    private boolean m_xonce = false;
    private boolean m_chained = false;
    private short m_replyStatus = 0;

    public RequestContext(boolean xonce, int requestId, boolean chained) {
        this.m_xonce = xonce;
        this.m_requestId = requestId;
        this.m_chained = chained;
    }

    public static void push(boolean xonce, int requestId, boolean chained) {
        m_contexts.put(Thread.currentThread(), new RequestContext(xonce, requestId, chained));
    }

    private static RequestContext get() {
        return (RequestContext)m_contexts.get(Thread.currentThread());
    }

    public static RequestContext pop() {
        return (RequestContext)m_contexts.remove(Thread.currentThread());
    }

    public static void setReplyStatus(short replyStatus) {
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            rc.m_replyStatus = replyStatus;
        }
    }

    public static int getRequestId() {
        RequestContext rc = RequestContext.get();
        if (rc == null) {
            return 0;
        }
        return rc.m_requestId;
    }

    public static long getRequestIdAsLong() {
        int req = 0;
        RequestContext rc = RequestContext.get();
        if (rc != null) {
            req = rc.m_requestId;
        }
        return (long)req & 0xFFFFFFFFL;
    }

    public static boolean getXonce() {
        RequestContext rc = RequestContext.get();
        if (rc == null) {
            return false;
        }
        return rc.m_xonce;
    }

    public static boolean getChained() {
        RequestContext rc = RequestContext.get();
        if (rc == null) {
            return false;
        }
        return rc.m_chained;
    }

    public static short getReplyStatus() {
        RequestContext rc = RequestContext.get();
        if (rc == null) {
            return 0;
        }
        return rc.m_replyStatus;
    }
}

