/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseQueue;
import progress.message.broker.IExpirable;
import progress.message.broker.IRecycler;
import progress.message.broker.ISavable;
import progress.message.broker.ISavableQueueContext;
import progress.message.broker.LogManager;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.QueueMsgAckedEvt;
import progress.message.broker.SavableQElement;
import progress.message.broker.gs.GSOrphanedMessageChecker;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;

public final class RoutingQueue
extends BaseQueue
implements IExpirable,
IRecycler,
ISavable {
    long m_saveThreshold = 0x180000L;
    long m_currentInMemorySize = 0L;
    QToken[] m_inMemoryListTokens;
    Vector m_recycledQElements;
    long m_maxRecycledQElementCount;
    LogManager m_logMgr = AgentRegistrar.getAgentRegistrar().getLogManager();
    GSOrphanedMessageChecker m_gsChecker = AgentRegistrar.getAgentRegistrar().getGSManager().getGSOrphanedMessageChecker();
    static final long s_DFLT_SAVE_THRESHOLD = 0x180000L;
    static final long s_DFLT_MAX_QUEUE_SIZE = 0x100000L;
    static final int s_SAVABLE_QUEUE_ELEMENT_TYPE_CODE = 1;

    public RoutingQueue(String qName, int numPriorities, int maxQueueSize, ISavableQueueContext sqc, Hashtable env) {
        super(qName, numPriorities, maxQueueSize, sqc);
        this.m_inMemoryListTokens = new QToken[this.m_numPriorities + 1];
        for (int i = 0; i <= this.m_numPriorities; ++i) {
            this.m_inMemoryListTokens[i] = new QToken();
            if (i <= 0) continue;
            this.m_inMemoryListTokens[i - 1].m_prev = this.m_inMemoryListTokens[i];
            this.m_inMemoryListTokens[i].m_next = this.m_inMemoryListTokens[i - 1];
        }
        this.m_maxRecycledQElementCount = 50L;
        this.m_recycledQElements = new Vector();
    }

    public synchronized void enqueue(IMgram m) {
        if (m == null) {
            return;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        SavableQElement elem = (SavableQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte);
        } else {
            elem = new SavableQElement(m, tracking, prio, len, tte);
        }
        m.getBrokerHandle().setLocalQueueName(this.m_qName);
        if (m.getBrokerHandle().isFromDB()) {
            elem.setSaved();
            elem.setInDB();
        }
        m.getBrokerHandle().setPtpEnqueueTime(0L);
        elem.setEnqueueTime(System.currentTimeMillis());
        super.enqueue(elem, prio, len);
        this.linkInMemory(elem, prio);
        this.notifyEnqueue(m);
        if (this.m_currentInMemorySize > this.m_saveThreshold) {
            this.enforceSaveThreshold();
        }
        this.notifyAll();
    }

    public synchronized void reenqueue(IMgram m, boolean preserveRedelivery) {
        if (m == null) {
            return;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        SavableQElement elem = (SavableQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte);
        } else {
            elem = new SavableQElement(m, tracking, prio, len, tte);
        }
        if (m.getBrokerHandle().isFromDB()) {
            elem.setSaved();
            elem.setInDB();
        } else if (m.getBrokerHandle().isDBSaveRequested()) {
            elem.setSaved();
        }
        long tm = m.getBrokerHandle().getPtpEnqueueTime();
        if (tm > 0L) {
            elem.setEnqueueTime(tm);
            m.getBrokerHandle().setPtpEnqueueTime(0L);
        } else {
            elem.setEnqueueTime(System.currentTimeMillis());
        }
        super.reenqueue(elem, prio, len, preserveRedelivery);
        this.relinkInMemory(elem, prio);
        this.notifyReenqueue(m);
        this.notifyAll();
    }

    @Override
    public synchronized Object dequeue(int prio) {
        IMgram payload;
        SavableQElement elem;
        boolean dequeuedOneOrMore = false;
        while ((elem = (SavableQElement)super.dequeue(prio)) != null) {
            this.cancelPendingSave(elem);
            payload = (IMgram)elem.getPayload();
            if (payload != null) {
                this.delinkInMemory(elem);
            } else {
                payload = this.retrieve(elem);
                elem.setPayload(payload);
            }
            dequeuedOneOrMore = true;
            this.notifyDequeue(payload);
            int reason = 0;
            if (this.hasMsgExpired(elem)) {
                reason = 1;
            } else if (this.isMsgRemoteSubscriptionOrphan(payload)) {
                reason = -1;
            }
            if (reason == 0) break;
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addMsgForCleanup(payload, reason);
            this.recycle(elem, 1);
        }
        payload = null;
        if (elem != null) {
            byte reenqueues = elem.getReenqueueCount();
            payload = (IMgram)elem.getPayload();
            if (reenqueues > 0) {
                payload.setSuccessor(true);
                payload.setReenqueueCount(reenqueues);
            }
            payload.getBrokerHandle().setPtpEnqueueTime(elem.getEnqueueTime());
            this.recycle(elem, 1);
        }
        if (dequeuedOneOrMore) {
            this.notifySpaceAvailable();
        }
        this.notifyAll();
        return payload;
    }

    @Override
    public synchronized Object dequeue() {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        return this.dequeue(this.m_highestNonEmptyPriority);
    }

    public synchronized Object dequeueByTrackingNum(long tracking) {
        SavableQElement elem = (SavableQElement)super.dequeue(tracking);
        if (elem == null) {
            this.notifyAll();
            return null;
        }
        this.cancelPendingSave(elem);
        IMgram payload = (IMgram)elem.getPayload();
        if (payload != null) {
            this.delinkInMemory(elem);
        } else {
            payload = this.retrieve(elem);
            elem.setPayload(payload);
        }
        this.notifyDequeue(payload);
        byte reenqueues = elem.getReenqueueCount();
        if (reenqueues > 0) {
            payload.setSuccessor(true);
            payload.setReenqueueCount(reenqueues);
        }
        payload.getBrokerHandle().setPtpEnqueueTime(elem.getEnqueueTime());
        this.recycle(elem, 1);
        this.notifySpaceAvailable();
        this.notifyAll();
        return payload;
    }

    @Override
    public synchronized Object dequeue(long receiverID) {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        return this.dequeue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws InterruptedException {
        QueueMsgAckedEvt lastAckEvt = null;
        RoutingQueue routingQueue = this;
        synchronized (routingQueue) {
            if (this.m_totalEnqueuedCount == 0) {
                return;
            }
            QElement next = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
            while (next != null) {
                if (next instanceof QToken) {
                    next = next.getNext();
                    continue;
                }
                SavableQElement sqe = (SavableQElement)next;
                boolean lastOne = this.m_totalEnqueuedCount == 1;
                this.cancelPendingSave(sqe);
                AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(sqe.getTracking());
                if (tracker != null) {
                    QueueMsgAckedEvt evt = tracker.canceled(lastOne, false);
                    if (lastOne && evt != null) {
                        lastAckEvt = evt;
                    }
                } else if (sqe.isSaved()) {
                    boolean deleted = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().deleteMsg("SonicMQ.routingQueue", sqe.getTracking(), true);
                    QueueMsgAckedEvt evt = new QueueMsgAckedEvt(sqe.getTracking(), null, deleted);
                    this.m_logMgr.addEvent(evt, lastOne);
                    if (lastOne) {
                        lastAckEvt = evt;
                    }
                }
                next = sqe.getNext();
                super.dequeue(sqe);
                if (sqe.getPayload() != null) {
                    this.delinkInMemory(sqe);
                }
                this.recycle(sqe, 1);
            }
            this.m_totalEnqueuedCount = 0;
            this.setCurrentEnqueuedSize(0L);
            this.m_currentInMemorySize = 0L;
            for (int i = 0; i < this.m_numPriorities; ++i) {
                this.m_elementsEnqueuedCount[i] = 0;
            }
            this.m_highestNonEmptyPriority = -1;
            this.notifySpaceAvailable();
            this.notifyClear();
            this.notifyAll();
        }
        if (lastAckEvt != null) {
            this.m_logMgr.waitForFlush(lastAckEvt);
        }
        ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().flush();
    }

    @Override
    public synchronized void unreserve(int size) {
        super.unreserve(size);
        this.notifySpaceAvailable();
    }

    @Override
    synchronized void notifySpaceAvailable() {
        AgentRegistrar.getAgentRegistrar().getQueueProc().getRoutingQueue().notifySpaceAvailable();
    }

    @Override
    public boolean hasMsgExpired(QElement elem) {
        SavableQElement selem = (SavableQElement)elem;
        long tte = selem.getTTE();
        if (tte == 0L) {
            return false;
        }
        return System.currentTimeMillis() >= tte;
    }

    boolean isMsgRemoteSubscriptionOrphan(IMgram m) {
        return this.m_gsChecker.isGSAOrphan(m);
    }

    @Override
    public synchronized void checkForExpiredMsgs() {
        this.checkForExpiredMsgs(false);
    }

    public synchronized void checkForExpiredMsgs(boolean checkRemoteSubscriptionDeletion) {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return;
        }
        QElement next = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        while (next != null) {
            if (next instanceof QToken) {
                next = next.getNext();
                continue;
            }
            SavableQElement elem = (SavableQElement)next;
            next = elem.getNext();
            int reason = 0;
            IMgram m = null;
            if (this.hasMsgExpired(elem)) {
                reason = 1;
            } else if (checkRemoteSubscriptionDeletion) {
                m = (IMgram)elem.getPayload();
                if (m == null) {
                    if (this.checkDebugFlags(64)) {
                        this.debug("About to test for GSA. Will incur message retrieval.");
                    }
                    m = this.retrieve(elem);
                }
                if (this.isMsgRemoteSubscriptionOrphan(m)) {
                    reason = -1;
                }
            }
            if (reason == 0) continue;
            this.dequeueMsgForCleanup(elem, reason);
            this.notifyDequeue(elem.getTracking());
        }
        this.notifySpaceAvailable();
        this.notifyAll();
    }

    @Override
    public synchronized void recycle(Object obj, int typeCode) {
        SavableQElement elt;
        if (typeCode == 1 && !(elt = (SavableQElement)obj).isSaved()) {
            elt.recycle();
            if ((long)this.m_recycledQElements.size() < this.m_maxRecycledQElementCount) {
                this.m_recycledQElements.add(elt);
            }
        }
    }

    @Override
    public synchronized Object reuse(int typeCode) {
        Object obj = null;
        if (typeCode == 1 && !this.m_recycledQElements.isEmpty()) {
            obj = this.m_recycledQElements.firstElement();
            this.m_recycledQElements.removeElement(obj);
        }
        return obj;
    }

    @Override
    public synchronized void setSaveThresholdInBytes(int saveThreshold) {
        this.m_saveThreshold = Math.abs((long)saveThreshold);
    }

    @Override
    public synchronized void setSaveThresholdInKiloBytes(int svThreshold) {
        long saveThreshold = Math.abs((long)svThreshold);
        this.m_saveThreshold = saveThreshold > 0x1FFFFFFFFFFFFFL ? Long.MAX_VALUE : saveThreshold * 1024L;
    }

    @Override
    public synchronized long getSaveThresholdInBytes() {
        return this.m_saveThreshold;
    }

    @Override
    public synchronized int getSaveThresholdInKiloBytes() {
        int saveThreshold = (int)(this.m_saveThreshold / 1024L);
        return saveThreshold;
    }

    private IMgram retrieve(SavableQElement elem) {
        IMgram payload = (IMgram)elem.getPayload();
        if (payload == null && (payload = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgram(this.m_qName, elem.getTracking())) == null) {
            throw new EAssertFailure("Message to retrieve for queue " + this.m_qName + " was not found in db, " + "SavableQElement: " + elem.toString());
        }
        payload.getBrokerHandle().setLocalQueueName(this.m_qName);
        return payload;
    }

    @Override
    public synchronized int restore(List elements) {
        if (elements == null) {
            return 0;
        }
        Iterator it = elements.iterator();
        SavableQElement elem = null;
        int restoredCount = 0;
        long tracking = 0L;
        IMgram payload = null;
        while (it.hasNext()) {
            elem = (SavableQElement)it.next();
            payload = (IMgram)elem.getPayload();
            tracking = elem.getTracking();
            if (tracking <= 0L) {
                elem.recycle();
                continue;
            }
            if (this.hasMsgExpired(elem)) {
                this.m_bqc.getAgentQueueProcessor().getCleanupThread().addExpiredMsg(payload, this.m_qName, tracking);
                elem.recycle();
                continue;
            }
            IMgram m = payload;
            if (m == null && (m = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().retrieveMgram(this.m_qName, tracking)) == null) {
                elem.recycle();
                continue;
            }
            if (this.isMsgRemoteSubscriptionOrphan(m)) {
                int reason = -1;
                this.m_bqc.getAgentQueueProcessor().getCleanupThread().addMsgForCleanup(this.m_qName, tracking, reason);
                elem.recycle();
                continue;
            }
            if (this.getCurrentTotalSize() + elem.getPayloadSize() < this.getSaveThresholdInBytes()) {
                m.getBrokerHandle().setFromDB(true);
                elem.setPayload(m);
            } else {
                elem.setPayload(null);
            }
            this.updateTotalSize(elem.getPayloadSize());
            this.incrementEnqueuedCounts(elem.getPriority());
            this.notifyEnqueue(m);
            AgentQueueMsgTracker tracker = AgentQueueMsgTracker.getTracker(tracking);
            if (tracker == null) {
                try {
                    tracker = new AgentQueueMsgTracker(tracking, this.m_qName, (byte)elem.getPriority(), elem.getTTE(), elem.getPayloadSize());
                }
                catch (EDuplicateKey edk) {
                    tracker = AgentQueueMsgTracker.getTracker(elem.getTracking());
                }
            }
            tracker.setLocalQueueName(this.m_qName);
            tracker.saved();
            if (m != null) {
                tracker.setReplicateOnly(m.isNonPersistentReplicated());
            }
            elem.setInDB();
            elem.setSaved();
            elem.setEnqueueTime(System.currentTimeMillis());
            this.link(elem, elem.getPriority());
            if (elem.getPayload() != null) {
                this.linkInMemory(elem, elem.getPriority());
            }
            if (++restoredCount != 1) continue;
            this.updateMinEnqueueTime();
        }
        return restoredCount;
    }

    @Override
    public void forcedSave() {
        QElement elem = this.m_inMemoryListTokens[0].getPrevious();
        while (elem != null) {
            if (elem instanceof QToken) {
                elem = elem.getPrevious();
                continue;
            }
            SavableQElement sqe = (SavableQElement)elem;
            IMgram mg = (IMgram)sqe.getPayload();
            if (mg == null) {
                throw new EAssertFailure("InMemory SavableQElement does not have payload in memory: " + sqe.toString());
            }
            if (!mg.isJMSPersistent()) {
                elem = sqe.getPrevInMemory();
                continue;
            }
            if (sqe.isSaved() && !sqe.isInDB()) {
                sqe.unsetPostProcess();
            } else if (sqe.isInDB() || mg.getBrokerHandle().isFromDB()) {
                sqe.setSaved();
                sqe.setInDB();
                sqe.unsetPostProcess();
            } else {
                sqe.unsetPostProcess();
                ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg(this.m_qName, sqe);
                sqe.setSaved();
            }
            elem = sqe.getPrevInMemory();
        }
    }

    private void cancelPendingSave(SavableQElement elem) {
        elem.unsetPostProcess();
        if (elem.isSaved() && !elem.isInDB()) {
            boolean cancelled = ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().cancelSave(elem.getTracking());
            if (cancelled) {
                elem.unsetSaved();
            } else {
                IMgram payload = (IMgram)elem.getPayload();
                if (payload != null) {
                    payload.getBrokerHandle().setDBSaveRequested(true);
                }
            }
        }
    }

    void notifyClear() {
        if (this.checkDebugFlags(64)) {
            this.debug("RoutingQueue:notifyClear(" + this.m_totalEnqueuedCount + ")");
        }
    }

    void notifyEnqueue(IMgram m) {
        if (this.checkDebugFlags(64)) {
            this.debug("RoutingQueue:notifyEnqueue(" + this.m_totalEnqueuedCount + ")" + m);
        }
    }

    void notifyDequeue(IMgram m) {
        if (this.checkDebugFlags(64)) {
            this.debug("RoutingQueue:notifyDequeue(" + this.m_totalEnqueuedCount + ")" + m);
        }
    }

    void notifyDequeue(long tracking) {
        if (this.checkDebugFlags(64)) {
            this.debug("RoutingQueue:notifyDequeue(" + this.m_totalEnqueuedCount + "); tracking= " + tracking);
        }
    }

    void notifyReenqueue(IMgram m) {
        if (this.checkDebugFlags(64)) {
            this.debug("RoutingQueue:notifyReenqueue(" + this.m_totalEnqueuedCount + ")" + m);
        }
    }

    private void linkInMemory(SavableQElement newLast, int prio) {
        QToken token = this.m_inMemoryListTokens[prio];
        QElement oldLast = token.m_prev;
        if (oldLast instanceof QToken) {
            oldLast.m_next = newLast;
        } else {
            ((SavableQElement)oldLast).setNextInMemory(newLast);
        }
        newLast.setPrevInMemory(oldLast);
        newLast.setNextInMemory(token);
        token.m_prev = newLast;
        this.m_currentInMemorySize += newLast.getPayloadSize();
    }

    private void relinkInMemory(SavableQElement newFirst, int prio) {
        QToken token = this.m_inMemoryListTokens[prio + 1];
        QElement oldFirst = token.m_next;
        if (oldFirst instanceof QToken) {
            oldFirst.m_prev = newFirst;
        } else {
            ((SavableQElement)oldFirst).setPrevInMemory(newFirst);
        }
        newFirst.setNextInMemory(oldFirst);
        newFirst.setPrevInMemory(token);
        token.m_next = newFirst;
        this.m_currentInMemorySize += newFirst.getPayloadSize();
    }

    private void delinkInMemory(SavableQElement sqe) {
        QElement prev = sqe.getPrevInMemory();
        QElement next = sqe.getNextInMemory();
        if (prev == null || next == null) {
            return;
        }
        if (prev instanceof QToken) {
            prev.setNext(next);
        } else {
            ((SavableQElement)prev).setNextInMemory(next);
        }
        if (next instanceof QToken) {
            next.setPrevious(prev);
        } else {
            ((SavableQElement)next).setPrevInMemory(prev);
        }
        sqe.setPrevInMemory(null);
        sqe.setNextInMemory(null);
        this.m_currentInMemorySize -= sqe.getPayloadSize();
    }

    private void enforceSaveThreshold() {
        QElement elem = this.m_inMemoryListTokens[0].getPrevious();
        while (elem != null && this.m_currentInMemorySize > this.m_saveThreshold) {
            if (elem instanceof QToken) {
                elem = elem.getPrevious();
                continue;
            }
            SavableQElement sqe = (SavableQElement)elem;
            IMgram mg = (IMgram)sqe.getPayload();
            if (mg == null) {
                throw new EAssertFailure("InMemory SavableQElement does not have payload in memory: " + sqe.toString());
            }
            if (sqe.isSaved() && !sqe.isInDB()) {
                sqe.setPostProcess();
            } else if (sqe.isInDB() || mg.getBrokerHandle().isFromDB()) {
                sqe.setSaved();
                sqe.setInDB();
                sqe.setPostProcess();
                sqe.setPayload(null);
            } else {
                sqe.setPostProcess();
                ((ISavableQueueContext)this.m_bqc).getQueueMsgSaver().saveMsg("SonicMQ.routingQueue", sqe);
                sqe.setSaved();
            }
            elem = sqe.getPrevInMemory();
            this.delinkInMemory(sqe);
        }
    }

    private void dequeueMsgForCleanup(SavableQElement elem, int reason) {
        super.dequeue(elem);
        this.cancelPendingSave(elem);
        IMgram payload = (IMgram)elem.getPayload();
        if (payload != null) {
            this.delinkInMemory(elem);
        }
        if (payload != null) {
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addMsgForCleanup(payload, reason);
        } else {
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addMsgForCleanup("SonicMQ.routingQueue", elem.getTracking(), reason);
        }
        this.recycle(elem, 1);
    }
}

