/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.util.Enumeration;
import progress.message.broker.Config;
import progress.message.broker.Service;
import progress.message.broker.prAccessor;
import progress.message.util.LinkedList;
import progress.message.zclient.Connection;

class ServiceStartLocal {
    private static volatile LinkedList s_services = null;
    private static Object LOCK_OBJ = new Object();

    ServiceStartLocal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Connection connection) {
        if (s_services != null) {
            return;
        }
        Object object = LOCK_OBJ;
        synchronized (object) {
            if (s_services != null) {
                s_services = new LinkedList();
                for (int i = 0; i < Config.SERVICE_START_LOCAL_NUM; ++i) {
                    try {
                        Class<?> service_class = Class.forName(Config.SERVICE_START_LOCALS[i]);
                        Service service = (Service)service_class.newInstance();
                        service.setConfigPath(Config.SERVICE_CONFIG_PATH[i]);
                        service.register(connection);
                        s_services.append(service);
                        continue;
                    }
                    catch (Exception e) {
                        BrokerComponent.getComponentContext().logMessage(e.toString(), 2);
                        BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR257") + Config.SERVICE_START_LOCALS[i] + "'", 2);
                    }
                }
            }
        }
    }

    public static void shutdown() {
        if (s_services == null) {
            return;
        }
        Enumeration services = s_services.elements();
        while (services.hasMoreElements()) {
            Service service = (Service)services.nextElement();
            try {
                service.base_shutdown();
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage("Unable to shutdown service: '" + service.getClass() + "'", 2);
            }
        }
    }
}

