/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Session;

public class Subdispatcher
extends MessageHandler
implements IMessageHandler {
    private Hashtable m_table = new Hashtable();
    private IMessageHandler m_default_handler;
    private int m_nth;

    public Subdispatcher(int nth, IMessageHandler default_handler) throws EGeneralException {
        super(null);
        this.replaceHandler(this);
        this.m_default_handler = default_handler;
        this.m_nth = nth;
    }

    public void addDispatcher(String subcategory, IMessageHandler handler) {
        this.m_table.put(subcategory, handler);
    }

    public static String extractNthToken(String subj, int n) {
        int ndelimiters = 0;
        String delim = ".";
        StringTokenizer stz = new StringTokenizer(subj, delim, true);
        try {
            do {
                if (!stz.nextToken().equals(delim)) continue;
                ++ndelimiters;
            } while (ndelimiters < n);
            return stz.nextToken();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        Message msg = null;
        msg = env.getMessage();
        Object obj = null;
        String subcat = Subdispatcher.extractNthToken(msg.getSubject().getSubjectString(), this.m_nth);
        if (subcat != null) {
            obj = this.m_table.get(subcat);
        }
        if (obj != null) {
            ((IMessageHandler)obj).handleMessage(s, env);
        } else {
            this.m_default_handler.handleMessage(s, env);
        }
    }
}

