/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidTTLException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.Subject;

final class Subscribe
extends DebugObject
implements IMessageHandler {
    static int nextSubscriptionId = 1;
    private AgentRegistrar m_reg;

    Subscribe(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "Subscribe handler" : null);
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message req = env.getMessage();
            long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
            SubscribeEvt evt = null;
            try {
                Subject sub = new Subject(req.readUTF());
                Label lbl = Label.unserialize(req);
                byte clientVer = this.m_reg.getClient(requestor).getClientSessionVer();
                boolean isSelectorAtBroker = false;
                String selector = null;
                boolean enforceCWADSStrictMessageOrder = false;
                int flowToDisk = 0;
                if (clientVer >= 24) {
                    selector = req.readUTF();
                    isSelectorAtBroker = req.readBoolean();
                    evt = new SubscribeEvtForSelector(env, requestor, sub, lbl, new String[]{selector}, isSelectorAtBroker);
                } else {
                    evt = new SubscribeEvt(env, requestor, sub, lbl);
                }
                if (clientVer >= 25) {
                    enforceCWADSStrictMessageOrder = req.readBoolean();
                    if (this.DEBUG) {
                        System.out.println("sub: " + sub + " enforceCWADSStrictMessageOrder: " + enforceCWADSStrictMessageOrder);
                    }
                    evt.setDurableStrictMessageOrder(enforceCWADSStrictMessageOrder);
                }
                if (clientVer >= 27) {
                    try {
                        flowToDisk = req.readInt();
                    }
                    catch (IOException e) {
                        flowToDisk = 0;
                    }
                    evt.setFlowToDisk(flowToDisk);
                    if (this.DEBUG) {
                        System.out.println("sub: " + sub + " flowToDisk: " + flowToDisk);
                    }
                }
                if (this.DEBUG) {
                    System.out.println("SubP27: " + sub + " req: " + env.getSubject().getSubjectString());
                }
                this.m_reg.subscribe(evt, true);
            }
            catch (EInvalidSubjectSyntax e) {
                Subscribe.sendReply(env, -1);
            }
            catch (EClientNotRegistered e) {
                Subscribe.sendReply(env, -10);
            }
            catch (ESecurityPolicyViolation e) {
                Subscribe.sendReply(env, evt.getErrorCode());
            }
            catch (EInvalidTTLException ittle) {
                Subscribe.sendReply(env, -24);
            }
            catch (ParseException e) {
                Subscribe.sendReply(env, -22);
            }
            catch (TokenMgrError e) {
                Subscribe.sendReply(env, -22);
            }
        }
        catch (EInvalidAdminAddress e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    static void sendSuccessReply(SubscribeEvt evt) {
        Subscribe.sendReply(evt.getRequest(), Subscribe.getSubscriptionId());
    }

    static void sendReply(Envelope req, int retcode) {
        block2: {
            try {
                Message rep = new Message();
                rep.writeInt(retcode);
                AgentRegistrar.getAgentRegistrar().getAdminSession().reply(rep, req, false);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block2;
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR258") + e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    private static synchronized int getSubscriptionId() {
        return nextSubscriptionId++;
    }
}

