/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.client.EGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.util.StreamUtil;
import progress.message.zclient.Envelope;
import progress.message.zclient.Message;

public class TempQueueDeletionEvt
extends LogEvent {
    private long m_cid;
    private String m_queueName;
    private Envelope m_env;
    private boolean m_replyDone;

    public TempQueueDeletionEvt() {
    }

    public TempQueueDeletionEvt(long clientId, String queueName, Envelope env) {
        this.m_queueName = queueName;
        this.m_cid = clientId;
        this.m_env = env;
        this.m_replyDone = env == null;
    }

    @Override
    public short type() {
        return 80;
    }

    @Override
    protected int memSizeBody() {
        return (this.m_queueName != null ? this.m_queueName.length() : 0) + 4 + 8;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 1 + (this.m_queueName != null ? this.m_queueName.length() : 0) + 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeBoolean(this.m_queueName != null, os);
        if (this.m_queueName != null) {
            StreamUtil.writeUTF(this.m_queueName, os);
        }
        StreamUtil.writeLong(this.m_cid, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        boolean hasQueueName = StreamUtil.readBoolean(in);
        this.m_queueName = hasQueueName ? StreamUtil.readUTF(in) : null;
        this.m_cid = StreamUtil.readLong(in);
    }

    public String getQueueName() {
        return this.m_queueName;
    }

    @Override
    public long getClientID() {
        return this.m_cid;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTempQueueDeletionEvt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onFlush() {
        boolean reply = false;
        TempQueueDeletionEvt tempQueueDeletionEvt = this;
        synchronized (tempQueueDeletionEvt) {
            reply = !this.m_replyDone;
            this.m_replyDone = true;
        }
        if (reply) {
            try {
                Message rep = new Message();
                rep.writeBoolean(true);
                AgentRegistrar.getAgentRegistrar().getAdminSession().reply(rep, this.m_env, false);
            }
            catch (ESecurityPolicyViolation e) {
            }
            catch (EGeneralException eGeneralException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + "TempQueueDeletionEvt";
    }
}

