/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.BrowsableBaseQueue;
import progress.message.broker.BrowserElement;
import progress.message.broker.Config;
import progress.message.broker.IExpirable;
import progress.message.broker.IQueueContext;
import progress.message.broker.IReceivable;
import progress.message.broker.IRecycler;
import progress.message.broker.ISelectable;
import progress.message.broker.ISizeChangeListener;
import progress.message.broker.QElement;
import progress.message.broker.QToken;
import progress.message.broker.SelectorElement;
import progress.message.broker.TemporaryQElement;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.MessageSelector;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.Selector;
import progress.message.broker.parser.TokenMgrError;
import progress.message.msg.IMgram;
import progress.message.util.LongHashTable;
import progress.message.util.server.LongVector;

public class TemporaryQueue
extends BrowsableBaseQueue
implements IExpirable,
IReceivable,
IRecycler,
ISelectable {
    LongVector m_receivers;
    LongHashTable m_browsers;
    LongHashTable m_selectors;
    Vector m_recycledQElements = new Vector();
    long m_maxRecycledQElementCount = 50L;
    ISizeChangeListener m_sizeChangeListener;
    static final int s_TEMPORARY_QUEUE_ELEMENT_TYPE_CODE = 1;

    public TemporaryQueue(String qName, int numPriorities, int maxQueueSize, IQueueContext qc, Hashtable env) {
        super(qName, numPriorities, maxQueueSize, qc);
    }

    void setSizeChangeListener(ISizeChangeListener l) {
        this.m_sizeChangeListener = l;
    }

    public synchronized void enqueue(IMgram m) {
        if (m == null) {
            this.notifyAll();
            return;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        TemporaryQElement elem = (TemporaryQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte);
        } else {
            elem = new TemporaryQElement(m, tracking, prio, len, tte);
        }
        m.getBrokerHandle().setPtpEnqueueTime(0L);
        elem.setEnqueueTime(System.currentTimeMillis());
        m.getBrokerHandle().setLocalQueueName(this.m_qName);
        super.enqueue(elem, prio, len);
        this.updateSelectorsOnEnqueue(elem, prio);
        this.notifySizeChange();
        this.notifyAll();
    }

    public synchronized void reenqueue(IMgram m, boolean preserveRedelivery) {
        if (m == null) {
            this.notifyAll();
            return;
        }
        long tracking = m.getGuarenteedTrackingNum();
        byte prio = m.getPriority();
        long len = m.getEnqueuedSize();
        long tte = m.getTTE();
        TemporaryQElement elem = (TemporaryQElement)this.reuse(1);
        if (elem != null) {
            elem.repopulate(m, tracking, prio, len, tte);
        } else {
            elem = new TemporaryQElement(m, tracking, prio, len, tte);
        }
        long tm = m.getBrokerHandle().getPtpEnqueueTime();
        if (tm > 0L) {
            elem.setEnqueueTime(tm);
            m.getBrokerHandle().setPtpEnqueueTime(0L);
        } else {
            elem.setEnqueueTime(System.currentTimeMillis());
        }
        super.reenqueue(elem, prio, len, preserveRedelivery);
        this.updateSelectorsOnReenqueue(elem, prio);
        this.notifySizeChange();
        this.notifyAll();
    }

    @Override
    public synchronized Object dequeue(int prio) {
        QElement elem = null;
        while ((elem = (QElement)super.dequeue(prio)) != null && this.hasMsgExpired(elem)) {
            this.updateSelectorsOnDequeue(elem);
            this.updateBrowsersOnDequeue(elem);
            this.m_bqc.getAgentQueueProcessor().getCleanupThread().addExpiredMsg((IMgram)elem.getPayload());
            this.recycle(elem, 1);
        }
        return this.onDequeue(elem);
    }

    @Override
    public synchronized Object dequeue() {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        return this.dequeue(this.m_highestNonEmptyPriority);
    }

    public synchronized Object dequeueByTrackingNum(long tracking) {
        TemporaryQElement elem = (TemporaryQElement)super.dequeue(tracking);
        if (elem == null) {
            this.notifyAll();
            return null;
        }
        return this.onDequeue(elem);
    }

    @Override
    public synchronized Object dequeue(long receiverID) {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return null;
        }
        if (this.m_selectors == null) {
            return this.dequeue();
        }
        SelectorElement se = (SelectorElement)this.m_selectors.get(receiverID);
        if (se == null) {
            return this.dequeue();
        }
        QElement elem = (QElement)this.select(se);
        if (elem != null) {
            super.dequeue(elem);
        }
        return this.onDequeue(elem);
    }

    public synchronized Object dequeueWait() throws InterruptedException {
        while (this.m_totalEnqueuedCount == 0) {
            this.wait();
        }
        return this.dequeue();
    }

    public synchronized Object dequeueWait(long receiverID) throws InterruptedException {
        SelectorElement se = null;
        if (this.m_selectors != null) {
            se = (SelectorElement)this.m_selectors.get(receiverID);
        }
        Object obj = null;
        while (obj == null) {
            if (this.m_selectors == null || se == null) {
                while (this.m_totalEnqueuedCount == 0) {
                    this.wait();
                }
            } else {
                while (se.getAtEnd()) {
                    this.wait();
                }
            }
            obj = this.dequeue(receiverID);
        }
        return obj;
    }

    @Override
    public synchronized void clear() throws InterruptedException {
        if (this.m_totalEnqueuedCount == 0) {
            return;
        }
        AgentQueueMsgTracker tracker = null;
        QElement elem = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].m_next;
        int prio = this.m_highestNonEmptyPriority;
        QElement prev = null;
        QElement next = null;
        boolean lastOne = false;
        while (elem != null) {
            if (elem instanceof QToken) {
                --prio;
                elem = elem.getNext();
                continue;
            }
            lastOne = this.m_totalEnqueuedCount == 1;
            tracker = AgentQueueMsgTracker.getTracker(elem.getTracking());
            if (tracker != null) {
                tracker.canceled(lastOne);
            }
            prev = elem.getPrevious();
            next = elem.getNext();
            prev.setNext(next);
            next.setPrevious(prev);
            this.recycle(elem, 1);
            elem = next;
            int n = prio;
            this.m_elementsEnqueuedCount[n] = this.m_elementsEnqueuedCount[n] - 1;
            --this.m_totalEnqueuedCount;
        }
        this.m_totalEnqueuedCount = 0;
        this.setCurrentEnqueuedSize(0L);
        for (int i = 0; i < this.m_numPriorities; ++i) {
            this.m_elementsEnqueuedCount[i] = 0;
        }
        this.m_highestNonEmptyPriority = -1;
        if (this.m_selectors != null) {
            Enumeration enumeration = this.m_selectors.elements();
            SelectorElement se = null;
            while (enumeration.hasMoreElements()) {
                se = (SelectorElement)enumeration.nextElement();
                if (se == null) continue;
                se.resetCursor();
            }
        }
        if (this.m_browsers != null) {
            Enumeration enumeration = this.m_browsers.elements();
            BrowserElement be = null;
            while (enumeration.hasMoreElements()) {
                be = (BrowserElement)enumeration.nextElement();
                if (be == null) continue;
                be.resetOnClear();
            }
        }
        this.notifySpaceAvailable();
        this.notifySizeChange();
        this.notifyAll();
    }

    @Override
    public synchronized void unreserve(int size) {
        super.unreserve(size);
        this.notifySpaceAvailable();
    }

    @Override
    synchronized void notifySpaceAvailable() {
        long min_notifysize;
        long available = this.getCurrentAvailableSize();
        long l = min_notifysize = (long)Config.FLOW_CONTROL_NOTIFY_SIZE <= this.m_maxQueueSize ? (long)Config.FLOW_CONTROL_NOTIFY_SIZE : (long)Config.FLOW_CONTROL_DEFAULT_NOTIFY_SIZE;
        if (available > 0L && available >= min_notifysize) {
            this.m_bqc.getFlowControlManager().onSpaceAvailable(this.getQueueAddress(), available);
        }
    }

    @Override
    public boolean hasMsgExpired(QElement elem) {
        TemporaryQElement telem = (TemporaryQElement)elem;
        long tte = telem.getTTE();
        if (tte == 0L) {
            return false;
        }
        return System.currentTimeMillis() >= telem.getTTE();
    }

    @Override
    public synchronized void checkForExpiredMsgs() {
        if (this.m_totalEnqueuedCount == 0) {
            this.notifyAll();
            return;
        }
        QElement next = this.m_queuePriorityToken[this.m_highestNonEmptyPriority + 1].getNext();
        while (next != null) {
            if (next instanceof QToken) {
                next = next.getNext();
                continue;
            }
            TemporaryQElement elem = (TemporaryQElement)next;
            next = elem.getNext();
            if (!this.hasMsgExpired(elem)) continue;
            this.dequeueExpiredMsg(elem);
        }
        this.notifySpaceAvailable();
        this.notifySizeChange();
        this.notifyAll();
    }

    private void dequeueExpiredMsg(TemporaryQElement elem) {
        super.dequeue(elem);
        this.updateSelectorsOnDequeue(elem);
        this.updateBrowsersOnDequeue(elem);
        this.m_bqc.getAgentQueueProcessor().getCleanupThread().addExpiredMsg((IMgram)elem.getPayload());
        this.recycle(elem, 1);
    }

    @Override
    public synchronized boolean openLocalJMSReceiver(long receiverID, String selectorString) throws ParseException, TokenMgrError {
        if (this.m_receivers == null) {
            this.m_receivers = new LongVector();
        }
        if (!this.m_receivers.contains(receiverID)) {
            this.m_receivers.addElement(receiverID);
        }
        if (selectorString == null) {
            return true;
        }
        MessageSelector ms = null;
        StringReader sr = new StringReader(selectorString);
        Selector parser = new Selector(sr);
        ms = parser.MessageSelector();
        if (ms == null) {
            return false;
        }
        if (this.m_selectors == null) {
            this.m_selectors = new LongHashTable();
        }
        SelectorElement se = new SelectorElement(ms, this.m_numPriorities, this.m_queuePriorityToken, this.m_qName);
        this.m_selectors.put(receiverID, se);
        return true;
    }

    @Override
    public synchronized void closeLocalJMSReceiver(long receiverID) {
        SelectorElement se;
        if (this.m_receivers != null && !this.m_receivers.isEmpty()) {
            this.m_receivers.removeElement(receiverID);
        }
        if (this.m_selectors != null && !this.m_selectors.isEmpty() && (se = (SelectorElement)this.m_selectors.remove(receiverID)) != null) {
            se.recycle();
            Object var3_2 = null;
        }
    }

    @Override
    public synchronized boolean isLocalJMSReceiverOpen(long receiverID) {
        if (this.m_receivers == null || this.m_receivers.isEmpty()) {
            return false;
        }
        boolean b = this.m_receivers.contains(receiverID);
        return b;
    }

    @Override
    public synchronized int getLocalJMSReceiverCount() {
        if (this.m_receivers == null) {
            return 0;
        }
        return this.m_receivers.size();
    }

    @Override
    public synchronized void recycle(Object obj, int typeCode) {
        if (typeCode == 1) {
            ((TemporaryQElement)obj).recycle();
            if ((long)this.m_recycledQElements.size() < this.m_maxRecycledQElementCount) {
                this.m_recycledQElements.add(obj);
            }
        }
    }

    @Override
    public synchronized Object reuse(int typeCode) {
        Object obj = null;
        if (typeCode == 1 && !this.m_recycledQElements.isEmpty()) {
            obj = this.m_recycledQElements.firstElement();
            this.m_recycledQElements.removeElement(obj);
        }
        return obj;
    }

    @Override
    public synchronized Object select(SelectorElement se) {
        if (se.getAtEnd()) {
            return null;
        }
        MessageSelector ms = se.getMessageSelector();
        boolean match = false;
        QElement elem = null;
        IMgram m = null;
        int prio = se.getSearchPriority();
        while (!match && prio >= 0) {
            elem = se.getCursorElement(prio);
            if (elem instanceof QToken) {
                se.setSearchPriority(--prio);
                continue;
            }
            if (this.hasMsgExpired(elem)) {
                this.dequeueExpiredMsg((TemporaryQElement)elem);
                prio = se.getSearchPriority();
                continue;
            }
            m = (IMgram)elem.getPayload();
            try {
                match = ms.match(m);
            }
            catch (EvalException ee) {
                // empty catch block
            }
            if (match) continue;
            se.incrementCursor(prio);
            prio = se.getSearchPriority();
        }
        if (match) {
            return elem;
        }
        return null;
    }

    private synchronized void updateSelectorsOnEnqueue(QElement elem, int prio) {
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnEnqueue(elem);
        }
    }

    private synchronized void updateSelectorsOnReenqueue(QElement elem, int prio) {
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnReenqueue(elem);
        }
    }

    private synchronized void updateSelectorsOnDequeue(QElement elem) {
        if (elem == null) {
            return;
        }
        if (this.m_selectors == null || this.m_selectors.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.m_selectors.elements();
        SelectorElement se = null;
        while (enumeration.hasMoreElements()) {
            se = (SelectorElement)enumeration.nextElement();
            se.updateCursorOnDequeue(elem);
        }
    }

    private void notifySizeChange() {
        ISizeChangeListener l = this.m_sizeChangeListener;
        if (l != null) {
            l.onSizeChange();
        }
    }

    private synchronized Object onDequeue(QElement elem) {
        IMgram payload = null;
        if (elem != null) {
            this.updateSelectorsOnDequeue(elem);
            this.updateBrowsersOnDequeue(elem);
            byte reenqueues = elem.getReenqueueCount();
            payload = (IMgram)elem.getPayload();
            if (reenqueues > 0) {
                payload.setSuccessor(true);
                payload.setReenqueueCount(reenqueues);
            }
            payload.getBrokerHandle().setPtpEnqueueTime(elem.getEnqueueTime());
            this.recycle(elem, 1);
        }
        this.notifySpaceAvailable();
        this.notifySizeChange();
        this.notifyAll();
        return payload;
    }
}

