/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.common.runtime.IPreparedXABranchData;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.AbortGlobalTransaction;
import progress.message.broker.AbortTransaction;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdminConnection;
import progress.message.broker.AgentAdminSession;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BeginGlobalTransaction;
import progress.message.broker.BeginTransaction;
import progress.message.broker.Broker;
import progress.message.broker.CommitChannelTransactionNoDup;
import progress.message.broker.CommitGlobalTransaction;
import progress.message.broker.CommitResult;
import progress.message.broker.CommitTransaction;
import progress.message.broker.CommitTransactionNoDup;
import progress.message.broker.Config;
import progress.message.broker.DeleteChannelTransactionNoDup;
import progress.message.broker.EBrokerTxnFailure;
import progress.message.broker.ECannotFlushEvents;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EStartupFailure;
import progress.message.broker.ETxnAborted;
import progress.message.broker.ETxnAccessViolation;
import progress.message.broker.ETxnNotFound;
import progress.message.broker.ETxnSequenceError;
import progress.message.broker.EndGlobalTransaction;
import progress.message.broker.GetPreparedBranchesInfo;
import progress.message.broker.GetPreparedGlobalTransactions;
import progress.message.broker.GlobalTxnBeginEvt;
import progress.message.broker.GlobalTxnEndEvt;
import progress.message.broker.GlobalTxnJoinEvt;
import progress.message.broker.GlobalTxnResumeEvt;
import progress.message.broker.GlobalTxnSuspendEvt;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.IClientContext;
import progress.message.broker.InDoubtTxnReplyHandler;
import progress.message.broker.IsThereXid;
import progress.message.broker.JoinGlobalTransaction;
import progress.message.broker.LogManager;
import progress.message.broker.NoDupCommitBegEvt;
import progress.message.broker.PrepareGlobalTransaction;
import progress.message.broker.PrepareTransaction;
import progress.message.broker.ReplyAckEvt;
import progress.message.broker.RequestContext;
import progress.message.broker.ResumeGlobalTransaction;
import progress.message.broker.StatsMetrics;
import progress.message.broker.SuspendGlobalTransaction;
import progress.message.broker.SyncTxnEvt;
import progress.message.broker.Transaction;
import progress.message.broker.TxMsg;
import progress.message.broker.TxnAbortBeginEvt;
import progress.message.broker.TxnAbortEvt;
import progress.message.broker.TxnAsyncOp;
import progress.message.broker.TxnBeginEvt;
import progress.message.broker.TxnCommitEvt;
import progress.message.broker.TxnPrecommitEvt;
import progress.message.broker.TxnPrepareEvt;
import progress.message.broker.TxnRequestOp;
import progress.message.broker.UpdateChannelTransactionNoDup;
import progress.message.broker.XAResourceManager;
import progress.message.broker.prAccessor;
import progress.message.broker.stats.LTotStatsObj;
import progress.message.broker.stats.LValueStatsObj;
import progress.message.client.EGeneralException;
import progress.message.client.ENetworkFailure;
import progress.message.client.EXADuplicateXidException;
import progress.message.client.EXAInvalidOperationException;
import progress.message.client.EXAThereIsNoXidException;
import progress.message.db.EDatabaseException;
import progress.message.db.EInvalidConfiguration;
import progress.message.dd.NoDupDetectDb;
import progress.message.dd.NoDupDetectDbConnection;
import progress.message.ft.ReplicationManager;
import progress.message.msg.IExtendedTXNRequestHandle;
import progress.message.msg.IMgram;
import progress.message.msg.ITXNRequestHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.ISizedEnumeration;
import progress.message.util.IndexedList;
import progress.message.util.LinkedList;
import progress.message.util.LongHashTable;
import progress.message.xa.TxnAdminInfo;
import progress.message.xa.TxnInfo;
import progress.message.xa.XidImpl;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.Solicitation;

public class TransactionMgr
extends DebugObject {
    public static final int INVALID_TID = -1;
    static final short FLUSH = 1;
    static final short COMMIT = 2;
    static final short RECOMMIT = 3;
    static final short SYNC = 4;
    static final short TIMEOUT = 5;
    static final short REQUEST = 6;
    static final int RECOVERY_STATE_COMMITTED = 1;
    static final int RECOVERY_STATE_UNDO = 2;
    static final int RECOVERY_STATE_PENDING = 3;
    static final int RECOVERY_STATE_PRECOMMITTED = 4;
    static final int RECOVERY_STATE_NOTFOUND = 5;
    private int m_nextTid = 0;
    private IndexedList m_txns;
    private LongHashTable m_txnOwnerIdx;
    private LongHashTable m_completedTxnOwnerIdx;
    private Hashtable m_txnParticipants = new Hashtable();
    private XAResourceManager m_xaRM;
    private AgentRegistrar m_reg;
    private AgentQueueProcessor m_qproc;
    private LogManager m_logMgr;
    private AgentAdminSession m_adminSession;
    private LinkedList m_asyncOps;
    private LinkedList m_asyncFlushOps;
    private LinkedList m_requestOps;
    private LongHashTable m_inDoubtTxns;
    private InDoubtTxnReplyHandler m_repHandler;
    private MessageHandler m_txnReqHandler;
    private TxThread m_txThread;
    private TxThread[] m_flushThreads;
    private TxThread[] m_requestThreads;
    private NoDupDetectDbConnection m_ndConnection;
    private int m_commitCount;
    private int m_abortCount;
    private LTotStatsObj m_numCommits;
    private LTotStatsObj m_numFlush;
    boolean debugStatsEnabled = false;
    private int m_numQueuedOps;
    private int m_numQueuedFlushOps;
    private int m_numQueuedRequestOps;
    private IndexedList m_ackRecommits;
    private boolean DEBUG1 = (this.debugFlags & 0x40) > 0;
    boolean DEBUG_RECOVERY = (this.debugFlags & 0x1000) > 0;
    private Hashtable m_preparedXAmsgTable = null;

    TransactionMgr(AgentRegistrar reg) throws EStartupFailure {
        super(DebugState.GLOBAL_DEBUG_ON ? "TransactionMgr" : null);
        int i;
        this.m_reg = reg;
        this.m_logMgr = reg.getLogManager();
        this.m_asyncOps = new LinkedList();
        this.m_asyncFlushOps = new LinkedList();
        this.m_requestOps = new LinkedList();
        this.m_txns = new IndexedList();
        this.m_txnOwnerIdx = new LongHashTable();
        this.m_completedTxnOwnerIdx = new LongHashTable();
        this.m_ackRecommits = new IndexedList();
        this.m_xaRM = XAResourceManager.getXAResourceManager();
        this.m_inDoubtTxns = new LongHashTable();
        this.m_repHandler = new InDoubtTxnReplyHandler(this);
        this.m_repHandler.setName("TxnMgr indoubt reply handler");
        this.m_txnReqHandler = new MessageHandler(null);
        this.m_txnReqHandler.setName("TxnMgr request handler");
        Transaction.initClass(this, this.m_reg);
        this.m_adminSession = this.m_reg.getAdminSession();
        try {
            boolean debugStatsEnabled;
            this.m_adminSession.getConnection().addMessageHandler(this.m_repHandler);
            String prefix = Config.getAdminPrefix("*", "*");
            this.m_txnReqHandler.setNumSMPThreads(Config.TXN_SECONDARY_THREADS);
            this.m_txnReqHandler.bind(prefix + ".beginTransaction", (IMessageHandler)new BeginTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".abortTransaction", (IMessageHandler)new AbortTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".commitTransaction", (IMessageHandler)new CommitTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".commitTransactionNoDup", (IMessageHandler)new CommitTransactionNoDup(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".commitChannelTransactionNoDup", (IMessageHandler)new CommitChannelTransactionNoDup(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".updateChannelTransactionNoDup", (IMessageHandler)new UpdateChannelTransactionNoDup(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".deleteChannelTransactionNoDup", (IMessageHandler)new DeleteChannelTransactionNoDup(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".prepareTransaction", (IMessageHandler)new PrepareTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".beginGlobalTransaction", (IMessageHandler)new BeginGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".resumeGlobalTransaction", (IMessageHandler)new ResumeGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".joinGlobalTransaction", (IMessageHandler)new JoinGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".endGlobalTransaction", (IMessageHandler)new EndGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".suspendGlobalTransaction", (IMessageHandler)new SuspendGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".prepareGlobalTransaction", (IMessageHandler)new PrepareGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".commitGlobalTransaction", (IMessageHandler)new CommitGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".abortGlobalTransaction", (IMessageHandler)new AbortGlobalTransaction(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".getPreparedGlobalTransactions", (IMessageHandler)new GetPreparedGlobalTransactions(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".getPreparedBranchesInfo", (IMessageHandler)new GetPreparedBranchesInfo(this.m_reg));
            this.m_txnReqHandler.bind(prefix + ".isThereXid", (IMessageHandler)new IsThereXid(this.m_reg));
            this.m_adminSession.getConnection().addMessageHandler(this.m_txnReqHandler);
            boolean bl = debugStatsEnabled = (this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(6);
            if (debugStatsEnabled) {
                this.m_reg.getStatsManager().registerStat(new LValueStatsObj(6, "TxnReqHandler QSize", 2){

                    @Override
                    public long getCurrentValue() {
                        this.update(TransactionMgr.this.m_txnReqHandler.getQueueSize());
                        return super.getCurrentValue();
                    }
                });
            }
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            throw new EStartupFailure(prAccessor.getString("STR262") + e);
        }
        this.m_txThread = new TxThread(0, "AsyncCommit");
        this.m_flushThreads = new TxThread[Config.TXN_FLUSH_THREADS];
        for (i = 0; i < Config.TXN_FLUSH_THREADS; ++i) {
            this.m_flushThreads[i] = new TxThread(i + 1, "AsyncFlush");
        }
        this.m_requestThreads = new TxThread[Config.TXN_PRIMARY_THREADS];
        for (i = 0; i < Config.TXN_PRIMARY_THREADS; ++i) {
            this.m_requestThreads[i] = new TxThread(i + 1 + Config.TXN_FLUSH_THREADS, "RequestThread");
        }
        if (this.DEBUG1) {
            this.debug("Config.TXN_FLUSH_THREADS= " + Config.TXN_FLUSH_THREADS);
            this.debug("Config.TXN_PRIMARY_THREADS= " + Config.TXN_PRIMARY_THREADS);
            this.debug("Config.TXN_BUFFER_SIZE= " + Config.TXN_BUFFER_SIZE);
        }
    }

    public void replicateFileBasedTxn(int tid) {
        try {
            Transaction t = this.getTxn(tid, true);
            if (t != null) {
                t.replicateFile();
            }
        }
        catch (ETxnNotFound etxnnf) {
            BrokerComponent.getComponentContext().logMessage((Throwable)etxnnf, 2);
        }
        catch (IOException ioe) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
        }
    }

    public void reset() {
        this.m_txns = new IndexedList();
        this.m_txnOwnerIdx = new LongHashTable();
        this.m_completedTxnOwnerIdx = new LongHashTable();
        this.m_ackRecommits = new IndexedList();
        this.m_nextTid = 0;
        this.m_inDoubtTxns = new LongHashTable();
        this.m_txnParticipants = new Hashtable();
        if (this.m_numCommits != null) {
            this.m_numCommits.reset();
        }
        if (this.m_numFlush != null) {
            this.m_numFlush.reset();
        }
        this.m_numQueuedOps = 0;
        this.m_numQueuedFlushOps = 0;
        this.m_numQueuedRequestOps = 0;
    }

    private synchronized int getNewTid() {
        int tid;
        if ((tid = this.m_nextTid++) == 0) {
            tid = this.m_nextTid++;
        }
        return tid;
    }

    void startup() {
        int i;
        this.m_qproc = this.m_reg.getQueueProc();
        boolean bl = this.debugStatsEnabled = (this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(6);
        if (this.debugStatsEnabled) {
            this.m_reg.getStatsManager().registerStat(new LValueStatsObj(6, "TransactionManager Async Commit QSize", 2){

                @Override
                public long getCurrentValue() {
                    this.update(TransactionMgr.this.m_numQueuedOps);
                    return super.getCurrentValue();
                }
            });
            this.m_reg.getStatsManager().registerStat(new LValueStatsObj(6, "TransactionManager Async Flush QSize", 2){

                @Override
                public long getCurrentValue() {
                    this.update(TransactionMgr.this.m_numQueuedFlushOps);
                    return super.getCurrentValue();
                }
            });
            this.m_numCommits = new LTotStatsObj(6, "TransactionManager numCommits", 1);
            this.m_reg.getStatsManager().registerStat(this.m_numCommits);
            this.m_numFlush = new LTotStatsObj(6, "TransactionManager numFlush", 1);
            this.m_reg.getStatsManager().registerStat(this.m_numFlush);
        }
        this.m_txThread.start();
        for (i = 0; i < Config.TXN_FLUSH_THREADS; ++i) {
            this.m_flushThreads[i].start();
        }
        for (i = 0; i < Config.TXN_PRIMARY_THREADS; ++i) {
            this.m_requestThreads[i].start();
        }
    }

    void shutdown() {
        int i;
        for (i = 0; i < Config.TXN_PRIMARY_THREADS; ++i) {
            if (this.m_requestThreads[i] == null) continue;
            this.m_requestThreads[i].shutdown();
        }
        for (i = 0; i < Config.TXN_FLUSH_THREADS; ++i) {
            if (this.m_flushThreads[i] == null) continue;
            this.m_flushThreads[i].shutdown();
        }
        if (this.m_txThread != null) {
            this.m_txThread.shutdown();
        }
        this.closeAllTxnFiles();
    }

    synchronized void incCommitCount() {
        if (this.debugStatsEnabled) {
            this.m_numCommits.add(1L);
        }
    }

    void incFlushCount() {
        if (this.debugStatsEnabled) {
            this.m_numFlush.add(1L);
        }
    }

    synchronized void incAbortCount() {
        ++this.m_abortCount;
    }

    synchronized int getCommitCount() {
        return this.m_commitCount;
    }

    synchronized int getAbortCount() {
        return this.m_abortCount;
    }

    synchronized void resetStats() {
        this.m_abortCount = 0;
        this.m_commitCount = 0;
    }

    AgentRegistrar getAgentRegistrar() {
        return this.m_reg;
    }

    boolean isAckRecomitted(long tracking) {
        return this.m_ackRecommits.get(tracking) != null;
    }

    void setAckRecomitted(long tracking) {
        this.m_ackRecommits.appendNoDup(tracking, new Long(tracking));
    }

    private void setNextChainedTransactionLink(Transaction next) {
        Transaction previous;
        if (next.getPreviousTid() != -1 && (previous = (Transaction)this.m_txns.get(next.getPreviousTid())) != null) {
            previous.setNextTid(next.getTid());
        }
    }

    public int beginTxn(String uid, String appid) throws InterruptedException {
        return this.beginTxn(-1, uid, appid);
    }

    public int beginTxn(int previousTid, String uid, String appid) throws InterruptedException {
        return this.internalBeginTxn(false, previousTid, uid, appid);
    }

    public int internalBeginTxn(boolean runtimeOnly, int previousTid, String uid, String appid) throws InterruptedException {
        long owner = AddrUtil.stringToClientId(uid, appid);
        int tid = this.getNewTid();
        Transaction txn = new Transaction(tid, owner, uid, appid, false);
        txn.setRequestId(RequestContext.getRequestIdAsLong());
        txn.setReplyStatus(RequestContext.getReplyStatus());
        txn.setPreviousTid(previousTid);
        this.setNextChainedTransactionLink(txn);
        this.addTxn(txn);
        if (this.DEBUG) {
            this.debug("began new transaction " + tid + " for client " + uid + ", " + appid + ": " + owner);
        }
        if (!runtimeOnly) {
            TxnBeginEvt tbe = new TxnBeginEvt(tid, previousTid, uid, appid, txn.getRequestId(), txn.getReplyStatus());
            if (!RequestContext.getXonce()) {
                this.m_logMgr.addEvent(tbe, false);
            } else {
                this.m_logMgr.addEvent(tbe, true);
                this.m_logMgr.waitForFlush(tbe);
                if (this.DEBUG) {
                    this.debug("txn begin record flushed to log");
                }
            }
        }
        this.startWatchdog(txn);
        return tid;
    }

    private void startWatchdog(Transaction txn) {
        if (Config.TXN_IDLE_TIMEOUT <= 0) {
            return;
        }
        IClientContext cc = null;
        try {
            cc = this.m_reg.getClient(txn.getOwner());
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        if (cc != null && cc.isJMSSession()) {
            this.m_reg.getWatchDogThread().register(txn);
        }
    }

    int beginTxn(String uid, String appid, Object xid) throws EXADuplicateXidException, InterruptedException {
        if (this.isThereXid(xid)) {
            throw new EXADuplicateXidException(xid.toString());
        }
        long owner = AddrUtil.stringToClientId(uid, appid);
        int tid = this.getNewTid();
        Transaction txn = new Transaction(tid, owner, uid, appid, xid, false);
        txn.setRequestId(RequestContext.getRequestIdAsLong());
        this.addTxn(txn);
        if (this.DEBUG) {
            this.debug("began new XA transaction " + tid + xid.toString() + " for client " + uid + ", " + appid + ": " + owner);
        }
        GlobalTxnBeginEvt tbe = new GlobalTxnBeginEvt(tid, uid, appid, xid, RequestContext.getRequestIdAsLong());
        if (!RequestContext.getXonce()) {
            this.m_logMgr.addEvent(tbe, false);
        } else {
            this.m_logMgr.addEvent(tbe, true);
            this.m_logMgr.waitForFlush(tbe);
            if (this.DEBUG) {
                this.debug("txn begin record flushed to log");
            }
        }
        boolean Sonic00016295 = true;
        if (!Sonic00016295) {
            this.startWatchdog(txn);
        }
        return tid;
    }

    void resumeTxn(String uid, String appid, Object xid, int tid) throws EXAThereIsNoXidException, ETxnNotFound, ETxnSequenceError, InterruptedException {
        this.resumeTxn(xid, tid);
    }

    private void resumeTxn(Object xid, int tid) throws EXAThereIsNoXidException, ETxnNotFound, ETxnSequenceError, InterruptedException {
        if (!this.isThereXid(xid)) {
            throw new EXAThereIsNoXidException(xid.toString());
        }
        Transaction txn = this.getTxn(tid);
        txn.resumeTxn();
    }

    void joinTxn(String uid, String appid, Object xid, int tid) throws EXAThereIsNoXidException, ETxnNotFound, ETxnSequenceError, InterruptedException {
        this.joinTxn(xid, tid);
    }

    private void joinTxn(Object xid, int tid) throws EXAThereIsNoXidException, ETxnNotFound, ETxnSequenceError, InterruptedException {
        if (!this.isThereXid(xid)) {
            throw new EXAThereIsNoXidException(xid.toString());
        }
        Transaction txn = this.getTxn(tid);
        txn.joinTxn();
    }

    void endTxn(int tid, Object xid) throws ETxnSequenceError, ETxnNotFound, EXAThereIsNoXidException, InterruptedException {
        if (!this.isThereXid(xid)) {
            throw new EXAThereIsNoXidException(xid.toString());
        }
        Transaction t = this.getTxn(tid);
        t.endTxn(xid);
    }

    void suspendTxn(int tid, Object xid) throws ETxnSequenceError, ETxnNotFound, EXAThereIsNoXidException, InterruptedException {
        if (!this.isThereXid(xid)) {
            throw new EXAThereIsNoXidException(xid.toString());
        }
        Transaction t = this.getTxn(tid);
        t.suspendTxn(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTxnParticipant(long participantID, Transaction txn) {
        Long pidObj = new Long(participantID);
        Integer tidObj = new Integer(txn.getTid());
        Hashtable hashtable = this.m_txnParticipants;
        synchronized (hashtable) {
            Vector<Integer> tids = (Vector<Integer>)this.m_txnParticipants.get(pidObj);
            if (tids == null) {
                tids = new Vector<Integer>();
                this.m_txnParticipants.put(pidObj, tids);
            }
            if (!tids.contains(tidObj)) {
                tids.addElement(tidObj);
            }
            txn.addParticipant(pidObj);
        }
        if (this.DEBUG && this.m_txnParticipants != null) {
            this.debug("reg ===>" + this.m_txnParticipants.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterTxnParticipant(long participantID, Transaction txn) {
        if (this.m_txnParticipants == null) {
            return;
        }
        Long pidObj = new Long(participantID);
        Integer tidObj = new Integer(txn.getTid());
        boolean doCleanupCC = false;
        Hashtable hashtable = this.m_txnParticipants;
        synchronized (hashtable) {
            Vector tids = (Vector)this.m_txnParticipants.get(pidObj);
            if (tids != null) {
                tids.removeElement(tidObj);
            }
            if (tids == null || tids.isEmpty()) {
                this.m_txnParticipants.remove(pidObj);
                doCleanupCC = true;
            }
        }
        if (doCleanupCC) {
            try {
                IClientContext pcc = this.m_reg.getClient(participantID);
                if (pcc != null && pcc.isDisconnectPending()) {
                    this.cleanupClientContext(pcc);
                }
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
        }
        if (this.DEBUG && this.m_txnParticipants != null) {
            this.debug("unreg ===>" + this.m_txnParticipants.toString());
        }
    }

    boolean isParticipantOfTxn(long participantId) {
        return this.m_txnParticipants.containsKey(new Long(participantId));
    }

    void newMsg(TxMsg msg) throws ETxnSequenceError, ETxnNotFound {
        int tid = msg.getTid();
        try {
            Transaction t = this.getTxn(tid);
            t.publish(msg);
        }
        catch (ETxnNotFound ex1) {
            if (this.DEBUG1) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex1, 2);
            }
            throw ex1;
        }
        catch (ETxnSequenceError ex2) {
            if (this.DEBUG1) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex2, 2);
            }
            throw ex2;
        }
    }

    void addingMsgToLog(int tid) throws ETxnNotFound, ETxnSequenceError {
        Transaction t = null;
        try {
            t = this.getTxn(tid);
            t.addingMsgToLog();
        }
        catch (ETxnNotFound e) {
            if (this.DEBUG1) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            throw e;
        }
    }

    byte getTransactionPersistenceType(int tid) {
        try {
            Transaction t = this.getTxn(tid);
            return t.getPersistenceType();
        }
        catch (Exception e) {
            return 0;
        }
    }

    void recoveredMsg(TxMsg msg) {
        int tid = msg.getTid();
        if (this.DEBUG1) {
            this.debug("Got recovered msg tid= " + tid);
        }
        try {
            Transaction t = this.getTxn(tid);
            t.publishRecovered(msg);
        }
        catch (Exception e) {
            if (this.DEBUG1) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            throw new EAssertFailure("Can't publish recovered Msg " + e.toString());
        }
    }

    void updateLastActiveTime(int tid) {
        try {
            Transaction t = this.getTxn(tid);
            t.updateLastActiveTime();
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    boolean handleNewMgram(IMgram m) throws InterruptedException {
        IClientContext senderCC;
        boolean sendAck;
        boolean handled;
        int status;
        int tid;
        block22: {
            tid = m.getTxnId();
            status = 0;
            handled = true;
            sendAck = true;
            senderCC = null;
            try {
                senderCC = this.m_reg.getClient(m.getBrokerHandle().getSenderID());
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
            Transaction t = null;
            try {
                t = this.getTxn(tid);
                if (t.isCompleted()) {
                    switch (m.getType()) {
                        case 3: 
                        case 14: 
                        case 36: {
                            return true;
                        }
                    }
                }
                int senderUID = AddrUtil.clientIdToUid(m.getBrokerHandle().getSenderID());
                if (this.DEBUG) {
                    this.debug("handleNewMgram() TYPE=" + m.getType() + "; senderID=" + m.getBrokerHandle().getSenderID() + "; senderUID=" + senderUID);
                }
                if (t.isOwner(senderUID)) {
                    this.registerTxnParticipant(m.getBrokerHandle().getSenderID(), t);
                    switch (m.getType()) {
                        case 3: 
                        case 14: 
                        case 36: {
                            long msgConsumerId = m.getAckHandle().getClientID();
                            this.registerTxnParticipant(msgConsumerId, t);
                            t.addAckMsg(m);
                            break;
                        }
                        default: {
                            if (!t.publish(m, senderCC)) {
                                handled = false;
                            }
                            if (t.getOwnerCC() != null && t.getOwnerCC().isXOnce()) {
                                sendAck = false;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block22;
                }
                status = -12;
            }
            catch (ETxnSequenceError e) {
                status = -13;
            }
            catch (ETxnNotFound e) {
                status = -11;
            }
            catch (ETxnAborted e) {
                status = -11;
            }
        }
        if (handled && (m.isGuarenteed() || m.isRejectable()) && senderCC != null && sendAck) {
            if (this.DEBUG1 && status != 0) {
                this.debug("Sending error ack for transaction " + tid);
            }
            if (status != 0) {
                senderCC.sendErrorAck(m, (short)status, false);
            } else if (m.isGuarenteed()) {
                senderCC.sendThrough(MgramFactory.getMgramFactory().buildAck(m.getGuarenteedTrackingNum(), (short)status, m.getChannel()));
            }
        }
        return handled;
    }

    void newMgram(IMgram m) throws InterruptedException {
        this.handleNewMgram(m);
    }

    void prepare(int tid, int uid, String userXid) throws ETxnSequenceError, ETxnNotFound, ETxnAborted, ETxnAccessViolation, InterruptedException {
        Transaction t = this.getTxn(tid);
        if (!t.isOwner(uid)) {
            throw new ETxnAccessViolation("tid: " + tid + " uid: " + uid);
        }
        t.prepare(userXid);
    }

    void prepareTxn(int tid, Object xid, long clientId) throws ETxnSequenceError, ETxnNotFound, ETxnAborted, ETxnAccessViolation, EXAThereIsNoXidException, InterruptedException {
        if (!this.isThereXid(xid)) {
            throw new EXAThereIsNoXidException(xid.toString());
        }
        Transaction t = this.getTxn(tid);
        try {
            if (!t.isAuthenticatedXAUser(clientId)) {
                throw new ETxnAccessViolation("tid: " + tid + " clientId: " + clientId + " uid: " + AddrUtil.clientIdToUid(clientId) + " appid: " + AddrUtil.clientIdToAppid(clientId));
            }
        }
        catch (EClientNotRegistered e) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            throw new ETxnAccessViolation("<prepareTxn> EClientNotRegistered(" + clientId + ")");
        }
        t.prepare();
    }

    public boolean commit(int tid, int uid, String transactionId, long lifespan) throws ETxnSequenceError, ETxnNotFound, ETxnAborted, EDatabaseException, EInvalidConfiguration, ETxnAccessViolation, EGeneralException, InterruptedException {
        CommitResult result = this.commit(tid, uid, transactionId, lifespan, false, 14, null);
        return result.getResult() == 0;
    }

    public CommitResult commit(int tid, int uid, String transactionId, long lifespan, boolean isChannel, int channelState, String channelId) throws ETxnSequenceError, ETxnNotFound, ETxnAborted, EDatabaseException, EInvalidConfiguration, ETxnAccessViolation, EGeneralException, InterruptedException {
        boolean abort = true;
        short replyStatus = 0;
        Transaction t = this.getTxn(tid);
        if (!t.isOwner(uid)) {
            throw new ETxnAccessViolation("tid: " + tid + " uid: " + uid);
        }
        this.m_reg.getWatchDogThread().unregister(t);
        if (!NoDupDetectDb.isEnabled()) {
            RequestContext.setReplyStatus((short)10);
            t.abort();
            this.removeTxn(t);
            throw new EInvalidConfiguration("");
        }
        long timestamp = System.currentTimeMillis();
        long lTrk = RequestContext.getRequestIdAsLong();
        boolean chained = RequestContext.getChained();
        t.startNoDupCommit(transactionId, timestamp, isChannel, channelState, channelId, lifespan, lTrk, chained);
        NoDupCommitBegEvt nde = new NoDupCommitBegEvt(tid, uid, transactionId, timestamp, isChannel, channelId, channelState, lifespan, lTrk, chained);
        this.m_logMgr.addEvent(nde, true);
        this.m_logMgr.waitForFlush(nde);
        CommitResult result = new CommitResult();
        try {
            if (this.m_ndConnection == null) {
                this.m_ndConnection = NoDupDetectDb.getConnection();
            }
            if ((result = !isChannel ? this.m_ndConnection.write(transactionId, lifespan, timestamp, 14, null) : this.m_ndConnection.writeChannel(transactionId, lifespan, timestamp, channelState, channelId)).getResult() == 0) {
                abort = false;
                this.commitInternal(t);
            } else if (result.getResult() == 14) {
                replyStatus = 7;
            } else if (result.getResult() == 13) {
                replyStatus = 13;
            }
        }
        catch (EGeneralException ege) {
            replyStatus = this.evaluateReplyStatus(ege);
            throw ege;
        }
        finally {
            if (abort) {
                if (replyStatus == 0) {
                    replyStatus = 4;
                }
                RequestContext.setReplyStatus(replyStatus);
                t.abort();
                this.removeTxn(t);
            }
        }
        return result;
    }

    private short evaluateReplyStatus(EGeneralException ege) {
        try {
            throw ege;
        }
        catch (EDatabaseException e) {
            return 8;
        }
        catch (EInvalidConfiguration e) {
            return 10;
        }
        catch (IllegalArgumentException e) {
            return 9;
        }
        catch (ETxnNotFound e) {
            return 2;
        }
        catch (ETxnSequenceError e) {
            return 3;
        }
        catch (ETxnAborted e) {
            return 4;
        }
        catch (ETxnAccessViolation e) {
            return 6;
        }
        catch (EGeneralException e) {
            return 5;
        }
    }

    void commit(int tid, int uid) throws ETxnSequenceError, ETxnNotFound, ETxnAborted, ETxnAccessViolation, InterruptedException {
        Transaction t = this.getTxn(tid);
        if (!t.isOwner(uid)) {
            throw new ETxnAccessViolation("tid: " + tid + " uid: " + uid);
        }
        this.commitInternal(t);
    }

    void commitTxn(int tid, Object xid, long clientId) throws ETxnSequenceError, ETxnAborted, ETxnNotFound, ETxnAccessViolation, EXAThereIsNoXidException, InterruptedException {
        if (!this.isThereXid(xid)) {
            throw new EXAThereIsNoXidException(xid.toString());
        }
        Transaction t = this.getTxn(tid);
        try {
            if (!t.isAuthenticatedXAUser(clientId)) {
                throw new ETxnAccessViolation("tid: " + tid + " clientId: " + clientId + " uid: " + AddrUtil.clientIdToUid(clientId) + " appid: " + AddrUtil.clientIdToAppid(clientId));
            }
        }
        catch (EClientNotRegistered e) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            throw new ETxnAccessViolation("<commitTxn> EClientNotRegistered(" + clientId + ")");
        }
        this.commitInternal(t);
    }

    void commit(int tid) throws ETxnSequenceError, ETxnAborted, ETxnNotFound, InterruptedException {
        this.commitInternal(this.getTxn(tid));
    }

    private void commitInternal(Transaction t) throws ETxnSequenceError, ETxnAborted, InterruptedException {
        this.m_reg.getWatchDogThread().unregister(t);
        t.precommit();
        if (Config.TXN_PARALLEL_PUBLISH || t.isXAtransaction()) {
            try {
                t.commit(false);
                this.removeTxn(t);
            }
            catch (EBrokerTxnFailure e) {
                BrokerComponent.getComponentContext().logMessage("Commit of transaction " + t.getTid() + " failed: " + e.getMessage(), (Throwable)e, 2);
            }
        } else {
            this.doAsyncOp(t, (short)2);
        }
    }

    void abort(int tid, int uid) throws ETxnSequenceError, ETxnNotFound, ETxnAccessViolation, InterruptedException {
        Transaction t = this.getTxn(tid);
        if (!t.isOwner(uid)) {
            throw new ETxnAccessViolation("tid: " + tid + " uid: " + uid);
        }
        this.abortInternal(t);
    }

    void abortTxn(int tid, Object xid, long clientId) throws ETxnSequenceError, ETxnNotFound, ETxnAccessViolation, EXAThereIsNoXidException, InterruptedException {
        if (!this.isThereXid(xid)) {
            throw new EXAThereIsNoXidException(xid.toString());
        }
        Transaction t = this.getTxn(tid);
        try {
            if (!t.isAuthenticatedXAUser(clientId)) {
                throw new ETxnAccessViolation("tid: " + tid + " clientId: " + clientId + " uid: " + AddrUtil.clientIdToUid(clientId) + " appid: " + AddrUtil.clientIdToAppid(clientId));
            }
        }
        catch (EClientNotRegistered e) {
            if (this.DEBUG) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
            throw new ETxnAccessViolation("<abortTxn> EClientNotRegistered(" + clientId + ")");
        }
        this.abortInternal(t);
    }

    private void abortInternal(Transaction t) throws ETxnSequenceError, InterruptedException {
        if (this.DEBUG) {
            this.debug("abortInternal: tid = " + t.getTid());
        }
        this.m_reg.getWatchDogThread().unregister(t);
        t.abort();
        this.removeTxn(t);
    }

    void abort(int tid) throws ETxnSequenceError, ETxnNotFound, InterruptedException {
        this.abortInternal(this.getTxn(tid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortTxns(long owner) throws InterruptedException {
        LongHashTable h;
        LongHashTable longHashTable = this.m_txnOwnerIdx;
        synchronized (longHashTable) {
            h = (LongHashTable)this.m_txnOwnerIdx.get(owner);
        }
        if (h != null) {
            Enumeration enu = ((LongHashTable)h.clone()).elements();
            while (enu.hasMoreElements()) {
                Integer IDRtrack;
                Transaction t = (Transaction)enu.nextElement();
                if (t.isNew() || t.isEnded() || t.isSuspended()) {
                    try {
                        this.m_reg.getWatchDogThread().unregister(t);
                        t.abort();
                        this.m_txns.remove(t.getTid());
                        h.remove(t.getTid());
                        this.m_xaRM.removeTransaction(t);
                    }
                    catch (ETxnSequenceError e) {
                        // empty catch block
                    }
                }
                if ((IDRtrack = t.getInDoubtReqTracking()) != null) {
                    t.cancelInDoubtReq();
                    this.removeInDoubtTxn(IDRtrack);
                }
                Transaction transaction = t;
                synchronized (transaction) {
                    if (t.isPrepared()) {
                        t.closeTxnFile();
                    }
                }
            }
            if (h.isEmpty()) {
                LongHashTable longHashTable2 = this.m_txnOwnerIdx;
                synchronized (longHashTable2) {
                    this.m_txnOwnerIdx.remove(owner);
                }
            }
        }
        this.cleanupCompletedTxns(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList snapshotFileBasedTxns() {
        ArrayList<Integer> snapshotFileBasedTxns = new ArrayList<Integer>();
        IndexedList<Transaction> cloned_txns = new IndexedList<Transaction>();
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            Enumeration enu = this.m_txns.elements();
            while (enu.hasMoreElements()) {
                Transaction t = (Transaction)enu.nextElement();
                cloned_txns.appendNoDup(t.getTid(), t);
            }
        }
        Enumeration txns = cloned_txns.elements();
        while (txns.hasMoreElements()) {
            Transaction txn = (Transaction)txns.nextElement();
            int tid = 0;
            Transaction transaction = txn;
            synchronized (transaction) {
                tid = txn.getTid();
                if (this.DEBUG) {
                    this.debug("snapshotFileBasedTxns checking tid: " + tid);
                }
                if (txn.isFileBased()) {
                    if (this.DEBUG) {
                        this.debug("snapshotFileBasedTxns tid: " + tid + " isFileBased");
                    }
                    txn.setDoNotReplicateLive(true);
                    snapshotFileBasedTxns.add(new Integer(tid));
                }
            }
        }
        return snapshotFileBasedTxns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupCompletedTxns(long owner) {
        LongHashTable longHashTable = this.m_completedTxnOwnerIdx;
        synchronized (longHashTable) {
            LongHashTable h = (LongHashTable)this.m_completedTxnOwnerIdx.get(owner);
            if (h != null) {
                Enumeration enu = ((LongHashTable)h.clone()).elements();
                while (enu.hasMoreElements()) {
                    Transaction t = (Transaction)enu.nextElement();
                    this.m_txns.remove(t.getTid());
                }
                this.m_completedTxnOwnerIdx.remove(owner);
            }
        }
    }

    public void closeAllTxnFiles() {
        Enumeration enu = this.m_txns.elements();
        while (enu.hasMoreElements()) {
            Transaction txn = (Transaction)enu.nextElement();
            txn.closeTxnFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReplyAck(long owner, long requestId) {
        LongHashTable h = null;
        LongHashTable longHashTable = this.m_txnOwnerIdx;
        synchronized (longHashTable) {
            h = (LongHashTable)this.m_txnOwnerIdx.get(owner);
        }
        if (h != null) {
            Enumeration enu = ((LongHashTable)h.clone()).elements();
            while (enu.hasMoreElements()) {
                Transaction t = (Transaction)enu.nextElement();
                if (t.getRequestId() != requestId) continue;
                t.setRequestId(0L);
                break;
            }
        }
        longHashTable = this.m_completedTxnOwnerIdx;
        synchronized (longHashTable) {
            h = (LongHashTable)this.m_completedTxnOwnerIdx.get(owner);
            if (h != null) {
                Enumeration enu = ((LongHashTable)h.clone()).elements();
                while (enu.hasMoreElements()) {
                    Transaction t = (Transaction)enu.nextElement();
                    if (t.getRequestId() != requestId) continue;
                    this.m_txns.remove(t.getTid());
                    h.remove(t.getTid());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getPreparedGlobalTransactions(long retrieverId) {
        Vector<TxnInfo> ret = new Vector<TxnInfo>();
        Vector copy = new Vector();
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            Enumeration e = this.m_txns.elements();
            while (e.hasMoreElements()) {
                copy.add(e.nextElement());
            }
        }
        Enumeration enu = copy.elements();
        while (enu.hasMoreElements()) {
            Transaction t = (Transaction)enu.nextElement();
            long ownerId = t.getOwner();
            if (!t.isXAtransaction() || !t.isPrepared()) continue;
            if (ownerId == retrieverId && t.isOwner(AddrUtil.clientIdToUid(retrieverId))) {
                if (this.DEBUG) {
                    this.debug("found in-Doubt txn owned by retriever:" + t.getTid());
                }
                if (this.DEBUG) {
                    this.debug("txn ownerId = " + ownerId + " ;retriever's clientId = " + retrieverId);
                }
                ret.addElement(new TxnInfo(t.getTid(), (XidImpl)t.getXid(), t.getStatus()));
                continue;
            }
            if (!t.isOrphan()) continue;
            if (this.DEBUG) {
                this.debug("found an orphan in-Doubt txn:" + t.getTid());
            }
            if (this.DEBUG) {
                this.debug("txn ownerId = " + ownerId + " ;retriever's clientId = " + retrieverId);
            }
            ret.addElement(new TxnInfo(t.getTid(), (XidImpl)t.getXid(), t.getStatus()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPreparedXABranches() {
        ArrayList<Object> branchesData = new ArrayList<Object>(this.m_txns.count());
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            Enumeration enu = this.m_txns.elements();
            while (enu.hasMoreElements()) {
                branchesData.add(enu.nextElement());
            }
        }
        for (int i = branchesData.size() - 1; i >= 0; --i) {
            Transaction txn = (Transaction)branchesData.get(i);
            if (!(txn.isXAtransaction() && txn.isPrepared() && txn.isOrphan())) {
                branchesData.remove(i);
                continue;
            }
            IPreparedXABranchData branchData = RuntimeDataFactory.createPreparedXABranchData(txn.getOwnerUid(), txn.getOwnerAppid(), txn.getXid().toString(), txn.getTid());
            branchesData.set(i, branchData);
        }
        return branchesData;
    }

    public void commitPreparedXABranches(Integer[] TIDs) throws Exception {
        for (int i = 0; i < TIDs.length; ++i) {
            this.commit(TIDs[i]);
        }
    }

    public void rollbackPreparedXABranches(Integer[] TIDs) throws Exception {
        for (int i = 0; i < TIDs.length; ++i) {
            this.abort(TIDs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getPreparedBranchesInfo() {
        Vector<TxnAdminInfo> ret = new Vector<TxnAdminInfo>();
        Vector copy = new Vector();
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            Enumeration e = this.m_txns.elements();
            while (e.hasMoreElements()) {
                copy.add(e.nextElement());
            }
        }
        Enumeration enu = copy.elements();
        while (enu.hasMoreElements()) {
            Transaction t = (Transaction)enu.nextElement();
            if (t == null || !t.isXAtransaction() || !t.isPrepared() || !t.isOrphan()) continue;
            if (this.DEBUG) {
                this.debug("found an orphan in-Doubt txn:" + t.getTid());
            }
            Vector<String> owners = new Vector<String>();
            owners.addElement(t.getOwnerUid());
            Vector<String> appids = new Vector<String>();
            appids.addElement(t.getOwnerAppid());
            ret.addElement(new TxnAdminInfo(owners, appids));
        }
        return ret;
    }

    boolean isThereXid(Object xid) {
        return this.m_xaRM.isThereXid(xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInDoubtReqs(long owner) {
        LongHashTable h;
        Object object;
        if (owner == this.m_reg.getId()) {
            AgentAdminConnection aac = (AgentAdminConnection)this.m_adminSession.getConnection();
            object = aac;
            synchronized (object) {
                try {
                    while (!aac.isConnected()) {
                        aac.wait();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        object = this.m_txnOwnerIdx;
        synchronized (object) {
            h = (LongHashTable)this.m_txnOwnerIdx.get(owner);
        }
        if (h != null) {
            Enumeration enu = h.elements();
            while (enu.hasMoreElements()) {
                Transaction t = (Transaction)enu.nextElement();
                if (!t.isPrepared() || t.isXAtransaction()) continue;
                try {
                    Message m = new Message();
                    m.writeUTF(t.getUserXid());
                    LongHashTable longHashTable = this.m_inDoubtTxns;
                    synchronized (longHashTable) {
                        IClientContext cc = null;
                        try {
                            cc = this.m_reg.getClient(owner);
                        }
                        catch (EClientNotRegistered cnr) {
                            throw new EAssertFailure("client not registered.", cnr);
                        }
                        m.setSubject("$SYS.TRANSACTION.IN-DOUBT");
                        Solicitation s = this.m_adminSession.directedSolicit(cc.getId(), m, this.m_repHandler, 0);
                        int tracking = s.getTracking();
                        if ((this.debugFlags & 0x1000) > 0) {
                            this.debug("Sent request to client " + owner + " for in doubt txn " + t.getUserXid() + ", tracking # is " + tracking + " tid= " + t.getTid());
                        }
                        this.m_inDoubtTxns.put(tracking, t);
                        t.setInDoubtReqPending(tracking);
                    }
                }
                catch (ENetworkFailure enf) {
                    if (Broker.isInShutdown()) continue;
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR263") + t.getTid() + ": " + enf.getMessage(), (Throwable)enf, 2);
                }
                catch (IOException e) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR263") + t.getTid() + ": " + e.getMessage(), (Throwable)e, 2);
                }
            }
        } else if ((this.debugFlags & 0x1000) > 0) {
            this.debug("SendInDoubtReqs: Client " + owner + " has no in doubt txns ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transaction removeInDoubtTxn(int tracking) {
        long jid;
        AgentAdminConnection conn = (AgentAdminConnection)this.m_adminSession.getConnection();
        if (conn.getJob(jid = (long)tracking & 0xFFFFFFFFL) instanceof Solicitation) {
            conn.removeJob(jid);
        }
        LongHashTable longHashTable = this.m_inDoubtTxns;
        synchronized (longHashTable) {
            return (Transaction)this.m_inDoubtTxns.remove(tracking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasTxns(long clientId) {
        LongHashTable longHashTable = this.m_txnOwnerIdx;
        synchronized (longHashTable) {
            return this.m_txnOwnerIdx.get(clientId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getXATxnsOwnedBy(long ownerId) {
        Vector<Transaction> ret = new Vector<Transaction>();
        if (this.m_txnOwnerIdx == null) {
            return null;
        }
        LongHashTable longHashTable = this.m_txnOwnerIdx;
        synchronized (longHashTable) {
            LongHashTable txnLHT = (LongHashTable)this.m_txnOwnerIdx.get(ownerId);
            Enumeration txns = txnLHT.elements();
            while (txns.hasMoreElements()) {
                Transaction txn = (Transaction)txns.nextElement();
                if (!txn.isXAtransaction()) continue;
                ret.addElement(txn);
            }
        }
        if (ret.isEmpty()) {
            ret = null;
        }
        return ret;
    }

    Vector getTxnsOwnedBy(long ownerId) {
        return this.getTxnsBy(ownerId, this.m_txnOwnerIdx);
    }

    Vector getCompletedTxnsOwnedBy(long ownerId) {
        return this.getTxnsBy(ownerId, this.m_completedTxnOwnerIdx);
    }

    private Vector getTxnsBy(long ownerId, LongHashTable ht) {
        if (ht == null) {
            return null;
        }
        return (Vector)ht.get(ownerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getInDoubtTxns(long clientId) {
        LongHashTable txns;
        Vector<Transaction> ret = new Vector<Transaction>();
        LongHashTable longHashTable = this.m_txnOwnerIdx;
        synchronized (longHashTable) {
            txns = (LongHashTable)this.m_txnOwnerIdx.get(clientId);
        }
        if (txns != null) {
            longHashTable = txns;
            synchronized (longHashTable) {
                Enumeration e = txns.elements();
                while (e.hasMoreElements()) {
                    Transaction t = (Transaction)e.nextElement();
                    if (!t.isPrepared()) continue;
                    ret.addElement(t);
                }
            }
        }
        return ret;
    }

    Transaction getTxn(int tid) throws ETxnNotFound {
        return this.getTxn(tid, false);
    }

    Transaction getTxn(int tid, boolean allowNullReturn) throws ETxnNotFound {
        Transaction t = (Transaction)this.m_txns.get(tid);
        if (t == null && !allowNullReturn) {
            throw new ETxnNotFound(tid);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTxn(Transaction t) {
        LongHashTable<Transaction> h;
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            this.m_txns.remove(t.getTid());
            this.m_txns.appendNoDup(t.getTid(), t);
        }
        long owner = t.getOwner();
        if (this.DEBUG) {
            try {
                this.debug("####### addTxn() tid=" + t.getTid() + "owner(" + owner + ") appId=" + this.m_reg.getClient(owner).getAppid());
            }
            catch (EClientNotRegistered e) {
                this.debug("####### addTxn() tid=" + t.getTid() + " owner(" + owner + ") not registered", e);
            }
        }
        if (t.isCompleted()) {
            this.addToCompletedTxnOwnerIdx(t);
            return;
        }
        LongHashTable longHashTable = this.m_txnOwnerIdx;
        synchronized (longHashTable) {
            h = (LongHashTable<Transaction>)this.m_txnOwnerIdx.get(owner);
        }
        if (h == null) {
            h = new LongHashTable<Transaction>();
            longHashTable = this.m_txnOwnerIdx;
            synchronized (longHashTable) {
                this.m_txnOwnerIdx.put(owner, h);
            }
        }
        h.put(t.getTid(), t);
        this.m_xaRM.addTransaction(t);
        if (this.DEBUG) {
            this.debug("addTxn(" + owner + ") m_txnOwnerIdx=" + this.m_txnOwnerIdx.toString() + "\n");
        }
    }

    private void removeTxn(Transaction t) {
        this.removeTxn(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTxn(Transaction t, boolean cleanupCC) {
        LongHashTable h;
        this.m_reg.getWatchDogThread().unregister(t);
        Integer IDRtrack = t.getInDoubtReqTracking();
        if (IDRtrack != null) {
            t.cancelInDoubtReq();
            this.removeInDoubtTxn(IDRtrack);
        }
        long owner = t.getOwner();
        LongHashTable longHashTable = this.m_txnOwnerIdx;
        synchronized (longHashTable) {
            h = (LongHashTable)this.m_txnOwnerIdx.get(owner);
        }
        if (h != null) {
            h.remove(t.getTid());
            if (h.isEmpty()) {
                longHashTable = this.m_txnOwnerIdx;
                synchronized (longHashTable) {
                    this.m_txnOwnerIdx.remove(owner);
                }
                if (cleanupCC) {
                    try {
                        IClientContext ownerCtx = this.m_reg.getClient(owner);
                        this.cleanupClientContext(ownerCtx);
                    }
                    catch (EClientNotRegistered e) {
                        // empty catch block
                    }
                }
            }
        }
        boolean isXonce = false;
        try {
            IClientContext ownerCtx = this.m_reg.getClient(t.getOwner());
            isXonce = ownerCtx.isXOnce();
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
        if (!isXonce) {
            this.m_txns.remove(t.getTid());
        } else {
            this.addToCompletedTxnOwnerIdx(t);
        }
        this.m_xaRM.removeTransaction(t);
        this.removePreparedXAmsgs(t);
        if (this.DEBUG) {
            this.debug("removeTxn(" + owner + ") m_txnOwnerIdx=" + this.m_txnOwnerIdx.toString() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupClientContext(IClientContext ctx) {
        LongHashTable trackingnums;
        if (ctx == null) {
            return;
        }
        if (ctx.isGroupSubscriptionMember() && (trackingnums = ctx.getGuarDoubtManager().clearPendingGroupTxnMessages()) != null) {
            ISizedEnumeration<Long> keys = trackingnums.keyList();
            GroupSubscriptionClientContext groupcc = ctx.getGroupSubscriptionCC();
            try {
                groupcc.waitForGroupCCUnfreeze(false);
                while (keys.hasMoreElements()) {
                    long tracking = (Long)keys.nextElement();
                    IMgram pendingGuar = null;
                    Object object = groupcc.getSyncObj();
                    synchronized (object) {
                        pendingGuar = groupcc.getOutQueue().removePendingGuar(tracking);
                    }
                    object = ctx.getSyncObj();
                    synchronized (object) {
                        ctx.getGuarDoubtManager().removeMessageInDoubt(tracking);
                        ctx.getGuarDoubtManager().removePendingGroupTxnMessage(tracking);
                        IMgram memberPendingGuar = ctx.getOutQueue().removePendingGuar(tracking);
                        if (pendingGuar == null) {
                            pendingGuar = memberPendingGuar;
                        }
                        ctx.getOutQueue().removeGroupSubGuarPending(tracking);
                    }
                    if (pendingGuar == null) continue;
                    if (ctx.isDurable()) {
                        groupcc.adjustDurableCCTracker(pendingGuar, false);
                    }
                    groupcc.doGroupMessageSave(pendingGuar, null, true, true, true);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                groupcc.unlockGroupCC();
            }
        }
        if (ctx.okToUnregister()) {
            ctx.lock();
            try {
                this.m_reg.checkUnregister(ctx);
            }
            finally {
                ctx.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCompletedTxnOwnerIdx(Transaction t) {
        long owner = t.getOwner();
        LongHashTable<Transaction> h = null;
        LongHashTable longHashTable = this.m_completedTxnOwnerIdx;
        synchronized (longHashTable) {
            h = (LongHashTable<Transaction>)this.m_completedTxnOwnerIdx.get(owner);
        }
        if (h == null) {
            h = new LongHashTable<Transaction>();
            longHashTable = this.m_completedTxnOwnerIdx;
            synchronized (longHashTable) {
                this.m_completedTxnOwnerIdx.put(owner, h);
            }
        }
        h.put(t.getTid(), t);
    }

    void addTimeOutOp(Transaction txn) {
        this.doAsyncOp(txn, (short)5);
    }

    void flush(Transaction t) {
        this.doAsyncFlushOp(t, (short)1);
    }

    void processTxnOp(IMgram request) {
        this.doRequestOp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws InterruptedException {
        TxnAsyncOp op;
        TxnAsyncOp txnAsyncOp = op = this.doAsyncOp(null, (short)4);
        synchronized (txnAsyncOp) {
            while (!op.isCompleted() && !Thread.currentThread().isInterrupted()) {
                op.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSyncRecords() throws ECannotFlushEvents {
        LinkedList txnlist = new LinkedList();
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            Enumeration enu = this.m_txns.elements();
            while (enu.hasMoreElements()) {
                txnlist.append(enu.nextElement());
            }
        }
        Enumeration enu = txnlist.elements();
        int count = 0;
        while (enu.hasMoreElements()) {
            ((Transaction)enu.nextElement()).writeSyncRecord();
            ++count;
        }
        if (this.DEBUG1) {
            this.debug("Wrote " + count + " sync events");
        }
    }

    void redoBeginTxn(TxnBeginEvt evt) {
        this.redoBeginTxn(evt.getTid(), evt.getPreviousTid(), evt.getUid(), evt.getAppid(), evt.getRequestId());
    }

    private void redoBeginTxn(int tid, int previousTid, String uid, String appid, long requestId) {
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoBeginTxn tid= " + tid);
        }
        Transaction t = new Transaction(tid, AddrUtil.stringToClientId(uid, appid), uid, appid, true);
        t.setRequestId(requestId);
        t.setPreviousTid(previousTid);
        this.setNextChainedTransactionLink(t);
        this.addTxn(t);
    }

    void redoBeginTxn(GlobalTxnBeginEvt evt) {
        this.redoBeginTxn(evt.getTid(), evt.getUid(), evt.getAppid(), evt.getXid(), evt.getRequestId());
    }

    private void redoBeginTxn(int tid, String uid, String appid, Object xid, long requestId) {
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoBeginTxn tid= " + tid);
        }
        Transaction t = new Transaction(tid, AddrUtil.stringToClientId(uid, appid), uid, appid, xid, true);
        t.setRequestId(requestId);
        this.addTxn(t);
    }

    void redoSync(SyncTxnEvt evt, boolean cloneAcks) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoSync tid= " + evt.getTid() + " state= " + evt.getState());
        }
        Transaction txn = new Transaction(evt, cloneAcks);
        this.addTxn(txn);
        this.setNextChainedTransactionLink(txn);
    }

    void redoCommit(TxnCommitEvt evt) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoCommit tid= " + tid);
        }
        try {
            Transaction t = this.getTxn(tid);
            t.redoCommit(evt);
            this.removeTxn(t, false);
            if (this.DEBUG) {
                this.debug("redoCommit: removed transaction " + t + " seqno= " + t.getLastMsgSeqNo());
            }
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    void redoPrecommit(TxnPrecommitEvt evt, boolean cloneAcks) {
        int tid = evt.getTid();
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoPreCommit tid= " + tid);
        }
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        try {
            this.getTxn(tid).redoPrecommit(evt, cloneAcks);
        }
        catch (ETxnNotFound e) {
            // empty catch block
        }
    }

    void redoPrepare(TxnPrepareEvt evt, boolean cloneAcks) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        try {
            this.getTxn(tid).redoPrepare(evt, cloneAcks);
        }
        catch (ETxnNotFound e) {
            // empty catch block
        }
    }

    void redoJoin(GlobalTxnJoinEvt evt) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        try {
            this.getTxn(tid).redoJoin(evt);
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    void redoEnd(GlobalTxnEndEvt evt) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        try {
            this.getTxn(tid).redoEnd(evt);
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    void redoSuspend(GlobalTxnSuspendEvt evt) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        try {
            this.getTxn(tid).redoSuspend(evt);
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    void redoResume(GlobalTxnResumeEvt evt) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        try {
            this.getTxn(tid).redoResume(evt);
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    void redoAbort(TxnAbortEvt evt) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoAbort tid= " + tid);
        }
        try {
            Transaction t = this.getTxn(tid);
            t.redoAbort(evt);
            this.removeTxn(t, false);
            if (this.DEBUG) {
                this.debug("redoAbort: removed transaction " + t + " seqno= " + t.getLastMsgSeqNo());
            }
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    void redoAbortBegin(TxnAbortBeginEvt evt) {
        int tid = evt.getTid();
        if (tid >= this.m_nextTid) {
            this.m_nextTid = tid + 1;
        }
        if ((this.debugFlags & 0x1000) > 0) {
            this.debug("redoAbortBegin tid= " + tid);
        }
        try {
            Transaction t = this.getTxn(tid);
            t.redoAbortBegin(evt);
            if (this.DEBUG) {
                this.debug("redoAbortBegin: removed transaction " + t + " seqno= " + t.getLastMsgSeqNo());
            }
        }
        catch (ETxnNotFound eTxnNotFound) {
            // empty catch block
        }
    }

    void redoNoDupCommitBeg(NoDupCommitBegEvt evt) {
        try {
            Transaction t = this.getTxn(evt.getTid());
            t.startNoDupCommit(evt.getNoDupCommitId(), evt.getTimestamp(), evt.isChannel(), evt.getChannelStatus(), evt.getChannelId(), evt.getLifespan(), evt.getRequestId(), evt.getChained());
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    void redoReplyAck(ReplyAckEvt evt) {
        this.processReplyAck(evt.getId(), evt.getRequestId());
    }

    int resolveRecoveredMsg(int tid, IMgram m) {
        Transaction tx = null;
        try {
            tx = this.getTxn(tid);
            if (tx.isPrepared()) {
                return 3;
            }
            if (tx.isPrecommitted()) {
                return 4;
            }
            if (tx.isCommitted()) {
                return 1;
            }
            if (tx.isNew() || tx.isEnded() || tx.isSuspended() || tx.isInNoDupCommitBeg()) {
                boolean isXonce = false;
                try {
                    IClientContext ownerCtx = this.m_reg.getClient(tx.getOwner());
                    isXonce = ownerCtx.isXOnce();
                }
                catch (EClientNotRegistered e) {
                    // empty catch block
                }
                if (isXonce) {
                    return 3;
                }
                return 2;
            }
            if ((this.debugFlags & 0x1000) > 0) {
                this.debug("resolveRecoveredMsg: tid= " + tx.getTid() + " txstate= " + tx.getStatus());
            }
            return 2;
        }
        catch (ETxnNotFound e) {
            return 5;
        }
    }

    public void setRecoveredTxSeqno(int tid, int tidpubseqno) {
        block2: {
            try {
                this.getTxn(tid).setLastMsgSeqNo(tidpubseqno);
            }
            catch (ETxnNotFound e) {
                if (!this.DEBUG || tidpubseqno <= 0) break block2;
                this.debug("setRecoveredTxSeqno tid not found; tid= " + tid + " tidseqno= " + tidpubseqno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int finishRecovery() throws InterruptedException {
        LinkedList txnlist = new LinkedList();
        int count = 0;
        int precommitted = 0;
        int undone = 0;
        int prepared = 0;
        int completed = 0;
        ReplicationManager repMgr = this.m_reg.getReplicationManager();
        if (repMgr != null) {
            repMgr.getTxnFileReplicationMgr().closeAllReplicatedFiles();
        }
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            Enumeration enu = this.m_txns.elements();
            while (enu.hasMoreElements()) {
                txnlist.append(enu.nextElement());
            }
        }
        Enumeration enu = txnlist.elements();
        boolean xoClient = false;
        while (enu.hasMoreElements()) {
            Transaction t = (Transaction)enu.nextElement();
            ++count;
            IClientContext cc = null;
            try {
                cc = this.m_reg.getClient(t.getOwner());
            }
            catch (EClientNotRegistered cnr) {
                // empty catch block
            }
            boolean bl = xoClient = cc != null && cc.isXOnce();
            if (xoClient && !t.isInNoDupCommitBeg() && t.getRequestId() != 0L) {
                cc.rcvdXORequest(t.getRequestId(), null);
            }
            if (t.isPrecommitted()) {
                t.initializeRuntimeState();
                this.doAsyncOp(t, (short)3);
                ++precommitted;
                if ((this.debugFlags & 0x1000) <= 0) continue;
                this.debug("finishRecovery: enqueued Precommitted transaction for recommit " + t + " seqno= " + t.getLastMsgSeqNo());
                continue;
            }
            if (t.isAborted() || t.isCommitted()) {
                if (xoClient) {
                    if (!t.getChained()) {
                        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(t.getReplyStatus(), -1, (int)t.getRequestId(), cc.getChannel());
                        cc.prepareXOReply(t.getRequestId(), reply);
                    } else if (t.getNextTid() == -1) {
                        try {
                            RequestContext.push(true, (int)t.getRequestId(), false);
                            RequestContext.setReplyStatus(t.getReplyStatus());
                            int nextTid = this.internalBeginTxn(true, t.getTid(), t.getOwnerUid(), t.getOwnerAppid());
                            long tte = -1L;
                            IMgram reply = this.buildRecoveredReply(t, tte, nextTid, cc.getChannel());
                            cc.prepareXOReply(t.getRequestId(), reply);
                        }
                        finally {
                            RequestContext.pop();
                        }
                    }
                }
                this.removeTxn(t);
                ++completed;
                if ((this.debugFlags & 0x1000) <= 0) continue;
                this.debug("finishRecovery: removing completed transaction " + t + " state= " + t.getStatus() + " seqno= " + t.getLastMsgSeqNo());
                continue;
            }
            if (t.isInNoDupCommitBeg()) {
                if (!NoDupDetectDb.isEnabled()) continue;
                try {
                    if (this.m_ndConnection == null) {
                        this.m_ndConnection = NoDupDetectDb.getConnection();
                    }
                    this.m_ndConnection.delete(t.getNoDupCommitId(), t.getNoDupTimestamp());
                    t.undoNoDupCommitBegin();
                    if (xoClient) {
                        t.initializeRuntimeState();
                        continue;
                    }
                    t.undo();
                    this.removeTxn(t);
                    ++undone;
                    if ((this.debugFlags & 0x1000) <= 0) continue;
                    this.debug("finishRecovery: removing undone transaction " + t + " state= " + t.getStatus() + " seqno= " + t.getLastMsgSeqNo());
                }
                catch (Exception e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                continue;
            }
            if (t.isEnded() || t.isSuspended() || t.isNew()) {
                if (xoClient) {
                    t.checkForGoodTxnFileContent();
                    long tte = -1L;
                    IMgram reply = this.buildRecoveredReply(t, tte, t.getTid(), cc.getChannel());
                    cc.prepareXOReply(t.getRequestId(), reply);
                    this.startWatchdog(t);
                    t.initializeRuntimeState();
                    continue;
                }
                t.undo();
                this.removeTxn(t);
                ++undone;
                if ((this.debugFlags & 0x1000) <= 0) continue;
                this.debug("finishRecovery: removing undone transaction " + t + " state= " + t.getStatus() + " seqno= " + t.getLastMsgSeqNo());
                continue;
            }
            if (t.isPrepared()) {
                if (xoClient) {
                    IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(t.getReplyStatus(), t.getTid(), (int)t.getRequestId(), cc.getChannel());
                    cc.prepareXOReply(t.getRequestId(), reply);
                }
                this.addPreparedXAmsgs(t);
                t.initializeRuntimeState();
                ++prepared;
                if ((this.debugFlags & 0x1000) <= 0) continue;
                this.debug("finishRecovery: prepared transaction " + t + " seqno= " + t.getLastMsgSeqNo());
                continue;
            }
            throw new EAssertFailure("Can't finish recovery of txn - unrecognized state " + t.getStatus() + ", tid " + t.getTid());
        }
        if (this.DEBUG1) {
            this.debug("TransactionManager.finishRecovery: transactions after log replay = " + count);
            this.debug("TransactionManager.finishRecovery: completed = " + completed);
            this.debug("TransactionManager.finishRecovery: to be recommitted = " + precommitted);
            this.debug("TransactionManager.finishRecovery: undone (discarded) = " + undone);
            this.debug("TransactionManager.finishRecovery: prepared = " + prepared);
        }
        return precommitted;
    }

    private IMgram buildRecoveredReply(Transaction t, long tte, int nextTid, int channel) {
        if (t.getReplyStatus() == 13) {
            long ttl = tte - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 0L;
            }
            return MgramFactory.getMgramFactory().buildTxnActiveReply(ttl, nextTid, (int)t.getRequestId(), channel);
        }
        return MgramFactory.getMgramFactory().buildTxnReply(t.getReplyStatus(), nextTid, (int)t.getRequestId(), channel);
    }

    private void addPreparedXAmsgs(Transaction txn) {
        if (this.DEBUG1) {
            this.debug("############# in addPreparedXAmsgs ");
        }
        if (!txn.isXAtransaction() || !txn.isPrepared()) {
            return;
        }
        if (this.m_preparedXAmsgTable == null) {
            this.m_preparedXAmsgTable = new Hashtable();
        }
        Integer tidObj = new Integer(txn.getTid());
        Hashtable preparedMsgs = txn.getMsgTrackings();
        this.m_preparedXAmsgTable.put(tidObj, preparedMsgs);
    }

    private void removePreparedXAmsgs(Transaction txn) {
        if (this.m_preparedXAmsgTable == null) {
            return;
        }
        this.m_preparedXAmsgTable.remove(new Integer(txn.getTid()));
    }

    boolean isMsgInPreparedXATxn(long tracking, String localQname) {
        if (this.m_preparedXAmsgTable == null) {
            return false;
        }
        boolean msgIsInDoubt = false;
        Long trackingObj = new Long(tracking);
        Enumeration enu = this.m_preparedXAmsgTable.elements();
        while (enu.hasMoreElements()) {
            Hashtable preparedMsgs = (Hashtable)enu.nextElement();
            if (preparedMsgs == null || !preparedMsgs.containsKey(trackingObj)) continue;
            msgIsInDoubt = true;
            preparedMsgs.put(trackingObj, localQname);
            if (!this.DEBUG1) break;
            this.debug("localQueueName = " + localQname);
            break;
        }
        if (this.DEBUG1) {
            this.debug("tracking = " + tracking + " isMsgInDoubt = " + msgIsInDoubt);
        }
        return msgIsInDoubt;
    }

    String getLocalQueueName(int tid, long tracking) {
        if (this.m_preparedXAmsgTable == null) {
            return null;
        }
        Hashtable trackingTable = (Hashtable)this.m_preparedXAmsgTable.get(new Integer(tid));
        if (trackingTable == null) {
            return null;
        }
        return (String)trackingTable.get(new Long(tracking));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTxnInfo(DataOutput out, boolean preparedOnly) throws IOException {
        Enumeration enu;
        LinkedList txnlist = new LinkedList();
        IndexedList indexedList = this.m_txns;
        synchronized (indexedList) {
            enu = this.m_txns.elements();
            while (enu.hasMoreElements()) {
                txnlist.append(enu.nextElement());
            }
        }
        Transaction t = null;
        enu = txnlist.elements();
        while (enu.hasMoreElements() && (t = (Transaction)enu.nextElement()) != null) {
            if (preparedOnly && !t.isPrepared() || t.isCompleted()) continue;
            t.writeAdminInfo(out);
        }
    }

    void processRequestReply(IMgram request) {
        switch (request.getType()) {
            case 8: {
                this.processRequest(request);
                break;
            }
            case 26: {
                try {
                    this.processExtendedTxnRequest(request);
                }
                catch (EXAInvalidOperationException e) {
                    BrokerComponent.getComponentContext().logMessage("invalid XA operation in EXTENDED_TXN_REQUEST_TYPE case: " + e.getMessage(), (Throwable)e, 2);
                }
                break;
            }
            default: {
                EUnexpectedMgram e = new EUnexpectedMgram(request);
                BrokerComponent.getComponentContext().logMessage("unexpected request Mgram in processRequestReply: " + e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(IMgram request) {
        ITXNRequestHandle handle = request.getTXNRequestHandle();
        int requestType = handle.getType();
        try {
            RequestContext.push(handle.isXonce(), handle.getReplyTracking(), handle.isChained());
            if (requestType == MgramConstants.TX_REQUEST_COMMIT_SUBTYPE) {
                this.processCommitRequest(handle);
            } else if (requestType == MgramConstants.TX_REQUEST_COMMIT_NO_DUP_SUBTYPE || requestType == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE) {
                this.processCommitNoDupRequest(handle);
            } else if (requestType == MgramConstants.TX_REQUEST_ABORT_SUBTYPE) {
                this.processAbortRequest(handle);
            } else if (requestType == MgramConstants.TX_REQUEST_BEGIN_SUBTYPE) {
                this.processBeginRequest(handle);
            } else if (requestType == MgramConstants.TX_REQUEST_UPDATE_CHANNEL_NO_DUP_SUBTYPE) {
                this.processUpdateNoDupRequest(handle);
            } else if (requestType == MgramConstants.TX_REQUEST_DELETE_CHANNEL_NO_DUP_SUBTYPE) {
                this.processDeleteNoDupRequest(handle);
            }
        }
        finally {
            RequestContext.pop();
        }
    }

    private void processBeginRequest(ITXNRequestHandle handle) {
        short status = 0;
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        int tid = -1;
        try {
            tid = this.beginTxn(clientCtx.getUid(), clientCtx.getAppid());
            status = 0;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, tid, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processAbortRequest(ITXNRequestHandle handle) {
        short status = 0;
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        int newTx = 0;
        try {
            this.abort(handle.getTID(), AddrUtil.clientIdToUid(handle.getClientId()));
            status = 0;
            if (handle.isChained()) {
                newTx = this.m_reg.getTransactionMgr().beginTxn(clientCtx.getUid(), clientCtx.getAppid());
            }
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (ETxnAccessViolation e) {
            status = 6;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, newTx, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processCommitNoDupRequest(ITXNRequestHandle handle) {
        int status = 0;
        boolean commitSuccess = false;
        boolean aborted = false;
        long activeTTL = 0L;
        try {
            int state = 14;
            String channelId = "";
            boolean isChannel = false;
            if (handle.getType() == MgramConstants.TX_REQUEST_COMMIT_CHANNEL_NO_DUP_SUBTYPE) {
                state = handle.getChannelState();
                channelId = handle.getChannelID();
                isChannel = true;
            }
            CommitResult result = this.commit(handle.getTID(), AddrUtil.clientIdToUid(handle.getClientId()), handle.getTransactionId(), handle.getLifespan(), isChannel, state, channelId);
            int stat = result.getResult();
            switch (stat) {
                case 0: {
                    status = 0;
                    commitSuccess = true;
                    break;
                }
                case 14: {
                    status = 7;
                    aborted = true;
                    break;
                }
                case 13: {
                    status = 13;
                    activeTTL = result.getTimeStamp() - System.currentTimeMillis();
                    aborted = true;
                }
            }
        }
        catch (EDatabaseException e) {
            status = 8;
            aborted = true;
        }
        catch (EInvalidConfiguration e) {
            status = 10;
            aborted = true;
        }
        catch (IllegalArgumentException e) {
            status = 9;
            aborted = true;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (ETxnAborted e) {
            status = 4;
        }
        catch (ETxnAccessViolation e) {
            status = 6;
        }
        catch (EGeneralException e) {
            status = 5;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        int newTx = -1;
        try {
            IClientContext clientCtx = this.m_reg.getClient(handle.getClientId());
            if ((commitSuccess || aborted) && handle.isChained()) {
                newTx = this.m_reg.getTransactionMgr().beginTxn(clientCtx.getUid(), clientCtx.getAppid());
            }
            IMgram reply = status == 13 ? MgramFactory.getMgramFactory().buildTxnActiveReply(activeTTL, newTx, handle.getReplyTracking(), clientCtx.getChannel()) : MgramFactory.getMgramFactory().buildTxnReply((short)status, newTx, handle.getReplyTracking(), clientCtx.getChannel());
            clientCtx.sendReply(handle.getReplyTracking(), reply);
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
    }

    private void processCommitRequest(ITXNRequestHandle handle) {
        short status = 0;
        try {
            this.commit(handle.getTID(), AddrUtil.clientIdToUid(handle.getClientId()));
            status = 0;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (ETxnAborted e) {
            status = 4;
        }
        catch (ETxnAccessViolation e) {
            status = 6;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        this.postCommit(handle.getClientId(), handle.getTID(), status, handle.isChained(), handle.getReplyTracking(), null);
    }

    private void postCommit(long clientId, int tid, short status, boolean chained, int replyTracking, Object xid) {
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(clientId);
        }
        catch (EClientNotRegistered e) {
            return;
        }
        int newTx = 0;
        if (status == 0 && chained) {
            String uid = clientCtx.getUid();
            String appid = clientCtx.getAppid();
            try {
                newTx = xid == null ? this.beginTxn(tid, uid, appid) : this.beginTxn(uid, appid, xid);
            }
            catch (InterruptedException ie) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ie, 2);
                Thread.currentThread().interrupt();
                return;
            }
            catch (EXADuplicateXidException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, newTx, replyTracking, clientCtx.getChannel());
        clientCtx.sendReply(replyTracking, reply);
    }

    private void processXACommit(IExtendedTXNRequestHandle handle) {
        short status = 0;
        try {
            this.commitTxn(handle.getTID(), handle.getXid(), handle.getClientId());
            status = 0;
        }
        catch (EXAThereIsNoXidException e) {
            status = 12;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (ETxnAborted e) {
            status = 4;
        }
        catch (ETxnAccessViolation e) {
            status = 6;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        this.postCommit(handle.getClientId(), handle.getTID(), status, handle.isChained(), handle.getReplyTracking(), handle.getXid());
    }

    private void processUpdateNoDupRequest(ITXNRequestHandle handle) {
        int status = 0;
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
            if (NoDupDetectDb.isEnabled()) {
                int result;
                if (this.m_ndConnection == null) {
                    this.m_ndConnection = NoDupDetectDb.getConnection();
                }
                status = (result = this.m_ndConnection.updateChannelRecord(handle.getTransactionId(), handle.getLifespan(), handle.getChannelState(), handle.getChannelID())) == 0 ? 15 : 0;
            } else {
                status = 10;
            }
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        catch (EDatabaseException e) {
            status = 8;
        }
        catch (EInvalidConfiguration e) {
            status = 10;
        }
        catch (IllegalArgumentException e) {
            status = 9;
        }
        catch (EGeneralException e) {
            status = 5;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply((short)status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processDeleteNoDupRequest(ITXNRequestHandle handle) {
        int status = 0;
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
            if (NoDupDetectDb.isEnabled()) {
                int result;
                if (this.m_ndConnection == null) {
                    this.m_ndConnection = NoDupDetectDb.getConnection();
                }
                status = (result = this.m_ndConnection.deleteChannelRecord(handle.getTransactionId(), handle.getChannelID())) == 0 ? 15 : 0;
            } else {
                status = 10;
            }
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        catch (EDatabaseException e) {
            status = 8;
        }
        catch (EInvalidConfiguration e) {
            status = 10;
        }
        catch (IllegalArgumentException e) {
            status = 9;
        }
        catch (EGeneralException e) {
            status = 5;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply((short)status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processExtendedTxnRequest(IMgram request) throws EXAInvalidOperationException {
        IExtendedTXNRequestHandle handle = request.getExtendedTXNRequestHandle();
        try {
            RequestContext.push(handle.isXonce(), handle.getReplyTracking(), handle.isChained());
            int op = handle.getOp();
            switch (op) {
                case 0: {
                    this.processXAStart(handle);
                    return;
                }
                case 1: {
                    this.processXAEnd(handle);
                    return;
                }
                case 2: {
                    this.processXAPrepare(handle);
                    return;
                }
                case 3: {
                    this.processXACommit(handle);
                    return;
                }
                case 4: {
                    this.processXAJoin(handle);
                    return;
                }
                case 6: {
                    this.processXASuspend(handle);
                    return;
                }
                case 5: {
                    this.processXAResume(handle);
                    return;
                }
                case 7: {
                    this.processXAAbort(handle);
                    return;
                }
                default: {
                    throw new EXAInvalidOperationException("the operation is not suppported in extended txn Request: " + op);
                }
            }
        }
        finally {
            RequestContext.pop();
        }
    }

    private void processXAStart(IExtendedTXNRequestHandle handle) {
        short status = 0;
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        int tid = -1;
        try {
            tid = this.beginTxn(clientCtx.getUid(), clientCtx.getAppid(), handle.getXid());
            status = 0;
        }
        catch (EXADuplicateXidException e) {
            status = 11;
        }
        catch (InterruptedException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            Thread.currentThread().interrupt();
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, tid, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processXAEnd(IExtendedTXNRequestHandle handle) {
        short status = 0;
        try {
            this.endTxn(handle.getTID(), handle.getXid());
            status = 0;
        }
        catch (EXAThereIsNoXidException e) {
            status = 12;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processXAPrepare(IExtendedTXNRequestHandle handle) {
        short status = 0;
        try {
            this.prepareTxn(handle.getTID(), handle.getXid(), handle.getClientId());
            status = 0;
        }
        catch (EXAThereIsNoXidException e) {
            status = 12;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (ETxnAborted e) {
            status = 4;
        }
        catch (ETxnAccessViolation e) {
            status = 6;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processXAJoin(IExtendedTXNRequestHandle handle) {
        short status = 0;
        try {
            this.joinTxn(handle.getXid(), handle.getTID());
            status = 0;
        }
        catch (EXAThereIsNoXidException e) {
            status = 12;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processXASuspend(IExtendedTXNRequestHandle handle) {
        short status = 0;
        try {
            this.suspendTxn(handle.getTID(), handle.getXid());
            status = 0;
        }
        catch (EXAThereIsNoXidException e) {
            status = 12;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processXAResume(IExtendedTXNRequestHandle handle) {
        short status = 0;
        try {
            this.resumeTxn(handle.getXid(), handle.getTID());
            status = 0;
        }
        catch (EXAThereIsNoXidException e) {
            status = 12;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    private void processXAAbort(IExtendedTXNRequestHandle handle) {
        short status = 0;
        try {
            this.abortTxn(handle.getTID(), handle.getXid(), handle.getClientId());
            status = 0;
        }
        catch (EXAThereIsNoXidException e) {
            status = 12;
        }
        catch (ETxnNotFound e) {
            status = 2;
        }
        catch (ETxnSequenceError e) {
            status = 3;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            return;
        }
        IClientContext clientCtx = null;
        try {
            clientCtx = this.m_reg.getClient(handle.getClientId());
        }
        catch (EClientNotRegistered e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return;
        }
        IMgram reply = MgramFactory.getMgramFactory().buildTxnReply(status, -1, handle.getReplyTracking(), clientCtx.getChannel());
        clientCtx.sendReply(handle.getReplyTracking(), reply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxnAsyncOp doAsyncOp(Transaction t, short opcode) {
        TxnAsyncOp op = new TxnAsyncOp(t, opcode);
        LinkedList linkedList = this.m_asyncOps;
        synchronized (linkedList) {
            this.m_asyncOps.append(op);
            ++this.m_numQueuedOps;
            this.m_asyncOps.notifyAll();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxnAsyncOp doAsyncFlushOp(Transaction t, short opcode) {
        TxnAsyncOp op = new TxnAsyncOp(t, opcode);
        LinkedList linkedList = this.m_asyncFlushOps;
        synchronized (linkedList) {
            this.m_asyncFlushOps.append(op);
            ++this.m_numQueuedFlushOps;
            this.m_asyncFlushOps.notifyAll();
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxnAsyncOp doRequestOp(IMgram request) {
        TxnRequestOp op = new TxnRequestOp(request, 6);
        this.xonceRequestArrivalInterceptor(request);
        LinkedList linkedList = this.m_requestOps;
        synchronized (linkedList) {
            this.m_requestOps.append(op);
            ++this.m_numQueuedRequestOps;
            this.m_requestOps.notifyAll();
        }
        return op;
    }

    void xonceRequestArrivalInterceptor(IMgram m) {
        Object handle;
        boolean xo = false;
        long cid = 0L;
        long lTrk = 0L;
        if (m.getType() == 8) {
            handle = m.getTXNRequestHandle();
            xo = handle.isXonce();
            cid = handle.getClientId();
            lTrk = (long)handle.getReplyTracking() & 0xFFFFFFFFL;
        } else if (m.getType() == 26) {
            handle = m.getExtendedTXNRequestHandle();
            xo = handle.isXonce();
            cid = handle.getClientId();
            lTrk = (long)handle.getReplyTracking() & 0xFFFFFFFFL;
        }
        if (xo) {
            IClientContext clientCtx = null;
            try {
                clientCtx = this.m_reg.getClient(cid);
            }
            catch (EClientNotRegistered e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                return;
            }
            clientCtx.rcvdXORequest(lTrk, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TxnAsyncOp nextAsyncOp(int id) throws InterruptedException {
        TxnAsyncOp op;
        if (id == 0) {
            LinkedList linkedList = this.m_asyncOps;
            synchronized (linkedList) {
                while ((op = (TxnAsyncOp)this.m_asyncOps.dequeue()) == null) {
                    this.m_asyncOps.wait();
                }
                --this.m_numQueuedOps;
                if (this.DEBUG) {
                    this.debug("got async op; qsize= " + this.m_numQueuedOps);
                }
            }
        }
        if (id <= Config.TXN_FLUSH_THREADS) {
            LinkedList linkedList = this.m_asyncFlushOps;
            synchronized (linkedList) {
                while ((op = (TxnAsyncOp)this.m_asyncFlushOps.dequeue()) == null) {
                    this.m_asyncFlushOps.wait();
                }
                --this.m_numQueuedFlushOps;
                if (this.DEBUG) {
                    this.debug("got async flush op; qsize= " + this.m_numQueuedFlushOps);
                }
            }
        }
        LinkedList linkedList = this.m_requestOps;
        synchronized (linkedList) {
            while ((op = (TxnAsyncOp)this.m_requestOps.dequeue()) == null) {
                this.m_requestOps.wait();
            }
            --this.m_numQueuedRequestOps;
            if (this.DEBUG) {
                this.debug("got request-reply op; qsize= " + this.m_numQueuedRequestOps);
            }
        }
        return op;
    }

    static int deleteAllTxnFiles() {
        int result = 0;
        try {
            File fdir = new File(Config.TXN_FILE_PATH);
            if (!fdir.exists()) {
                return result;
            }
            File[] files = fdir.listFiles();
            if (files != null) {
                for (File f : files) {
                    boolean rc;
                    if (!f.getName().startsWith("Txn") || !(rc = f.delete())) continue;
                    ++result;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    class TxThread
    extends DebugThread {
        private int m_id;
        private String m_name;

        TxThread(int id, String name) {
            super("TxThread " + name + id);
            this.m_id = 0;
            this.m_name = null;
            this.m_id = id;
            this.m_name = name;
            this.setName("TxThread " + name + id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() throws InterruptedException {
            block41: {
                if (this.DEBUG) {
                    this.debug("starting " + this.m_name + this.m_id);
                }
                block31: while (true) {
                    try {
                        while (!Broker.exiting && !this.isShuttingDown()) {
                            TxnAsyncOp op = null;
                            op = TransactionMgr.this.nextAsyncOp(this.m_id);
                            short opcode = op.getOpcode();
                            if (this.DEBUG) {
                                this.debug("Got async op " + opcode + " Txn= " + op.getTxn());
                            }
                            try {
                                switch (opcode) {
                                    case 4: {
                                        TxnAsyncOp txnAsyncOp = op;
                                        synchronized (txnAsyncOp) {
                                            op.setCompleted();
                                            op.notifyAll();
                                            break;
                                        }
                                    }
                                    case 5: {
                                        IClientContext cc = null;
                                        try {
                                            cc = TransactionMgr.this.m_reg.getClient(op.getTxn().getOwner());
                                        }
                                        catch (EClientNotRegistered cnr) {
                                            // empty catch block
                                        }
                                        if (cc == null) break;
                                        try {
                                            Message msg = new Message();
                                            msg.setSubject("$SYS.TRANSACTION.IDLE_TIMEOUT");
                                            TransactionMgr.this.m_adminSession.directedPublish(cc.getId(), msg, (byte)12, 0, false);
                                        }
                                        catch (EGeneralException ege) {
                                            if (Broker.isInShutdown()) continue block31;
                                            BrokerComponent.getComponentContext().logMessage((Throwable)ege, 2);
                                        }
                                        break;
                                    }
                                    case 1: {
                                        op.getTxn().flushMsgs();
                                        break;
                                    }
                                    case 2: 
                                    case 3: {
                                        Transaction t = op.getTxn();
                                        IClientContext cc = null;
                                        try {
                                            cc = TransactionMgr.this.m_reg.getClient(op.getTxn().getOwner());
                                        }
                                        catch (EClientNotRegistered cnr) {
                                            // empty catch block
                                        }
                                        boolean xo = cc != null && cc.isXOnce();
                                        RequestContext.push(xo, (int)t.getRequestId(), t.getChained());
                                        RequestContext.setReplyStatus(t.getReplyStatus());
                                        try {
                                            t.commit(opcode == 3);
                                            if (xo && !t.getChained()) {
                                                long tte = -1L;
                                                IMgram reply = TransactionMgr.this.buildRecoveredReply(t, tte, -1, cc.getChannel());
                                                cc.prepareXOReply(t.getRequestId(), reply);
                                            } else if (xo) {
                                                int nextTid = TransactionMgr.this.internalBeginTxn(true, t.getTid(), t.getOwnerUid(), t.getOwnerAppid());
                                                long tte = -1L;
                                                IMgram reply = TransactionMgr.this.buildRecoveredReply(t, tte, nextTid, cc.getChannel());
                                                cc.prepareXOReply(t.getRequestId(), reply);
                                            }
                                        }
                                        finally {
                                            RequestContext.pop();
                                        }
                                        if (this.DEBUG) {
                                            this.debug("Committed " + t);
                                        }
                                        TransactionMgr.this.removeTxn(t);
                                        break;
                                    }
                                    case 6: {
                                        TransactionMgr.this.processRequestReply(((TxnRequestOp)op).getRequest());
                                    }
                                }
                                continue block31;
                            }
                            catch (EBrokerTxnFailure e) {
                                switch (opcode) {
                                    case 1: {
                                        BrokerComponent.getComponentContext().logMessage("Flush of transaction " + op.getTxn().getTid() + " failed: " + e.getMessage(), (Throwable)e, 2);
                                        continue block31;
                                    }
                                    case 2: {
                                        BrokerComponent.getComponentContext().logMessage("COMMIT of transaction " + op.getTxn().getTid() + " failed: " + e.getMessage(), (Throwable)e, 2);
                                        continue block31;
                                    }
                                    case 3: {
                                        BrokerComponent.getComponentContext().logMessage("RECOMMIT of transaction " + op.getTxn().getTid() + " failed: " + e.getMessage(), (Throwable)e, 2);
                                        continue block31;
                                    }
                                }
                                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                            }
                        }
                        break block41;
                    }
                    catch (InterruptedException ie) {
                        if (!Broker.exiting) {
                            throw ie;
                        }
                        break block41;
                    }
                    break;
                }
                finally {
                    if (this.DEBUG) {
                        this.debug("threadMain: Thread exiting, broker exiting = " + Broker.exiting);
                    }
                }
            }
        }
    }
}

