/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EIPAddressLimitExceeded;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.IClientContext;
import progress.message.broker.prAccessor;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EGeneralException;
import progress.message.client.ESessionLimitExceeded;
import progress.message.client.ESocketIdMismatch;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.EUserAlreadyConnectedPendingReconnect;
import progress.message.util.DebugState;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IErrorCodes;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.SessionConfig;

public final class TunnelingChannel
extends DebugObject
implements IMessageHandler,
IErrorCodes {
    private AgentRegistrar m_reg;
    private boolean DEBUG1;
    private boolean DEBUG0;

    TunnelingChannel(AgentRegistrar reg) {
        super(DebugState.GLOBAL_DEBUG_ON ? "TunnelingChannel" : null);
        this.m_reg = reg;
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.DEBUG0 = (this.debugFlags & 0x20) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Session s, Envelope env) {
        boolean replied = false;
        String uid = null;
        String appid = null;
        try {
            ClientSecurityContext csc;
            Object criticalConnectRegionLock;
            AgentConnection ac;
            IClientContext cc;
            Message req = env.getMessage();
            long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
            long socketId = req.readLong();
            uid = req.readUTF();
            appid = req.readUTF();
            int channel = req.readInt();
            long parentID = req.readLong();
            if (this.DEBUG1) {
                String requestordata = null;
                try {
                    IClientContext requestorcc = this.m_reg.getClient(requestor);
                    requestordata = requestorcc.getUid() + "/" + requestorcc.getAppid();
                }
                catch (Exception e) {
                    this.debug("requestor not available error = " + e.getMessage(), e);
                }
                this.debug("in handleMessage()\n requestorid = " + requestor + " requestor = " + requestordata + "\n new channel = " + channel + " new channel uid = " + uid + " new channel appid = " + appid);
            }
            if ((cc = this.m_reg.getClient(requestor)) == null) {
                throw new Exception(prAccessor.getString("STR267"));
            }
            short flags = 0;
            short ackMode = 0;
            if (cc.getClientSessionVer() >= 25) {
                flags = req.readShort();
            }
            if (cc.getClientSessionVer() >= 26) {
                ackMode = req.readShort();
            }
            if ((ac = cc.getConnection()) == null) {
                throw new Exception(prAccessor.getString("STR268"));
            }
            if (ac.getSocketId() != socketId) {
                throw new ESocketIdMismatch(prAccessor.getString("STR269"));
            }
            if (!uid.equals(env.getMessage().getSubject().extractSubjectLevel(2))) {
                throw new Exception(prAccessor.getString("STR270"));
            }
            boolean resumed = (flags & 4) > 0;
            int dbLimitExc = flags & 3;
            if (this.DEBUG) {
                this.debug("uid= " + uid + " appid= " + appid + " dblimitexc= " + dbLimitExc + " flags= " + flags);
            }
            if (Config.MAX_SESSIONS_PER_CONNECTION > 0 && !resumed && ac.getJMSSessionCount() >= Config.MAX_SESSIONS_PER_CONNECTION && appid.indexOf("$SESSION$") != -1) {
                throw new ESessionLimitExceeded(prAccessor.getString("MAX_SESSION_LIMIT_ERROR") + Config.MAX_SESSIONS_PER_CONNECTION);
            }
            Object object = criticalConnectRegionLock = ac.getAgentListener().getCriticalConnectRegionLock();
            synchronized (object) {
                csc = ac.getAgentListener().newChannelConnection(channel, uid, appid, parentID, resumed, ackMode, dbLimitExc);
            }
            if (this.DEBUG1) {
                this.debug("handleMessage() successful \n new channel = " + channel + " new channel uid = " + uid + " new channel appid = " + appid);
            }
            try {
                s.reply(this.makeSuccessResponse(csc), env);
            }
            catch (IOException e) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            }
            replied = true;
        }
        catch (EUserAlreadyConnected e) {
            try {
                this.debug("handleMessage() received " + e + " for " + uid + "/" + appid, e);
                int errCode = e instanceof EUserAlreadyConnectedPendingReconnect ? -40 : -17;
                boolean collision = false;
                try {
                    long ccid = SessionConfig.stringToClientId(uid, appid);
                    IClientContext conflictcc = this.m_reg.getClient(ccid);
                    if (!conflictcc.getUid().equals(uid) || !conflictcc.getAppid().startsWith(appid)) {
                        if (this.DEBUG0) {
                            this.debug("handleMessage() clientid collision detected with\n" + conflictcc.getUid() + "/" + conflictcc.getAppid() + "/" + conflictcc.getId() + "\nand this client " + uid + "/" + appid + "/" + ccid);
                        }
                        collision = true;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (collision) {
                    s.reply(this.makeClientIDCollisionFailureResponse(errCode, e.toString(), collision), env);
                } else {
                    s.reply(this.makeFailureResponse(errCode, e.toString()), env);
                }
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            }
            replied = true;
        }
        catch (EIPAddressLimitExceeded e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received EIPAddressLimitExceeded: " + e.toString(), e);
            }
            try {
                s.reply(this.makeFailureResponse(-35, e.toString()), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            }
            replied = true;
        }
        catch (EConnectionLimitExceeded e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received EConnectionLimitExceeded: " + e.toString());
            }
            try {
                s.reply(this.makeFailureResponse(-18, e.toString()), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(ex.toString(), (Throwable)ex, 2);
            }
            replied = true;
        }
        catch (ESessionLimitExceeded e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received ESessionLimitExceeded: " + e.toString());
            }
            try {
                s.reply(this.makeFailureResponse(-41, e.getMessage()), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(ex.toString(), (Throwable)ex, 2);
            }
            replied = true;
        }
        catch (EClientNotRegistered e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received EClientNotRegistered: " + e.toString());
            }
            try {
                s.reply(this.makeFailureResponse(-33, "Client not registered."), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage(ioe.toString(), (Throwable)ioe, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
            }
            replied = true;
        }
        catch (InterruptedException e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received InterruptedException: " + e.toString());
            }
            try {
                s.reply(this.makeFailureResponse(-33, "Interrupted."), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
            }
            replied = true;
        }
        catch (EInvalidAdminAddress e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received EInvalidAdminAddress: " + e.toString(), e);
            }
            try {
                s.reply(this.makeFailureResponse(-33, "Invalid admin address."), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            }
            replied = true;
        }
        catch (ESocketIdMismatch e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received ESocketIdMismatch: " + e.toString(), e);
            }
            try {
                s.reply(this.makeFailureResponse(-38, e.toString()), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            }
            replied = true;
        }
        catch (EConnectFailure e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received EConnectFailure: " + e.toString(), e);
            }
            try {
                s.reply(this.makeFailureResponse(-23, e.toString()), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            }
            replied = true;
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            try {
                s.reply(this.makeFailureResponse(-33, e.toString()), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
            }
            replied = true;
        }
        catch (IOException e) {
            if (this.DEBUG1) {
                this.debug("handleMessage() received IOException: " + e.toString());
            }
            try {
                s.reply(this.makeFailureResponse(-33, "IOException."), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
            }
            replied = true;
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            try {
                s.reply(this.makeFailureResponse(-33, e.toString()), env);
            }
            catch (IOException ioe) {
                if (!Broker.isInShutdown()) {
                    BrokerComponent.getComponentContext().logMessage(e.toString(), (Throwable)e, 2);
                }
            }
            catch (Exception ex) {
                BrokerComponent.getComponentContext().logMessage(ex.toString(), (Throwable)ex, 2);
            }
            replied = true;
        }
        finally {
            if (!replied) {
                try {
                    s.reply(this.makeFailureResponse(-33, "Unknown failure."), env);
                }
                catch (IOException e) {
                    if (!Broker.isInShutdown()) {
                        BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                    }
                }
                catch (Exception ex) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
                }
            }
        }
    }

    private Message makeSuccessResponse(ClientSecurityContext csc) {
        Message m = new Message();
        m.writeBoolean(true);
        try {
            csc.writeToStream(m, (short)-1);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return m;
    }

    private Message makeFailureResponse(int errcode, String s) {
        Message m = new Message();
        m.writeBoolean(false);
        m.writeInt(errcode);
        try {
            if (s == null || s.length() == 0) {
                m.writeUTF("Unable to create connection tunneling channel");
            } else {
                m.writeUTF(s);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return m;
    }

    private Message makeClientIDCollisionFailureResponse(int errcode, String s, boolean collision) {
        Message m = this.makeFailureResponse(errcode, s);
        m.writeByte(1);
        m.writeBoolean(collision);
        return m;
    }
}

