/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.LogInputStream;
import progress.message.broker.LogOutputStream;
import progress.message.broker.LogStreamFile;
import progress.message.broker.MgramSerializer;
import progress.message.broker.Transaction;
import progress.message.broker.TransactionMgr;
import progress.message.broker.TxMsg;
import progress.message.broker.TxnContentMgr;
import progress.message.ft.ReplicationManager;
import progress.message.ft.TxnFileReplicationMgr;
import progress.message.ft.TxnFileReplicationOutputStream;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.DebugState;
import progress.message.util.LinkedList;
import progress.message.util.StreamUtil;
import progress.message.util.server.LongHolder;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.xonce.IXOnceHandle;

public class TxnContentMgrFile
extends TxnContentMgr {
    private TransactionMgr s_txnmgr;
    private boolean m_txnFile = false;
    private boolean m_flushing = false;
    private LogStreamFile m_msgFile;
    private File m_msgFileName;
    private OutputStream m_os;
    private Vector m_storageAcks = null;
    private boolean m_insertSavePointOnNextFlush = false;
    public static final byte VERSION = 0;
    TxnFileReplicationOutputStream m_liveReplicationStream = null;

    TxnContentMgrFile(Transaction t) {
        super(t);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("TxnContentMgrFile " + t.getTid());
        }
        this.s_txnmgr = t.getTransactionMgr();
        this.m_storageAcks = new Vector();
        this.m_insertSavePointOnNextFlush = true;
        if (this.DEBUG) {
            this.debug("contructed ");
        }
    }

    TxnContentMgrFile(Transaction t, LinkedList msgQueue, int size) {
        super(t, msgQueue, size);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("TxnContentMgrFile " + t.getTid());
        }
        this.s_txnmgr = t.getTransactionMgr();
        this.m_storageAcks = new Vector();
        if (this.DEBUG) {
            this.debug("contructed with msgQueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addMsg(TxMsg m) {
        TxnContentMgrFile txnContentMgrFile = this;
        synchronized (txnContentMgrFile) {
            super.addMsg(m);
            if (!this.m_flushing && this.getMemoryQsize() > this.getTxn().getBufferSize()) {
                if (this.DEBUG) {
                    this.debug("flush in TxnContentMgrFile.addMsg tid: " + this.getTxn().getTid());
                }
                this.s_txnmgr.flush(this.getTxn());
                this.m_flushing = true;
                this.m_txnFile = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void finalizeMsgsBeforeEventFlush() throws IOException {
        if (this.DEBUG) {
            this.debug("finalizeMsgs:");
        }
        TxnContentMgrFile txnContentMgrFile = this;
        synchronized (txnContentMgrFile) {
            boolean interrupted = false;
            while (this.m_flushing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.flush(false, false, true);
            this.m_os.flush();
            if (!Config.EVALUATION_MODE && Config.LOG_FORCE_SYNC) {
                this.m_msgFile.sync();
                if (this.DEBUG) {
                    this.debug("Synced message file for txn " + this.getTxn().getTid());
                }
            }
        }
    }

    @Override
    void flushMsgs() throws IOException {
        this.flush(true, false, false);
    }

    void flush(boolean clearQ, boolean addSavePoint, boolean addEOF) throws IOException {
        this.flush(clearQ, addSavePoint, addEOF, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(boolean clearQ, boolean addSavePoint, boolean addEOF, boolean noreplicate) throws IOException {
        if (this.DEBUG) {
            this.debug("flushing tid = " + this.getTxn().getTid() + " clearQ = " + clearQ + " addSavePoint = " + addSavePoint + " addEOF = " + addEOF + " addSavePoint = " + addSavePoint + " noreplicate = " + noreplicate);
        }
        boolean xoClient = false;
        boolean replicate = false;
        TxnContentMgrFile txnContentMgrFile = this;
        synchronized (txnContentMgrFile) {
            try {
                this.openMsgStore();
                Enumeration enu = this.m_msgQueue.elements();
                IClientContext owner = this.getTxn().getOwnerCC();
                xoClient = owner != null && owner.isXOnce();
                boolean bl = replicate = xoClient && !noreplicate && Config.REPLICATED && !this.getTxn().getDoNotReplicateLive();
                if (this.DEBUG) {
                    this.debug("flushing m_tid: " + this.getTxn().getTid() + " replicate: " + replicate);
                }
                while (enu.hasMoreElements()) {
                    TxMsg m = (TxMsg)enu.nextElement();
                    TxnContentMgrFile.serialize(this.m_os, m.getOrigTracking(), m.getMsg());
                    if (replicate) {
                        this.handleLiveReplication(m.getOrigTracking(), m.getMsg());
                    }
                    if (!xoClient) continue;
                    this.m_storageAcks.add(new Long(m.getOrigTracking()));
                }
                if (addSavePoint || this.m_insertSavePointOnNextFlush) {
                    IMgram savemark = MgramFactory.getMgramFactory().buildTxnSavePointMarker();
                    TxnContentMgrFile.serialize(this.m_os, -1L, savemark);
                    if (replicate) {
                        this.handleLiveReplication(-1L, savemark);
                    }
                    this.m_insertSavePointOnNextFlush = false;
                }
                if (addEOF) {
                    IMgram eofmark = MgramFactory.getMgramFactory().buildTxnEOFMarker();
                    TxnContentMgrFile.serialize(this.m_os, -1L, eofmark);
                    if (replicate) {
                        this.handleLiveReplication(-1L, eofmark);
                    }
                }
                if (xoClient || replicate || Config.REPLICATED) {
                    this.m_os.flush();
                    this.m_msgFile.sync();
                    if (this.DEBUG) {
                        this.debug("flushed m_os and synced m_msgFlie for tid: " + this.getTxn().getTid());
                    }
                }
                if (replicate) {
                    this.flushLiveReplication();
                }
                if (clearQ) {
                    this.cleanupMemoryQ();
                }
                this.s_txnmgr.incFlushCount();
            }
            finally {
                this.m_flushing = false;
                this.notifyAll();
            }
        }
        if (xoClient) {
            this.releaseStorageAcks();
        }
    }

    public static IMgram unserialize(InputStream is, LongHolder origTrackingHolder) throws IOException, EMgramFormatError {
        byte version = StreamUtil.readByte(is);
        long originalTracking = StreamUtil.readLong(is);
        origTrackingHolder.set(originalTracking);
        IMgram m = MgramSerializer.getMgramSerializer().unserializeTransacted(is);
        return m;
    }

    public static void serialize(OutputStream os, long origTracking, IMgram m) throws IOException {
        StreamUtil.writeByte((byte)0, os);
        StreamUtil.writeLong(origTracking, os);
        MgramSerializer.getMgramSerializer().serialize(os, m, false);
    }

    private void handleLiveReplication(long origTracking, IMgram m) {
        if (this.m_liveReplicationStream == null) {
            this.m_liveReplicationStream = new TxnFileReplicationOutputStream(this.getTxn().getTid(), false);
        }
        this.m_liveReplicationStream.write(origTracking, m);
    }

    private void flushLiveReplication() {
        if (this.m_liveReplicationStream != null) {
            this.m_liveReplicationStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseStorageAcks() {
        long[] backTrackings = null;
        Vector vector = this.m_storageAcks;
        synchronized (vector) {
            backTrackings = new long[this.m_storageAcks.size()];
            for (int i = 0; i < this.m_storageAcks.size(); ++i) {
                backTrackings[i] = (Long)this.m_storageAcks.elementAt(i);
            }
            this.m_storageAcks.clear();
        }
        this.getTxn().sendStorageAcks(backTrackings, true);
    }

    @Override
    void cancelMsgs() {
        if (this.DEBUG) {
            this.debug("cancelMsgs tid = " + this.getTxn().getTid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteMsgStore() {
        if (this.DEBUG) {
            this.debug("deleteMsgStore tid = " + this.getTxn().getTid());
        }
        TxnContentMgrFile txnContentMgrFile = this;
        synchronized (txnContentMgrFile) {
            TxnFileReplicationMgr txnFileReplMgr;
            ReplicationManager replMgr;
            boolean interrupted = false;
            while (this.m_flushing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.m_msgFile != null) {
                try {
                    this.m_msgFile.close();
                }
                catch (IOException e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            if (this.m_msgFileName == null) {
                this.m_msgFileName = Transaction.getTxnFileName(this.getTxn().getTid());
            }
            if ((replMgr = AgentRegistrar.getAgentRegistrar().getReplicationManager()) != null && (txnFileReplMgr = replMgr.getTxnFileReplicationMgr()) != null) {
                txnFileReplMgr.closeReplicatedFile(this.getTxn().getTid());
            }
            if (this.m_msgFileName.exists()) {
                this.m_msgFileName.delete();
            }
            if (this.DEBUG) {
                this.debug("Deleted ");
            }
        }
        this.cleanupMemoryQ();
    }

    @Override
    synchronized void closeMsgStore() {
        if (this.DEBUG) {
            this.debug("closeMsgStore tid = " + this.getTxn().getTid());
        }
        if (this.m_msgFile == null) {
            return;
        }
        try {
            this.m_msgFile.close();
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        this.m_msgFile = null;
    }

    @Override
    void commitMsgs(int lastMsgSeqNo, boolean retry) throws Exception {
        if (this.DEBUG) {
            this.debug("committing messages from disk startseq= " + lastMsgSeqNo);
        }
        if (retry) {
            if (this.m_msgFileName == null) {
                this.m_msgFileName = Transaction.getTxnFileName(this.getTxn().getTid());
            }
            if (!this.m_msgFileName.exists() || this.m_msgFileName.length() == 0L) {
                if (this.checkDebugFlags(64)) {
                    this.debug("commitMsgs: retry; tid=" + this.getTxn().getTid() + " no messages to commit: " + " exists= " + this.m_msgFileName.exists() + " length= " + this.m_msgFileName.length() + " " + this.m_msgFileName.getCanonicalPath());
                }
                return;
            }
        }
        this.openMsgStore();
        LogInputStream is = this.m_msgFile.getInputStream();
        LongHolder origTrackingHolder = new LongHolder(-1L);
        int seq = 0;
        IClientContext cc = null;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(this.getTxn().getOwner());
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
        int count = 0;
        while (true) {
            IMgram m = TxnContentMgrFile.unserialize(is, origTrackingHolder);
            long originalTracking = origTrackingHolder.get();
            if (m.getBrokerHandle().isTxnEOFMarker()) break;
            if (m.getBrokerHandle().isTxnSavePointMarker() || ++seq <= lastMsgSeqNo) continue;
            TxMsg msg = new TxMsg(this.getTxn().getTid(), this.getTxn().getOwner(), cc, m);
            msg.setOrigTracking(originalTracking);
            msg.deliverMsg(seq, retry, this.getTxn());
            ++count;
        }
        if (this.DEBUG) {
            this.debug("Committed " + count + " messages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean load() throws IOException {
        if (this.DEBUG) {
            this.debug("loading messages from disk");
        }
        long pos = 0L;
        long initialReadPos = 0L;
        LogInputStream is = null;
        boolean valid = false;
        LongHolder origTrackingHolder = new LongHolder(-1L);
        try {
            IClientContext cc = null;
            try {
                cc = AgentRegistrar.getAgentRegistrar().getClient(this.getTxn().getOwner());
            }
            catch (EClientNotRegistered e) {
                // empty catch block
            }
            this.openMsgStore();
            is = this.m_msgFile.getInputStream();
            pos = initialReadPos = is.getFilePointer();
            int count = 0;
            while (true) {
                IXOnceHandle xoh;
                IMgram m = TxnContentMgrFile.unserialize(is, origTrackingHolder);
                long originalTracking = origTrackingHolder.get();
                if (m.getBrokerHandle().isTxnEOFMarker()) break;
                if (m.getBrokerHandle().isTxnSavePointMarker()) {
                    valid = true;
                    continue;
                }
                if (m != null && (xoh = cc.getXOnceHandle()) != null) {
                    cc.getWindowAckManager().receivedTxnMsg(this.getTxn().getTid(), originalTracking);
                    xoh.addGuarUGA(originalTracking);
                }
                pos = is.getFilePointer();
                ++count;
            }
            if (this.DEBUG) {
                this.debug("Loaded " + count + " messages");
            }
        }
        catch (Throwable th) {
            this.debug("Good savepoint present status: " + valid, th);
        }
        finally {
            try {
                this.closeMsgStore();
                this.openMsgStore();
                ((LogOutputStream)this.m_os).seek(pos);
            }
            catch (IOException ioe) {}
        }
        return valid;
    }

    void openMsgStore() throws IOException {
        if (this.m_msgFile == null) {
            this.m_msgFileName = new File(Config.TXN_FILE_FULLPATH_PREFIX + this.getTxn().getTid());
            this.m_msgFile = new LogStreamFile(Config.TXN_FILE_FULLPATH_PREFIX + this.getTxn().getTid());
            this.m_os = this.m_msgFile.getOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void replicate() throws IOException {
        LongHolder origTrackingHolder = new LongHolder(-1L);
        if (this.DEBUG) {
            this.debug("replicate");
        }
        boolean interrupted = false;
        TxnContentMgrFile txnContentMgrFile = this;
        synchronized (txnContentMgrFile) {
            while (this.m_flushing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            this.m_liveReplicationStream = null;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        long pos = 0L;
        long initialReadPos = 0L;
        LogInputStream is = null;
        if (this.DEBUG) {
            this.debug("replicate tid: " + this.getTxn().getTid());
        }
        LogStreamFile msgFile = new LogStreamFile(Config.TXN_FILE_FULLPATH_PREFIX + this.getTxn().getTid());
        boolean valid = false;
        TxnFileReplicationOutputStream dynamicSyncReplicationStream = new TxnFileReplicationOutputStream(this.getTxn().getTid(), true);
        int count = 0;
        try {
            is = msgFile.getInputStream();
            while (true) {
                IMgram m = TxnContentMgrFile.unserialize(is, origTrackingHolder);
                long originalTracking = origTrackingHolder.get();
                dynamicSyncReplicationStream.write(originalTracking, m);
                if (this.DEBUG) {
                    this.debug("replicate tid: " + this.getTxn().getTid() + " m.getType(): " + m.getType());
                }
                if (m.getBrokerHandle().isTxnEOFMarker()) break;
                ++count;
            }
            dynamicSyncReplicationStream.flush();
            if (this.DEBUG) {
                this.debug("Replicated " + count + " messages tid: " + this.getTxn().getTid());
            }
        }
        catch (EOFException eofex) {
            dynamicSyncReplicationStream.flush();
            if (this.DEBUG) {
                this.debug("Replicated " + count + " messages tid: " + this.getTxn().getTid());
            }
        }
        catch (IOException ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
        }
        catch (EMgramFormatError ex) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ex, 2);
        }
        finally {
            try {
                msgFile.close();
            }
            catch (IOException e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }
}

