/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.TxnAckPool;
import progress.message.util.StreamUtil;

public class TxnPrecommitEvt
extends LogEvent {
    private int m_tid;
    private TxnAckPool m_acks;
    private byte m_persistenceType;
    private long m_requestId;
    private boolean m_chained;
    private short m_eventType = (short)82;

    TxnPrecommitEvt(int tid, TxnAckPool acks, byte persistenceType, long requestId, boolean chained) {
        this.m_tid = tid;
        this.m_acks = acks;
        this.m_persistenceType = persistenceType;
        this.m_requestId = requestId;
        this.m_chained = chained;
    }

    TxnPrecommitEvt(short type) {
        this.m_eventType = type;
    }

    int getTid() {
        return this.m_tid;
    }

    TxnAckPool getTxnAckPool() {
        return this.m_acks;
    }

    byte getPersistenceType() {
        return this.m_persistenceType;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    boolean getChained() {
        return this.m_chained;
    }

    @Override
    public short type() {
        return 82;
    }

    @Override
    protected int memSizeBody() {
        int size = 14;
        if (this.m_acks != null) {
            size += 4 + this.m_acks.getMemorySize();
        }
        return size;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        int size = 14;
        size = this.m_acks == null ? (size += 4) : (size += this.m_acks.getSerializedSize());
        return size;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        StreamUtil.writeInt(this.m_tid, out);
        if (this.m_acks == null) {
            StreamUtil.writeInt(0, out);
        } else {
            this.m_acks.writebody(out);
        }
        StreamUtil.writeByte(this.m_persistenceType, out);
        StreamUtil.writeLong(this.m_requestId, out);
        StreamUtil.writeBoolean(this.m_chained, out);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        StreamUtil.writeInt(this.m_tid, os);
        if (this.m_acks == null) {
            StreamUtil.writeInt(0, os);
        } else {
            this.m_acks.writebody(os);
        }
        StreamUtil.writeByte(this.m_persistenceType, os);
        StreamUtil.writeLong(this.m_requestId, os);
        StreamUtil.writeBoolean(this.m_chained, os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        if (this.m_eventType == 12 || this.m_eventType == 36) {
            this.m_persistenceType = (byte)2;
            return;
        }
        this.m_acks = new TxnAckPool(this.m_tid);
        this.m_acks.readBody(in);
        this.m_persistenceType = StreamUtil.readByte(in);
        if (this.m_eventType == 82 || this.m_eventType == 97) {
            this.m_requestId = StreamUtil.readLong(in);
            this.m_chained = StreamUtil.readBoolean(in);
        } else {
            this.m_requestId = 0L;
            this.m_chained = false;
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTxnPrecommit(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Txn " + this.m_tid + ", requestId " + this.m_requestId + ", chained " + this.m_chained + ": precommit";
    }
}

