/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.CWADSInfo;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.IDurableOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class CWADSInfoOp
extends CWADSInfo
implements IDurableOperation {
    private static final byte CURRENT_VERSION = 0;

    CWADSInfoOp(IClientContext cc) throws ESubscriptionNotFound {
        super(cc);
    }

    public CWADSInfoOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 19) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            this.deserializeInfo(mg.getPayloadInputStreamHandle());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void doit(BrokerDatabase db_not_used_here) throws IOException {
    }

    @Override
    public void postProcess() {
    }

    public IMgram makeMgram() {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(19);
        try {
            this.serializeInfo(result.getPayloadOutputStreamHandle());
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return result;
    }

    @Override
    public void serializeInfo(DataOutput doutput) throws IOException {
        doutput.writeByte(0);
        super.serializeInfo(doutput);
    }

    @Override
    public final void deserializeInfo(DataInput dinput) throws IOException {
        dinput.readByte();
        super.deserializeInfo(dinput);
    }

    @Override
    public String toString() {
        return "CWADSInfoOp: " + super.toString();
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }
}

