/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.IClientContext;
import progress.message.broker.durable.CWADSInfoOp;
import progress.message.broker.durable.ESubscriptionNotFound;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class CWADSListXferReplyOp
implements IDurableReplyOperation {
    private static int m_errorCode = 0;
    private boolean m_replyready = false;
    private Vector<CWADSInfoOp> m_infoMgrams = new Vector();
    private static final byte CURRENT_VERSION = 0;

    public CWADSListXferReplyOp(boolean replyready, Iterator durSubs) {
        this.m_replyready = replyready;
        if (durSubs == null) {
            return;
        }
        block4: while (true) {
            try {
                while (durSubs.hasNext()) {
                    IClientContext cc = (IClientContext)durSubs.next();
                    try {
                        this.m_infoMgrams.add(new CWADSInfoOp(cc));
                        continue block4;
                    }
                    catch (ESubscriptionNotFound esnf) {
                    }
                }
                break;
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                break;
            }
        }
    }

    public CWADSListXferReplyOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 18) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            int size = dinput.readInt();
            LinkedList ll = iopHandle.getMgramList();
            if (ll != null) {
                for (int count = 0; count < ll.size(); ++count) {
                    this.m_infoMgrams.add(new CWADSInfoOp((IMgram)ll.get(count)));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isComplete() {
        return this.m_replyready;
    }

    public void doit(BrokerDatabase db_not_used_here) throws IOException {
    }

    public void postProcess() {
    }

    @Override
    public IMgram getMgram() {
        IMgram m = MgramFactory.getMgramFactory().buildOperationMgram(18);
        try {
            ObjectOutput doutput = m.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            Enumeration<CWADSInfoOp> infoMgrams = this.m_infoMgrams.elements();
            doutput.writeInt(this.m_infoMgrams.size());
            while (infoMgrams.hasMoreElements()) {
                m.getOperationHandle().addMgram(infoMgrams.nextElement().makeMgram());
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return m;
    }

    @Override
    public int getErrorCode() {
        return m_errorCode;
    }

    public void setErrorCode(int error) {
        m_errorCode = error;
    }

    public Enumeration<CWADSInfoOp> infoMgramsEnum() {
        return this.m_infoMgrams.elements();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(" CWADSListXferReplyOp: ");
        Enumeration<CWADSInfoOp> infoMgrams = this.m_infoMgrams.elements();
        while (infoMgrams.hasMoreElements()) {
            CWADSInfoOp info = infoMgrams.nextElement();
            ret.append(" " + info.getUid() + "/" + info.getAppid() + "/" + info.getSubject());
        }
        return ret.toString();
    }
}

