/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.MsgSaver;
import progress.message.broker.durable.DurableBrowseReplyOp;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class DurableBrowseOp
implements IDurableOperation {
    private IDurableReplyQueue m_replyQueue;
    private long m_clientId;
    private int m_maxReplies;
    private long m_trkNum;
    private static final byte CURRENT_VERSION = 0;

    public DurableBrowseOp(IDurableReplyQueue queue, long clientId, long trkNum, int maxReplies) {
        this.m_replyQueue = queue;
        this.m_clientId = clientId;
        this.m_maxReplies = maxReplies;
        this.m_trkNum = trkNum;
    }

    public DurableBrowseOp(IDurableReplyQueue queue, IMgram mg) {
        this.m_replyQueue = queue;
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 8) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            this.m_clientId = dinput.readLong();
            this.m_trkNum = dinput.readLong();
            this.m_maxReplies = dinput.readInt();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void doit(BrokerDatabase db) throws IOException {
        try {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
            if (this.m_trkNum == -1L) {
                this.m_trkNum = AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().getMaxDeleteMsgId(this.m_clientId);
            }
            if (cc.isDisconnected() && !cc.isDisconnecting()) {
                Collection result = db.getMgramsFromPosTx(this.m_clientId, this.m_trkNum, -1L, this.m_maxReplies);
                Iterator iter = result.iterator();
                int count = 0;
                while (iter.hasNext()) {
                    BrokerDatabase.MgramInfo mi = (BrokerDatabase.MgramInfo)iter.next();
                    IMgram m = db.getMgramTx(mi.m_messageId);
                    if (m == null) continue;
                    m = MsgSaver.removeLBSWrapper(m);
                    DurableBrowseReplyOp op = new DurableBrowseReplyOp(mi.m_messageId, Config.BROKER_NAME);
                    op.setReplyInformation(m, this.m_clientId);
                    this.m_replyQueue.enqueue(op);
                    ++count;
                }
                if (count < this.m_maxReplies) {
                    DurableBrowseReplyOp op = new DurableBrowseReplyOp(0L, Config.BROKER_NAME);
                    op.setEnd();
                    this.m_replyQueue.enqueue(op);
                }
            } else {
                DurableBrowseReplyOp result = new DurableBrowseReplyOp(0L, Config.BROKER_NAME);
                result.setEnd();
                result.setErrorCode(2);
                this.m_replyQueue.enqueue(result);
            }
        }
        catch (EClientNotRegistered e) {
            DurableBrowseReplyOp result = new DurableBrowseReplyOp(0L, Config.BROKER_NAME);
            result.setEnd();
            result.setErrorCode(4);
            this.m_replyQueue.enqueue(result);
        }
    }

    @Override
    public void postProcess() {
    }

    public static IMgram getMgram(String jmsID, long clientId, long trkNum, int maxNum) {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(8);
        try {
            ObjectOutput doutput = result.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeLong(clientId);
            doutput.writeLong(trkNum);
            doutput.writeInt(maxNum);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return result;
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }
}

