/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.durable.DurableCountSizeRestoreReplyOp;
import progress.message.broker.durable.ECounterFrozenException;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class DurableCountSizeRestoreOp
extends DebugObject
implements IDurableOperation {
    private IDurableReplyQueue m_replyQueue;
    private long m_clientId;
    private int m_chunkSize;
    private long m_maxMessageID;
    private long m_maxSequenceNumber;
    private long m_trkNum;

    public DurableCountSizeRestoreOp(IDurableReplyQueue queue) {
        super(DebugState.GLOBAL_DEBUG_ON ? "DurableCountSizeRestoreOp" : null);
        this.m_replyQueue = queue;
    }

    public void init(int chunkSize, long maxMessageID, long clientId, long trkNum) {
        this.m_chunkSize = chunkSize;
        this.m_maxMessageID = maxMessageID;
        this.m_clientId = clientId;
        this.m_trkNum = trkNum;
    }

    public long getTrkNum() {
        return this.m_trkNum;
    }

    public long getClientID() {
        return this.m_clientId;
    }

    public long getMaxMessageID() {
        return this.m_maxMessageID;
    }

    public long getMaxSequenceNumber() {
        return this.m_maxSequenceNumber;
    }

    public int getChunkSize() {
        return this.m_chunkSize;
    }

    @Override
    public void doit(BrokerDatabase db) throws IOException {
        BrokerDatabase.CountSizeUpdateInfo info = db.getCountSizeFromPosTx(this.m_clientId, this.m_trkNum, this.m_maxMessageID, this.m_chunkSize);
        DurableCountSizeRestoreReplyOp result = null;
        ICCSizeTracker tracker = null;
        try {
            tracker = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId).getCCSizeTracker();
        }
        catch (EClientNotRegistered e) {
            // empty catch block
        }
        if (info != null && tracker != null) {
            if (info.m_count > 0) {
                try {
                    tracker.updateQueryMsgs(info.m_size, info.m_count, info.m_maxMessageID);
                }
                catch (ECounterFrozenException e) {
                    result = new DurableCountSizeRestoreReplyOp(-1L, true);
                }
            }
            if (this.DEBUG) {
                this.debug("Restoring count/size for " + this.m_clientId + " Size: " + info.m_size + " Count: " + info.m_count);
            }
            if (result == null) {
                result = new DurableCountSizeRestoreReplyOp(info.m_maxMessageID, info.m_allMessagesRestored);
            }
            if (info.m_allMessagesRestored) {
                if (this.DEBUG) {
                    this.debug("All messages for " + this.m_clientId + " restored");
                }
                tracker.setQueryPending(false, -1L);
            }
        } else {
            result = new DurableCountSizeRestoreReplyOp(-1L, true);
            if (tracker != null) {
                tracker.setQueryPending(false, -1L);
            }
        }
        this.m_replyQueue.enqueue(result);
    }

    @Override
    public void postProcess() {
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }
}

