/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.MsgSaver;
import progress.message.broker.TrackedSubjectFilter;
import progress.message.broker.durable.DurableGetMgramReplyOp;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyQueue;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ISubject;

public class DurableGetMgramOp
implements IDurableOperation {
    private IDurableReplyQueue m_replyQueue;
    private String m_jmsID;
    private long m_clientId;
    private static final byte CURRENT_VERSION = 0;

    public DurableGetMgramOp(IDurableReplyQueue queue, long clientId, String JMSMessageID) {
        this.m_replyQueue = queue;
        this.m_jmsID = JMSMessageID;
        this.m_clientId = clientId;
    }

    public DurableGetMgramOp(IDurableReplyQueue queue, IMgram mg) {
        this.m_replyQueue = queue;
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 6) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        try {
            ObjectInput dinput = mg.getPayloadInputStreamHandle();
            dinput.readByte();
            this.m_jmsID = dinput.readUTF();
            this.m_clientId = dinput.readLong();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void doit(BrokerDatabase db) throws IOException {
        DurableGetMgramReplyOp result;
        block8: {
            BrokerDatabase.ClientDeliveryInfo info = db.getClientInfofromJMSMessageIDTx(this.m_jmsID, this.m_clientId);
            if (info != null) {
                long cid = info.cid;
                try {
                    IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(this.m_clientId);
                    if (cc.isDisconnected() && !cc.isDisconnecting()) {
                        IMgram mg = db.getMgramTx(info.messageid);
                        if (mg != null) {
                            mg = MsgSaver.removeLBSWrapper(mg);
                            if (info.undelSubjectIds != null && !info.undelSubjectIds.isEmpty()) {
                                ISubject s = mg.getSubject();
                                TrackedSubjectFilter tsf = new TrackedSubjectFilter((HashSet)info.undelSubjectIds);
                                mg.setSubject(tsf.filter(s), mg.getSubjectFormat());
                            }
                            result = new DurableGetMgramReplyOp(true, mg);
                        } else {
                            result = new DurableGetMgramReplyOp(false, null);
                            result.setErrorCode(3);
                        }
                        break block8;
                    }
                    result = new DurableGetMgramReplyOp(false, null);
                    result.setErrorCode(2);
                }
                catch (EClientNotRegistered e) {
                    result = new DurableGetMgramReplyOp(false, null);
                    result.setErrorCode(4);
                }
            } else {
                result = new DurableGetMgramReplyOp(false, null);
            }
        }
        this.m_replyQueue.enqueue(result);
    }

    @Override
    public void postProcess() {
    }

    public static IMgram getMgram(String jmsID, long clientId) {
        IMgram result = MgramFactory.getMgramFactory().buildOperationMgram(6);
        try {
            ObjectOutput doutput = result.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeUTF(jmsID);
            doutput.writeLong(clientId);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return result;
    }

    @Override
    public boolean isReplicateable() {
        return false;
    }
}

