/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import java.io.IOException;
import java.util.LinkedList;
import progress.message.broker.Broker;
import progress.message.broker.durable.IDurableOperation;
import progress.message.zclient.DebugObject;

public class DurableOpProcessor
extends DebugObject
implements Runnable {
    private LinkedList m_ops = new LinkedList();
    private LinkedList m_prevOps = new LinkedList();
    private boolean m_opsEnqueued = false;
    private boolean m_isRunning = false;
    private boolean m_isShutdown = false;
    private Object m_runningSyncObject = new Object();
    private Thread m_durableOpProcessor = null;
    private static final int IDLE_TIMEOUT = 300000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        var1_1 = this.m_runningSyncObject;
        synchronized (var1_1) {
            this.m_durableOpProcessor = Thread.currentThread();
            if (this.m_isShutdown) {
                return;
            }
            this.m_isRunning = true;
        }
lbl11:
        // 2 sources

        try {
            while (!(Broker.exiting || Thread.currentThread().isInterrupted() || this.m_isShutdown)) {
                block38: {
                    todo = this.getTodoList();
                    if (todo == null) {
                        return;
                    }
                    if (this.DEBUG) {
                        this.debug("Retrieved TODO list");
                    }
                    if (todo.isEmpty()) break block38;
                    iter = todo.iterator();
                    while (iter.hasNext()) {
                        block36: {
                            op = (IDurableOperation)todo.removeFirst();
                            try {
                                op.doit(null);
                            }
                            catch (IOException ioe) {
                                if (!Broker.exiting) break block36;
                                Thread.currentThread().interrupt();
                            }
                        }
                        op.postProcess();
                    }
                    ** GOTO lbl11
                }
                if (!this.DEBUG) continue;
                this.debug("Retrieved TODO list empty");
            }
        }
        catch (InterruptedException e) {
            if (this.DEBUG) {
                this.debug("Exiting DurableOpProcessor");
            }
            e = this.m_runningSyncObject;
            synchronized (e) {
                this.m_isRunning = false;
            }
        }
        catch (RuntimeException var1_4) {
            if (this.DEBUG) {
                this.debug("Exiting DurableOpProcessor");
            }
            var1_5 = this.m_runningSyncObject;
            synchronized (var1_5) {
                this.m_isRunning = false;
            }
        }
        finally {
            if (this.DEBUG) {
                this.debug("Exiting DurableOpProcessor");
            }
            var2_7 = this.m_runningSyncObject;
            synchronized (var2_7) {
                this.m_isRunning = false;
            }
        }
    }

    public void startThread() {
        Thread t = new Thread(this);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.m_runningSyncObject;
        synchronized (object) {
            this.m_isShutdown = true;
            if (this.m_isRunning) {
                this.m_durableOpProcessor.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDurableOperation(IDurableOperation op) {
        Object object = this.m_runningSyncObject;
        synchronized (object) {
            if (this.m_isShutdown || Broker.exiting) {
                return;
            }
        }
        object = this;
        synchronized (object) {
            this.m_ops.addLast(op);
            this.m_opsEnqueued = true;
        }
        boolean startThread = false;
        Thread durableOpProcessor = null;
        Object object2 = this.m_runningSyncObject;
        synchronized (object2) {
            if (!(this.m_isRunning || Broker.exiting || this.m_isShutdown)) {
                durableOpProcessor = this.m_durableOpProcessor;
                startThread = true;
                this.m_isRunning = true;
            }
        }
        if (startThread) {
            try {
                if (durableOpProcessor != null) {
                    durableOpProcessor.join();
                }
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.DEBUG) {
                this.debug("Starting durableOpProcessor");
            }
            this.startThread();
        }
        object2 = this;
        synchronized (object2) {
            this.notifyAll();
        }
    }

    private synchronized LinkedList getTodoList() throws InterruptedException {
        while (!(this.m_ops.size() != 0 || Broker.exiting || Thread.currentThread().isInterrupted() || this.m_isShutdown)) {
            this.wait(300000L);
            if (this.m_opsEnqueued) continue;
            if (this.DEBUG) {
                this.debug("DurableOpProcessor timed out");
            }
            return null;
        }
        if (Broker.exiting || Thread.currentThread().isInterrupted() || this.m_isShutdown) {
            return null;
        }
        LinkedList ret = this.m_ops;
        this.m_ops = this.m_prevOps;
        this.m_prevOps = ret;
        this.m_opsEnqueued = false;
        return ret;
    }
}

