/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import com.sonicsw.mq.common.runtime.IRemoteSubscriptionSummary;
import com.sonicsw.mq.common.runtime.impl.RuntimeDataFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentRoutingQueue;
import progress.message.broker.Authorize;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.ConnectEvt;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.FlowControlListener;
import progress.message.broker.FlowControlManager;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IFlowController;
import progress.message.broker.INeighbor;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.IRoutingConfigListener;
import progress.message.broker.IStateListener;
import progress.message.broker.MergedBrokerSubscription;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.broker.SubscriptionData;
import progress.message.broker.SubscriptionsTable;
import progress.message.broker.gs.GSNodeInfo;
import progress.message.broker.gs.GSOrphanedMessageChecker;
import progress.message.broker.gs.GSPropagationClient;
import progress.message.broker.gs.GSPropagationRule;
import progress.message.broker.gs.GSPropagationRuleList;
import progress.message.broker.gs.GSRequest;
import progress.message.broker.gs.GSRoutingQueueListener;
import progress.message.broker.gs.GSStandbySubscriptionExpirationManager;
import progress.message.broker.gs.GSSubscriptionExpirationManager;
import progress.message.broker.gs.GSTopicInfo;
import progress.message.broker.gs.GSTracker;
import progress.message.broker.gs.GSTransport;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.gs.IGSRemoteRequest;
import progress.message.broker.gs.IGSRequestSender;
import progress.message.broker.gs.IGSSubscriptionExpirationManager;
import progress.message.broker.prAccessor;
import progress.message.gr.RouterManager;
import progress.message.msg.IMgram;
import progress.message.security.SecurityBean;
import progress.message.util.IndexedList;
import progress.message.util.LongHashTable;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectUtil;

public class GSManager
extends DebugObject
implements IRoutingConfigListener,
IStateListener {
    private boolean ENABLE_FORWARDING = false;
    private static Label s_label = new Label();
    private transient AgentRegistrar m_reg;
    private GSPropagationRuleList m_rulesTable;
    private GSTransport m_transport = null;
    private GSPropagationClient m_propagation_client = null;
    private IGSRequestSender m_requestSender = null;
    private IGSSubscriptionExpirationManager m_expirationManager = null;
    private GSRoutingQueueListener m_routingQueueListener = null;
    private GSOrphanedMessageChecker m_gsOrphanedMessageChecker = null;
    private Hashtable m_proxySubscriptionList = new Hashtable();
    private Hashtable m_requestList = new Hashtable();
    private Hashtable m_reconciledNodeList = new Hashtable();
    private static int m_localSubscriberCount;
    private Hashtable m_trackers = new Hashtable();
    private static volatile String m_localNodeName;
    private AgentRoutingQueue m_routingQ = null;
    private int m_routingConfigIndex;
    private boolean m_started = false;
    boolean DEBUG1;

    public GSManager(AgentRegistrar reg) {
        super("GSManager");
        if (this.checkDebugFlags(64)) {
            this.DEBUG1 = true;
        }
        this.m_reg = reg;
        this.m_transport = new GSTransport(reg);
        this.m_propagation_client = new GSPropagationClient(reg, this, this.m_transport);
        this.m_routingQueueListener = new GSRoutingQueueListener(this);
        this.m_gsOrphanedMessageChecker = new GSOrphanedMessageChecker(this);
        this.m_requestSender = new GSStandbyRequestSender();
        this.m_expirationManager = new GSStandbySubscriptionExpirationManager();
        this.m_rulesTable = new GSPropagationRuleList(reg);
        s_label.setGuaranteed(true);
        s_label.setRouteLimit(1);
        m_localNodeName = Config.ROUTING_NODE_NAME;
        this.ENABLE_FORWARDING = Config.ENABLE_GLOBAL_SUBCRIPTIONS_FORWARDING;
        if (this.DEBUG1) {
            this.debug("enable_forwarding = " + this.ENABLE_FORWARDING + " RoutingNode= " + m_localNodeName);
            this.m_rulesTable.dump();
        }
    }

    @Override
    public void stateChanging(int newState) {
    }

    @Override
    public void stateChanged(int newState) throws Exception {
        switch (newState) {
            case 1: 
            case 2: 
            case 3: {
                if (this.m_requestSender != null && this.m_requestSender instanceof GSRequestSender) {
                    this.m_requestSender.start();
                } else {
                    this.updateAllVCs();
                    this.m_requestSender = new GSRequestSender(this.m_reg.getFlowControlManager());
                    this.m_requestSender.start();
                    Enumeration propagatees = this.m_proxySubscriptionList.elements();
                    while (propagatees.hasMoreElements()) {
                        GSNodeInfo ni = (GSNodeInfo)propagatees.nextElement();
                        Hashtable rl = ni.getRequestList();
                        if (rl == null || rl.isEmpty()) continue;
                        this.m_transport.sendReconciliationList(ni.getNodeName(), ni, false);
                    }
                }
                if (this.m_expirationManager != null && this.m_expirationManager instanceof GSSubscriptionExpirationManager) {
                    this.m_expirationManager.start();
                    break;
                }
                this.m_expirationManager = new GSSubscriptionExpirationManager(this.m_reg, this, this.m_transport);
                this.m_expirationManager.start();
                break;
            }
            case 6: {
                if (this.m_requestSender != null) {
                    this.m_requestSender.shutdown();
                }
                if (this.m_expirationManager != null) {
                    this.m_expirationManager.shutdown();
                }
                this.m_requestSender = new GSStandbyRequestSender();
                this.m_expirationManager = new GSStandbySubscriptionExpirationManager();
                break;
            }
            case 4: {
                this.reset();
            }
        }
    }

    public void start() {
        try {
            AgentRegistrar.getAgentRegistrar().getRoutingConfig().addRoutingConfigListener(this);
            this.m_started = true;
            this.m_propagation_client.start();
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllVCs() {
        Hashtable hashtable = this.m_requestList;
        synchronized (hashtable) {
            GSVirtualClock vc = GSVirtualClock.assignVirtualClock();
            Enumeration e = this.m_requestList.elements();
            while (e.hasMoreElements()) {
                GSRequest req = (GSRequest)e.nextElement();
                req.setVirtualClock(vc);
            }
        }
    }

    public void shutdown() {
        if (this.getRequestSender() != null) {
            this.getRequestSender().shutdown();
        }
    }

    public void setupAdminHandlers() {
        try {
            this.m_propagation_client.setupGSPropagationClientHandlers();
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
    }

    public IGSRequestSender getRequestSender() {
        return this.m_requestSender;
    }

    public Label getLabel() {
        return s_label;
    }

    public void onExpire(BrokerSubscription bs) {
        this.m_expirationManager.onExpire(bs);
    }

    public String getNodeAppID(String remoteNode) {
        return RouterManager.getRemoteNodeGSAppID(remoteNode);
    }

    public boolean isForwardingEnabled() {
        return this.ENABLE_FORWARDING;
    }

    public boolean checkGlobalSubscribe(IMgram mgram, IClientContext fromCC) {
        GSRequest req;
        String remoteNode;
        block24: {
            ISubject subject = null;
            remoteNode = null;
            req = null;
            if (fromCC == null) {
                return true;
            }
            if (fromCC.isInterbroker()) {
                return true;
            }
            subject = mgram.getSubject();
            if (subject == null || subject.isMultiSubject() || !this.m_transport.isGSASubject(subject.getSubjectString())) {
                return true;
            }
            ObjectInput in = null;
            try {
                if (this.m_transport.isGSASubscribe(mgram) || this.m_transport.isGSAUnsubscribe(mgram)) {
                    in = mgram.getPayloadInputStreamHandle();
                    req = GSRequest.deserialize(in);
                    if (this.DEBUG) {
                        this.debug("checkGlobalSubscribe:" + req);
                    }
                    remoteNode = req.getHomeNodeName();
                    break block24;
                }
                if (this.m_transport.isGSAReconcile(mgram)) {
                    in = mgram.getPayloadInputStreamHandle();
                    in.readByte();
                    in.readInt();
                    in.readInt();
                    remoteNode = in.readUTF();
                    break block24;
                }
                if (this.m_transport.isGSAPing(mgram)) {
                    in = mgram.getPayloadInputStreamHandle();
                    in.readByte();
                    remoteNode = in.readUTF();
                    break block24;
                }
                return true;
            }
            catch (IOException ex) {
                if (this.DEBUG) {
                    this.debug("checkGlobalSubscribe: malformed request");
                }
                return false;
            }
        }
        if (remoteNode == null || remoteNode.length() == 0) {
            return false;
        }
        if (!fromCC.isRemoteBroker()) {
            return false;
        }
        if (!remoteNode.equals(RouterManager.getRemoteNodeFromGRAppID(fromCC.getAppid()))) {
            return false;
        }
        if (Config.ENABLE_SECURITY) {
            ClientSecurityContext secctx = fromCC.getCSC();
            String remoteUser = secctx.getUid();
            boolean ok = this.m_reg.getRouterManager().checkNodePermission(remoteUser, remoteNode);
            if (!ok) {
                if (this.DEBUG) {
                    this.debug("checkGlobalSubscribe: checkNodePermission failed !");
                }
                return false;
            }
        }
        if (this.m_transport.isGSAReconcile(mgram)) {
            IMgram rejectsMgram = this.m_transport.removeProhibitedSubscriptions(fromCC, mgram);
            if (rejectsMgram != null) {
                fromCC.sendThrough(rejectsMgram);
            }
            return true;
        }
        if (!this.m_transport.isGSASubscribe(mgram)) {
            return true;
        }
        if (this.DEBUG) {
            this.debug("checkGlobalSubscribe: GSA request");
        }
        if (req == null) {
            throw new NullPointerException("GSRequest req is null at " + GSManager.class.getName() + ".checkGlobalSubscribe(IMgram mgram, IClientContext fromCC)");
        }
        if (!this.okToSubscribe(req.getHomeNodeName(), req.getTopic())) {
            return false;
        }
        req.setReceivingBrokerName(Config.BROKER_NAME);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            req.serialize(out);
            baos.close();
            byte[] newBody = baos.toByteArray();
            mgram.setBody(newBody);
            mgram.sync();
        }
        catch (IOException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        return true;
    }

    boolean okToSubscribe(String remoteNode, String subject) {
        if (Config.ENABLE_ACCESS_MEDIATION && !Authorize.checkPermission(this.getRemoteNodePrincipal(remoteNode), new Subject(subject), 2)) {
            if (this.DEBUG) {
                this.debug("checkGlobalSubscribe: authorization check failed !");
            }
            return false;
        }
        return true;
    }

    public Principal getRemoteNodePrincipal(String remoteNode) {
        Principal remoteNodePrincipal = null;
        SecurityBean secdb = this.m_reg.getSecurityBean();
        if (remoteNode == null || secdb == null) {
            remoteNodePrincipal = null;
        } else {
            Vector routingUserACLs = secdb.getRoutingUserACLs(remoteNode);
            if (routingUserACLs != null && !routingUserACLs.isEmpty()) {
                RoutingUserAclEntry routingUserACL = (RoutingUserAclEntry)routingUserACLs.get(0);
                remoteNodePrincipal = routingUserACL.getPrincipal();
            } else {
                remoteNodePrincipal = null;
            }
        }
        return remoteNodePrincipal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClientContext createRemoteNodeCC(String remoteNode) {
        IClientContext remoteNodeCC;
        block6: {
            long clientID = this.m_reg.getRouterManager().getRemoteNodeGSClientID(remoteNode);
            remoteNodeCC = null;
            try {
                remoteNodeCC = this.m_reg.getClient(clientID);
            }
            catch (EClientNotRegistered e) {
                String remoteNodeAppID = RouterManager.getRemoteNodeGSAppID(remoteNode);
                String gsUserID = this.m_reg.getRouterManager().getGSUserID();
                String gsPWD = this.m_reg.getRouterManager().getGSPWD();
                ProgressPasswordUser principal = new ProgressPasswordUser(gsUserID, gsPWD);
                ClientSecurityContext csc = new ClientSecurityContext(principal, Config.BROKER_UID, remoteNodeAppID, clientID, false, false, null, null, -1L);
                remoteNodeCC = this.m_reg.lockContext(clientID, true, csc, null);
                try {
                    this.m_reg.getLogManager().addEvent(new ConnectEvt(clientID, csc, false), false);
                }
                finally {
                    remoteNodeCC.unlock();
                }
                if (!this.DEBUG) break block6;
                this.debug("createRemodeNodeCC: created CC for " + remoteNode);
            }
        }
        return remoteNodeCC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createRemoteBrokerCC(String remoteNode, String remoteBroker) {
        long clientID = this.m_reg.getRouterManager().getRemoteBrokerGSClientID(remoteNode, remoteBroker);
        IClientContext remoteBrokerCC = null;
        try {
            remoteBrokerCC = this.m_reg.getClient(clientID);
        }
        catch (EClientNotRegistered e) {
            String remoteBrokerAppID = RouterManager.getRemoteBrokerGSAppID(remoteNode, remoteBroker);
            String gsUserID = this.m_reg.getRouterManager().getGSUserID();
            String gsPWD = this.m_reg.getRouterManager().getGSPWD();
            ProgressPasswordUser principal = new ProgressPasswordUser(gsUserID, gsPWD);
            ClientSecurityContext csc = new ClientSecurityContext(principal, principal.getName(), remoteBrokerAppID, clientID, false, false, null, null, -1L);
            remoteBrokerCC = this.m_reg.lockContext(clientID, true, csc, null);
            try {
                this.m_reg.getLogManager().addEvent(new ConnectEvt(clientID, csc, false), false);
            }
            finally {
                remoteBrokerCC.unlock();
            }
            if (this.DEBUG) {
                this.debug("createRemodeBrokerCC: created CC for " + remoteNode + ", " + remoteBroker);
            }
            this.createRemoteNodeCC(remoteNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRequestFailure(int eventType, String node, String topic, GSVirtualClock requestVirtualClock, int failureCode, String reportingBroker) {
        boolean reconciledSubjects = topic.equals("$ISYS.GSA.RECONCILED TOPICS");
        Hashtable hashtable = this.m_reconciledNodeList;
        synchronized (hashtable) {
            GSVirtualClock lastReconcile = (GSVirtualClock)this.m_reconciledNodeList.get(node);
            if (lastReconcile == null || requestVirtualClock.compareTo(lastReconcile) >= 0) {
                GSTopicInfo topicInfo;
                GSNodeInfo nodeInfo = (GSNodeInfo)this.m_proxySubscriptionList.get(node);
                if (!reconciledSubjects && nodeInfo != null && (topicInfo = (GSTopicInfo)nodeInfo.getTopicInfoList().get(topic)) != null) {
                    topicInfo.setFailureCode(failureCode);
                }
            }
            String topicStr = topic;
            if (reconciledSubjects) {
                topicStr = prAccessor.getString("RECONCILED_SUBJECTS");
            }
            if (BrokerComponent.getComponentContext() != null) {
                Object[] obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, reportingBroker, node, topicStr, Integer.toString(failureCode)};
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("REMOTE_SUBSCRIBE_FAILURE"), obj), 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeReconciliation(String node, GSVirtualClock virtualClock) {
        Hashtable hashtable = this.m_reconciledNodeList;
        synchronized (hashtable) {
            this.m_reconciledNodeList.put(node, virtualClock);
        }
    }

    public void globalSubscribe(BrokerSubscription bs, boolean newSubscription, boolean suppressNotification, Vector addedSelectors, Vector removedSelectors, ISubject addedSubject, ISubject removedSubject) {
        this.doOperation(1, bs, newSubscription, suppressNotification, addedSelectors, removedSelectors, addedSubject, removedSubject);
    }

    public void globalUnsubscribe(BrokerSubscription bs) {
        this.doOperation(2, bs);
    }

    public void setRule(String topic, Vector toNodes) {
        this.deleteRule(topic, toNodes);
        this.addRule(topic, GSManager.convertNodes(toNodes), null);
    }

    public void deleteRule(String topic, Vector toNodes) {
        this.deleteRule(topic);
    }

    public void deleteRule(String topic) {
        if (this.DEBUG) {
            this.debug("[deleteRule] topic = " + topic);
        }
        GSPropagationRule rule = null;
        GSPropagationRule[] rules = this.m_rulesTable.getRule(topic);
        if (rules != null && rules.length > 0) {
            rule = rules[0];
            this.m_rulesTable.deleteRule(rule);
        }
        this.internalDeleteRule(rule);
    }

    public void deleteNodesFromRule(String topic, Vector deletedNodes) {
        if (this.DEBUG) {
            this.debug("[deleteNodesFromRule] topic = " + topic + ", nodes = " + deletedNodes);
        }
        GSPropagationRule rule = null;
        GSPropagationRule[] rules = this.m_rulesTable.getRule(topic);
        if (rules != null && rules.length > 0) {
            rule = rules[0];
            Vector nodeList = rule.getToNodeList();
            Enumeration nodes = deletedNodes.elements();
            while (nodes.hasMoreElements()) {
                String tbd = (String)nodes.nextElement();
                nodeList.remove(tbd);
            }
            rule.setToNodeListString(this.toNodeString(nodeList));
            if (this.DEBUG) {
                this.debug("[deleteNodesFromRule] topic = " + topic + ", NEW node list = " + rule.getToNodeListString() + "]");
            }
        }
        this.internalDeleteRule(rule, deletedNodes);
    }

    private String toNodeString(Vector nodeList) {
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Enumeration nodes = nodeList.elements();
        boolean needSeparator = false;
        while (nodes.hasMoreElements()) {
            if (needSeparator) {
                sb.append(",");
            }
            sb.append((String)nodes.nextElement());
            needSeparator = true;
        }
        return sb.toString();
    }

    private void internalDeleteRule(GSPropagationRule rule) {
        this.internalDeleteRule(rule, null);
    }

    private void internalDeleteRule(GSPropagationRule rule, Vector toNodes) {
        if (rule == null) {
            return;
        }
        if (m_localSubscriberCount == 0 && this.m_trackers.isEmpty()) {
            return;
        }
        Enumeration enu = this.m_reg.getAllSubscriptions();
        while (enu.hasMoreElements()) {
            BrokerSubscription bs = (BrokerSubscription)enu.nextElement();
            ISubject subject = bs.getSubject();
            if (SessionConfig.isSystemSubject(subject) || subject.isSonicMQSubject() || bs.getClient().isInterbroker()) continue;
            ISubject nextSubject = subject;
            Iterator<ISubject> subjects = null;
            if (subject.isMultiSubject()) {
                subjects = subject.getMultiSubjects();
                nextSubject = subjects.next();
            }
            while (nextSubject != null) {
                if ((nextSubject = this.computeRuleIntersect(bs, rule, nextSubject)) != null) {
                    if (this.DEBUG) {
                        this.debug("[deleteRule matches bs, rule ]" + rule.toString() + " [bs] " + subject);
                    }
                    this.doProxySubscription(2, bs, nextSubject, toNodes != null ? toNodes : rule.getToNodeList(), false, false, null, null);
                }
                if (subjects != null && subjects.hasNext()) {
                    nextSubject = subjects.next();
                    continue;
                }
                nextSubject = null;
            }
        }
    }

    public void enableForwading(boolean forwarding) {
        this.ENABLE_FORWARDING = forwarding;
        if (this.DEBUG) {
            this.debug("[enableForwading set to] " + forwarding);
        }
    }

    public void addRule(String topic, String toNode, String fromNode) {
        if (this.DEBUG) {
            this.debug("[addGSRule] topic = " + topic + " toNode = " + toNode);
        }
        GSPropagationRule rule = this.m_rulesTable.addRule(topic, toNode, fromNode);
        this.internalAddRule(rule);
    }

    public void addNodesToRule(String topic, Vector addedNodes) {
        GSPropagationRule[] rules;
        if (this.DEBUG) {
            this.debug("[addNodesToRule] topic = " + topic + ", nodes = " + addedNodes);
        }
        if ((rules = this.m_rulesTable.getRule(topic)) != null && rules.length > 0) {
            GSPropagationRule rule = rules[0];
            rule.addMoreToNodes(this.toNodeString(addedNodes));
            if (this.DEBUG) {
                this.debug("[addNodesToRule] topic = " + topic + ", NEW node list = [" + rule.getToNodeListString() + "]");
            }
            this.internalAddRule(rule, addedNodes);
        }
    }

    private void internalAddRule(GSPropagationRule rule) {
        this.internalAddRule(rule, null);
    }

    private void internalAddRule(GSPropagationRule rule, Vector toNodes) {
        if (m_localSubscriberCount == 0 && this.m_trackers.isEmpty()) {
            return;
        }
        Enumeration enu = this.m_reg.getAllSubscriptions();
        while (enu.hasMoreElements()) {
            BrokerSubscription bs = (BrokerSubscription)enu.nextElement();
            ISubject subject = bs.getSubject();
            if (SessionConfig.isSystemSubject(subject) || subject.isSonicMQSubject() || bs.getClient().isInterbroker()) continue;
            Iterator<ISubject> subjects = null;
            ISubject nextSubject = null;
            if (bs.getSubject().isMultiSubject()) {
                subjects = bs.getSubject().getMultiSubjects();
                nextSubject = subjects.next();
            } else {
                nextSubject = bs.getSubject();
            }
            while (nextSubject != null) {
                if ((nextSubject = this.computeRuleIntersect(bs, rule, nextSubject)) != null) {
                    if (this.DEBUG) {
                        this.debug("[addRule matches bs, rule ]" + rule.toString() + " [bs] " + subject);
                    }
                    this.doProxySubscription(1, bs, nextSubject, toNodes != null ? toNodes : rule.getToNodeList(), true, false, null, null);
                }
                if (subjects != null && subjects.hasNext()) {
                    nextSubject = subjects.next();
                    continue;
                }
                nextSubject = null;
            }
        }
    }

    public void updateRule(String topic, Vector addedNodes, Vector deletedNodes) {
        if (deletedNodes != null && !deletedNodes.isEmpty()) {
            this.deleteNodesFromRule(topic, deletedNodes);
        }
        if (addedNodes != null && !addedNodes.isEmpty()) {
            this.addNodesToRule(topic, addedNodes);
        }
    }

    private void doOperation(int op, BrokerSubscription bs) {
        this.doOperation(op, bs, false, false, null, null, null, null);
    }

    private void doOperation(int op, BrokerSubscription bs, boolean newSubscription, boolean suppressNotification, Vector addedSelectors, Vector removedSelectors, ISubject addedSubject, ISubject removedSubject) {
        ISubject iSubject;
        GSPropagationRule rule;
        ISubject nextSubject;
        Enumeration rules;
        if (bs == null || bs.getSubject() == null) {
            return;
        }
        if (SessionConfig.isSystemSubject(bs.getSubject()) || bs.getSubject().isSonicMQSubject()) {
            return;
        }
        if (bs.getClient().isInterbroker()) {
            return;
        }
        ISubject subject = bs.getSubject();
        if (bs.getClient().getRemoteNode() != null) {
            if (op == 1) {
                if (this.DEBUG) {
                    this.debug("doOperation: [remote subscribe for subject] " + subject + " [ENABLE_GS_FORWARDING?] " + this.ENABLE_FORWARDING);
                }
            } else if (op == 2 && this.DEBUG) {
                this.debug("doOperation: [remote unsubscribe for subject] " + subject + " [ENABLE_GS_FORWARDING?] " + this.ENABLE_FORWARDING);
            }
            if (!this.ENABLE_FORWARDING) {
                return;
            }
        } else if (op == 1) {
            if (newSubscription) {
                ++m_localSubscriberCount;
            }
            if (this.DEBUG) {
                this.debug("doOperation: [local subscribe for subject] " + subject + " m_localSubscriberCount= " + m_localSubscriberCount);
            }
        } else if (op == 2) {
            --m_localSubscriberCount;
            if (this.DEBUG) {
                this.debug("doOperation: [local unsubscribe for subject] " + subject + " m_localSubscriberCount= " + m_localSubscriberCount);
            }
        }
        if (this.m_rulesTable.isEmpty()) {
            return;
        }
        Hashtable t = this.m_rulesTable.getRules();
        if (t == null || t.isEmpty()) {
            if (this.DEBUG) {
                this.debug("doOperation: no rules match with " + subject);
            }
            return;
        }
        Iterator<ISubject> subjects = bs.getSubject().getSingleSubjects();
        if (subjects != null) {
            while (subjects.hasNext()) {
                rules = t.elements();
                nextSubject = subjects.next();
                if (addedSubject != null && addedSubject.hasIntersect(nextSubject)) continue;
                while (rules.hasMoreElements()) {
                    rule = (GSPropagationRule)rules.nextElement();
                    iSubject = this.computeRuleIntersect(bs, rule, nextSubject);
                    if (iSubject == null) continue;
                    if (this.DEBUG) {
                        this.debug("[intersection rule]" + rule.toString());
                    }
                    this.doProxySubscription(op, bs, iSubject, rule.getToNodeList(), newSubscription, suppressNotification, addedSelectors, removedSelectors);
                }
            }
        }
        if (op == 1) {
            if (addedSubject != null && addedSubject.isSubjectSet()) {
                subjects = addedSubject.getSingleSubjects();
                while (subjects.hasNext()) {
                    rules = t.elements();
                    nextSubject = subjects.next();
                    while (rules.hasMoreElements()) {
                        rule = (GSPropagationRule)rules.nextElement();
                        iSubject = this.computeRuleIntersect(bs, rule, nextSubject);
                        if (iSubject == null) continue;
                        if (this.DEBUG) {
                            this.debug("[intersection rule]" + rule.toString());
                        }
                        this.doProxySubscription(op, bs, iSubject, rule.getToNodeList(), true, suppressNotification, null, null);
                    }
                }
            }
            if (removedSubject != null && removedSubject.isSubjectSet()) {
                subjects = removedSubject.getSingleSubjects();
                while (subjects.hasNext()) {
                    rules = t.elements();
                    nextSubject = subjects.next();
                    while (rules.hasMoreElements()) {
                        rule = (GSPropagationRule)rules.nextElement();
                        iSubject = this.computeRuleIntersect(bs, rule, nextSubject);
                        if (iSubject == null) continue;
                        if (this.DEBUG) {
                            this.debug("[intersection rule]" + rule.toString());
                        }
                        this.doProxySubscription(2, bs, iSubject, rule.getToNodeList(), true, suppressNotification, addedSelectors, removedSelectors);
                    }
                }
            }
        }
        if (this.DEBUG) {
            this.dumpProxySubscriptionList();
            this.dumpRequestList();
        }
    }

    private void reset() {
        if (this.DEBUG1) {
            this.debug("Starting reset(): m_trackers.size= " + this.m_trackers.size() + " " + Thread.currentThread().getName());
        }
        this.m_proxySubscriptionList.clear();
        this.m_requestList.clear();
        m_localSubscriberCount = 0;
        this.m_trackers.clear();
    }

    private ISubject computeRuleIntersect(BrokerSubscription bs, GSPropagationRule rule, ISubject subject) {
        if (bs.getClient().getRemoteNode() == null || this.matchForRemoteNode()) {
            return SubjectUtil.computeIntersectSubject(rule.getTopic(), subject);
        }
        return null;
    }

    private boolean matchForRemoteNode() {
        return this.ENABLE_FORWARDING;
    }

    private void doProxySubscription(int op, BrokerSubscription bs, ISubject iSubject, Vector nodeList, boolean newSubscription, boolean suppressNotification, Vector addedSelectors, Vector removedSelectors) {
        String[] selectors = null;
        if (op == 1) {
            if (addedSelectors == null) {
                if (bs.getSelectorAtBroker()) {
                    selectors = bs.getSelectorStrings();
                    if (selectors != null) {
                        addedSelectors = new Vector(selectors.length);
                        for (int ii = 0; ii < selectors.length; ++ii) {
                            addedSelectors.addElement(selectors[ii]);
                        }
                    } else {
                        addedSelectors = new Vector(1);
                        addedSelectors.addElement("");
                    }
                } else {
                    addedSelectors = new Vector<String>(1);
                    addedSelectors.addElement("");
                }
            }
        } else if (addedSelectors != null) {
            selectors = new String[]{""};
        } else if (removedSelectors != null) {
            selectors = new String[removedSelectors.size()];
            for (int i = 0; i < removedSelectors.size(); ++i) {
                selectors[i] = (String)removedSelectors.get(i);
            }
        } else if (bs.getSelectorAtBroker()) {
            selectors = bs.getSelectorStrings();
            if (selectors == null) {
                selectors = new String[]{""};
            }
        } else {
            selectors = new String[]{""};
        }
        Enumeration toNodes = nodeList.elements();
        while (toNodes.hasMoreElements()) {
            String toNode = (String)toNodes.nextElement();
            if (toNode.equals(m_localNodeName)) continue;
            if (bs.getClient().getRemoteNode() != null && bs.getClient().getRemoteNode().equals(toNode)) {
                if (!this.DEBUG) continue;
                this.debug("Skipping GSA propagation to source node " + bs.getClient().getRemoteNode() + " for " + bs.getSubject());
                continue;
            }
            if (!this.isConfiguredNode(toNode)) {
                if (!this.DEBUG) continue;
                this.debug("[This node is not known, can't send proxy request to ] " + toNode);
                continue;
            }
            if (op == 1) {
                this.addOrUpdateProxySubscription(toNode, iSubject.getLookupName(), newSubscription, suppressNotification, addedSelectors, removedSelectors);
                continue;
            }
            if (op != 2) continue;
            this.deleteProxySubscription(toNode, iSubject.getLookupName(), suppressNotification, selectors);
        }
    }

    private void addOrUpdateProxySubscription(String node, String topic, boolean newSubscription, boolean suppressNotification, Vector addedSelectors, Vector removedSelectors) {
        boolean updateNeeded;
        GSNodeInfo ni = (GSNodeInfo)this.m_proxySubscriptionList.get(node);
        if (ni == null) {
            ni = new GSNodeInfo(node);
            this.m_proxySubscriptionList.put(node, ni);
        }
        if (!(updateNeeded = ni.addOrUpdateTopic(topic, newSubscription, addedSelectors, removedSelectors))) {
            return;
        }
        if (!ni.isConfigured()) {
            if (this.DEBUG) {
                this.debug("[This node is not known, can't send proxy request to ] " + node);
            }
            return;
        }
        GSTopicInfo topicInfo = (GSTopicInfo)ni.getTopicInfoList().get(topic);
        String[] selectorsToSend = topicInfo.getSelectors();
        GSRequest req = new GSRequest(Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node, topic, selectorsToSend, 1, null);
        req.setSuppressNotification(suppressNotification);
        this.m_requestSender.sendRequest(req);
        if (this.DEBUG1) {
            String sels = null;
            if (selectorsToSend != null) {
                sels = "";
                for (int j = 0; j < selectorsToSend.length; ++j) {
                    sels = sels + "," + selectorsToSend[j];
                }
            }
            this.debug("addOrUpdateProxySubscription: [sending request #] " + req.getVirtualClockStr() + " [to node] " + node + " [topic] " + topic + " [selectors] " + sels);
        }
        this.m_requestList.put(GSManager.buildRequestKey(req), req);
        ni.register(req);
    }

    private void deleteProxySubscription(String node, String topic, boolean suppressNotification, String[] selectors) {
        GSNodeInfo ni = (GSNodeInfo)this.m_proxySubscriptionList.get(node);
        if (ni == null) {
            return;
        }
        boolean updateNeeded = ni.deleteTopic(topic, selectors);
        if (ni.getTopicInfoList().isEmpty()) {
            this.m_proxySubscriptionList.remove(node);
        }
        if (!updateNeeded) {
            return;
        }
        GSTopicInfo topicInfo = (GSTopicInfo)ni.getTopicInfoList().get(topic);
        if (!ni.isConfigured()) {
            if (this.DEBUG) {
                this.debug("[This node is not known, can't send proxy request to ] " + node);
            }
            return;
        }
        GSRequest req = (GSRequest)this.m_requestList.get(GSManager.buildRequestKey(node, topic));
        if (req == null) {
            return;
        }
        if (topicInfo == null) {
            req = new GSRequest(Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node, topic, null, 2, null);
            this.m_requestList.remove(GSManager.buildRequestKey(node, topic));
            ni.unregister(req);
            if (this.DEBUG1) {
                this.debug("deleteProxySubscription: [sending unsubscribe request #] " + req.getVirtualClockStr() + " to [node] " + node + " [topic] " + topic);
            }
        } else {
            String[] selectorsToSend = topicInfo.getSelectors();
            req = new GSRequest(Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node, topic, selectorsToSend, 1, null);
            req.setSuppressNotification(suppressNotification);
            if (this.DEBUG1) {
                String sels = null;
                if (selectorsToSend != null) {
                    sels = "";
                    for (int j = 0; j < selectorsToSend.length; ++j) {
                        sels = sels + "," + selectorsToSend[j];
                    }
                }
                this.debug("deleteProxySubscription: [sending request #] " + req.getVirtualClockStr() + " [to node] " + node + " [topic] " + topic + " [selectors] " + sels);
            }
            this.m_requestList.put(GSManager.buildRequestKey(req), req);
            ni.register(req);
        }
        this.m_requestSender.sendRequest(req);
    }

    void dumpProxySubscriptionList() {
        System.out.println("[ProxySubscriptionList Dump]: ");
        Enumeration enums = this.m_proxySubscriptionList.elements();
        while (enums.hasMoreElements()) {
            ((GSNodeInfo)enums.nextElement()).dump();
        }
    }

    void dumpRequestList() {
        System.out.println("[RequestList Dump]: ");
        Enumeration enums = this.m_requestList.elements();
        while (enums.hasMoreElements()) {
            ((GSRequest)enums.nextElement()).dump();
        }
    }

    static String buildRequestKey(String node, String topic) {
        return GSManager.buildRequestKey(node, topic, 1);
    }

    static String buildRequestKey(String node, String topic, int opcode) {
        return opcode + "$" + node + "::" + topic;
    }

    static String buildRequestKey(GSRequest req) {
        return GSManager.buildRequestKey(req.getRemoteNodeName(), req.getTopic(), req.getOpCode());
    }

    static String convertNodes(Vector nodes) {
        Enumeration enu = nodes.elements();
        String toNodesString = "";
        while (enu.hasMoreElements()) {
            String aNode = (String)enu.nextElement();
            toNodesString = toNodesString.length() == 0 ? aNode : toNodesString + "," + aNode;
        }
        return toNodesString;
    }

    private boolean isConfiguredNode(String nodeName) {
        Vector allNodes = GSManager.getAllRoutingNodes();
        return allNodes.contains(nodeName.intern());
    }

    static Vector getAllRoutingNodes() {
        Vector<String> nodeNames = new Vector<String>();
        try {
            Vector routings = AgentRegistrar.getAgentRegistrar().getRoutingConfig().getRoutingConnections();
            RoutingConnectionInfo r = null;
            int numMatches = routings.size();
            for (int i = 0; i < numMatches; ++i) {
                r = (RoutingConnectionInfo)routings.elementAt(i);
                if (r.getRouteType() != RoutingConnectionInfo.ROUTE_TYPE_SONIC) continue;
                nodeNames.add(r.getRoutingNodeName().intern());
            }
        }
        catch (Exception e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        return nodeNames;
    }

    public GSNodeInfo getNodeInfo(String node) {
        return (GSNodeInfo)this.m_proxySubscriptionList.get(node);
    }

    public void onFailedConnection(IRemoteBroker rb) {
        if (rb.isNeighbor()) {
            return;
        }
        this.m_expirationManager.onFailedConnection(rb);
    }

    public void onFailedConnectInitiation(IRemoteBroker rb) {
        if (rb.isNeighbor()) {
            return;
        }
        this.m_expirationManager.onFailedConnectInitiation(rb);
    }

    public void notifyRemoteNodeWayOutUpdate(String remoteNode) {
        this.m_expirationManager.notifyRemoteNodeWayOutUpdate(remoteNode);
    }

    public void onNewConnection(IRemoteBroker rb, boolean inbound) {
        if (rb.isNeighbor()) {
            if (this.DEBUG) {
                this.debug("onNewConnection: Neighbor connected" + (inbound ? "(inbound):" : "(outbound):") + rb.getBrokerName());
            }
            this.m_transport.sendGSIBReconciliationList((INeighbor)((Object)rb));
        } else {
            if (this.DEBUG) {
                this.debug("onNewConnection: Remote Node connected" + (inbound ? "(inbound):" : "(outbound):") + rb.getNodeName() + ":" + rb.getBrokerName());
            }
            this.m_expirationManager.onNewConnection(rb, inbound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubjectMatch(BrokerSubscription bs, IMgram m) {
        if (!(bs instanceof MergedBrokerSubscription)) {
            return;
        }
        if (this.m_routingQ == null) {
            this.m_routingQ = this.m_reg.getQueueProc().getRoutingQueue();
        }
        long pingThreshold = this.m_routingQ.getMaxQueueSizeInBytes() / 2L;
        String rn = bs.getClient().getRemoteNode();
        GSTracker nodeTracker = this.locateGSTracker(rn, bs.getTopic());
        boolean pingNow = false;
        if (nodeTracker != null) {
            GSTracker gSTracker = nodeTracker;
            synchronized (gSTracker) {
                nodeTracker.messageMatched(m);
                if (nodeTracker.getMessageMatchSize() > pingThreshold) {
                    nodeTracker.resetMatchStats();
                    pingNow = true;
                }
            }
            if (pingNow) {
                this.m_transport.sendPing(bs);
            }
        }
    }

    public GSTransport getTransport() {
        return this.m_transport;
    }

    public GSOrphanedMessageChecker getGSOrphanedMessageChecker() {
        return this.m_gsOrphanedMessageChecker;
    }

    public GSRoutingQueueListener getRoutingQueueListener() {
        return this.m_routingQueueListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allocateGSTracker(MergedBrokerSubscription mbs) {
        String node = mbs.getClient().getRemoteNode();
        Hashtable hashtable = this.m_trackers;
        synchronized (hashtable) {
            GSTracker t = new GSTracker(node, mbs);
            GSTracker nt = (GSTracker)this.m_trackers.get(node);
            if (nt == null) {
                nt = new GSTracker(node);
                this.m_trackers.put(node, nt);
                if (this.m_started) {
                    this.m_expirationManager.startExpirationMonitoring(node);
                }
            }
            nt.addChild(mbs.getTopic(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeGSTracker(MergedBrokerSubscription mbs) {
        String node = mbs.getClient().getRemoteNode();
        Hashtable hashtable = this.m_trackers;
        synchronized (hashtable) {
            GSTracker nt = (GSTracker)this.m_trackers.get(node);
            if (nt != null) {
                nt.removeChild(mbs.getTopic());
                if (!nt.hasChildren()) {
                    this.m_trackers.remove(node);
                    if (this.m_started) {
                        this.m_expirationManager.stopExpirationMonitoring(node);
                    }
                }
            }
        }
    }

    public GSTracker locateGSTracker(String node, String topic) {
        GSTracker nt = (GSTracker)this.m_trackers.get(node);
        if (nt == null) {
            return null;
        }
        return nt.getChild(topic);
    }

    public GSTracker locateGSTracker(String node) {
        return (GSTracker)this.m_trackers.get(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRemoteSubscriptionSummary(String prefix, boolean getAllNodes) {
        boolean useFilter = prefix != null && prefix.length() > 0;
        ArrayList<IRemoteSubscriptionSummary> al = new ArrayList<IRemoteSubscriptionSummary>();
        Hashtable hashtable = this.m_trackers;
        synchronized (hashtable) {
            Enumeration enu = this.m_trackers.elements();
            GSTracker nt = null;
            while (enu.hasMoreElements()) {
                nt = (GSTracker)enu.nextElement();
                if (useFilter && !nt.getRemoteNodeName().startsWith(prefix)) continue;
                IRemoteSubscriptionSummary s = RuntimeDataFactory.createRemoteSubscriptionSummary(nt.getRemoteNodeName(), nt.getMessageCount(), nt.getMessageSize(), true);
                al.add(s);
            }
            if (!getAllNodes) {
                return al;
            }
            Enumeration enum2 = GSManager.getAllRoutingNodes().elements();
            String nodeName = null;
            while (enum2.hasMoreElements()) {
                nodeName = (String)enum2.nextElement();
                if (useFilter && !nodeName.startsWith(prefix) || this.m_trackers.get(nodeName) != null) continue;
                IRemoteSubscriptionSummary s = RuntimeDataFactory.createRemoteSubscriptionSummary(nodeName, 0L, 0L, false);
                al.add(s);
            }
        }
        return al;
    }

    public ArrayList getRemoteSubscriptionSummary(String prefix) {
        return this.getRemoteSubscriptionSummary(prefix, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getRemoteSubscriptionTopics(String node, String pattern) {
        boolean useFilter;
        ArrayList<String> al = new ArrayList<String>();
        GSTracker nt = (GSTracker)this.m_trackers.get(node);
        if (nt == null) {
            return al;
        }
        int[] pvec = null;
        int[] tvec = null;
        boolean bl = useFilter = pattern != null && pattern.length() > 0 && !pattern.equals("#");
        if (useFilter) {
            pvec = SubjectUtil.computeMatchVector(pattern, true);
        }
        GSTracker gSTracker = nt;
        synchronized (gSTracker) {
            Enumeration enu = nt.getChildren();
            while (enu.hasMoreElements()) {
                GSTracker tracker = (GSTracker)enu.nextElement();
                if (!useFilter) {
                    al.add(tracker.getTopic());
                    continue;
                }
                tvec = SubjectUtil.computeMatchVector(tracker.getTopic(), true);
                try {
                    if (!SubjectUtil.isSubset(tvec, pvec)) continue;
                    al.add(tracker.getTopic());
                }
                catch (Exception e) {}
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTrackers(String node) {
        GSTracker nt = (GSTracker)this.m_trackers.get(node);
        ArrayList<SubscriptionData> al = new ArrayList<SubscriptionData>();
        if (nt == null) {
            return al;
        }
        GSTracker gSTracker = nt;
        synchronized (gSTracker) {
            SubscriptionData s = new SubscriptionData(nt.getClientId(), nt.getTopic(), nt.getSelectors(), nt.getSelectorAtBroker(), nt.getMessageCount(), nt.getMessageSize());
            al.add(s);
            Enumeration enu = nt.getChildren();
            while (enu.hasMoreElements()) {
                GSTracker tracker = (GSTracker)enu.nextElement();
                s = new SubscriptionData(tracker.getClientId(), tracker.getTopic(), tracker.getSelectors(), tracker.getSelectorAtBroker(), tracker.getMessageCount(), tracker.getMessageSize());
                al.add(s);
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAllRemoteSubscriptionsPerBroker() {
        Vector<BrokerSubscription> v = new Vector<BrokerSubscription>();
        Enumeration nodeEnum = null;
        Hashtable hashtable = this.m_trackers;
        synchronized (hashtable) {
            nodeEnum = ((Hashtable)this.m_trackers.clone()).elements();
        }
        while (nodeEnum.hasMoreElements()) {
            GSTracker nt = (GSTracker)nodeEnum.nextElement();
            String rn = nt.getRemoteNodeName();
            long cid = this.m_reg.getRouterManager().getRemoteNodeGSClientID(rn);
            IClientContext cc = this.m_reg.lockContext(cid);
            if (cc == null) continue;
            try {
                SubscriptionsTable msubs = cc.getSubscriptions();
                Enumeration msubEnum = msubs.elements();
                while (msubEnum.hasMoreElements()) {
                    BrokerSubscription bs = (BrokerSubscription)msubEnum.nextElement();
                    if (!(bs instanceof MergedBrokerSubscription)) continue;
                    MergedBrokerSubscription mbs = (MergedBrokerSubscription)bs;
                    LongHashTable bsubs = mbs.getContributors();
                    LongHashTable shallowClone = null;
                    LongHashTable longHashTable = bsubs;
                    synchronized (longHashTable) {
                        shallowClone = (LongHashTable)bsubs.clone();
                    }
                    Enumeration enu = shallowClone.elements();
                    while (enu.hasMoreElements()) {
                        BrokerSubscription bbs = (BrokerSubscription)enu.nextElement();
                        v.add(bbs);
                    }
                }
            }
            finally {
                cc.unlock();
            }
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getGSRules(String prefix) {
        boolean useFilter = prefix != null && prefix.length() > 0;
        Vector<GSPropagationRule> rules = new Vector<GSPropagationRule>();
        GSPropagationRuleList gSPropagationRuleList = this.m_rulesTable;
        synchronized (gSPropagationRuleList) {
            Enumeration enu = this.m_rulesTable.getRules().elements();
            while (enu.hasMoreElements()) {
                GSPropagationRule aRule = (GSPropagationRule)enu.nextElement();
                if (useFilter && !aRule.getTopic().startsWith(prefix)) continue;
                rules.addElement(aRule);
            }
        }
        return rules;
    }

    public boolean isStarted() {
        return this.m_started;
    }

    public void processUndeliveredInterceptor(IMgram mgram, int reason) throws InterruptedException {
        String topicStr;
        String sourceBroker;
        String sourceNode;
        if (!BrokerStateManager.getBrokerStateManager().isActive()) {
            return;
        }
        if (!this.m_transport.isGSASubscribe(mgram) && !this.m_transport.isGSAReconcile(mgram)) {
            return;
        }
        GSRequest gsRequest = null;
        try {
            ObjectInput in = mgram.getPayloadInputStreamHandle();
            if (this.m_transport.isGSASubscribe(mgram)) {
                String topic;
                gsRequest = GSRequest.deserialize(in);
                sourceNode = gsRequest.getHomeNodeName();
                sourceBroker = gsRequest.getHomeBrokerName();
                topicStr = topic = gsRequest.getTopic();
            } else {
                in.readByte();
                int mask = in.readInt();
                in.readInt();
                sourceNode = in.readUTF();
                sourceBroker = in.readUTF();
                String topic = "$ISYS.GSA.RECONCILED TOPICS";
                topicStr = prAccessor.getString("RECONCILED_SUBJECTS");
                GSVirtualClock masterReconcileClock = GSVirtualClock.unserialize(in);
                gsRequest = new GSRequest(sourceNode, sourceBroker, mgram.getRouting(), topic, new String[0], 1, masterReconcileClock);
                if ((mask & 8) == 8) {
                    gsRequest.setSuppressNotification(true);
                } else {
                    gsRequest.setSuppressNotification(false);
                }
            }
        }
        catch (IOException ex) {
            if (this.DEBUG) {
                this.debug("processUndelivered: malformed remote subscribe request");
            }
            return;
        }
        String remoteNode = mgram.getRouting();
        if (reason == 18) {
            reason = 20;
        }
        if (!gsRequest.getSuppressNotification()) {
            BrokerManagementNotificationsHelper.sendRemoteSubscribeFailureNotification(sourceBroker, sourceNode, Config.BROKER_NAME, remoteNode, topicStr, reason);
        }
        this.getRequestSender().sendRequestFailure(gsRequest, remoteNode, reason, Config.BROKER_NAME);
    }

    @Override
    public void IRoutingConfigChanged(RoutingConnectionInfo newRouting, RoutingConnectionInfo oldRouting) {
        if (oldRouting == null && newRouting != null) {
            String newRoutingNodeName = newRouting.getRoutingNodeName();
            this.addRouting(newRoutingNodeName);
            if (this.DEBUG) {
                this.debug("GSManager.IRoutingConfigChanged(), [adding new routing : ] " + newRoutingNodeName);
            }
        } else if (newRouting == null && oldRouting != null) {
            String oldRoutingNodeName = oldRouting.getRoutingNodeName();
            this.deleteRouting(oldRoutingNodeName);
            if (this.DEBUG) {
                this.debug("GSManager.IRoutingConfigChanged(), [deleting routing : ] " + oldRoutingNodeName);
            }
        }
    }

    @Override
    public void setRoutingConfigIndex(int index) {
        this.m_routingConfigIndex = index;
        if (this.DEBUG) {
            this.debug("GSManager.setRoutingConfigIndex() set to " + index);
        }
    }

    @Override
    public int getRoutingConfigIndex() {
        return this.m_routingConfigIndex;
    }

    private void addRouting(String nodeName) {
        this.addDeleteRouting(nodeName, "ADD");
    }

    private void deleteRouting(String nodeName) {
        this.addDeleteRouting(nodeName, "DELETE");
    }

    private void addDeleteRouting(String nodeName, String op) {
        if (m_localSubscriberCount == 0 && this.m_trackers.isEmpty()) {
            if (this.DEBUG) {
                this.debug("GSManager.addDeleteRouting found no subscriber, no need to do more..");
            }
            return;
        }
        Vector rules = this.m_rulesTable.findRulesContain(nodeName);
        Enumeration enum1 = rules.elements();
        if (this.DEBUG) {
            this.debug("GSManager.addDeleteRouting found " + rules.size() + " rules contain node " + nodeName);
        }
        while (enum1.hasMoreElements()) {
            GSPropagationRule r = (GSPropagationRule)enum1.nextElement();
            GSPropagationRule newRule = new GSPropagationRule(r.getTopic(), nodeName);
            if (op.equals("ADD")) {
                if (this.DEBUG) {
                    this.debug("GSManager.addDeleteRouting, [call internalAddRule for topic: ] " + newRule.getTopic());
                }
                this.internalAddRule(newRule);
                continue;
            }
            if (!op.equals("DELETE")) continue;
            if (this.DEBUG) {
                this.debug("GSManager.addDeleteRouting, [calling internalDeleteRule for topic: ] " + newRule.getTopic());
            }
            this.internalDeleteRule(newRule);
        }
    }

    static {
        m_localNodeName = null;
    }

    public class GSRequestSender
    extends DebugThread
    implements FlowControlListener,
    IFlowController,
    IGSRequestSender {
        FlowControlManager m_flowControlManager;
        Hashtable m_toBeSentList;
        Hashtable m_blockedList;
        Hashtable m_resumedList;
        boolean m_blocked;
        boolean m_running;

        GSRequestSender(FlowControlManager flowControlManager) {
            super("GSRequestSender");
            this.m_flowControlManager = null;
            this.m_toBeSentList = new Hashtable();
            this.m_blockedList = new Hashtable();
            this.m_resumedList = new Hashtable();
            this.m_blocked = false;
            this.m_running = false;
            this.m_flowControlManager = flowControlManager;
        }

        @Override
        public void start() {
            if (this.m_running) {
                return;
            }
            super.start();
            this.m_running = true;
        }

        @Override
        public void shutdown() {
            if (!this.m_running) {
                return;
            }
            super.shutdown();
            this.m_running = false;
        }

        private final String getNodeName(IMgram mgram) {
            String node = mgram.getRoutingHandle().getRouting();
            return node;
        }

        @Override
        public synchronized void nack(IMgram mgram, IAgentQueue target) {
            this.nack(mgram, mgram.getEnqueuedSize(), target, null);
        }

        @Override
        public synchronized void nack(IMgram mgram, int size, IAgentQueue target, String[] blockedRoutes) {
            IndexedList nodeQueue;
            this.m_blocked = true;
            String localDest = target.getQueueAddress();
            String node = null;
            node = this.getNodeName(mgram);
            if (this.DEBUG) {
                this.debug("Received a nack for node " + node);
            }
            if ((nodeQueue = (IndexedList)this.m_toBeSentList.remove(node)) != null) {
                this.m_blockedList.put(node, nodeQueue);
                if (this.DEBUG) {
                    this.debug("Moved queue for node " + node + " to blocked list");
                }
            }
            this.m_flowControlManager.addFlowControlListener(this, localDest, node, size, blockedRoutes);
        }

        @Override
        public void block(IMgram m, int size, IAgentQueue target, String[] blockedRoutes) {
        }

        @Override
        public void block(IMgram m, IAgentQueue target) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean checkGlobalBlocked(String localDestination, IMgram mgram) {
            boolean notBlocked;
            String node = this.getNodeName(mgram);
            GSRequestSender gSRequestSender = this;
            synchronized (gSRequestSender) {
                if (this.m_resumedList.get(node) != null) {
                    this.m_resumedList.remove(node);
                    if (this.DEBUG) {
                        this.debug("Removed node " + node + " from resumed list");
                    }
                    return true;
                }
            }
            boolean bl = notBlocked = !GSManager.this.m_reg.getFlowControlManager().isDestinationGloballyBlocked(localDestination);
            if (this.DEBUG) {
                this.debug("Node " + node + " is" + (notBlocked ? " not" : "") + " globally blocked");
            }
            return notBlocked;
        }

        @Override
        public boolean isDestinationLocalBlocked(IMgram mgram) {
            return false;
        }

        @Override
        public void onResumeReply(IMgram m) throws EMgramFormatError {
        }

        @Override
        public void disconnect() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlockingDestinations(ArrayList al) {
            GSRequestSender gSRequestSender = this;
            synchronized (gSRequestSender) {
                if (this.m_blockedList.isEmpty()) {
                    return;
                }
                for (String node : this.m_blockedList.keySet()) {
                    al.add(node);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onQueueResume(Object destKey, String localDestination, int size) {
            String node = (String)destKey;
            if (this.DEBUG) {
                this.debug("Received resume for node " + node);
            }
            GSRequestSender gSRequestSender = this;
            synchronized (gSRequestSender) {
                if (this.m_blockedList.get(node) != null) {
                    IndexedList nodeQueue = (IndexedList)this.m_blockedList.remove(node);
                    if (nodeQueue != null) {
                        this.m_toBeSentList.put(node, nodeQueue);
                        if (this.DEBUG) {
                            this.debug("Moved queue for node " + node + " back to to be sent list");
                        }
                    }
                    this.m_resumedList.put(node, new Integer(size));
                    this.notifyAll();
                    return true;
                }
                if (this.DEBUG) {
                    this.debug("WARNING: Not locally blocked, resume ignored: " + node);
                }
                return false;
            }
        }

        @Override
        public boolean isConnected() {
            return true;
        }

        @Override
        public void sendRequestFailure(GSRequest gsRequest, String remoteNode, int reason, String reportingBroker) {
            GSManager.this.m_transport.sendRequestFailure(gsRequest, remoteNode, reason, reportingBroker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendRequest(IGSRemoteRequest request) {
            GSRequestSender gSRequestSender = this;
            synchronized (gSRequestSender) {
                GSRequest gr;
                if (request instanceof GSRequest && (gr = (GSRequest)request).getVirtualClock() == null) {
                    gr.setVirtualClock(GSVirtualClock.assignVirtualClock());
                }
                String node = request.getRemoteNodeName();
                String key = request.getUniqueKey();
                IndexedList<IGSRemoteRequest> nodeQueue = (IndexedList<IGSRemoteRequest>)this.m_toBeSentList.get(node);
                if (this.DEBUG) {
                    this.debug("Received request for node " + node + ", key " + key + ", op " + request.opStr());
                }
                if (nodeQueue == null) {
                    nodeQueue = (IndexedList)this.m_blockedList.get(node);
                    if (this.DEBUG && nodeQueue != null) {
                        this.debug("Found node queue on blocked list");
                    }
                } else if (this.DEBUG) {
                    this.debug("Found node queue on to be sent list");
                }
                if (nodeQueue == null) {
                    nodeQueue = new IndexedList<IGSRemoteRequest>();
                    this.m_toBeSentList.put(node, nodeQueue);
                    if (this.DEBUG) {
                        this.debug("Created node queue");
                    }
                }
                if (request.preNodeQueueInsertionInterceptor(nodeQueue)) {
                    nodeQueue.appendNoDup(key, request);
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IGSRemoteRequest getNextRequest() throws InterruptedException {
            IGSRemoteRequest request = null;
            GSRequestSender gSRequestSender = this;
            synchronized (gSRequestSender) {
                while (request == null) {
                    if (!this.m_toBeSentList.isEmpty()) {
                        Enumeration enu = this.m_toBeSentList.elements();
                        while (enu.hasMoreElements()) {
                            IndexedList nodeQueue = (IndexedList)enu.nextElement();
                            if (nodeQueue.count() <= 0) continue;
                            request = (IGSRemoteRequest)nodeQueue.head().obj;
                            break;
                        }
                    }
                    if (request != null) continue;
                    this.wait();
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            IGSRemoteRequest request = null;
            if (this.DEBUG) {
                this.debug("GSRequestSender thread started");
            }
            while (!this.isShuttingDown()) {
                try {
                    request = this.getNextRequest();
                    if (request == null) continue;
                    this.m_blocked = false;
                    GSManager.this.m_transport.sendRequest(request, this);
                    if (this.m_blocked) continue;
                    if (this.DEBUG) {
                        this.debug(" Sent request for node " + request.getRemoteNodeName() + ", key " + request.getUniqueKey() + ", op " + request.opStr());
                    }
                    String node = request.getRemoteNodeName();
                    GSRequestSender gSRequestSender = this;
                    synchronized (gSRequestSender) {
                        IndexedList nodeQueue = (IndexedList)this.m_toBeSentList.get(node);
                        if (nodeQueue != null) {
                            nodeQueue.remove(request.getUniqueKey());
                            if (this.DEBUG) {
                                this.debug("Removed sent request from node queue");
                            }
                            if (nodeQueue.count() == 0) {
                                this.m_toBeSentList.remove(node);
                                if (this.DEBUG) {
                                    this.debug("Removed empty node queue");
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException iex) {
                    if (!this.isShuttingDown()) continue;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getBlockedDestinationsAsString() {
            Hashtable blockedListCopy = null;
            GSRequestSender gSRequestSender = this;
            synchronized (gSRequestSender) {
                if (!this.m_blocked) {
                    return null;
                }
                if (this.m_blockedList.isEmpty()) {
                    return null;
                }
                blockedListCopy = (Hashtable)this.m_blockedList.clone();
            }
            StringBuffer resultBuffer = new StringBuffer();
            boolean first = true;
            for (String node : blockedListCopy.keySet()) {
                if (first) {
                    first = false;
                } else {
                    resultBuffer.append(", ");
                }
                resultBuffer.append(node).append(" (node)");
            }
            return resultBuffer.toString();
        }
    }

    public class GSStandbyRequestSender
    implements IGSRequestSender {
        @Override
        public void start() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public void sendRequest(IGSRemoteRequest request) {
        }

        @Override
        public void sendRequestFailure(GSRequest gsRequest, String remoteNode, int reason, String reportingBroker) {
        }
    }
}

