/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.gs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.gs.GSVirtualClockAssigner;
import progress.message.util.StreamUtil;

public class GSVirtualClock
implements Comparable {
    private long m_virtualClock;

    public GSVirtualClock(long l) {
        this.m_virtualClock = l;
    }

    public GSVirtualClock(String dbStr) {
        this.m_virtualClock = Long.parseLong(dbStr);
    }

    public int compareTo(Object o) {
        GSVirtualClock vc = (GSVirtualClock)o;
        if (this.m_virtualClock < vc.m_virtualClock) {
            return -1;
        }
        if (this.m_virtualClock > vc.m_virtualClock) {
            return 1;
        }
        return 0;
    }

    public long getVirtualClock() {
        return this.m_virtualClock;
    }

    public String toDbString() {
        return Long.toString(this.m_virtualClock);
    }

    public String toString() {
        return "VC:" + this.m_virtualClock;
    }

    public static GSVirtualClock maximum() {
        return GSVirtualClockLazyHolder.MAX_SINGLETON;
    }

    public void serialize(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_virtualClock, os);
    }

    public void serialize(DataOutput dos) throws IOException {
        dos.writeLong(this.m_virtualClock);
    }

    public static GSVirtualClock unserialize(InputStream is) throws IOException {
        long v = StreamUtil.readLong(is);
        return new GSVirtualClock(v);
    }

    public static GSVirtualClock unserialize(DataInput di) throws IOException {
        long v = di.readLong();
        return new GSVirtualClock(v);
    }

    static int serializedSize() {
        return 8;
    }

    public static GSVirtualClock assignVirtualClock() {
        return GSVirtualClockAssigner.assignVirtualClock();
    }

    private static class GSVirtualClockLazyHolder {
        private static final GSVirtualClock MAX_SINGLETON = new GSVirtualClock(Long.MAX_VALUE);

        private GSVirtualClockLazyHolder() {
        }
    }
}

